/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.action.RemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;

public class TransportRemoveIndexLifecyclePolicyAction
extends TransportMasterNodeAction<RemoveIndexLifecyclePolicyAction.Request, RemoveIndexLifecyclePolicyAction.Response> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportRemoveIndexLifecyclePolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/ilm/remove_policy", transportService, clusterService, threadPool, actionFilters, RemoveIndexLifecyclePolicyAction.Request::new, RemoveIndexLifecyclePolicyAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected ClusterBlockException checkBlock(RemoveIndexLifecyclePolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, RemoveIndexLifecyclePolicyAction.Request request, ClusterState state, final ActionListener<RemoveIndexLifecyclePolicyAction.Response> listener) throws Exception {
        final Index[] indices = this.indexNameExpressionResolver.concreteIndices(state, request.indicesOptions(), true, request.indices());
        this.submitUnbatchedTask("remove-lifecycle-for-index", new ClusterStateUpdateTask(this, request.masterNodeTimeout()){
            private final List<String> failedIndexes;
            {
                super(arg0);
                this.failedIndexes = new ArrayList<String>();
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                return IndexLifecycleTransition.removePolicyForIndexes(indices, currentState, this.failedIndexes);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new RemoveIndexLifecyclePolicyAction.Response(this.failedIndexes));
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }
}

