/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.ConnectorConfiguration;
import org.elasticsearch.xpack.application.connector.ConnectorCustomSchedule;
import org.elasticsearch.xpack.application.connector.ConnectorFeatures;
import org.elasticsearch.xpack.application.connector.ConnectorFiltering;
import org.elasticsearch.xpack.application.connector.ConnectorIngestPipeline;
import org.elasticsearch.xpack.application.connector.ConnectorScheduling;
import org.elasticsearch.xpack.application.connector.ConnectorStatus;
import org.elasticsearch.xpack.application.connector.ConnectorSyncInfo;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.ConnectorUtils;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;

public class Connector
implements ToXContentObject {
    public static final String NAME = Connector.class.getName().toUpperCase(Locale.ROOT);
    @Nullable
    private final String connectorId;
    @Nullable
    private final String apiKeyId;
    @Nullable
    private final String apiKeySecretId;
    private final Map<String, ConnectorConfiguration> configuration;
    private final Map<String, ConnectorCustomSchedule> customScheduling;
    @Nullable
    private final String description;
    @Nullable
    private final String error;
    @Nullable
    private final ConnectorFeatures features;
    private final List<ConnectorFiltering> filtering;
    @Nullable
    private final FilteringRules syncJobFiltering;
    @Nullable
    private final String indexName;
    private final boolean isNative;
    @Nullable
    private final String language;
    @Nullable
    private final Instant lastSeen;
    @Nullable
    private final ConnectorSyncInfo syncInfo;
    @Nullable
    private final String name;
    @Nullable
    private final ConnectorIngestPipeline pipeline;
    private final ConnectorScheduling scheduling;
    @Nullable
    private final String serviceType;
    private final ConnectorStatus status;
    @Nullable
    private final Object syncCursor;
    private final boolean syncNow;
    private final boolean isDeleted;
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    public static final ParseField API_KEY_ID_FIELD = new ParseField("api_key_id", new String[0]);
    public static final ParseField API_KEY_SECRET_ID_FIELD = new ParseField("api_key_secret_id", new String[0]);
    public static final ParseField CONFIGURATION_FIELD = new ParseField("configuration", new String[0]);
    static final ParseField CUSTOM_SCHEDULING_FIELD = new ParseField("custom_scheduling", new String[0]);
    public static final ParseField DESCRIPTION_FIELD = new ParseField("description", new String[0]);
    public static final ParseField ERROR_FIELD = new ParseField("error", new String[0]);
    public static final ParseField FEATURES_FIELD = new ParseField("features", new String[0]);
    public static final ParseField FILTERING_FIELD = new ParseField("filtering", new String[0]);
    public static final ParseField INDEX_NAME_FIELD = new ParseField("index_name", new String[0]);
    public static final ParseField IS_NATIVE_FIELD = new ParseField("is_native", new String[0]);
    public static final ParseField LANGUAGE_FIELD = new ParseField("language", new String[0]);
    public static final ParseField LAST_SEEN_FIELD = new ParseField("last_seen", new String[0]);
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField PIPELINE_FIELD = new ParseField("pipeline", new String[0]);
    public static final ParseField SCHEDULING_FIELD = new ParseField("scheduling", new String[0]);
    public static final ParseField SERVICE_TYPE_FIELD = new ParseField("service_type", new String[0]);
    public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    public static final ParseField SYNC_CURSOR_FIELD = new ParseField("sync_cursor", new String[0]);
    static final ParseField SYNC_NOW_FIELD = new ParseField("sync_now", new String[0]);
    public static final ParseField IS_DELETED_FIELD = new ParseField("deleted", new String[0]);
    private static final ConstructingObjectParser<Connector, String> PARSER = new ConstructingObjectParser("connector", true, (args, docId) -> {
        int i = 0;
        return new Builder().setConnectorId((String)docId).setApiKeyId((String)args[i++]).setApiKeySecretId((String)args[i++]).setConfiguration((Map)args[i++]).setCustomScheduling((Map)args[i++]).setDescription((String)args[i++]).setError((String)args[i++]).setFeatures((ConnectorFeatures)args[i++]).setFiltering((List)args[i++]).setIndexName((String)args[i++]).setIsNative((Boolean)args[i++]).setLanguage((String)args[i++]).setLastSeen((Instant)args[i++]).setSyncInfo(new ConnectorSyncInfo.Builder().setLastAccessControlSyncError((String)args[i++]).setLastAccessControlSyncScheduledAt((Instant)args[i++]).setLastAccessControlSyncStatus((ConnectorSyncStatus)((Object)((Object)args[i++]))).setLastDeletedDocumentCount((Long)args[i++]).setLastIncrementalSyncScheduledAt((Instant)args[i++]).setLastIndexedDocumentCount((Long)args[i++]).setLastSyncError((String)args[i++]).setLastSyncScheduledAt((Instant)args[i++]).setLastSyncStatus((ConnectorSyncStatus)((Object)((Object)args[i++]))).setLastSynced((Instant)args[i++]).build()).setName((String)args[i++]).setPipeline((ConnectorIngestPipeline)args[i++]).setScheduling((ConnectorScheduling)args[i++]).setServiceType((String)args[i++]).setStatus((ConnectorStatus)((Object)((Object)args[i++]))).setSyncCursor(args[i++]).setSyncNow((Boolean)args[i++]).setIsDeleted((Boolean)args[i]).build();
    });

    private Connector(String connectorId, String apiKeyId, String apiKeySecretId, Map<String, ConnectorConfiguration> configuration, Map<String, ConnectorCustomSchedule> customScheduling, String description, String error, ConnectorFeatures features, List<ConnectorFiltering> filtering, FilteringRules syncJobFiltering, String indexName, boolean isNative, String language, Instant lastSeen, ConnectorSyncInfo syncInfo, String name, ConnectorIngestPipeline pipeline, ConnectorScheduling scheduling, String serviceType, ConnectorStatus status, Object syncCursor, boolean syncNow, Boolean isDeleted) {
        this.connectorId = connectorId;
        this.apiKeyId = apiKeyId;
        this.apiKeySecretId = apiKeySecretId;
        this.configuration = configuration;
        this.customScheduling = customScheduling;
        this.description = description;
        this.error = error;
        this.features = features;
        this.filtering = filtering;
        this.syncJobFiltering = syncJobFiltering;
        this.indexName = indexName;
        this.isNative = isNative;
        this.language = language;
        this.lastSeen = lastSeen;
        this.syncInfo = syncInfo;
        this.name = name;
        this.pipeline = pipeline;
        this.scheduling = scheduling;
        this.serviceType = serviceType;
        this.status = status;
        this.syncCursor = syncCursor;
        this.syncNow = syncNow;
        this.isDeleted = isDeleted;
    }

    public String getAccessControlIndexName() {
        return ".search-acl-filter-" + this.indexName;
    }

    public static Connector fromXContentBytes(BytesReference source, String docId, XContentType xContentType) {
        Connector connector;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connector = Connector.fromXContent(parser, docId);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector document.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connector;
    }

    public static Connector fromXContent(XContentParser parser, String docId) throws IOException {
        return (Connector)PARSER.parse(parser, (Object)docId);
    }

    public void toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.connectorId != null) {
            builder.field(ID_FIELD.getPreferredName(), this.connectorId);
        }
        if (this.apiKeyId != null) {
            builder.field(API_KEY_ID_FIELD.getPreferredName(), this.apiKeyId);
        }
        if (this.apiKeySecretId != null) {
            builder.field(API_KEY_SECRET_ID_FIELD.getPreferredName(), this.apiKeySecretId);
        }
        if (this.configuration != null) {
            builder.xContentValuesMap(CONFIGURATION_FIELD.getPreferredName(), this.configuration);
        }
        if (this.customScheduling != null) {
            builder.xContentValuesMap(CUSTOM_SCHEDULING_FIELD.getPreferredName(), this.customScheduling);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD.getPreferredName(), this.description);
        }
        if (this.error != null) {
            builder.field(ERROR_FIELD.getPreferredName(), this.error);
        }
        if (this.features != null) {
            builder.field(FEATURES_FIELD.getPreferredName(), (ToXContent)this.features);
        }
        if (this.filtering != null) {
            builder.xContentList(FILTERING_FIELD.getPreferredName(), this.filtering);
        }
        if (this.indexName != null) {
            builder.field(INDEX_NAME_FIELD.getPreferredName(), this.indexName);
        }
        builder.field(IS_NATIVE_FIELD.getPreferredName(), this.isNative);
        if (this.language != null) {
            builder.field(LANGUAGE_FIELD.getPreferredName(), this.language);
        }
        if (this.lastSeen != null) {
            builder.field(LAST_SEEN_FIELD.getPreferredName(), (Object)this.lastSeen);
        }
        if (this.syncInfo != null) {
            this.syncInfo.toXContent(builder, params);
        }
        if (this.name != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.name);
        }
        if (this.pipeline != null) {
            builder.field(PIPELINE_FIELD.getPreferredName(), (ToXContent)this.pipeline);
        }
        if (this.scheduling != null) {
            builder.field(SCHEDULING_FIELD.getPreferredName(), (ToXContent)this.scheduling);
        }
        if (this.serviceType != null) {
            builder.field(SERVICE_TYPE_FIELD.getPreferredName(), this.serviceType);
        }
        if (this.syncCursor != null) {
            builder.field(SYNC_CURSOR_FIELD.getPreferredName(), this.syncCursor);
        }
        if (this.status != null) {
            builder.field(STATUS_FIELD.getPreferredName(), this.status.toString());
        }
        builder.field(SYNC_NOW_FIELD.getPreferredName(), this.syncNow);
        builder.field(IS_DELETED_FIELD.getPreferredName(), this.isDeleted);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public String getApiKeySecretId() {
        return this.apiKeySecretId;
    }

    public Map<String, ConnectorConfiguration> getConfiguration() {
        return this.configuration;
    }

    public Map<String, ConnectorCustomSchedule> getCustomScheduling() {
        return this.customScheduling;
    }

    public String getDescription() {
        return this.description;
    }

    public String getError() {
        return this.error;
    }

    public ConnectorFeatures getFeatures() {
        return this.features;
    }

    public List<ConnectorFiltering> getFiltering() {
        return this.filtering;
    }

    public FilteringRules getSyncJobFiltering() {
        return this.syncJobFiltering;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public String getLanguage() {
        return this.language;
    }

    public Instant getLastSeen() {
        return this.lastSeen;
    }

    public ConnectorSyncInfo getSyncInfo() {
        return this.syncInfo;
    }

    public String getName() {
        return this.name;
    }

    public ConnectorIngestPipeline getPipeline() {
        return this.pipeline;
    }

    public ConnectorScheduling getScheduling() {
        return this.scheduling;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public ConnectorStatus getStatus() {
        return this.status;
    }

    public Object getSyncCursor() {
        return this.syncCursor;
    }

    public boolean isSyncNow() {
        return this.syncNow;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connector connector = (Connector)o;
        return this.isNative == connector.isNative && this.syncNow == connector.syncNow && this.isDeleted == connector.isDeleted && Objects.equals(this.connectorId, connector.connectorId) && Objects.equals(this.apiKeyId, connector.apiKeyId) && Objects.equals(this.apiKeySecretId, connector.apiKeySecretId) && Objects.equals(this.configuration, connector.configuration) && Objects.equals(this.customScheduling, connector.customScheduling) && Objects.equals(this.description, connector.description) && Objects.equals(this.error, connector.error) && Objects.equals(this.features, connector.features) && Objects.equals(this.filtering, connector.filtering) && Objects.equals(this.syncJobFiltering, connector.syncJobFiltering) && Objects.equals(this.indexName, connector.indexName) && Objects.equals(this.language, connector.language) && Objects.equals(this.lastSeen, connector.lastSeen) && Objects.equals(this.syncInfo, connector.syncInfo) && Objects.equals(this.name, connector.name) && Objects.equals(this.pipeline, connector.pipeline) && Objects.equals(this.scheduling, connector.scheduling) && Objects.equals(this.serviceType, connector.serviceType) && this.status == connector.status && Objects.equals(this.syncCursor, connector.syncCursor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectorId, this.apiKeyId, this.apiKeySecretId, this.configuration, this.customScheduling, this.description, this.error, this.features, this.filtering, this.syncJobFiltering, this.indexName, this.isNative, this.language, this.lastSeen, this.syncInfo, this.name, this.pipeline, this.scheduling, this.serviceType, this.status, this.syncCursor, this.syncNow, this.isDeleted});
    }

    static {
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), API_KEY_ID_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), API_KEY_SECRET_ID_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(HashMap::new, ConnectorConfiguration::fromXContent), CONFIGURATION_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(HashMap::new, ConnectorCustomSchedule::fromXContent), CUSTOM_SCHEDULING_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), DESCRIPTION_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ERROR_FIELD);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorFeatures.fromXContent(p), null, FEATURES_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorFiltering.fromXContent(p), FILTERING_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), INDEX_NAME_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), IS_NATIVE_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), LANGUAGE_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, LAST_SEEN_FIELD.getPreferredName()), LAST_SEEN_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_ERROR);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : ConnectorSyncStatus.connectorSyncStatus(p.text()), ConnectorSyncInfo.LAST_ACCESS_CONTROL_SYNC_STATUS_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareLongOrNull(ConstructingObjectParser.optionalConstructorArg(), 0L, ConnectorSyncInfo.LAST_DELETED_DOCUMENT_COUNT_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_INCREMENTAL_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_INCREMENTAL_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareLongOrNull(ConstructingObjectParser.optionalConstructorArg(), 0L, ConnectorSyncInfo.LAST_INDEXED_DOCUMENT_COUNT_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncInfo.LAST_SYNC_ERROR_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_SYNC_SCHEDULED_AT_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_SYNC_SCHEDULED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : ConnectorSyncStatus.connectorSyncStatus(p.text()), ConnectorSyncInfo.LAST_SYNC_STATUS_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, ConnectorSyncInfo.LAST_SYNCED_FIELD.getPreferredName()), ConnectorSyncInfo.LAST_SYNCED_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), NAME_FIELD);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorIngestPipeline.fromXContent(p), null, PIPELINE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorScheduling.fromXContent(p), SCHEDULING_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), SERVICE_TYPE_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorStatus.connectorStatus(p.text()), STATUS_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), null, SYNC_CURSOR_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SYNC_NOW_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), IS_DELETED_FIELD);
    }

    public static class Builder {
        private String connectorId;
        private String apiKeyId;
        private String apiKeySecretId;
        private Map<String, ConnectorConfiguration> configuration = Collections.emptyMap();
        private Map<String, ConnectorCustomSchedule> customScheduling = Collections.emptyMap();
        private String description;
        private String error;
        private ConnectorFeatures features;
        private List<ConnectorFiltering> filtering;
        private FilteringRules syncJobFiltering;
        private String indexName;
        private boolean isNative;
        private String language;
        private Instant lastSeen;
        private ConnectorSyncInfo syncInfo = new ConnectorSyncInfo.Builder().build();
        private String name;
        private ConnectorIngestPipeline pipeline;
        private ConnectorScheduling scheduling;
        private String serviceType;
        private ConnectorStatus status = ConnectorStatus.CREATED;
        private Object syncCursor;
        private boolean syncNow;
        private boolean isDeleted;

        public Builder setConnectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public Builder setApiKeyId(String apiKeyId) {
            this.apiKeyId = apiKeyId;
            return this;
        }

        public Builder setApiKeySecretId(String apiKeySecretId) {
            this.apiKeySecretId = apiKeySecretId;
            return this;
        }

        public Builder setConfiguration(Map<String, ConnectorConfiguration> configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setCustomScheduling(Map<String, ConnectorCustomSchedule> customScheduling) {
            this.customScheduling = customScheduling;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setFeatures(ConnectorFeatures features) {
            this.features = features;
            return this;
        }

        public Builder setFiltering(List<ConnectorFiltering> filtering) {
            this.filtering = filtering;
            return this;
        }

        public Builder setSyncJobFiltering(FilteringRules syncJobFiltering) {
            this.syncJobFiltering = syncJobFiltering;
            return this;
        }

        public Builder setIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder setIsNative(boolean isNative) {
            this.isNative = isNative;
            return this;
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public Builder setSyncInfo(ConnectorSyncInfo syncInfo) {
            this.syncInfo = syncInfo;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPipeline(ConnectorIngestPipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public Builder setScheduling(ConnectorScheduling scheduling) {
            this.scheduling = scheduling;
            return this;
        }

        public Builder setServiceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public Builder setStatus(ConnectorStatus status) {
            this.status = status;
            return this;
        }

        public Builder setSyncCursor(Object syncCursor) {
            this.syncCursor = syncCursor;
            return this;
        }

        public Builder setSyncNow(Boolean syncNow) {
            this.syncNow = Objects.requireNonNullElse(syncNow, false);
            return this;
        }

        public Builder setIsDeleted(Boolean isDeleted) {
            this.isDeleted = Objects.requireNonNullElse(isDeleted, false);
            return this;
        }

        public Connector build() {
            return new Connector(this.connectorId, this.apiKeyId, this.apiKeySecretId, this.configuration, this.customScheduling, this.description, this.error, this.features, this.filtering, this.syncJobFiltering, this.indexName, this.isNative, this.language, this.lastSeen, this.syncInfo, this.name, this.pipeline, this.scheduling, this.serviceType, this.status, this.syncCursor, this.syncNow, this.isDeleted);
        }
    }
}

