/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.ConnectorSearchResult;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;

public class GetConnectorAction {
    public static final String NAME = "cluster:admin/xpack/connector/get";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/connector/get");

    private GetConnectorAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final ConnectorSearchResult connector;

        public Response(ConnectorSearchResult connector) {
            this.connector = connector;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.connector = new ConnectorSearchResult(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.connector.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.connector.toXContent(builder, params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.connector, response.connector);
        }

        public int hashCode() {
            return Objects.hash(this.connector);
        }
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final Boolean includeDeleted;
        private static final ParseField CONNECTOR_ID_FIELD = new ParseField("connector_id", new String[0]);
        private static final ParseField INCLUDE_DELETED_FIELD = new ParseField("include_deleted", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("get_connector_request", false, p -> new Request((String)p[0], (Boolean)p[1]));

        public Request(String connectorId, Boolean includeDeleted) {
            this.connectorId = connectorId;
            this.includeDeleted = includeDeleted;
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public Boolean getIncludeDeleted() {
            return this.includeDeleted;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"connector_id missing", validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.includeDeleted, request.includeDeleted);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.includeDeleted);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CONNECTOR_ID_FIELD.getPreferredName(), this.connectorId);
            builder.field(INCLUDE_DELETED_FIELD.getPreferredName(), this.includeDeleted);
            builder.endObject();
            return builder;
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), CONNECTOR_ID_FIELD);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), INCLUDE_DELETED_FIELD);
        }
    }
}

