/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.profiling.ProfilingPlugin;
import org.elasticsearch.xpack.profiling.action.GetStatusAction;
import org.elasticsearch.xpack.profiling.persistence.EventsIndex;
import org.elasticsearch.xpack.profiling.persistence.IndexStateResolver;
import org.elasticsearch.xpack.profiling.persistence.ProfilingDataStreamManager;
import org.elasticsearch.xpack.profiling.persistence.ProfilingIndexManager;
import org.elasticsearch.xpack.profiling.persistence.ProfilingIndexTemplateRegistry;

public class TransportGetStatusAction
extends TransportMasterNodeAction<GetStatusAction.Request, GetStatusAction.Response> {
    private static final Logger log = LogManager.getLogger(TransportGetStatusAction.class);
    private final StatusResolver resolver;

    @Inject
    public TransportGetStatusAction(TransportService transportService, ClusterService clusterService, NodeClient nodeClient, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:monitor/profiling/status/get", transportService, clusterService, threadPool, actionFilters, GetStatusAction.Request::new, GetStatusAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.resolver = new StatusResolver(clusterService, nodeClient);
    }

    protected void masterOperation(Task task, GetStatusAction.Request request, ClusterState state, ActionListener<GetStatusAction.Response> listener) {
        if (request.waitForResourcesCreated()) {
            this.createAndRegisterListener(listener, request.waitForResourcesCreatedTimeout());
        } else {
            this.resolver.execute(state, listener);
        }
    }

    private void createAndRegisterListener(ActionListener<GetStatusAction.Response> listener, TimeValue timeout) {
        DiscoveryNode localNode = this.clusterService.localNode();
        ClusterStateObserver.waitForState((ClusterService)this.clusterService, (ThreadContext)this.threadPool.getThreadContext(), (ClusterStateObserver.Listener)new StatusListener(listener, localNode, this.clusterService, this.resolver), this.resolver::isResourcesCreated, (TimeValue)timeout, (Logger)log);
    }

    protected ClusterBlockException checkBlock(GetStatusAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private static class StatusResolver {
        private final ClusterService clusterService;
        private final NodeClient nodeClient;

        private StatusResolver(ClusterService clusterService, NodeClient nodeClient) {
            this.clusterService = clusterService;
            this.nodeClient = nodeClient;
        }

        private boolean isResourcesCreated(ClusterState state) {
            IndexStateResolver indexStateResolver = this.indexStateResolver(state);
            boolean templatesCreated = ProfilingIndexTemplateRegistry.isAllResourcesCreated(state, this.clusterService.getSettings());
            boolean indicesCreated = ProfilingIndexManager.isAllResourcesCreated(state, indexStateResolver);
            boolean dataStreamsCreated = ProfilingDataStreamManager.isAllResourcesCreated(state, indexStateResolver);
            return templatesCreated && indicesCreated && dataStreamsCreated;
        }

        private boolean isAnyPre891Data(ClusterState state) {
            IndexStateResolver indexStateResolver = this.indexStateResolver(state);
            boolean indicesPre891 = ProfilingIndexManager.isAnyResourceTooOld(state, indexStateResolver);
            boolean dataStreamsPre891 = ProfilingDataStreamManager.isAnyResourceTooOld(state, indexStateResolver);
            return indicesPre891 || dataStreamsPre891;
        }

        private IndexStateResolver indexStateResolver(ClusterState state) {
            return new IndexStateResolver(this.getValue(state, ProfilingPlugin.PROFILING_CHECK_OUTDATED_INDICES));
        }

        private void execute(ClusterState state, ActionListener<GetStatusAction.Response> listener) {
            boolean pluginEnabled = this.getValue(state, (Setting<Boolean>)XPackSettings.PROFILING_ENABLED);
            boolean resourceManagementEnabled = this.getValue(state, ProfilingPlugin.PROFILING_TEMPLATES_ENABLED);
            boolean resourcesCreated = this.isResourcesCreated(state);
            boolean anyPre891Data = this.isAnyPre891Data(state);
            if (resourcesCreated) {
                SearchRequest countRequest = new SearchRequest(new String[]{EventsIndex.FULL_INDEX.getName()});
                countRequest.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
                countRequest.allowPartialSearchResults(true);
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).trackTotalHits(true).trackTotalHitsUpTo(1);
                countRequest.source(searchSourceBuilder);
                this.nodeClient.search(countRequest, ActionListener.wrap(searchResponse -> {
                    boolean hasData = searchResponse.getHits().getTotalHits().value() > 0L;
                    listener.onResponse((Object)new GetStatusAction.Response(pluginEnabled, resourceManagementEnabled, resourcesCreated, anyPre891Data, hasData));
                }, e -> {
                    if (e instanceof SearchPhaseExecutionException) {
                        log.trace("Has data check has failed.", (Throwable)e);
                        listener.onResponse((Object)new GetStatusAction.Response(pluginEnabled, resourceManagementEnabled, resourcesCreated, anyPre891Data, false));
                    } else {
                        listener.onFailure(e);
                    }
                }));
            } else {
                listener.onResponse((Object)new GetStatusAction.Response(pluginEnabled, resourceManagementEnabled, false, anyPre891Data, false));
            }
        }

        private boolean getValue(ClusterState state, Setting<Boolean> setting) {
            Metadata metadata = state.getMetadata();
            if (metadata.settings().hasValue(setting.getKey())) {
                return (Boolean)setting.get(metadata.settings());
            }
            return (Boolean)setting.get(this.clusterService.getSettings());
        }
    }

    private static class StatusListener
    implements ClusterStateObserver.Listener {
        private final ActionListener<GetStatusAction.Response> listener;
        private final DiscoveryNode localNode;
        private final ClusterService clusterService;
        private final StatusResolver resolver;

        private StatusListener(ActionListener<GetStatusAction.Response> listener, DiscoveryNode localNode, ClusterService clusterService, StatusResolver resolver) {
            this.listener = listener;
            this.localNode = localNode;
            this.clusterService = clusterService;
            this.resolver = resolver;
        }

        public void onNewClusterState(ClusterState state) {
            this.resolver.execute(state, this.listener);
        }

        public void onClusterServiceClose() {
            this.listener.onFailure((Exception)new NodeClosedException(this.localNode));
        }

        public void onTimeout(TimeValue timeout) {
            this.resolver.execute(this.clusterService.state(), (ActionListener<GetStatusAction.Response>)ActionListener.wrap(response -> {
                response.setTimedOut(true);
                this.listener.onResponse((Object)response);
            }, arg_0 -> this.listener.onFailure(arg_0)));
        }
    }
}

