/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.openai;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.external.unified.UnifiedChatCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionModel;

public class OpenAiUnifiedChatCompletionRequestEntity
implements ToXContentObject {
    public static final String USER_FIELD = "user";
    private static final String MODEL_FIELD = "model";
    private final OpenAiChatCompletionModel model;
    private final UnifiedChatCompletionRequestEntity unifiedRequestEntity;

    public OpenAiUnifiedChatCompletionRequestEntity(UnifiedChatInput unifiedChatInput, OpenAiChatCompletionModel model) {
        this.unifiedRequestEntity = new UnifiedChatCompletionRequestEntity(Objects.requireNonNull(unifiedChatInput));
        this.model = Objects.requireNonNull(model);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.unifiedRequestEntity.toXContent(builder, params);
        builder.field(MODEL_FIELD, this.model.getServiceSettings().modelId());
        if (!Strings.isNullOrEmpty((String)this.model.getTaskSettings().user())) {
            builder.field(USER_FIELD, this.model.getTaskSettings().user());
        }
        builder.endObject();
        return builder;
    }
}

