/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.monitoring.Monitoring;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExporter;
import org.elasticsearch.xpack.monitoring.exporter.local.LocalExporter;

public class Exporters
extends AbstractLifecycleComponent {
    private static final Logger LOGGER = LogManager.getLogger(Exporters.class);
    private final Settings settings;
    private final Map<String, Exporter.Factory> factories;
    private final AtomicReference<Map<String, Exporter>> exporters;
    private final AtomicReference<Map<String, Exporter.Config>> disabledExporterConfigs;
    private final ClusterService clusterService;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;

    public Exporters(Settings settings, Map<String, Exporter.Factory> factories, ClusterService clusterService, XPackLicenseState licenseState, ThreadContext threadContext, SSLService sslService) {
        this.settings = settings;
        this.factories = factories;
        this.exporters = new AtomicReference(Collections.emptyMap());
        this.disabledExporterConfigs = new AtomicReference(Collections.emptyMap());
        this.threadContext = Objects.requireNonNull(threadContext);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.licenseState = Objects.requireNonNull(licenseState);
        List<Setting.AffixSetting> dynamicSettings = Exporters.getSettings().stream().filter(Setting::isDynamic).toList();
        ArrayList<Setting.AffixSetting> updateSettings = new ArrayList<Setting.AffixSetting>(dynamicSettings);
        updateSettings.add((Setting.AffixSetting)Monitoring.MIGRATION_DECOMMISSION_ALERTS);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(this::setExportersSetting, updateSettings);
        HttpExporter.registerSettingValidators(clusterService, sslService);
        for (Setting.AffixSetting affixSetting : dynamicSettings) {
            clusterService.getClusterSettings().addAffixUpdateConsumer(affixSetting, (s, o) -> {}, (s, o) -> {});
        }
    }

    public void setExportersSetting(Settings exportersSetting) {
        if (this.lifecycle.started()) {
            InitializedExporters initializedExporters = this.initExporters(exportersSetting);
            Map<String, Exporter> updated = initializedExporters.enabledExporters;
            Exporters.closeExporters(LOGGER, this.exporters.getAndSet(updated));
            this.disabledExporterConfigs.getAndSet(initializedExporters.disabledExporters);
        }
    }

    protected void doStart() {
        InitializedExporters initializedExporters = this.initExporters(this.settings);
        this.exporters.set(initializedExporters.enabledExporters);
        this.disabledExporterConfigs.set(initializedExporters.disabledExporters);
    }

    protected void doStop() {
        Exporters.closeExporters(LOGGER, this.exporters.get());
    }

    protected void doClose() {
    }

    public Exporter getExporter(String name) {
        return this.exporters.get().get(name);
    }

    public Collection<Exporter> getEnabledExporters() {
        return this.exporters.get().values();
    }

    public Collection<Exporter.Config> getDisabledExporterConfigs() {
        return this.disabledExporterConfigs.get().values();
    }

    public Exporter openExporter(Exporter.Config config) {
        String name = config.name();
        String type = config.type();
        Exporter.Factory factory = this.factories.get(type);
        if (factory == null) {
            throw new SettingsException("unknown exporter type [" + type + "] set for exporter [" + name + "]");
        }
        return factory.create(config);
    }

    static void closeExporters(Logger logger, Map<String, Exporter> exporters) {
        for (Exporter exporter : exporters.values()) {
            try {
                exporter.close();
            }
            catch (Exception e) {
                logger.error(() -> "failed to close exporter [" + exporter.name() + "]", (Throwable)e);
            }
        }
    }

    InitializedExporters initExporters(Settings settingsToUse) {
        HashSet<String> singletons = new HashSet<String>();
        HashMap<String, Exporter> exportersMap = new HashMap<String, Exporter>();
        HashMap<String, Exporter.Config> disabled = new HashMap<String, Exporter.Config>();
        boolean hasDisabled = false;
        Settings exportersSettings = settingsToUse.getByPrefix("xpack.monitoring.exporters.");
        for (String name : exportersSettings.names()) {
            Settings exporterSettings = exportersSettings.getAsSettings(name);
            String type = exporterSettings.get("type");
            if (type == null) {
                throw new SettingsException("missing exporter type for [" + name + "] exporter");
            }
            Exporter.Factory factory = this.factories.get(type);
            if (factory == null) {
                throw new SettingsException("unknown exporter type [" + type + "] set for exporter [" + name + "]");
            }
            Exporter.Config config = new Exporter.Config(name, type, settingsToUse, this.clusterService, this.licenseState);
            if (!config.enabled()) {
                hasDisabled = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("exporter [{}/{}] is disabled", (Object)type, (Object)name);
                }
                disabled.put(config.name(), config);
                continue;
            }
            Exporter exporter = factory.create(config);
            if (exporter.isSingleton()) {
                if (singletons.contains(type)) {
                    throw new SettingsException("multiple [" + type + "] exporters are configured. there can only be one [" + type + "] exporter configured");
                }
                singletons.add(type);
            }
            exportersMap.put(config.name(), exporter);
        }
        if (exportersMap.isEmpty() && !hasDisabled) {
            Exporter.Config config = new Exporter.Config("default_local", "local", settingsToUse, this.clusterService, this.licenseState);
            exportersMap.put(config.name(), this.factories.get("local").create(config));
        }
        return new InitializedExporters(exportersMap, disabled);
    }

    void wrapExportBulk(ActionListener<ExportBulk> listener) {
        ClusterState state = this.clusterService.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK) || "_na_".equals(state.metadata().clusterUUID()) || state.version() == -1L) {
            LOGGER.trace("skipping exporters because the cluster state is not loaded");
            listener.onResponse(null);
            return;
        }
        Map<String, Exporter> exporterMap = this.exporters.get();
        if (exporterMap.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        AtomicArray accumulatedBulks = new AtomicArray(exporterMap.size());
        CountDown countDown = new CountDown(exporterMap.size());
        int i = 0;
        for (Exporter exporter : exporterMap.values()) {
            exporter.openBulk(new AccumulatingExportBulkActionListener(exporter.name(), i++, (AtomicArray<ExportBulk>)accumulatedBulks, countDown, this.threadContext, listener));
        }
    }

    public void export(Collection<MonitoringDoc> docs, ActionListener<Void> listener) throws ExportException {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            listener.onFailure((Exception)((Object)new ExportException("Export service is not started", new Object[0])));
        } else if (docs != null && docs.size() > 0) {
            this.wrapExportBulk((ActionListener<ExportBulk>)listener.delegateFailureAndWrap((l, bulk) -> {
                if (bulk != null) {
                    Exporters.doExport(bulk, docs, (ActionListener<Void>)l);
                } else {
                    l.onResponse(null);
                }
            }));
        } else {
            listener.onResponse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExport(ExportBulk bulk, Collection<MonitoringDoc> docs, ActionListener<Void> listener) {
        AtomicReference<ExportException> exceptionRef = new AtomicReference<ExportException>();
        try {
            bulk.add(docs);
        }
        catch (ExportException e) {
            exceptionRef.set(e);
        }
        finally {
            bulk.flush((ActionListener<Void>)ActionListener.wrap(r -> {
                if (exceptionRef.get() == null) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure((Exception)exceptionRef.get());
                }
            }, exception -> {
                if (exceptionRef.get() != null) {
                    exception.addSuppressed((Throwable)exceptionRef.get());
                }
                listener.onFailure(exception);
            }));
        }
    }

    public static List<Setting.AffixSetting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(Exporter.getSettings());
        settings.addAll(HttpExporter.getSettings());
        settings.addAll(LocalExporter.getSettings());
        return settings;
    }

    static class InitializedExporters {
        final Map<String, Exporter> enabledExporters;
        final Map<String, Exporter.Config> disabledExporters;

        InitializedExporters(Map<String, Exporter> enabledExporters, Map<String, Exporter.Config> disabledExporters) {
            this.enabledExporters = enabledExporters;
            this.disabledExporters = disabledExporters;
        }
    }

    static class AccumulatingExportBulkActionListener
    implements ActionListener<ExportBulk> {
        private final String name;
        private final int indexPosition;
        private final AtomicArray<ExportBulk> accumulatedBulks;
        private final CountDown countDown;
        private final ActionListener<ExportBulk> delegate;
        private final ThreadContext threadContext;

        AccumulatingExportBulkActionListener(String name, int indexPosition, AtomicArray<ExportBulk> accumulatedBulks, CountDown countDown, ThreadContext threadContext, ActionListener<ExportBulk> delegate) {
            this.name = name;
            this.indexPosition = indexPosition;
            this.accumulatedBulks = accumulatedBulks;
            this.countDown = countDown;
            this.threadContext = threadContext;
            this.delegate = delegate;
        }

        public void onResponse(ExportBulk exportBulk) {
            if (exportBulk == null) {
                LOGGER.debug("skipping exporter [{}] as it is not ready yet", (Object)this.name);
            } else {
                this.accumulatedBulks.set(this.indexPosition, (Object)exportBulk);
            }
            this.delegateIfComplete();
        }

        public void onFailure(Exception e) {
            LOGGER.error(() -> "exporter [" + this.name + "] failed to open exporting bulk", (Throwable)e);
            this.delegateIfComplete();
        }

        void delegateIfComplete() {
            if (this.countDown.countDown()) {
                List bulkList = this.accumulatedBulks.asList();
                if (bulkList.isEmpty()) {
                    this.delegate.onResponse(null);
                } else {
                    this.delegate.onResponse((Object)new ExportBulk.Compound(bulkList, this.threadContext));
                }
            }
        }
    }
}

