/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.transport;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.textstructure.action.AbstractFindStructureRequest;
import org.elasticsearch.xpack.core.textstructure.action.FindMessageStructureAction;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureResponse;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinderManager;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.transport.TextStructExecutor;

public class TransportFindMessageStructureAction
extends HandledTransportAction<FindMessageStructureAction.Request, FindStructureResponse> {
    private final ThreadPool threadPool;
    private final TextStructExecutor executor;

    @Inject
    public TransportFindMessageStructureAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, TextStructExecutor executor) {
        super("cluster:monitor/text_structure/find_message_structure", transportService, actionFilters, FindMessageStructureAction.Request::new, (Executor)executor.handledTransportActionExecutorService());
        this.threadPool = threadPool;
        this.executor = executor;
    }

    protected void doExecute(Task task, FindMessageStructureAction.Request request, ActionListener<FindStructureResponse> listener) {
        this.executor.execute(listener, () -> this.buildTextStructureResponse(request));
    }

    private FindStructureResponse buildTextStructureResponse(FindMessageStructureAction.Request request) throws Exception {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
        TextStructureFinderManager structureFinderManager = new TextStructureFinderManager(this.threadPool.scheduler());
        TextStructureFinder textStructureFinder = structureFinderManager.findTextStructure(request.getMessages(), new TextStructureOverrides((AbstractFindStructureRequest)request), request.getTimeout());
        return new FindStructureResponse(textStructureFinder.getStructure());
    }
}

