/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.LongGauge;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

public class LongGaugeAdapter
extends AbstractInstrument<ObservableLongGauge>
implements LongGauge {
    public LongGaugeAdapter(Meter meter, String name, String description, String unit, Supplier<Collection<LongWithAttributes>> observer) {
        super(meter, new Builder(name, description, unit, observer));
    }

    public void close() throws Exception {
        ((ObservableLongGauge)this.getInstrument()).close();
    }

    private static class Builder
    extends AbstractInstrument.Builder<ObservableLongGauge> {
        private final Supplier<Collection<LongWithAttributes>> observer;

        private Builder(String name, String description, String unit, Supplier<Collection<LongWithAttributes>> observer) {
            super(name, description, unit);
            this.observer = observer;
        }

        @Override
        public ObservableLongGauge build(Meter meter) {
            return Objects.requireNonNull(meter).gaugeBuilder(this.name).ofLongs().setDescription(this.description).setUnit(this.unit).buildWithCallback(OtelHelper.longMeasurementCallback(this.observer));
        }
    }
}

