/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class NotQuery
extends Query {
    private final Query child;

    public NotQuery(Source source, Query child) {
        super(source);
        if (child == null) {
            throw new IllegalArgumentException("child is required");
        }
        this.child = child;
    }

    public Query child() {
        return this.child;
    }

    @Override
    protected QueryBuilder asBuilder() {
        return QueryBuilders.boolQuery().mustNot(this.child.toQueryBuilder());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.child.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NotQuery other = (NotQuery)obj;
        return this.child.equals(other.child);
    }

    @Override
    protected String innerToString() {
        return this.child.toString();
    }

    @Override
    public Query negate(Source source) {
        return this.child;
    }
}

