/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.ThreadWatchdog;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.InboundAggregator;
import org.elasticsearch.transport.InboundDecoder;
import org.elasticsearch.transport.InboundPipeline;
import org.elasticsearch.transport.NetworkTraceFlag;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.TcpServerChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty4.ESLoggingHandler;
import org.elasticsearch.transport.netty4.NetUtils;
import org.elasticsearch.transport.netty4.Netty4MessageInboundHandler;
import org.elasticsearch.transport.netty4.Netty4NioSocketChannel;
import org.elasticsearch.transport.netty4.Netty4Plugin;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.transport.netty4.Netty4TcpServerChannel;
import org.elasticsearch.transport.netty4.Netty4Utils;
import org.elasticsearch.transport.netty4.Netty4WriteThrottlingHandler;
import org.elasticsearch.transport.netty4.NettyAllocator;
import org.elasticsearch.transport.netty4.NettyByteBufSizer;
import org.elasticsearch.transport.netty4.SharedGroupFactory;

public class Netty4Transport
extends TcpTransport {
    private static final Logger logger = LogManager.getLogger(Netty4Transport.class);
    public static final ChannelOption<Integer> OPTION_TCP_KEEP_IDLE = NioChannelOption.of(NetUtils.getTcpKeepIdleSocketOption());
    public static final ChannelOption<Integer> OPTION_TCP_KEEP_INTERVAL = NioChannelOption.of(NetUtils.getTcpKeepIntervalSocketOption());
    public static final ChannelOption<Integer> OPTION_TCP_KEEP_COUNT = NioChannelOption.of(NetUtils.getTcpKeepCountSocketOption());
    private final SharedGroupFactory sharedGroupFactory;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final ByteSizeValue receivePredictorMin;
    private final ByteSizeValue receivePredictorMax;
    private final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();
    private volatile Bootstrap clientBootstrap;
    private volatile SharedGroupFactory.SharedGroup sharedGroup;
    protected final boolean remoteClusterPortEnabled;
    private final ThreadWatchdog threadWatchdog;
    static final AttributeKey<Netty4TcpChannel> CHANNEL_KEY = AttributeKey.newInstance((String)"es-channel");
    static final AttributeKey<Netty4TcpServerChannel> SERVER_CHANNEL_KEY = AttributeKey.newInstance((String)"es-server-channel");

    public Netty4Transport(Settings settings, TransportVersion version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SharedGroupFactory sharedGroupFactory) {
        super(settings, version, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        Netty4Utils.setAvailableProcessors(EsExecutors.allocatedProcessors((Settings)settings));
        NettyAllocator.logAllocatorDescriptionIfNeeded();
        this.sharedGroupFactory = sharedGroupFactory;
        this.threadWatchdog = networkService.getThreadWatchdog();
        this.receivePredictorMin = (ByteSizeValue)Netty4Plugin.NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = (ByteSizeValue)Netty4Plugin.NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
        this.remoteClusterPortEnabled = (Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(settings);
    }

    protected Recycler<BytesRef> createRecycler(Settings settings, PageCacheRecycler pageCacheRecycler) {
        return Netty4Utils.createRecycler(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            this.sharedGroup = this.sharedGroupFactory.getTransportGroup();
            this.clientBootstrap = this.createClientBootstrap(this.sharedGroup);
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettingsSet) {
                    this.createServerBootstrap(profileSettings, this.sharedGroup);
                    this.bindServer(profileSettings);
                }
            }
            this.threadWatchdog.run(this.settings, this.threadPool, this.lifecycle);
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createClientBootstrap(SharedGroupFactory.SharedGroup sharedGroupForBootstrap) {
        ByteSizeValue tcpReceiveBufferSize;
        ByteSizeValue tcpSendBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(sharedGroupForBootstrap.getLowLevelGroup());
        assert (Netty4NioSocketChannel.class.isAssignableFrom(NettyAllocator.getChannelType()));
        bootstrap.channel(NettyAllocator.getChannelType());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)((Boolean)TransportSettings.TCP_NO_DELAY.get(this.settings)));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)((Boolean)TransportSettings.TCP_KEEP_ALIVE.get(this.settings)));
        if (((Boolean)TransportSettings.TCP_KEEP_ALIVE.get(this.settings)).booleanValue()) {
            if ((Integer)TransportSettings.TCP_KEEP_IDLE.get(this.settings) >= 0) {
                bootstrap.option(OPTION_TCP_KEEP_IDLE, (Object)((Integer)TransportSettings.TCP_KEEP_IDLE.get(this.settings)));
            }
            if ((Integer)TransportSettings.TCP_KEEP_INTERVAL.get(this.settings) >= 0) {
                bootstrap.option(OPTION_TCP_KEEP_INTERVAL, (Object)((Integer)TransportSettings.TCP_KEEP_INTERVAL.get(this.settings)));
            }
            if ((Integer)TransportSettings.TCP_KEEP_COUNT.get(this.settings) >= 0) {
                bootstrap.option(OPTION_TCP_KEEP_COUNT, (Object)((Integer)TransportSettings.TCP_KEEP_COUNT.get(this.settings)));
            }
        }
        if ((tcpSendBufferSize = (ByteSizeValue)TransportSettings.TCP_SEND_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        boolean reuseAddress = (Boolean)TransportSettings.TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        return bootstrap;
    }

    private void createServerBootstrap(TcpTransport.ProfileSettings profileSettings, SharedGroupFactory.SharedGroup sharedGroupForServerBootstrap) {
        String name = profileSettings.profileName;
        if (logger.isDebugEnabled()) {
            logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], receive_predictor[{}->{}]", (Object)name, (Object)this.sharedGroupFactory.getTransportWorkerCount(), (Object)profileSettings.portOrRange, (Object)profileSettings.bindHosts, (Object)profileSettings.publishHosts, (Object)this.receivePredictorMin, (Object)this.receivePredictorMax);
        }
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(sharedGroupForServerBootstrap.getLowLevelGroup());
        serverBootstrap.channel(NettyAllocator.getServerChannelType());
        serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        serverBootstrap.childHandler(this.getServerChannelInitializer(name));
        serverBootstrap.handler((ChannelHandler)new ServerChannelExceptionHandler());
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)profileSettings.tcpNoDelay);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)profileSettings.tcpKeepAlive);
        if (profileSettings.tcpKeepAlive) {
            if (profileSettings.tcpKeepIdle >= 0) {
                serverBootstrap.childOption(NioChannelOption.of(NetUtils.getTcpKeepIdleSocketOption()), (Object)profileSettings.tcpKeepIdle);
            }
            if (profileSettings.tcpKeepInterval >= 0) {
                serverBootstrap.childOption(NioChannelOption.of(NetUtils.getTcpKeepIntervalSocketOption()), (Object)profileSettings.tcpKeepInterval);
            }
            if (profileSettings.tcpKeepCount >= 0) {
                serverBootstrap.childOption(NioChannelOption.of(NetUtils.getTcpKeepCountSocketOption()), (Object)profileSettings.tcpKeepCount);
            }
        }
        if (profileSettings.sendBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(profileSettings.sendBufferSize.getBytes()));
        }
        if (profileSettings.receiveBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(profileSettings.receiveBufferSize.bytesAsInt()));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.validate();
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new ServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node, ConnectionProfile connectionProfile) {
        return new ClientChannelInitializer();
    }

    protected Netty4TcpChannel initiateChannel(DiscoveryNode node, ConnectionProfile connectionProfile) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        Bootstrap bootstrapWithHandler = this.getClientBootstrap(connectionProfile);
        bootstrapWithHandler.handler(this.getClientChannelInitializer(node, connectionProfile));
        bootstrapWithHandler.remoteAddress((SocketAddress)address);
        ChannelFuture connectFuture = bootstrapWithHandler.connect();
        Channel channel = connectFuture.channel();
        if (channel == null) {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)connectFuture.cause());
            throw new IOException(connectFuture.cause());
        }
        Netty4TcpChannel nettyChannel = new Netty4TcpChannel(channel, false, connectionProfile.getTransportProfile(), this.rstOnClose, connectFuture);
        channel.attr(CHANNEL_KEY).set((Object)nettyChannel);
        return nettyChannel;
    }

    protected Bootstrap getClientBootstrap(ConnectionProfile connectionProfile) {
        return this.clientBootstrap.clone();
    }

    protected Netty4TcpServerChannel bind(String name, InetSocketAddress address) {
        Channel channel = this.serverBootstraps.get(name).bind((SocketAddress)address).syncUninterruptibly().channel();
        Netty4TcpServerChannel esChannel = new Netty4TcpServerChannel(channel);
        channel.attr(SERVER_CHANNEL_KEY).set((Object)esChannel);
        return esChannel;
    }

    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasable[] releasableArray = new Releasable[3];
        releasableArray[0] = () -> {
            if (this.sharedGroup != null) {
                this.sharedGroup.shutdown();
            }
        };
        releasableArray[1] = this.serverBootstraps::clear;
        releasableArray[2] = () -> {
            this.clientBootstrap = null;
        };
        Releasables.close((Releasable[])releasableArray);
    }

    private void setupPipeline(Channel ch, boolean isRemoteClusterServerChannel) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("byte_buf_sizer", (ChannelHandler)NettyByteBufSizer.INSTANCE);
        if (NetworkTraceFlag.TRACE_ENABLED) {
            pipeline.addLast("logging", (ChannelHandler)ESLoggingHandler.INSTANCE);
        }
        pipeline.addLast("chunked_writer", (ChannelHandler)new Netty4WriteThrottlingHandler(this.getThreadPool().getThreadContext(), this.threadWatchdog.getActivityTrackerForCurrentThread()));
        pipeline.addLast("dispatcher", (ChannelHandler)new Netty4MessageInboundHandler(this, this.getInboundPipeline(ch, isRemoteClusterServerChannel), this.threadWatchdog.getActivityTrackerForCurrentThread()));
    }

    protected InboundPipeline getInboundPipeline(Channel ch, boolean isRemoteClusterServerChannel) {
        return new InboundPipeline(this.getStatsTracker(), this.threadPool.relativeTimeInMillisSupplier(), new InboundDecoder(this.recycler), new InboundAggregator(this.getInflightBreaker(), arg_0 -> ((Transport.RequestHandlers)this.getRequestHandlers()).getHandler(arg_0), this.ignoreDeserializationErrors()), (arg_0, arg_1) -> ((Netty4Transport)this).inboundMessage(arg_0, arg_1));
    }

    private static void addClosedExceptionLogger(Channel channel) {
        Netty4Utils.addListener(channel.closeFuture(), channelFuture -> {
            if (!channelFuture.isSuccess() && logger.isDebugEnabled()) {
                logger.debug(Strings.format((String)"exception while closing channel: %s", (Object[])new Object[]{channelFuture.channel()}), channelFuture.cause());
            }
        });
    }

    @ChannelHandler.Sharable
    private static class ServerChannelExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private ServerChannelExceptionHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            Netty4TcpServerChannel serverChannel = (Netty4TcpServerChannel)ctx.channel().attr(SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                Netty4Transport.onServerException((TcpServerChannel)serverChannel, (Exception)new Exception(cause));
            } else {
                Netty4Transport.onServerException((TcpServerChannel)serverChannel, (Exception)((Exception)cause));
            }
        }
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;
        private final boolean isRemoteClusterServerChannel;

        protected ServerChannelInitializer(String name) {
            this.name = name;
            this.isRemoteClusterServerChannel = Netty4Transport.this.remoteClusterPortEnabled && "_remote_cluster".equals(name);
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4Transport.addClosedExceptionLogger(ch);
            assert (ch instanceof Netty4NioSocketChannel);
            NetUtils.tryEnsureReasonableKeepAliveConfig(((Netty4NioSocketChannel)ch).javaChannel());
            Netty4TcpChannel nettyTcpChannel = new Netty4TcpChannel(ch, true, this.name, Netty4Transport.this.rstOnClose, ch.newSucceededFuture());
            ch.attr(CHANNEL_KEY).set((Object)nettyTcpChannel);
            Netty4Transport.this.setupPipeline(ch, this.isRemoteClusterServerChannel);
            Netty4Transport.this.serverAcceptedChannel(nettyTcpChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4Transport.addClosedExceptionLogger(ch);
            assert (ch instanceof Netty4NioSocketChannel);
            NetUtils.tryEnsureReasonableKeepAliveConfig(((Netty4NioSocketChannel)ch).javaChannel());
            Netty4Transport.this.setupPipeline(ch, false);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

