/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.apmdata;

import java.util.function.Predicate;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.apmdata.APMPlugin;
import org.elasticsearch.xpack.core.template.YamlTemplateRegistry;

public class APMIndexTemplateRegistry
extends YamlTemplateRegistry {
    public static final String APM_TEMPLATE_VERSION_VARIABLE = "xpack.apmdata.template.version";

    public APMIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry, APMIndexTemplateRegistry.templateFilter(DataStreamLifecycle.isDataStreamsLifecycleOnlyMode((Settings)clusterService.getSettings())));
    }

    public String getName() {
        return "apm";
    }

    public void initialize() {
        super.initialize();
        if (this.isEnabled()) {
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(APMPlugin.APM_DATA_REGISTRY_ENABLED, arg_0 -> ((APMIndexTemplateRegistry)this).setEnabled(arg_0));
        }
    }

    protected String getVersionProperty() {
        return APM_TEMPLATE_VERSION_VARIABLE;
    }

    protected String getOrigin() {
        return "apm";
    }

    private static Predicate<String> templateFilter(boolean dslOnlyMode) {
        return templateName -> !dslOnlyMode || !templateName.endsWith("@ilm");
    }
}

