# Test suite (for verifying correctness)
#
# The test suite is a list of 5- or 3-tuples.  The 5 parts of a
# complete tuple are:
# element 0: a string containing the pattern
#         1: the string to match against the pattern
#         2: the expected result (0 - SUCCEED, 1 - FAIL, 2 - SYNTAX_ERROR)
#         3: a string that will be eval()'ed to produce a test string.
#            This is an arbitrary Python expression; the available
#            variables are "found" (the whole match), and "g1", "g2", ...
#            up to "g10" contain the contents of each group, or the
#            string 'None' if the group wasn't given a value.
#         4: The expected result of evaluating the expression.
#            If the two don't match, an error is reported.
#
# If the regex isn't expected to work, the latter two elements can be omitted.

# test suite for search
search_regex_tests=[
['abc', 'abc', 0, 'found', 'abc'],
['abc', 'xbc', 1],
['abc', 'axc', 1],
['abc', 'abx', 1],
['abc', 'xabcy', 0, 'found', 'abc'],
['abc', 'ababc', 0, 'found', 'abc'],
['ab*c', 'abc', 0, 'found', 'abc'],
['ab*bc', 'abc', 0, 'found', 'abc'],
['ab*bc', 'abbc', 0, 'found', 'abbc'],
['ab*bc', 'abbbbc', 0, 'found', 'abbbbc'],
['ab+bc', 'abbc', 0, 'found', 'abbc'],
['ab+bc', 'abc', 1],
['ab+bc', 'abq', 1],
['ab+bc', 'abbbbc', 0, 'found', 'abbbbc'],
['ab?bc', 'abbc', 0, 'found', 'abbc'],
['ab?bc', 'abc', 0, 'found', 'abc'],
['ab?bc', 'abbbbc', 1],
['ab?c', 'abc', 0, 'found', 'abc'],
['^abc$', 'abc', 0, 'found', 'abc'],
['^abc$', 'abcc', 1],
['^abc', 'abcc', 0, 'found', 'abc'],
['^abc$', 'aabc', 1],
['abc$', 'aabc', 0, 'found', 'abc'],
['^', 'abc', 0, 'found+"-"', '-'],
['$', 'abc', 0, 'found+"-"', '-'],
['a.c', 'abc', 0, 'found', 'abc'],
['a.c', 'axc', 0, 'found', 'axc'],
['a.*c', 'axyzc', 0, 'found', 'axyzc'],
['a.*c', 'axyzd', 1],
['a[bc]d', 'abc', 1],
['a[bc]d', 'abd', 0, 'found', 'abd'],
['a[b-d]e', 'abd', 1],
['a[b-d]e', 'ace', 0, 'found', 'ace'],
['a[b-d]', 'aac', 0, 'found', 'ac'],
['a[-b]', 'a-', 0, 'found', 'a-'],
['a[b-]', 'a-', 0, 'found', 'a-'],
['a[]b', '-', 2],
['a[', '-', 2],
['a\\', '-', 2],
['abc\\)', '-', 2],
['\\(abc', '-', 2],
['a]', 'a]', 0, 'found', 'a]'],
['a[]]b', 'a]b', 0, 'found', 'a]b'],
['a[^bc]d', 'aed', 0, 'found', 'aed'],
['a[^bc]d', 'abd', 1],
['a[^-b]c', 'adc', 0, 'found', 'adc'],
['a[^-b]c', 'a-c', 1],
['a[^]b]c', 'a]c', 1],
['a[^]b]c', 'adc', 0, 'found', 'adc'],
['\\ba\\b', 'a-', 0, '"-"', '-'],
['\\ba\\b', '-a', 0, '"-"', '-'],
['\\ba\\b', '-a-', 0, '"-"', '-'],
['\\by\\b', 'xy', 1],
['\\by\\b', 'yz', 1],
['\\by\\b', 'xyz', 1],
['ab\\|cd', 'abc', 0, 'found', 'ab'],
['ab\\|cd', 'abcd', 0, 'found', 'ab'],
['\\(\\)ef', 'def', 0, 'found+"-"+g1', 'ef-'],
['$b', 'b', 1],
['a(b', 'a(b', 0, 'found+"-"+g1', 'a(b-None'],
['a(*b', 'ab', 0, 'found', 'ab'],
['a(*b', 'a((b', 0, 'found', 'a((b'],
['a\\\\b', 'a\\b', 0, 'found', 'a\\b'],
['\\(\\(a\\)\\)', 'abc', 0, 'found+"-"+g1+"-"+g2', 'a-a-a'],
['\\(a\\)b\\(c\\)', 'abc', 0, 'found+"-"+g1+"-"+g2', 'abc-a-c'],
['a+b+c', 'aabbabc', 0, 'found', 'abc'],
['\\(a+\\|b\\)*', 'ab', 0, 'found+"-"+g1', 'ab-b'],
['\\(a+\\|b\\)+', 'ab', 0, 'found+"-"+g1', 'ab-b'],
['\\(a+\\|b\\)?', 'ab', 0, 'found+"-"+g1', 'a-a'],
['\\)\\(', '-', 2],
['[^ab]*', 'cde', 0, 'found', 'cde'],
['abc', '', 1],
['a*', '', 0, 'found', ''],
['a\\|b\\|c\\|d\\|e', 'e', 0, 'found', 'e'],
['\\(a\\|b\\|c\\|d\\|e\\)f', 'ef', 0, 'found+"-"+g1', 'ef-e'],
['abcd*efg', 'abcdefg', 0, 'found', 'abcdefg'],
['ab*', 'xabyabbbz', 0, 'found', 'ab'],
['ab*', 'xayabbbz', 0, 'found', 'a'],
['\\(ab\\|cd\\)e', 'abcde', 0, 'found+"-"+g1', 'cde-cd'],
['[abhgefdc]ij', 'hij', 0, 'found', 'hij'],
['^\\(ab\\|cd\\)e', 'abcde', 1, 'xg1y', 'xy'],
['\\(abc\\|\\)ef', 'abcdef', 0, 'found+"-"+g1', 'ef-'],
['\\(a\\|b\\)c*d', 'abcd', 0, 'found+"-"+g1', 'bcd-b'],
['\\(ab\\|ab*\\)bc', 'abc', 0, 'found+"-"+g1', 'abc-a'],
['a\\([bc]*\\)c*', 'abc', 0, 'found+"-"+g1', 'abc-bc'],
['a\\([bc]*\\)\\(c*d\\)', 'abcd', 0, 'found+"-"+g1+"-"+g2', 'abcd-bc-d'],
['a\\([bc]+\\)\\(c*d\\)', 'abcd', 0, 'found+"-"+g1+"-"+g2', 'abcd-bc-d'],
['a\\([bc]*\\)\\(c+d\\)', 'abcd', 0, 'found+"-"+g1+"-"+g2', 'abcd-b-cd'],
['a[bcd]*dcdcde', 'adcdcde', 0, 'found', 'adcdcde'],
['a[bcd]+dcdcde', 'adcdcde', 1],
['\\(ab\\|a\\)b*c', 'abc', 0, 'found+"-"+g1', 'abc-ab'],
['\\(\\(a\\)\\(b\\)c\\)\\(d\\)', 'abcd', 0, 'g1+"-"+g2+"-"+g3+"-"+g4', 'abc-a-b-d'],
['[a-zA-Z_][a-zA-Z0-9_]*', 'alpha', 0, 'found', 'alpha'],
['^a\\(bc+\\|b[eh]\\)g\\|.h$', 'abh', 0, 'found+"-"+g1', 'bh-None'],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'effgz', 0, 'found+"-"+g1+"-"+g2', 'effgz-effgz-None'],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'ij', 0, 'found+"-"+g1+"-"+g2', 'ij-ij-j'],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'effg', 1],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'bcdd', 1],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'reffgz', 0, 'found+"-"+g1+"-"+g2', 'effgz-effgz-None'],
['\\(\\(\\(\\(\\(\\(\\(\\(\\(a\\)\\)\\)\\)\\)\\)\\)\\)\\)', 'a', 0, 'found', 'a'],
['multiple words of text', 'uh-uh', 1],
['multiple words', 'multiple words, yeah', 0, 'found', 'multiple words'],
['\\(.*\\)c\\(.*\\)', 'abcde', 0, 'found+"-"+g1+"-"+g2', 'abcde-ab-de'],
['(\\(.*\\), \\(.*\\))', '(a, b)', 0, 'g2+"-"+g1', 'b-a'],
['[k]', 'ab', 1],
['a[-]?c', 'ac', 0, 'found', 'ac'],
['\\(abc\\)\\1', 'abcabc', 0, 'g1', 'abc'],
['\\([a-c]*\\)\\1', 'abcabc', 0, 'g1', 'abc'],
['^\\(.+\\)?B', 'AB', 0, 'g1', 'A'],
['\\(a+\\).\\1$', 'aaaaa', 0, 'found+"-"+g1', 'aaaaa-aa'],
['^\\(a+\\).\\1$', 'aaaa', 1],
['\\(abc\\)\\1', 'abcabc', 0, 'found+"-"+g1', 'abcabc-abc'],
['\\([a-c]+\\)\\1', 'abcabc', 0, 'found+"-"+g1', 'abcabc-abc'],
['\\(a\\)\\1', 'aa', 0, 'found+"-"+g1', 'aa-a'],
['\\(a+\\)\\1', 'aa', 0, 'found+"-"+g1', 'aa-a'],
['\\(a+\\)+\\1', 'aa', 0, 'found+"-"+g1', 'aa-a'],
['\\(a\\).+\\1', 'aba', 0, 'found+"-"+g1', 'aba-a'],
['\\(a\\)ba*\\1', 'aba', 0, 'found+"-"+g1', 'aba-a'],
['\\(aa\\|a\\)a\\1$', 'aaa', 0, 'found+"-"+g1', 'aaa-a'],
['\\(a\\|aa\\)a\\1$', 'aaa', 0, 'found+"-"+g1', 'aaa-a'],
['\\(a+\\)a\\1$', 'aaa', 0, 'found+"-"+g1', 'aaa-a'],
['\\([abc]*\\)\\1', 'abcabc', 0, 'found+"-"+g1', 'abcabc-abc'],
['\\(a\\)\\(b\\)c\\|ab', 'ab', 0, 'found+"-"+g1+"-"+g2', 'ab-None-None'],
['\\(a\\)+x', 'aaax', 0, 'found+"-"+g1', 'aaax-a'],
['\\([ac]\\)+x', 'aacx', 0, 'found+"-"+g1', 'aacx-c'],
['\\([^/]*/\\)*sub1/', 'd:msgs/tdir/sub1/trial/away.cpp', 0, 'found+"-"+g1', 'd:msgs/tdir/sub1/-tdir/'],
['\\([^.]*\\)\\.\\([^:]*\\):[T ]+\\(.*\\)', 'track1.title:TBlah blah blah', 0, 'found+"-"+g1+"-"+g2+"-"+g3', 'track1.title:TBlah blah blah-track1-title-Blah blah blah'],
['\\([^N]*N\\)+', 'abNNxyzN', 0, 'found+"-"+g1', 'abNNxyzN-xyzN'],
['\\([^N]*N\\)+', 'abNNxyz', 0, 'found+"-"+g1', 'abNN-N'],
['\\([abc]*\\)x', 'abcx', 0, 'found+"-"+g1', 'abcx-abc'],
['\\([abc]*\\)x', 'abc', 1],
['\\([xyz]*\\)x', 'abcx', 0, 'found+"-"+g1', 'x-'],
['\\(a\\)+b\\|aac', 'aac', 0, 'found+"-"+g1', 'aac-None'],
['\\<a', 'a', 0, 'found', 'a'],
['\\<a', '!', 1],
['a\\<b', 'ab', 1],
['a\\>', 'ab', 1],
['a\\>', 'a!', 0, 'found', 'a'],
['a\\>', 'a', 0, 'found', 'a'],
]


# test suite for match
match_regex_tests=[
['abc', 'abc', 0, 'found', 'abc'],
['abc', 'xbc', 1],
['abc', 'axc', 1],
['abc', 'abx', 1],
['abc', 'xabcy', 1],
['abc', 'ababc', 1],
['ab*c', 'abc', 0, 'found', 'abc'],
['ab*bc', 'abc', 0, 'found', 'abc'],
['ab*bc', 'abbc', 0, 'found', 'abbc'],
['ab*bc', 'abbbbc', 0, 'found', 'abbbbc'],
['ab+bc', 'abbc', 0, 'found', 'abbc'],
['ab+bc', 'abc', 1],
['ab+bc', 'abq', 1],
['ab+bc', 'abbbbc', 0, 'found', 'abbbbc'],
['ab?bc', 'abbc', 0, 'found', 'abbc'],
['ab?bc', 'abc', 0, 'found', 'abc'],
['ab?bc', 'abbbbc', 1],
['ab?c', 'abc', 0, 'found', 'abc'],
['^abc$', 'abc', 0, 'found', 'abc'],
['^abc$', 'abcc', 1],
['^abc', 'abcc', 0, 'found', 'abc'],
['^abc$', 'aabc', 1],
['abc$', 'aabc', 1],
['^', 'abc', 0, 'found+"-"', '-'],
['$', 'abc', 1],
['a.c', 'abc', 0, 'found', 'abc'],
['a.c', 'axc', 0, 'found', 'axc'],
['a.*c', 'axyzc', 0, 'found', 'axyzc'],
['a.*c', 'axyzd', 1],
['a[bc]d', 'abc', 1],
['a[bc]d', 'abd', 0, 'found', 'abd'],
['a[b-d]e', 'abd', 1],
['a[b-d]e', 'ace', 0, 'found', 'ace'],
['a[b-d]', 'aac', 1],
['a[-b]', 'a-', 0, 'found', 'a-'],
['a[b-]', 'a-', 0, 'found', 'a-'],
['a[]b', '-', 2],
['a[', '-', 2],
['a\\', '-', 2],
['abc\\)', '-', 2],
['\\(abc', '-', 2],
['a]', 'a]', 0, 'found', 'a]'],
['a[]]b', 'a]b', 0, 'found', 'a]b'],
['a[^bc]d', 'aed', 0, 'found', 'aed'],
['a[^bc]d', 'abd', 1],
['a[^-b]c', 'adc', 0, 'found', 'adc'],
['a[^-b]c', 'a-c', 1],
['a[^]b]c', 'a]c', 1],
['a[^]b]c', 'adc', 0, 'found', 'adc'],
['\\ba\\b', 'a-', 0, '"-"', '-'],
['\\ba\\b', '-a', 1],
['\\ba\\b', '-a-', 1],
['\\by\\b', 'xy', 1],
['\\by\\b', 'yz', 1],
['\\by\\b', 'xyz', 1],
['ab\\|cd', 'abc', 0, 'found', 'ab'],
['ab\\|cd', 'abcd', 0, 'found', 'ab'],
['\\(\\)ef', 'def', 1],
['$b', 'b', 1],
['a(b', 'a(b', 0, 'found+"-"+g1', 'a(b-None'],
['a(*b', 'ab', 0, 'found', 'ab'],
['a(*b', 'a((b', 0, 'found', 'a((b'],
['a\\\\b', 'a\\b', 0, 'found', 'a\\b'],
['\\(\\(a\\)\\)', 'abc', 0, 'found+"-"+g1+"-"+g2', 'a-a-a'],
['\\(a\\)b\\(c\\)', 'abc', 0, 'found+"-"+g1+"-"+g2', 'abc-a-c'],
['a+b+c', 'aabbabc', 1],
['\\(a+\\|b\\)*', 'ab', 0, 'found+"-"+g1', 'ab-b'],
['\\(a+\\|b\\)+', 'ab', 0, 'found+"-"+g1', 'ab-b'],
['\\(a+\\|b\\)?', 'ab', 0, 'found+"-"+g1', 'a-a'],
['\\)\\(', '-', 2],
['[^ab]*', 'cde', 0, 'found', 'cde'],
['abc', '', 1],
['a*', '', 0, 'found', ''],
['a\\|b\\|c\\|d\\|e', 'e', 0, 'found', 'e'],
['\\(a\\|b\\|c\\|d\\|e\\)f', 'ef', 0, 'found+"-"+g1', 'ef-e'],
['abcd*efg', 'abcdefg', 0, 'found', 'abcdefg'],
['ab*', 'xabyabbbz', 1],
['ab*', 'xayabbbz', 1],
['\\(ab\\|cd\\)e', 'abcde', 1],
['[abhgefdc]ij', 'hij', 0, 'found', 'hij'],
['^\\(ab\\|cd\\)e', 'abcde', 1, 'xg1y', 'xy'],
['\\(abc\\|\\)ef', 'abcdef', 1],
['\\(a\\|b\\)c*d', 'abcd', 1],
['\\(ab\\|ab*\\)bc', 'abc', 0, 'found+"-"+g1', 'abc-a'],
['a\\([bc]*\\)c*', 'abc', 0, 'found+"-"+g1', 'abc-bc'],
['a\\([bc]*\\)\\(c*d\\)', 'abcd', 0, 'found+"-"+g1+"-"+g2', 'abcd-bc-d'],
['a\\([bc]+\\)\\(c*d\\)', 'abcd', 0, 'found+"-"+g1+"-"+g2', 'abcd-bc-d'],
['a\\([bc]*\\)\\(c+d\\)', 'abcd', 0, 'found+"-"+g1+"-"+g2', 'abcd-b-cd'],
['a[bcd]*dcdcde', 'adcdcde', 0, 'found', 'adcdcde'],
['a[bcd]+dcdcde', 'adcdcde', 1],
['\\(ab\\|a\\)b*c', 'abc', 0, 'found+"-"+g1', 'abc-ab'],
['\\(\\(a\\)\\(b\\)c\\)\\(d\\)', 'abcd', 0, 'g1+"-"+g2+"-"+g3+"-"+g4', 'abc-a-b-d'],
['[a-zA-Z_][a-zA-Z0-9_]*', 'alpha', 0, 'found', 'alpha'],
['^a\\(bc+\\|b[eh]\\)g\\|.h$', 'abh', 1],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'effgz', 0, 'found+"-"+g1+"-"+g2', 'effgz-effgz-None'],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'ij', 0, 'found+"-"+g1+"-"+g2', 'ij-ij-j'],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'effg', 1],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'bcdd', 1],
['\\(bc+d$\\|ef*g.\\|h?i\\(j\\|k\\)\\)', 'reffgz', 1],
['\\(\\(\\(\\(\\(\\(\\(\\(\\(a\\)\\)\\)\\)\\)\\)\\)\\)\\)', 'a', 0, 'found', 'a'],
['multiple words of text', 'uh-uh', 1],
['multiple words', 'multiple words, yeah', 0, 'found', 'multiple words'],
['\\(.*\\)c\\(.*\\)', 'abcde', 0, 'found+"-"+g1+"-"+g2', 'abcde-ab-de'],
['(\\(.*\\), \\(.*\\))', '(a, b)', 0, 'g2+"-"+g1', 'b-a'],
['[k]', 'ab', 1],
['a[-]?c', 'ac', 0, 'found', 'ac'],
['\\(abc\\)\\1', 'abcabc', 0, 'g1', 'abc'],
['\\([a-c]*\\)\\1', 'abcabc', 0, 'g1', 'abc'],
['^\\(.+\\)?B', 'AB', 0, 'g1', 'A'],
['\\(a+\\).\\1$', 'aaaaa', 0, 'found+"-"+g1', 'aaaaa-aa'],
['^\\(a+\\).\\1$', 'aaaa', 1],
['\\(abc\\)\\1', 'abcabc', 0, 'found+"-"+g1', 'abcabc-abc'],
['\\([a-c]+\\)\\1', 'abcabc', 0, 'found+"-"+g1', 'abcabc-abc'],
['\\(a\\)\\1', 'aa', 0, 'found+"-"+g1', 'aa-a'],
['\\(a+\\)\\1', 'aa', 0, 'found+"-"+g1', 'aa-a'],
['\\(a+\\)+\\1', 'aa', 0, 'found+"-"+g1', 'aa-a'],
['\\(a\\).+\\1', 'aba', 0, 'found+"-"+g1', 'aba-a'],
['\\(a\\)ba*\\1', 'aba', 0, 'found+"-"+g1', 'aba-a'],
['\\(aa\\|a\\)a\\1$', 'aaa', 0, 'found+"-"+g1', 'aaa-a'],
['\\(a\\|aa\\)a\\1$', 'aaa', 0, 'found+"-"+g1', 'aaa-a'],
['\\(a+\\)a\\1$', 'aaa', 0, 'found+"-"+g1', 'aaa-a'],
['\\([abc]*\\)\\1', 'abcabc', 0, 'found+"-"+g1', 'abcabc-abc'],
['\\(a\\)\\(b\\)c\\|ab', 'ab', 0, 'found+"-"+g1+"-"+g2', 'ab-None-None'],
['\\(a\\)+x', 'aaax', 0, 'found+"-"+g1', 'aaax-a'],
['\\([ac]\\)+x', 'aacx', 0, 'found+"-"+g1', 'aacx-c'],
['\\([^/]*/\\)*sub1/', 'd:msgs/tdir/sub1/trial/away.cpp', 0, 'found+"-"+g1', 'd:msgs/tdir/sub1/-tdir/'],
['\\([^.]*\\)\\.\\([^:]*\\):[T ]+\\(.*\\)', 'track1.title:TBlah blah blah', 0, 'found+"-"+g1+"-"+g2+"-"+g3', 'track1.title:TBlah blah blah-track1-title-Blah blah blah'],
['\\([^N]*N\\)+', 'abNNxyzN', 0, 'found+"-"+g1', 'abNNxyzN-xyzN'],
['\\([^N]*N\\)+', 'abNNxyz', 0, 'found+"-"+g1', 'abNN-N'],
['\\([abc]*\\)x', 'abcx', 0, 'found+"-"+g1', 'abcx-abc'],
['\\([abc]*\\)x', 'abc', 1],
['\\([xyz]*\\)x', 'abcx', 1],
['\\(a\\)+b\\|aac', 'aac', 0, 'found+"-"+g1', 'aac-None'],
['\\<a', 'a', 0, 'found', 'a'],
['\\<a', '!', 1],
['a\\<b', 'ab', 1],
['a\\>', 'ab', 1],
['a\\>', 'a!', 0, 'found', 'a'],
['a\\>', 'a', 0, 'found', 'a'],
]

# test suite for split()
# element 0: pattern
#         1: string to split
#         3: compile result
#         4: maxsplit
#         5: splitted fields list
split_regex_tests = [
["[ |,]", "with you, nothing, and me", 0, 0, ["with","you","nothing","and","me"]],
["[ |,]", "with you, nothing, and me", 0, 1, ["with", "you, nothing, and me"]],
["\\ ", "send email to apply", 0, 0, ["send", "email", "to", "apply"]],
["\\ ", "send email to apply", 0, 2, ["send", "email", "to apply"]],
["[+ | -]", "+86-028-83201034", 0, 0, ["86", "028", "83201034"]],
["[+ | -]", "+86-028-83201034", 0, 1, ["86", "028-83201034"]],
["[*|#]", "slide show", 0, 0, ["slide show"]],
["(", "whats ever", 0, 1, ["whats ever"]],
["@#!~$%^&*()<>\n", "who knows", 0, 1, ["who knows"]],
]

# test suite for findall()
# element 0: pattern
#         1: string to match
#         3: compile result
#         4: starting position
#         5: grouped fields list

# reobj.find()
findall_regex_tests = [
["\\ ", "send email to apply", 0, 0, [" ", " ", " "]],
["\\ ", "send email to apply", 0, 5, [" ", " "]],
["[+ | -]", "+86-028-83201034", 0, 0, ["+", "-", "-"]],
["[+ | -]", "+86-028-83201034", 0, 1, ["-", "-"]],
["sl.*e\\|#", "slide show at Room #3", 0, 0, ["slide", "#"]],
["w.+s\\|e.*r", "whats ever", 0, 0, ["whats", "ever"]],
["Euler\\|Gauss", "Both Euler and Gauss are great mathematicians", 0, 0, ["Euler", "Gauss"]],
]

# module re.findall()
mod_findall_regex_tests = [
["\\ ", "send email to apply", 0, 0, [" ", " ", " "]],
["\\ ", "send email to apply", 0, 0, [" ", " ", " "]],
["[+ | -]", "+86-028-83201034", 0, 0, ["+", "-", "-"]],
["[+ | -]", "+86-028-83201034", 0, 0, ["+", "-", "-"]],
["sl.*e\\|#", "slide show at Room #3", 0, 0, ["slide", "#"]],
["w.+s\\|e.*r", "whats ever", 0, 0, ["whats", "ever"]],
["Euler\\|Gauss", "Both Euler and Gauss are great mathematicians", 0, 0, ["Euler", "Gauss"]],
]

# test for match object's groups() method
# element 0: pattern
#		  1: string
#		  2: compile result
#		  3: matched fields, for groups()
#		  4: group index, valid when > 0, for start(), end(), and span()
#		  5: pattern's starting index in string, for start() and span()
#		  6: pattern's ending index in string, for end() and span
matobj_groups_regex_tests = [
["\\(abc\\(.*xyz\\)\\(.*31415926\\)\\)", "where is abc and flurry xyz, which is pi 31415926, derived from ms", 0, ["abc and flurry xyz, which is pi 31415926"," and flurry xyz",", which is pi 31415926"], 2, 12, 27],

["[a\\|b]\\(.+\\)shoe\\([t]+\\)d", "bbbshoetttdxrznmlkjp", 0, ["bb", "ttt"], 1, 1, 3],

["abcdef", "xyah2oewoyqe030uabcdefwhalsdewnkhgiohyczb", 0, [], -1, 0, 0],
]

