// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::formatter::FormatterString;
#[cfg(any(feature = "intel", feature = "masm", feature = "mvex"))]
use crate::iced_constants::IcedConstants;
#[cfg(any(feature = "intel", feature = "nasm"))]
use alloc::vec::Vec;
use lazy_static::lazy_static;

#[cfg(feature = "mvex")]
pub(super) struct MvexFormatterConstants {
	pub(super) swizzle_cdab: FormatterString,
	pub(super) swizzle_badc: FormatterString,
	pub(super) swizzle_dacb: FormatterString,
	pub(super) swizzle_aaaa: FormatterString,
	pub(super) swizzle_bbbb: FormatterString,
	pub(super) swizzle_cccc: FormatterString,
	pub(super) swizzle_dddd: FormatterString,
	pub(super) mem_1to16: FormatterString,
	pub(super) mem_1to8: FormatterString,
	pub(super) mem_4to16: FormatterString,
	pub(super) mem_4to8: FormatterString,
	pub(super) mem_float16: FormatterString,
	pub(super) mem_uint8: FormatterString,
	pub(super) mem_sint8: FormatterString,
	pub(super) mem_uint16: FormatterString,
	pub(super) mem_sint16: FormatterString,
	pub(super) eh: FormatterString,
}

#[cfg(feature = "mvex")]
impl MvexFormatterConstants {
	fn new() -> Self {
		Self {
			swizzle_cdab: FormatterString::new_str("cdab"),
			swizzle_badc: FormatterString::new_str("badc"),
			swizzle_dacb: FormatterString::new_str("dacb"),
			swizzle_aaaa: FormatterString::new_str("aaaa"),
			swizzle_bbbb: FormatterString::new_str("bbbb"),
			swizzle_cccc: FormatterString::new_str("cccc"),
			swizzle_dddd: FormatterString::new_str("dddd"),
			mem_1to16: FormatterString::new_str("1to16"),
			mem_1to8: FormatterString::new_str("1to8"),
			mem_4to16: FormatterString::new_str("4to16"),
			mem_4to8: FormatterString::new_str("4to8"),
			mem_float16: FormatterString::new_str("float16"),
			mem_uint8: FormatterString::new_str("uint8"),
			mem_sint8: FormatterString::new_str("sint8"),
			mem_uint16: FormatterString::new_str("uint16"),
			mem_sint16: FormatterString::new_str("sint16"),
			eh: FormatterString::new_str("eh"),
		}
	}
}

#[allow(dead_code)]
pub(super) struct FormatterConstants {
	pub(super) empty: FormatterString,
	// GENERATOR-BEGIN: FormatterConstantsDef
	// ⚠️This was generated by GENERATOR!🦹‍♂️
	pub(super) b1to16: FormatterString,
	pub(super) b1to2: FormatterString,
	pub(super) b1to32: FormatterString,
	pub(super) b1to4: FormatterString,
	pub(super) b1to8: FormatterString,
	pub(super) bcst: FormatterString,
	pub(super) byte: FormatterString,
	pub(super) dword: FormatterString,
	pub(super) far: FormatterString,
	pub(super) fpuenv14: FormatterString,
	pub(super) fpuenv28: FormatterString,
	pub(super) fpustate108: FormatterString,
	pub(super) fpustate94: FormatterString,
	pub(super) fword: FormatterString,
	pub(super) mem384: FormatterString,
	pub(super) mmword: FormatterString,
	pub(super) oword: FormatterString,
	pub(super) ptr: FormatterString,
	pub(super) qword: FormatterString,
	pub(super) tbyte: FormatterString,
	pub(super) tword: FormatterString,
	pub(super) word: FormatterString,
	pub(super) xmmword: FormatterString,
	pub(super) ymmword: FormatterString,
	pub(super) yword: FormatterString,
	pub(super) zmmword: FormatterString,
	pub(super) zword: FormatterString,
	// GENERATOR-END: FormatterConstantsDef
	pub(super) bnd: FormatterString,
	pub(super) dot_byte: FormatterString,
	pub(super) hint_not_taken: FormatterString,
	pub(super) hint_taken: FormatterString,
	pub(super) hnt: FormatterString,
	pub(super) ht: FormatterString,
	pub(super) lock: FormatterString,
	pub(super) near: FormatterString,
	pub(super) notrack: FormatterString,
	pub(super) offset: FormatterString,
	pub(super) pn: FormatterString,
	pub(super) pt: FormatterString,
	pub(super) rel: FormatterString,
	pub(super) rep: FormatterString,
	pub(super) repe: [FormatterString; 2],
	pub(super) repne: [FormatterString; 2],
	pub(super) rex_w: FormatterString,
	pub(super) rne_sae: FormatterString,
	pub(super) rn_sae: FormatterString,
	pub(super) rd_sae: FormatterString,
	pub(super) ru_sae: FormatterString,
	pub(super) rz_sae: FormatterString,
	pub(super) sae: FormatterString,
	pub(super) rne: FormatterString,
	pub(super) rn: FormatterString,
	pub(super) rd: FormatterString,
	pub(super) ru: FormatterString,
	pub(super) rz: FormatterString,
	pub(super) short: FormatterString,
	pub(super) to: FormatterString,
	pub(super) xacquire: FormatterString,
	pub(super) xrelease: FormatterString,
	pub(super) z: FormatterString,
	pub(super) a16: FormatterString,
	pub(super) a32: FormatterString,
	pub(super) a64: FormatterString,
	pub(super) addr16: FormatterString,
	pub(super) addr32: FormatterString,
	pub(super) addr64: FormatterString,
	pub(super) data16: FormatterString,
	pub(super) data32: FormatterString,
	pub(super) data64: FormatterString,
	pub(super) o16: FormatterString,
	pub(super) o32: FormatterString,
	pub(super) o64: FormatterString,
	#[cfg(feature = "mvex")]
	pub(super) mvex: MvexFormatterConstants,
}

lazy_static! {
	pub(super) static ref FORMATTER_CONSTANTS: FormatterConstants = {
		FormatterConstants {
			empty: FormatterString::new_str(""),
			// GENERATOR-BEGIN: FormatterConstantsInit
			// ⚠️This was generated by GENERATOR!🦹‍♂️
			b1to16: FormatterString::new_str("1to16"),
			b1to2: FormatterString::new_str("1to2"),
			b1to32: FormatterString::new_str("1to32"),
			b1to4: FormatterString::new_str("1to4"),
			b1to8: FormatterString::new_str("1to8"),
			bcst: FormatterString::new_str("bcst"),
			byte: FormatterString::new_str("byte"),
			dword: FormatterString::new_str("dword"),
			far: FormatterString::new_str("far"),
			fpuenv14: FormatterString::new_str("fpuenv14"),
			fpuenv28: FormatterString::new_str("fpuenv28"),
			fpustate108: FormatterString::new_str("fpustate108"),
			fpustate94: FormatterString::new_str("fpustate94"),
			fword: FormatterString::new_str("fword"),
			mem384: FormatterString::new_str("mem384"),
			mmword: FormatterString::new_str("mmword"),
			oword: FormatterString::new_str("oword"),
			ptr: FormatterString::new_str("ptr"),
			qword: FormatterString::new_str("qword"),
			tbyte: FormatterString::new_str("tbyte"),
			tword: FormatterString::new_str("tword"),
			word: FormatterString::new_str("word"),
			xmmword: FormatterString::new_str("xmmword"),
			ymmword: FormatterString::new_str("ymmword"),
			yword: FormatterString::new_str("yword"),
			zmmword: FormatterString::new_str("zmmword"),
			zword: FormatterString::new_str("zword"),
			// GENERATOR-END: FormatterConstantsInit
			bnd: FormatterString::new_str("bnd"),
			dot_byte: FormatterString::new_str(".byte"),
			hint_not_taken: FormatterString::new_str("hint-not-taken"),
			hint_taken: FormatterString::new_str("hint-taken"),
			hnt: FormatterString::new_str("hnt"),
			ht: FormatterString::new_str("ht"),
			lock: FormatterString::new_str("lock"),
			near: FormatterString::new_str("near"),
			notrack: FormatterString::new_str("notrack"),
			offset: FormatterString::new_str("offset"),
			pn: FormatterString::new_str("pn"),
			pt: FormatterString::new_str("pt"),
			rel: FormatterString::new_str("rel"),
			rep: FormatterString::new_str("rep"),
			repe: [FormatterString::new_str("repe"), FormatterString::new_str("repz")],
			repne: [FormatterString::new_str("repne"), FormatterString::new_str("repnz")],
			rex_w: FormatterString::new_str("rex.w"),
			rne_sae: FormatterString::new_str("rne-sae"),
			rn_sae: FormatterString::new_str("rn-sae"),
			rd_sae: FormatterString::new_str("rd-sae"),
			ru_sae: FormatterString::new_str("ru-sae"),
			rz_sae: FormatterString::new_str("rz-sae"),
			sae: FormatterString::new_str("sae"),
			rne: FormatterString::new_str("rne"),
			rn: FormatterString::new_str("rn"),
			rd: FormatterString::new_str("rd"),
			ru: FormatterString::new_str("ru"),
			rz: FormatterString::new_str("rz"),
			short: FormatterString::new_str("short"),
			to: FormatterString::new_str("to"),
			xacquire: FormatterString::new_str("xacquire"),
			xrelease: FormatterString::new_str("xrelease"),
			z: FormatterString::new_str("z"),
			a16: FormatterString::new_str("a16"),
			a32: FormatterString::new_str("a32"),
			a64: FormatterString::new_str("a64"),
			addr16: FormatterString::new_str("addr16"),
			addr32: FormatterString::new_str("addr32"),
			addr64: FormatterString::new_str("addr64"),
			data16: FormatterString::new_str("data16"),
			data32: FormatterString::new_str("data32"),
			data64: FormatterString::new_str("data64"),
			o16: FormatterString::new_str("o16"),
			o32: FormatterString::new_str("o32"),
			o64: FormatterString::new_str("o64"),
			#[cfg(feature = "mvex")]
			mvex: MvexFormatterConstants::new(),
		}
	};
}

#[allow(dead_code)]
pub(super) struct FormatterArrayConstants {
	pub(super) nothing: [&'static FormatterString; 0],
	// GENERATOR-BEGIN: FormatterArrayConstantsDef
	// ⚠️This was generated by GENERATOR!🦹‍♂️
	pub(super) byte_ptr: [&'static FormatterString; 2],
	pub(super) dword_bcst: [&'static FormatterString; 2],
	pub(super) dword_ptr: [&'static FormatterString; 2],
	pub(super) fpuenv14_ptr: [&'static FormatterString; 2],
	pub(super) fpuenv28_ptr: [&'static FormatterString; 2],
	pub(super) fpustate108_ptr: [&'static FormatterString; 2],
	pub(super) fpustate94_ptr: [&'static FormatterString; 2],
	pub(super) fword_ptr: [&'static FormatterString; 2],
	pub(super) mem384_ptr: [&'static FormatterString; 2],
	pub(super) mmword_ptr: [&'static FormatterString; 2],
	pub(super) oword_ptr: [&'static FormatterString; 2],
	pub(super) qword_bcst: [&'static FormatterString; 2],
	pub(super) qword_ptr: [&'static FormatterString; 2],
	pub(super) tbyte_ptr: [&'static FormatterString; 2],
	pub(super) word_bcst: [&'static FormatterString; 2],
	pub(super) word_ptr: [&'static FormatterString; 2],
	pub(super) xmmword_ptr: [&'static FormatterString; 2],
	pub(super) ymmword_ptr: [&'static FormatterString; 2],
	pub(super) zmmword_ptr: [&'static FormatterString; 2],
	// GENERATOR-END: FormatterArrayConstantsDef
	#[cfg(feature = "gas")]
	pub(super) gas_op_size_strings: [&'static FormatterString; crate::formatter::gas::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1],
	#[cfg(not(feature = "gas"))]
	pub(super) gas_op_size_strings: (),
	#[cfg(feature = "gas")]
	pub(super) gas_addr_size_strings: [&'static FormatterString; crate::formatter::gas::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1],
	#[cfg(not(feature = "gas"))]
	pub(super) gas_addr_size_strings: (),
	#[cfg(feature = "intel")]
	pub(super) intel_op_size_strings: [&'static FormatterString; crate::formatter::intel::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1],
	#[cfg(not(feature = "intel"))]
	pub(super) intel_op_size_strings: (),
	#[cfg(feature = "intel")]
	pub(super) intel_addr_size_strings: [&'static FormatterString; crate::formatter::intel::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1],
	#[cfg(not(feature = "intel"))]
	pub(super) intel_addr_size_strings: (),
	#[cfg(feature = "intel")]
	pub(super) intel_rc_strings: [&'static FormatterString; IcedConstants::ROUNDING_CONTROL_ENUM_COUNT],
	#[cfg(feature = "intel")]
	pub(super) intel_rc_sae_strings: [&'static FormatterString; IcedConstants::ROUNDING_CONTROL_ENUM_COUNT],
	#[cfg(not(feature = "intel"))]
	pub(super) intel_rc_strings: (),
	#[cfg(not(feature = "intel"))]
	pub(super) intel_rc_sae_strings: (),
	#[cfg(feature = "intel")]
	pub(super) intel_branch_infos:
		[Vec<&'static FormatterString>; crate::formatter::intel::enums::InstrOpInfoFlags::BRANCH_SIZE_INFO_MASK as usize + 1],
	#[cfg(not(feature = "intel"))]
	pub(super) intel_branch_infos: (),
	#[cfg(feature = "masm")]
	pub(super) masm_rc_strings: [&'static FormatterString; IcedConstants::ROUNDING_CONTROL_ENUM_COUNT],
	#[cfg(feature = "masm")]
	pub(super) masm_rc_sae_strings: [&'static FormatterString; IcedConstants::ROUNDING_CONTROL_ENUM_COUNT],
	#[cfg(not(feature = "masm"))]
	pub(super) masm_rc_strings: (),
	#[cfg(not(feature = "masm"))]
	pub(super) masm_rc_sae_strings: (),
	#[cfg(feature = "nasm")]
	pub(super) nasm_op_size_strings: [&'static FormatterString; crate::formatter::nasm::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1],
	#[cfg(not(feature = "nasm"))]
	pub(super) nasm_op_size_strings: (),
	#[cfg(feature = "nasm")]
	pub(super) nasm_addr_size_strings: [&'static FormatterString; crate::formatter::nasm::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1],
	#[cfg(not(feature = "nasm"))]
	pub(super) nasm_addr_size_strings: (),
	#[cfg(feature = "nasm")]
	pub(super) nasm_branch_infos:
		[Vec<&'static FormatterString>; crate::formatter::nasm::enums::InstrOpInfoFlags::BRANCH_SIZE_INFO_MASK as usize + 1],
	#[cfg(not(feature = "nasm"))]
	pub(super) nasm_branch_infos: (),
	#[cfg(feature = "nasm")]
	pub(super) nasm_mem_size_infos: [&'static FormatterString; crate::formatter::nasm::enums::InstrOpInfoFlags::MEMORY_SIZE_INFO_MASK as usize + 1],
	#[cfg(not(feature = "nasm"))]
	pub(super) nasm_mem_size_infos: (),
	#[cfg(feature = "nasm")]
	pub(super) nasm_far_mem_size_infos:
		[&'static FormatterString; crate::formatter::nasm::enums::InstrOpInfoFlags::FAR_MEMORY_SIZE_INFO_MASK as usize + 1],
	#[cfg(not(feature = "nasm"))]
	pub(super) nasm_far_mem_size_infos: (),
	#[cfg(feature = "mvex")]
	pub(super) mvex_reg_mem_consts_32: [&'static FormatterString; IcedConstants::MVEX_REG_MEM_CONV_ENUM_COUNT],
	#[cfg(feature = "mvex")]
	pub(super) mvex_reg_mem_consts_64: [&'static FormatterString; IcedConstants::MVEX_REG_MEM_CONV_ENUM_COUNT],
}

lazy_static! {
	pub(super) static ref ARRAY_CONSTS: FormatterArrayConstants = {
		#![allow(clippy::let_unit_value)]
		let c = &*FORMATTER_CONSTANTS;
		let nothing: [&'static FormatterString; 0] = [];
		// GENERATOR-BEGIN: FormatterArrayConstantsCreate
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let byte_ptr: [&'static FormatterString; 2] = [&c.byte, &c.ptr];
		let dword_bcst: [&'static FormatterString; 2] = [&c.dword, &c.bcst];
		let dword_ptr: [&'static FormatterString; 2] = [&c.dword, &c.ptr];
		let fpuenv14_ptr: [&'static FormatterString; 2] = [&c.fpuenv14, &c.ptr];
		let fpuenv28_ptr: [&'static FormatterString; 2] = [&c.fpuenv28, &c.ptr];
		let fpustate108_ptr: [&'static FormatterString; 2] = [&c.fpustate108, &c.ptr];
		let fpustate94_ptr: [&'static FormatterString; 2] = [&c.fpustate94, &c.ptr];
		let fword_ptr: [&'static FormatterString; 2] = [&c.fword, &c.ptr];
		let mem384_ptr: [&'static FormatterString; 2] = [&c.mem384, &c.ptr];
		let mmword_ptr: [&'static FormatterString; 2] = [&c.mmword, &c.ptr];
		let oword_ptr: [&'static FormatterString; 2] = [&c.oword, &c.ptr];
		let qword_bcst: [&'static FormatterString; 2] = [&c.qword, &c.bcst];
		let qword_ptr: [&'static FormatterString; 2] = [&c.qword, &c.ptr];
		let tbyte_ptr: [&'static FormatterString; 2] = [&c.tbyte, &c.ptr];
		let word_bcst: [&'static FormatterString; 2] = [&c.word, &c.bcst];
		let word_ptr: [&'static FormatterString; 2] = [&c.word, &c.ptr];
		let xmmword_ptr: [&'static FormatterString; 2] = [&c.xmmword, &c.ptr];
		let ymmword_ptr: [&'static FormatterString; 2] = [&c.ymmword, &c.ptr];
		let zmmword_ptr: [&'static FormatterString; 2] = [&c.zmmword, &c.ptr];
		// GENERATOR-END: FormatterArrayConstantsCreate
		#[cfg(feature = "gas")]
		#[rustfmt::skip]
		let gas_op_size_strings: [&'static FormatterString; crate::formatter::gas::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1] = [
			&c.empty,
			&c.data16,
			&c.data32,
			&c.rex_w,
		];
		#[cfg(not(feature = "gas"))]
		let gas_op_size_strings = ();
		#[cfg(feature = "gas")]
		#[rustfmt::skip]
		let gas_addr_size_strings: [&'static FormatterString; crate::formatter::gas::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1] = [
			&c.empty,
			&c.addr16,
			&c.addr32,
			&c.addr64,
		];
		#[cfg(not(feature = "gas"))]
		let gas_addr_size_strings = ();
		#[cfg(feature = "intel")]
		#[rustfmt::skip]
		let intel_op_size_strings: [&'static FormatterString; crate::formatter::intel::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1] = [
			&c.empty,
			&c.data16,
			&c.data32,
			&c.data64,
		];
		#[cfg(not(feature = "intel"))]
		let intel_op_size_strings = ();
		#[cfg(feature = "intel")]
		#[rustfmt::skip]
		let intel_addr_size_strings: [&'static FormatterString; crate::formatter::intel::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1] = [
			&c.empty,
			&c.addr16,
			&c.addr32,
			&c.addr64,
		];
		#[cfg(not(feature = "intel"))]
		let intel_addr_size_strings = ();
		#[cfg(feature = "intel")]
		#[rustfmt::skip]
		let intel_rc_strings: [&'static FormatterString; IcedConstants::ROUNDING_CONTROL_ENUM_COUNT] = [
			&c.empty,
			&c.rne,
			&c.rd,
			&c.ru,
			&c.rz,
		];
		#[cfg(feature = "intel")]
		#[rustfmt::skip]
		let intel_rc_sae_strings: [&'static FormatterString; IcedConstants::ROUNDING_CONTROL_ENUM_COUNT] = [
			&c.empty,
			&c.rne_sae,
			&c.rd_sae,
			&c.ru_sae,
			&c.rz_sae,
		];
		#[cfg(not(feature = "intel"))]
		let (intel_rc_strings, intel_rc_sae_strings) = ((), ());
		#[cfg(feature = "intel")]
		#[rustfmt::skip]
		let intel_branch_infos: [Vec<&'static FormatterString>; crate::formatter::intel::enums::InstrOpInfoFlags::BRANCH_SIZE_INFO_MASK as usize + 1] = [
			vec![],
			vec![&c.short],
		];
		#[cfg(not(feature = "intel"))]
		let intel_branch_infos = ();
		#[cfg(feature = "masm")]
		#[rustfmt::skip]
		let masm_rc_strings: [&'static FormatterString; IcedConstants::ROUNDING_CONTROL_ENUM_COUNT] = [
			&c.empty,
			&c.rn,
			&c.rd,
			&c.ru,
			&c.rz,
		];
		#[cfg(feature = "masm")]
		#[rustfmt::skip]
		let masm_rc_sae_strings: [&'static FormatterString; IcedConstants::ROUNDING_CONTROL_ENUM_COUNT] = [
			&c.empty,
			&c.rn_sae,
			&c.rd_sae,
			&c.ru_sae,
			&c.rz_sae,
		];
		#[cfg(not(feature = "masm"))]
		let (masm_rc_strings, masm_rc_sae_strings) = ((), ());
		#[cfg(feature = "nasm")]
		#[rustfmt::skip]
		let nasm_op_size_strings: [&'static FormatterString; crate::formatter::nasm::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1] = [
			&c.empty,
			&c.o16,
			&c.o32,
			&c.o64,
		];
		#[cfg(not(feature = "nasm"))]
		let nasm_op_size_strings = ();
		#[cfg(feature = "nasm")]
		#[rustfmt::skip]
		let nasm_addr_size_strings: [&'static FormatterString; crate::formatter::nasm::enums::InstrOpInfoFlags::SIZE_OVERRIDE_MASK as usize + 1] = [
			&c.empty,
			&c.a16,
			&c.a32,
			&c.a64,
		];
		#[cfg(not(feature = "nasm"))]
		let nasm_addr_size_strings = ();
		#[cfg(feature = "nasm")]
		#[rustfmt::skip]
		let nasm_branch_infos: [Vec<&'static FormatterString>; crate::formatter::nasm::enums::InstrOpInfoFlags::BRANCH_SIZE_INFO_MASK as usize + 1] = [
			vec![],
			vec![&c.near],
			vec![&c.near, &c.word],
			vec![&c.near, &c.dword],
			vec![&c.word],
			vec![&c.dword],
			vec![&c.short],
			vec![],
		];
		#[cfg(not(feature = "nasm"))]
		let nasm_branch_infos = ();
		#[cfg(feature = "nasm")]
		#[rustfmt::skip]
		let nasm_mem_size_infos: [&'static FormatterString; crate::formatter::nasm::enums::InstrOpInfoFlags::MEMORY_SIZE_INFO_MASK as usize + 1] = [
			&c.empty,
			&c.word,
			&c.dword,
			&c.qword,
		];
		#[cfg(not(feature = "nasm"))]
		let nasm_mem_size_infos = ();
		#[cfg(feature = "nasm")]
		#[rustfmt::skip]
		let nasm_far_mem_size_infos: [&'static FormatterString; crate::formatter::nasm::enums::InstrOpInfoFlags::FAR_MEMORY_SIZE_INFO_MASK as usize + 1] = [
			&c.empty,
			&c.word,
			&c.dword,
			&c.empty,
		];
		#[cfg(not(feature = "nasm"))]
		let nasm_far_mem_size_infos = ();

		FormatterArrayConstants {
			nothing,
			// GENERATOR-BEGIN: FormatterArrayConstantsInit
			// ⚠️This was generated by GENERATOR!🦹‍♂️
			byte_ptr,
			dword_bcst,
			dword_ptr,
			fpuenv14_ptr,
			fpuenv28_ptr,
			fpustate108_ptr,
			fpustate94_ptr,
			fword_ptr,
			mem384_ptr,
			mmword_ptr,
			oword_ptr,
			qword_bcst,
			qword_ptr,
			tbyte_ptr,
			word_bcst,
			word_ptr,
			xmmword_ptr,
			ymmword_ptr,
			zmmword_ptr,
			// GENERATOR-END: FormatterArrayConstantsInit
			gas_op_size_strings,
			gas_addr_size_strings,
			intel_op_size_strings,
			intel_addr_size_strings,
			intel_rc_strings,
			intel_rc_sae_strings,
			intel_branch_infos,
			masm_rc_strings,
			masm_rc_sae_strings,
			nasm_op_size_strings,
			nasm_addr_size_strings,
			nasm_branch_infos,
			nasm_mem_size_infos,
			nasm_far_mem_size_infos,
			#[cfg(feature = "mvex")]
			mvex_reg_mem_consts_32: [
				&c.empty,
				&c.empty,
				&c.mvex.swizzle_cdab,
				&c.mvex.swizzle_badc,
				&c.mvex.swizzle_dacb,
				&c.mvex.swizzle_aaaa,
				&c.mvex.swizzle_bbbb,
				&c.mvex.swizzle_cccc,
				&c.mvex.swizzle_dddd,
				&c.empty,
				&c.mvex.mem_1to16,
				&c.mvex.mem_4to16,
				&c.mvex.mem_float16,
				&c.mvex.mem_uint8,
				&c.mvex.mem_sint8,
				&c.mvex.mem_uint16,
				&c.mvex.mem_sint16,
			],
			#[cfg(feature = "mvex")]
			mvex_reg_mem_consts_64: [
				&c.empty,
				&c.empty,
				&c.mvex.swizzle_cdab,
				&c.mvex.swizzle_badc,
				&c.mvex.swizzle_dacb,
				&c.mvex.swizzle_aaaa,
				&c.mvex.swizzle_bbbb,
				&c.mvex.swizzle_cccc,
				&c.mvex.swizzle_dddd,
				&c.empty,
				&c.mvex.mem_1to8,
				&c.mvex.mem_4to8,
				&c.mvex.mem_float16,
				&c.mvex.mem_uint8,
				&c.mvex.mem_sint8,
				&c.mvex.mem_uint16,
				&c.mvex.mem_sint16,
			],
		}
	};
}

pub(super) static SCALE_NUMBERS: [&str; 4] = ["1", "2", "4", "8"];
