/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal.pgp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRing;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRingCollection;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.internal.lazy.Lazy;
import org.gradle.plugins.signing.signatory.pgp.PgpKeyId;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatory;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatoryFactory;
import org.gradle.security.internal.BaseSignatoryProvider;

public class BaseInMemoryPgpSignatoryProvider
implements BaseSignatoryProvider<PgpSignatory> {
    private final PgpSignatoryFactory factory = new PgpSignatoryFactory();
    private final Map<String, PgpSignatory> signatories = new LinkedHashMap<String, PgpSignatory>();
    private final Lazy<PgpSignatory> defaultSignatory = Lazy.locking().of(() -> {
        if (defaultSecretKey != null && defaultPassword != null) {
            return this.createSignatory("default", defaultKeyId, defaultSecretKey, defaultPassword);
        }
        return null;
    });

    public BaseInMemoryPgpSignatoryProvider(String defaultSecretKey, String defaultPassword) {
        this(null, defaultSecretKey, defaultPassword);
    }

    public BaseInMemoryPgpSignatoryProvider(String defaultKeyId, String defaultSecretKey, String defaultPassword) {
    }

    @Override
    public PgpSignatory getDefaultSignatory(Project project) {
        return (PgpSignatory)this.defaultSignatory.get();
    }

    @Override
    public PgpSignatory getSignatory(String name) {
        return this.signatories.get(name);
    }

    protected void addSignatory(String name, String keyId, String secretKey, String password) {
        this.signatories.put(name, this.createSignatory(name, keyId, secretKey, password));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PgpSignatory createSignatory(String name, String keyId, String secretKey, String password) {
        try (InputStream in = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(secretKey.getBytes(StandardCharsets.UTF_8)));){
            if (keyId == null) {
                PGPSecretKey key = new JcaPGPSecretKeyRing(in).getSecretKey();
                PgpSignatory pgpSignatory = this.factory.createSignatory(name, key, password);
                return pgpSignatory;
            }
            PgpKeyId expectedKeyId = new PgpKeyId(keyId);
            for (PGPSecretKeyRing keyring : new JcaPGPSecretKeyRingCollection(in)) {
                for (PGPSecretKey key : keyring) {
                    if (!expectedKeyId.equals(new PgpKeyId(key.getKeyID()))) continue;
                    PgpSignatory pgpSignatory = this.factory.createSignatory(name, key, password);
                    return pgpSignatory;
                }
            }
            PgpSignatory pgpSignatory = null;
            return pgpSignatory;
        }
        catch (Exception e) {
            throw new InvalidUserDataException("Could not read PGP secret key", (Throwable)e);
        }
    }
}

