package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PollUserStatus invokes the ccc.PollUserStatus API synchronously
func (client *Client) PollUserStatus(request *PollUserStatusRequest) (response *PollUserStatusResponse, err error) {
	response = CreatePollUserStatusResponse()
	err = client.DoAction(request, response)
	return
}

// PollUserStatusWithChan invokes the ccc.PollUserStatus API asynchronously
func (client *Client) PollUserStatusWithChan(request *PollUserStatusRequest) (<-chan *PollUserStatusResponse, <-chan error) {
	responseChan := make(chan *PollUserStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PollUserStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PollUserStatusWithCallback invokes the ccc.PollUserStatus API asynchronously
func (client *Client) PollUserStatusWithCallback(request *PollUserStatusRequest, callback func(response *PollUserStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PollUserStatusResponse
		var err error
		defer close(result)
		response, err = client.PollUserStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PollUserStatusRequest is the request struct for api PollUserStatus
type PollUserStatusRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	DeviceId   string `position:"Query" name:"DeviceId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// PollUserStatusResponse is the response struct for api PollUserStatus
type PollUserStatusResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreatePollUserStatusRequest creates a request to invoke PollUserStatus API
func CreatePollUserStatusRequest() (request *PollUserStatusRequest) {
	request = &PollUserStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "PollUserStatus", "", "")
	request.Method = requests.POST
	return
}

// CreatePollUserStatusResponse creates a response to parse from PollUserStatus response
func CreatePollUserStatusResponse() (response *PollUserStatusResponse) {
	response = &PollUserStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
