package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportMinute invokes the cloudwf.ReportMinute API synchronously
// api document: https://help.aliyun.com/api/cloudwf/reportminute.html
func (client *Client) ReportMinute(request *ReportMinuteRequest) (response *ReportMinuteResponse, err error) {
	response = CreateReportMinuteResponse()
	err = client.DoAction(request, response)
	return
}

// ReportMinuteWithChan invokes the cloudwf.ReportMinute API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportminute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportMinuteWithChan(request *ReportMinuteRequest) (<-chan *ReportMinuteResponse, <-chan error) {
	responseChan := make(chan *ReportMinuteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportMinute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportMinuteWithCallback invokes the cloudwf.ReportMinute API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/reportminute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ReportMinuteWithCallback(request *ReportMinuteRequest, callback func(response *ReportMinuteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportMinuteResponse
		var err error
		defer close(result)
		response, err = client.ReportMinute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportMinuteRequest is the request struct for api ReportMinute
type ReportMinuteRequest struct {
	*requests.RpcRequest
	BeginDate string           `position:"Query" name:"BeginDate"`
	EndDate   string           `position:"Query" name:"EndDate"`
	Agsid     requests.Integer `position:"Query" name:"Agsid"`
}

// ReportMinuteResponse is the response struct for api ReportMinute
type ReportMinuteResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateReportMinuteRequest creates a request to invoke ReportMinute API
func CreateReportMinuteRequest() (request *ReportMinuteRequest) {
	request = &ReportMinuteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ReportMinute", "cloudwf", "openAPI")
	return
}

// CreateReportMinuteResponse creates a response to parse from ReportMinute response
func CreateReportMinuteResponse() (response *ReportMinuteResponse) {
	response = &ReportMinuteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
