package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMediaMeta invokes the imm.GetMediaMeta API synchronously
func (client *Client) GetMediaMeta(request *GetMediaMetaRequest) (response *GetMediaMetaResponse, err error) {
	response = CreateGetMediaMetaResponse()
	err = client.DoAction(request, response)
	return
}

// GetMediaMetaWithChan invokes the imm.GetMediaMeta API asynchronously
func (client *Client) GetMediaMetaWithChan(request *GetMediaMetaRequest) (<-chan *GetMediaMetaResponse, <-chan error) {
	responseChan := make(chan *GetMediaMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMediaMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMediaMetaWithCallback invokes the imm.GetMediaMeta API asynchronously
func (client *Client) GetMediaMetaWithCallback(request *GetMediaMetaRequest, callback func(response *GetMediaMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMediaMetaResponse
		var err error
		defer close(result)
		response, err = client.GetMediaMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMediaMetaRequest is the request struct for api GetMediaMeta
type GetMediaMetaRequest struct {
	*requests.RpcRequest
	MediaUri string `position:"Query" name:"MediaUri"`
	Project  string `position:"Query" name:"Project"`
}

// GetMediaMetaResponse is the response struct for api GetMediaMeta
type GetMediaMetaResponse struct {
	*responses.BaseResponse
	MediaUri  string    `json:"MediaUri" xml:"MediaUri"`
	RequestId string    `json:"RequestId" xml:"RequestId"`
	MediaMeta MediaMeta `json:"MediaMeta" xml:"MediaMeta"`
}

// CreateGetMediaMetaRequest creates a request to invoke GetMediaMeta API
func CreateGetMediaMetaRequest() (request *GetMediaMetaRequest) {
	request = &GetMediaMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "GetMediaMeta", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMediaMetaResponse creates a response to parse from GetMediaMeta response
func CreateGetMediaMetaResponse() (response *GetMediaMetaResponse) {
	response = &GetMediaMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
