package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRiskListDetail invokes the jarvis.DescribeRiskListDetail API synchronously
// api document: https://help.aliyun.com/api/jarvis/describerisklistdetail.html
func (client *Client) DescribeRiskListDetail(request *DescribeRiskListDetailRequest) (response *DescribeRiskListDetailResponse, err error) {
	response = CreateDescribeRiskListDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRiskListDetailWithChan invokes the jarvis.DescribeRiskListDetail API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describerisklistdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRiskListDetailWithChan(request *DescribeRiskListDetailRequest) (<-chan *DescribeRiskListDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeRiskListDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRiskListDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRiskListDetailWithCallback invokes the jarvis.DescribeRiskListDetail API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describerisklistdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRiskListDetailWithCallback(request *DescribeRiskListDetailRequest, callback func(response *DescribeRiskListDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRiskListDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeRiskListDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRiskListDetailRequest is the request struct for api DescribeRiskListDetail
type DescribeRiskListDetailRequest struct {
	*requests.RpcRequest
	RiskType      string           `position:"Query" name:"riskType"`
	SourceIp      string           `position:"Query" name:"SourceIp"`
	PageSize      requests.Integer `position:"Query" name:"pageSize"`
	QueryProduct  string           `position:"Query" name:"queryProduct"`
	CurrentPage   requests.Integer `position:"Query" name:"currentPage"`
	RiskDescribe  string           `position:"Query" name:"riskDescribe"`
	Lang          string           `position:"Query" name:"Lang"`
	SrcUid        requests.Integer `position:"Query" name:"srcUid"`
	SourceCode    string           `position:"Query" name:"sourceCode"`
	QueryRegionId string           `position:"Query" name:"queryRegionId"`
	Status        string           `position:"Query" name:"status"`
}

// DescribeRiskListDetailResponse is the response struct for api DescribeRiskListDetail
type DescribeRiskListDetailResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Module    string   `json:"Module" xml:"Module"`
	PageInfo  PageInfo `json:"PageInfo" xml:"PageInfo"`
	DataList  []Data   `json:"DataList" xml:"DataList"`
}

// CreateDescribeRiskListDetailRequest creates a request to invoke DescribeRiskListDetail API
func CreateDescribeRiskListDetailRequest() (request *DescribeRiskListDetailRequest) {
	request = &DescribeRiskListDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeRiskListDetail", "jarvis", "openAPI")
	return
}

// CreateDescribeRiskListDetailResponse creates a response to parse from DescribeRiskListDetail response
func CreateDescribeRiskListDetailResponse() (response *DescribeRiskListDetailResponse) {
	response = &DescribeRiskListDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
