package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDatasetRecord invokes the nlp_automl.CreateDatasetRecord API synchronously
func (client *Client) CreateDatasetRecord(request *CreateDatasetRecordRequest) (response *CreateDatasetRecordResponse, err error) {
	response = CreateCreateDatasetRecordResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDatasetRecordWithChan invokes the nlp_automl.CreateDatasetRecord API asynchronously
func (client *Client) CreateDatasetRecordWithChan(request *CreateDatasetRecordRequest) (<-chan *CreateDatasetRecordResponse, <-chan error) {
	responseChan := make(chan *CreateDatasetRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDatasetRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDatasetRecordWithCallback invokes the nlp_automl.CreateDatasetRecord API asynchronously
func (client *Client) CreateDatasetRecordWithCallback(request *CreateDatasetRecordRequest, callback func(response *CreateDatasetRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDatasetRecordResponse
		var err error
		defer close(result)
		response, err = client.CreateDatasetRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDatasetRecordRequest is the request struct for api CreateDatasetRecord
type CreateDatasetRecordRequest struct {
	*requests.RpcRequest
	DatasetRecord string           `position:"Body" name:"DatasetRecord"`
	DatasetId     requests.Integer `position:"Body" name:"DatasetId"`
	ProjectId     requests.Integer `position:"Body" name:"ProjectId"`
}

// CreateDatasetRecordResponse is the response struct for api CreateDatasetRecord
type CreateDatasetRecordResponse struct {
	*responses.BaseResponse
	RequestId       string                 `json:"RequestId" xml:"RequestId"`
	DatasetRecordId map[string]interface{} `json:"DatasetRecordId" xml:"DatasetRecordId"`
	Code            int                    `json:"Code" xml:"Code"`
	Message         string                 `json:"Message" xml:"Message"`
	Success         bool                   `json:"Success" xml:"Success"`
}

// CreateCreateDatasetRecordRequest creates a request to invoke CreateDatasetRecord API
func CreateCreateDatasetRecordRequest() (request *CreateDatasetRecordRequest) {
	request = &CreateDatasetRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-11-11", "CreateDatasetRecord", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDatasetRecordResponse creates a response to parse from CreateDatasetRecord response
func CreateCreateDatasetRecordResponse() (response *CreateDatasetRecordResponse) {
	response = &CreateDatasetRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
