package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelScheduleTasks invokes the polardb.CancelScheduleTasks API synchronously
func (client *Client) CancelScheduleTasks(request *CancelScheduleTasksRequest) (response *CancelScheduleTasksResponse, err error) {
	response = CreateCancelScheduleTasksResponse()
	err = client.DoAction(request, response)
	return
}

// CancelScheduleTasksWithChan invokes the polardb.CancelScheduleTasks API asynchronously
func (client *Client) CancelScheduleTasksWithChan(request *CancelScheduleTasksRequest) (<-chan *CancelScheduleTasksResponse, <-chan error) {
	responseChan := make(chan *CancelScheduleTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelScheduleTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelScheduleTasksWithCallback invokes the polardb.CancelScheduleTasks API asynchronously
func (client *Client) CancelScheduleTasksWithCallback(request *CancelScheduleTasksRequest, callback func(response *CancelScheduleTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelScheduleTasksResponse
		var err error
		defer close(result)
		response, err = client.CancelScheduleTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelScheduleTasksRequest is the request struct for api CancelScheduleTasks
type CancelScheduleTasksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CancelScheduleTasksResponse is the response struct for api CancelScheduleTasks
type CancelScheduleTasksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCancelScheduleTasksRequest creates a request to invoke CancelScheduleTasks API
func CreateCancelScheduleTasksRequest() (request *CancelScheduleTasksRequest) {
	request = &CancelScheduleTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CancelScheduleTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelScheduleTasksResponse creates a response to parse from CancelScheduleTasks response
func CreateCancelScheduleTasksResponse() (response *CancelScheduleTasksResponse) {
	response = &CancelScheduleTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
