package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagWifi invokes the smartag.ModifySagWifi API synchronously
func (client *Client) ModifySagWifi(request *ModifySagWifiRequest) (response *ModifySagWifiResponse, err error) {
	response = CreateModifySagWifiResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagWifiWithChan invokes the smartag.ModifySagWifi API asynchronously
func (client *Client) ModifySagWifiWithChan(request *ModifySagWifiRequest) (<-chan *ModifySagWifiResponse, <-chan error) {
	responseChan := make(chan *ModifySagWifiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagWifi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagWifiWithCallback invokes the smartag.ModifySagWifi API asynchronously
func (client *Client) ModifySagWifiWithCallback(request *ModifySagWifiRequest, callback func(response *ModifySagWifiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagWifiResponse
		var err error
		defer close(result)
		response, err = client.ModifySagWifi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagWifiRequest is the request struct for api ModifySagWifi
type ModifySagWifiRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EncryptAlgorithm     string           `position:"Query" name:"EncryptAlgorithm"`
	Channel              string           `position:"Query" name:"Channel"`
	AuthenticationType   string           `position:"Query" name:"AuthenticationType"`
	SSID                 string           `position:"Query" name:"SSID"`
	Password             string           `position:"Query" name:"Password"`
	IsBroadcast          string           `position:"Query" name:"IsBroadcast"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth            string           `position:"Query" name:"Bandwidth"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	IsEnable             string           `position:"Query" name:"IsEnable"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
	IsAuth               string           `position:"Query" name:"IsAuth"`
}

// ModifySagWifiResponse is the response struct for api ModifySagWifi
type ModifySagWifiResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagWifiRequest creates a request to invoke ModifySagWifi API
func CreateModifySagWifiRequest() (request *ModifySagWifiRequest) {
	request = &ModifySagWifiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagWifi", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySagWifiResponse creates a response to parse from ModifySagWifi response
func CreateModifySagWifiResponse() (response *ModifySagWifiResponse) {
	response = &ModifySagWifiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
