package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeSlotStatus invokes the unimkt.ChangeSlotStatus API synchronously
func (client *Client) ChangeSlotStatus(request *ChangeSlotStatusRequest) (response *ChangeSlotStatusResponse, err error) {
	response = CreateChangeSlotStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeSlotStatusWithChan invokes the unimkt.ChangeSlotStatus API asynchronously
func (client *Client) ChangeSlotStatusWithChan(request *ChangeSlotStatusRequest) (<-chan *ChangeSlotStatusResponse, <-chan error) {
	responseChan := make(chan *ChangeSlotStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeSlotStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeSlotStatusWithCallback invokes the unimkt.ChangeSlotStatus API asynchronously
func (client *Client) ChangeSlotStatusWithCallback(request *ChangeSlotStatusRequest, callback func(response *ChangeSlotStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeSlotStatusResponse
		var err error
		defer close(result)
		response, err = client.ChangeSlotStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeSlotStatusRequest is the request struct for api ChangeSlotStatus
type ChangeSlotStatusRequest struct {
	*requests.RpcRequest
	MessageKey            string `position:"Body" name:"MessageKey"`
	Business              string `position:"Query" name:"Business"`
	Message               string `position:"Body" name:"Message"`
	UserId                string `position:"Query" name:"UserId"`
	OriginSiteUserId      string `position:"Query" name:"OriginSiteUserId"`
	Environment           string `position:"Query" name:"Environment"`
	AppName               string `position:"Query" name:"AppName"`
	AdSlotStatus          string `position:"Body" name:"AdSlotStatus"`
	TenantId              string `position:"Query" name:"TenantId"`
	AdSlotId              string `position:"Body" name:"AdSlotId"`
	UserSite              string `position:"Query" name:"UserSite"`
	AdSlotCorporateStatus string `position:"Body" name:"AdSlotCorporateStatus"`
}

// ChangeSlotStatusResponse is the response struct for api ChangeSlotStatus
type ChangeSlotStatusResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateChangeSlotStatusRequest creates a request to invoke ChangeSlotStatus API
func CreateChangeSlotStatusRequest() (request *ChangeSlotStatusRequest) {
	request = &ChangeSlotStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "ChangeSlotStatus", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeSlotStatusResponse creates a response to parse from ChangeSlotStatus response
func CreateChangeSlotStatusResponse() (response *ChangeSlotStatusResponse) {
	response = &ChangeSlotStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
