// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/appengine/v1beta/app_yaml.proto

package appengine

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Actions to take when the user is not logged in.
type AuthFailAction int32

const (
	// Not specified. `AUTH_FAIL_ACTION_REDIRECT` is assumed.
	AuthFailAction_AUTH_FAIL_ACTION_UNSPECIFIED AuthFailAction = 0
	// Redirects user to "accounts.google.com". The user is redirected back to the
	// application URL after signing in or creating an account.
	AuthFailAction_AUTH_FAIL_ACTION_REDIRECT AuthFailAction = 1
	// Rejects request with a `401` HTTP status code and an error
	// message.
	AuthFailAction_AUTH_FAIL_ACTION_UNAUTHORIZED AuthFailAction = 2
)

// Enum value maps for AuthFailAction.
var (
	AuthFailAction_name = map[int32]string{
		0: "AUTH_FAIL_ACTION_UNSPECIFIED",
		1: "AUTH_FAIL_ACTION_REDIRECT",
		2: "AUTH_FAIL_ACTION_UNAUTHORIZED",
	}
	AuthFailAction_value = map[string]int32{
		"AUTH_FAIL_ACTION_UNSPECIFIED":  0,
		"AUTH_FAIL_ACTION_REDIRECT":     1,
		"AUTH_FAIL_ACTION_UNAUTHORIZED": 2,
	}
)

func (x AuthFailAction) Enum() *AuthFailAction {
	p := new(AuthFailAction)
	*p = x
	return p
}

func (x AuthFailAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthFailAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_appengine_v1beta_app_yaml_proto_enumTypes[0].Descriptor()
}

func (AuthFailAction) Type() protoreflect.EnumType {
	return &file_google_appengine_v1beta_app_yaml_proto_enumTypes[0]
}

func (x AuthFailAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthFailAction.Descriptor instead.
func (AuthFailAction) EnumDescriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{0}
}

// Methods to restrict access to a URL based on login status.
type LoginRequirement int32

const (
	// Not specified. `LOGIN_OPTIONAL` is assumed.
	LoginRequirement_LOGIN_UNSPECIFIED LoginRequirement = 0
	// Does not require that the user is signed in.
	LoginRequirement_LOGIN_OPTIONAL LoginRequirement = 1
	// If the user is not signed in, the `auth_fail_action` is taken.
	// In addition, if the user is not an administrator for the
	// application, they are given an error message regardless of
	// `auth_fail_action`. If the user is an administrator, the handler
	// proceeds.
	LoginRequirement_LOGIN_ADMIN LoginRequirement = 2
	// If the user has signed in, the handler proceeds normally. Otherwise, the
	// auth_fail_action is taken.
	LoginRequirement_LOGIN_REQUIRED LoginRequirement = 3
)

// Enum value maps for LoginRequirement.
var (
	LoginRequirement_name = map[int32]string{
		0: "LOGIN_UNSPECIFIED",
		1: "LOGIN_OPTIONAL",
		2: "LOGIN_ADMIN",
		3: "LOGIN_REQUIRED",
	}
	LoginRequirement_value = map[string]int32{
		"LOGIN_UNSPECIFIED": 0,
		"LOGIN_OPTIONAL":    1,
		"LOGIN_ADMIN":       2,
		"LOGIN_REQUIRED":    3,
	}
)

func (x LoginRequirement) Enum() *LoginRequirement {
	p := new(LoginRequirement)
	*p = x
	return p
}

func (x LoginRequirement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoginRequirement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_appengine_v1beta_app_yaml_proto_enumTypes[1].Descriptor()
}

func (LoginRequirement) Type() protoreflect.EnumType {
	return &file_google_appengine_v1beta_app_yaml_proto_enumTypes[1]
}

func (x LoginRequirement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoginRequirement.Descriptor instead.
func (LoginRequirement) EnumDescriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{1}
}

// Methods to enforce security (HTTPS) on a URL.
type SecurityLevel int32

const (
	// Not specified.
	SecurityLevel_SECURE_UNSPECIFIED SecurityLevel = 0
	// Both HTTP and HTTPS requests with URLs that match the handler succeed
	// without redirects. The application can examine the request to determine
	// which protocol was used, and respond accordingly.
	SecurityLevel_SECURE_DEFAULT SecurityLevel = 0
	// Requests for a URL that match this handler that use HTTPS are automatically
	// redirected to the HTTP equivalent URL.
	SecurityLevel_SECURE_NEVER SecurityLevel = 1
	// Both HTTP and HTTPS requests with URLs that match the handler succeed
	// without redirects. The application can examine the request to determine
	// which protocol was used and respond accordingly.
	SecurityLevel_SECURE_OPTIONAL SecurityLevel = 2
	// Requests for a URL that match this handler that do not use HTTPS are
	// automatically redirected to the HTTPS URL with the same path. Query
	// parameters are reserved for the redirect.
	SecurityLevel_SECURE_ALWAYS SecurityLevel = 3
)

// Enum value maps for SecurityLevel.
var (
	SecurityLevel_name = map[int32]string{
		0: "SECURE_UNSPECIFIED",
		// Duplicate value: 0: "SECURE_DEFAULT",
		1: "SECURE_NEVER",
		2: "SECURE_OPTIONAL",
		3: "SECURE_ALWAYS",
	}
	SecurityLevel_value = map[string]int32{
		"SECURE_UNSPECIFIED": 0,
		"SECURE_DEFAULT":     0,
		"SECURE_NEVER":       1,
		"SECURE_OPTIONAL":    2,
		"SECURE_ALWAYS":      3,
	}
)

func (x SecurityLevel) Enum() *SecurityLevel {
	p := new(SecurityLevel)
	*p = x
	return p
}

func (x SecurityLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_appengine_v1beta_app_yaml_proto_enumTypes[2].Descriptor()
}

func (SecurityLevel) Type() protoreflect.EnumType {
	return &file_google_appengine_v1beta_app_yaml_proto_enumTypes[2]
}

func (x SecurityLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityLevel.Descriptor instead.
func (SecurityLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{2}
}

// Error codes.
type ErrorHandler_ErrorCode int32

const (
	// Not specified. ERROR_CODE_DEFAULT is assumed.
	ErrorHandler_ERROR_CODE_UNSPECIFIED ErrorHandler_ErrorCode = 0
	// All other error types.
	ErrorHandler_ERROR_CODE_DEFAULT ErrorHandler_ErrorCode = 0
	// Application has exceeded a resource quota.
	ErrorHandler_ERROR_CODE_OVER_QUOTA ErrorHandler_ErrorCode = 1
	// Client blocked by the application's Denial of Service protection
	// configuration.
	ErrorHandler_ERROR_CODE_DOS_API_DENIAL ErrorHandler_ErrorCode = 2
	// Deadline reached before the application responds.
	ErrorHandler_ERROR_CODE_TIMEOUT ErrorHandler_ErrorCode = 3
)

// Enum value maps for ErrorHandler_ErrorCode.
var (
	ErrorHandler_ErrorCode_name = map[int32]string{
		0: "ERROR_CODE_UNSPECIFIED",
		// Duplicate value: 0: "ERROR_CODE_DEFAULT",
		1: "ERROR_CODE_OVER_QUOTA",
		2: "ERROR_CODE_DOS_API_DENIAL",
		3: "ERROR_CODE_TIMEOUT",
	}
	ErrorHandler_ErrorCode_value = map[string]int32{
		"ERROR_CODE_UNSPECIFIED":    0,
		"ERROR_CODE_DEFAULT":        0,
		"ERROR_CODE_OVER_QUOTA":     1,
		"ERROR_CODE_DOS_API_DENIAL": 2,
		"ERROR_CODE_TIMEOUT":        3,
	}
)

func (x ErrorHandler_ErrorCode) Enum() *ErrorHandler_ErrorCode {
	p := new(ErrorHandler_ErrorCode)
	*p = x
	return p
}

func (x ErrorHandler_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorHandler_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_appengine_v1beta_app_yaml_proto_enumTypes[3].Descriptor()
}

func (ErrorHandler_ErrorCode) Type() protoreflect.EnumType {
	return &file_google_appengine_v1beta_app_yaml_proto_enumTypes[3]
}

func (x ErrorHandler_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorHandler_ErrorCode.Descriptor instead.
func (ErrorHandler_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{1, 0}
}

// Redirect codes.
type UrlMap_RedirectHttpResponseCode int32

const (
	// Not specified. `302` is assumed.
	UrlMap_REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED UrlMap_RedirectHttpResponseCode = 0
	// `301 Moved Permanently` code.
	UrlMap_REDIRECT_HTTP_RESPONSE_CODE_301 UrlMap_RedirectHttpResponseCode = 1
	// `302 Moved Temporarily` code.
	UrlMap_REDIRECT_HTTP_RESPONSE_CODE_302 UrlMap_RedirectHttpResponseCode = 2
	// `303 See Other` code.
	UrlMap_REDIRECT_HTTP_RESPONSE_CODE_303 UrlMap_RedirectHttpResponseCode = 3
	// `307 Temporary Redirect` code.
	UrlMap_REDIRECT_HTTP_RESPONSE_CODE_307 UrlMap_RedirectHttpResponseCode = 4
)

// Enum value maps for UrlMap_RedirectHttpResponseCode.
var (
	UrlMap_RedirectHttpResponseCode_name = map[int32]string{
		0: "REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED",
		1: "REDIRECT_HTTP_RESPONSE_CODE_301",
		2: "REDIRECT_HTTP_RESPONSE_CODE_302",
		3: "REDIRECT_HTTP_RESPONSE_CODE_303",
		4: "REDIRECT_HTTP_RESPONSE_CODE_307",
	}
	UrlMap_RedirectHttpResponseCode_value = map[string]int32{
		"REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED": 0,
		"REDIRECT_HTTP_RESPONSE_CODE_301":         1,
		"REDIRECT_HTTP_RESPONSE_CODE_302":         2,
		"REDIRECT_HTTP_RESPONSE_CODE_303":         3,
		"REDIRECT_HTTP_RESPONSE_CODE_307":         4,
	}
)

func (x UrlMap_RedirectHttpResponseCode) Enum() *UrlMap_RedirectHttpResponseCode {
	p := new(UrlMap_RedirectHttpResponseCode)
	*p = x
	return p
}

func (x UrlMap_RedirectHttpResponseCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UrlMap_RedirectHttpResponseCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_appengine_v1beta_app_yaml_proto_enumTypes[4].Descriptor()
}

func (UrlMap_RedirectHttpResponseCode) Type() protoreflect.EnumType {
	return &file_google_appengine_v1beta_app_yaml_proto_enumTypes[4]
}

func (x UrlMap_RedirectHttpResponseCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UrlMap_RedirectHttpResponseCode.Descriptor instead.
func (UrlMap_RedirectHttpResponseCode) EnumDescriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{2, 0}
}

// [Google Cloud Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/)
// configuration for API handlers.
type ApiConfigHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action to take when users access resources that require
	// authentication. Defaults to `redirect`.
	AuthFailAction AuthFailAction `protobuf:"varint,1,opt,name=auth_fail_action,json=authFailAction,proto3,enum=google.appengine.v1beta.AuthFailAction" json:"auth_fail_action,omitempty"`
	// Level of login required to access this resource. Defaults to
	// `optional`.
	Login LoginRequirement `protobuf:"varint,2,opt,name=login,proto3,enum=google.appengine.v1beta.LoginRequirement" json:"login,omitempty"`
	// Path to the script from the application root directory.
	Script string `protobuf:"bytes,3,opt,name=script,proto3" json:"script,omitempty"`
	// Security (HTTPS) enforcement for this URL.
	SecurityLevel SecurityLevel `protobuf:"varint,4,opt,name=security_level,json=securityLevel,proto3,enum=google.appengine.v1beta.SecurityLevel" json:"security_level,omitempty"`
	// URL to serve the endpoint at.
	Url string `protobuf:"bytes,5,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *ApiConfigHandler) Reset() {
	*x = ApiConfigHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApiConfigHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiConfigHandler) ProtoMessage() {}

func (x *ApiConfigHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiConfigHandler.ProtoReflect.Descriptor instead.
func (*ApiConfigHandler) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{0}
}

func (x *ApiConfigHandler) GetAuthFailAction() AuthFailAction {
	if x != nil {
		return x.AuthFailAction
	}
	return AuthFailAction_AUTH_FAIL_ACTION_UNSPECIFIED
}

func (x *ApiConfigHandler) GetLogin() LoginRequirement {
	if x != nil {
		return x.Login
	}
	return LoginRequirement_LOGIN_UNSPECIFIED
}

func (x *ApiConfigHandler) GetScript() string {
	if x != nil {
		return x.Script
	}
	return ""
}

func (x *ApiConfigHandler) GetSecurityLevel() SecurityLevel {
	if x != nil {
		return x.SecurityLevel
	}
	return SecurityLevel_SECURE_UNSPECIFIED
}

func (x *ApiConfigHandler) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// Custom static error page to be served when an error occurs.
type ErrorHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error condition this handler applies to.
	ErrorCode ErrorHandler_ErrorCode `protobuf:"varint,1,opt,name=error_code,json=errorCode,proto3,enum=google.appengine.v1beta.ErrorHandler_ErrorCode" json:"error_code,omitempty"`
	// Static file content to be served for this error.
	StaticFile string `protobuf:"bytes,2,opt,name=static_file,json=staticFile,proto3" json:"static_file,omitempty"`
	// MIME type of file. Defaults to `text/html`.
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *ErrorHandler) Reset() {
	*x = ErrorHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorHandler) ProtoMessage() {}

func (x *ErrorHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorHandler.ProtoReflect.Descriptor instead.
func (*ErrorHandler) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{1}
}

func (x *ErrorHandler) GetErrorCode() ErrorHandler_ErrorCode {
	if x != nil {
		return x.ErrorCode
	}
	return ErrorHandler_ERROR_CODE_UNSPECIFIED
}

func (x *ErrorHandler) GetStaticFile() string {
	if x != nil {
		return x.StaticFile
	}
	return ""
}

func (x *ErrorHandler) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// URL pattern and description of how the URL should be handled. App Engine can
// handle URLs by executing application code or by serving static files
// uploaded with the version, such as images, CSS, or JavaScript.
type UrlMap struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL prefix. Uses regular expression syntax, which means regexp
	// special characters must be escaped, but should not contain groupings.
	// All URLs that begin with this prefix are handled by this handler, using the
	// portion of the URL after the prefix as part of the file path.
	UrlRegex string `protobuf:"bytes,1,opt,name=url_regex,json=urlRegex,proto3" json:"url_regex,omitempty"`
	// Type of handler for this URL pattern.
	//
	// Types that are assignable to HandlerType:
	//
	//	*UrlMap_StaticFiles
	//	*UrlMap_Script
	//	*UrlMap_ApiEndpoint
	HandlerType isUrlMap_HandlerType `protobuf_oneof:"handler_type"`
	// Security (HTTPS) enforcement for this URL.
	SecurityLevel SecurityLevel `protobuf:"varint,5,opt,name=security_level,json=securityLevel,proto3,enum=google.appengine.v1beta.SecurityLevel" json:"security_level,omitempty"`
	// Level of login required to access this resource. Not supported for Node.js
	// in the App Engine standard environment.
	Login LoginRequirement `protobuf:"varint,6,opt,name=login,proto3,enum=google.appengine.v1beta.LoginRequirement" json:"login,omitempty"`
	// Action to take when users access resources that require
	// authentication. Defaults to `redirect`.
	AuthFailAction AuthFailAction `protobuf:"varint,7,opt,name=auth_fail_action,json=authFailAction,proto3,enum=google.appengine.v1beta.AuthFailAction" json:"auth_fail_action,omitempty"`
	// `30x` code to use when performing redirects for the `secure` field.
	// Defaults to `302`.
	RedirectHttpResponseCode UrlMap_RedirectHttpResponseCode `protobuf:"varint,8,opt,name=redirect_http_response_code,json=redirectHttpResponseCode,proto3,enum=google.appengine.v1beta.UrlMap_RedirectHttpResponseCode" json:"redirect_http_response_code,omitempty"`
}

func (x *UrlMap) Reset() {
	*x = UrlMap{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UrlMap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UrlMap) ProtoMessage() {}

func (x *UrlMap) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UrlMap.ProtoReflect.Descriptor instead.
func (*UrlMap) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{2}
}

func (x *UrlMap) GetUrlRegex() string {
	if x != nil {
		return x.UrlRegex
	}
	return ""
}

func (m *UrlMap) GetHandlerType() isUrlMap_HandlerType {
	if m != nil {
		return m.HandlerType
	}
	return nil
}

func (x *UrlMap) GetStaticFiles() *StaticFilesHandler {
	if x, ok := x.GetHandlerType().(*UrlMap_StaticFiles); ok {
		return x.StaticFiles
	}
	return nil
}

func (x *UrlMap) GetScript() *ScriptHandler {
	if x, ok := x.GetHandlerType().(*UrlMap_Script); ok {
		return x.Script
	}
	return nil
}

func (x *UrlMap) GetApiEndpoint() *ApiEndpointHandler {
	if x, ok := x.GetHandlerType().(*UrlMap_ApiEndpoint); ok {
		return x.ApiEndpoint
	}
	return nil
}

func (x *UrlMap) GetSecurityLevel() SecurityLevel {
	if x != nil {
		return x.SecurityLevel
	}
	return SecurityLevel_SECURE_UNSPECIFIED
}

func (x *UrlMap) GetLogin() LoginRequirement {
	if x != nil {
		return x.Login
	}
	return LoginRequirement_LOGIN_UNSPECIFIED
}

func (x *UrlMap) GetAuthFailAction() AuthFailAction {
	if x != nil {
		return x.AuthFailAction
	}
	return AuthFailAction_AUTH_FAIL_ACTION_UNSPECIFIED
}

func (x *UrlMap) GetRedirectHttpResponseCode() UrlMap_RedirectHttpResponseCode {
	if x != nil {
		return x.RedirectHttpResponseCode
	}
	return UrlMap_REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED
}

type isUrlMap_HandlerType interface {
	isUrlMap_HandlerType()
}

type UrlMap_StaticFiles struct {
	// Returns the contents of a file, such as an image, as the response.
	StaticFiles *StaticFilesHandler `protobuf:"bytes,2,opt,name=static_files,json=staticFiles,proto3,oneof"`
}

type UrlMap_Script struct {
	// Executes a script to handle the requests that match this URL
	// pattern. Only the `auto` value is supported for Node.js in the
	// App Engine standard environment, for example `"script": "auto"`.
	Script *ScriptHandler `protobuf:"bytes,3,opt,name=script,proto3,oneof"`
}

type UrlMap_ApiEndpoint struct {
	// Uses API Endpoints to handle requests.
	ApiEndpoint *ApiEndpointHandler `protobuf:"bytes,4,opt,name=api_endpoint,json=apiEndpoint,proto3,oneof"`
}

func (*UrlMap_StaticFiles) isUrlMap_HandlerType() {}

func (*UrlMap_Script) isUrlMap_HandlerType() {}

func (*UrlMap_ApiEndpoint) isUrlMap_HandlerType() {}

// Files served directly to the user for a given URL, such as images, CSS
// stylesheets, or JavaScript source files. Static file handlers describe which
// files in the application directory are static files, and which URLs serve
// them.
type StaticFilesHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the static files matched by the URL pattern, from the
	// application root directory. The path can refer to text matched in groupings
	// in the URL pattern.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Regular expression that matches the file paths for all files that should be
	// referenced by this handler.
	UploadPathRegex string `protobuf:"bytes,2,opt,name=upload_path_regex,json=uploadPathRegex,proto3" json:"upload_path_regex,omitempty"`
	// HTTP headers to use for all responses from these URLs.
	HttpHeaders map[string]string `protobuf:"bytes,3,rep,name=http_headers,json=httpHeaders,proto3" json:"http_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// MIME type used to serve all files served by this handler.
	//
	// Defaults to file-specific MIME types, which are derived from each file's
	// filename extension.
	MimeType string `protobuf:"bytes,4,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Time a static file served by this handler should be cached
	// by web proxies and browsers.
	Expiration *durationpb.Duration `protobuf:"bytes,5,opt,name=expiration,proto3" json:"expiration,omitempty"`
	// Whether this handler should match the request if the file
	// referenced by the handler does not exist.
	RequireMatchingFile bool `protobuf:"varint,6,opt,name=require_matching_file,json=requireMatchingFile,proto3" json:"require_matching_file,omitempty"`
	// Whether files should also be uploaded as code data. By default, files
	// declared in static file handlers are uploaded as static
	// data and are only served to end users; they cannot be read by the
	// application. If enabled, uploads are charged against both your code and
	// static data storage resource quotas.
	ApplicationReadable bool `protobuf:"varint,7,opt,name=application_readable,json=applicationReadable,proto3" json:"application_readable,omitempty"`
}

func (x *StaticFilesHandler) Reset() {
	*x = StaticFilesHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StaticFilesHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticFilesHandler) ProtoMessage() {}

func (x *StaticFilesHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticFilesHandler.ProtoReflect.Descriptor instead.
func (*StaticFilesHandler) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{3}
}

func (x *StaticFilesHandler) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *StaticFilesHandler) GetUploadPathRegex() string {
	if x != nil {
		return x.UploadPathRegex
	}
	return ""
}

func (x *StaticFilesHandler) GetHttpHeaders() map[string]string {
	if x != nil {
		return x.HttpHeaders
	}
	return nil
}

func (x *StaticFilesHandler) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *StaticFilesHandler) GetExpiration() *durationpb.Duration {
	if x != nil {
		return x.Expiration
	}
	return nil
}

func (x *StaticFilesHandler) GetRequireMatchingFile() bool {
	if x != nil {
		return x.RequireMatchingFile
	}
	return false
}

func (x *StaticFilesHandler) GetApplicationReadable() bool {
	if x != nil {
		return x.ApplicationReadable
	}
	return false
}

// Executes a script to handle the request that matches the URL pattern.
type ScriptHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the script from the application root directory.
	ScriptPath string `protobuf:"bytes,1,opt,name=script_path,json=scriptPath,proto3" json:"script_path,omitempty"`
}

func (x *ScriptHandler) Reset() {
	*x = ScriptHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScriptHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScriptHandler) ProtoMessage() {}

func (x *ScriptHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScriptHandler.ProtoReflect.Descriptor instead.
func (*ScriptHandler) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{4}
}

func (x *ScriptHandler) GetScriptPath() string {
	if x != nil {
		return x.ScriptPath
	}
	return ""
}

// Uses Google Cloud Endpoints to handle requests.
type ApiEndpointHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the script from the application root directory.
	ScriptPath string `protobuf:"bytes,1,opt,name=script_path,json=scriptPath,proto3" json:"script_path,omitempty"`
}

func (x *ApiEndpointHandler) Reset() {
	*x = ApiEndpointHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApiEndpointHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiEndpointHandler) ProtoMessage() {}

func (x *ApiEndpointHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiEndpointHandler.ProtoReflect.Descriptor instead.
func (*ApiEndpointHandler) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{5}
}

func (x *ApiEndpointHandler) GetScriptPath() string {
	if x != nil {
		return x.ScriptPath
	}
	return ""
}

// Health checking configuration for VM instances. Unhealthy instances
// are killed and replaced with new instances. Only applicable for
// instances in App Engine flexible environment.
type HealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to explicitly disable health checks for this instance.
	DisableHealthCheck bool `protobuf:"varint,1,opt,name=disable_health_check,json=disableHealthCheck,proto3" json:"disable_health_check,omitempty"`
	// Host header to send when performing an HTTP health check.
	// Example: "myapp.appspot.com"
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// Number of consecutive successful health checks required before receiving
	// traffic.
	HealthyThreshold uint32 `protobuf:"varint,3,opt,name=healthy_threshold,json=healthyThreshold,proto3" json:"healthy_threshold,omitempty"`
	// Number of consecutive failed health checks required before removing
	// traffic.
	UnhealthyThreshold uint32 `protobuf:"varint,4,opt,name=unhealthy_threshold,json=unhealthyThreshold,proto3" json:"unhealthy_threshold,omitempty"`
	// Number of consecutive failed health checks required before an instance is
	// restarted.
	RestartThreshold uint32 `protobuf:"varint,5,opt,name=restart_threshold,json=restartThreshold,proto3" json:"restart_threshold,omitempty"`
	// Interval between health checks.
	CheckInterval *durationpb.Duration `protobuf:"bytes,6,opt,name=check_interval,json=checkInterval,proto3" json:"check_interval,omitempty"`
	// Time before the health check is considered failed.
	Timeout *durationpb.Duration `protobuf:"bytes,7,opt,name=timeout,proto3" json:"timeout,omitempty"`
}

func (x *HealthCheck) Reset() {
	*x = HealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck) ProtoMessage() {}

func (x *HealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{6}
}

func (x *HealthCheck) GetDisableHealthCheck() bool {
	if x != nil {
		return x.DisableHealthCheck
	}
	return false
}

func (x *HealthCheck) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *HealthCheck) GetHealthyThreshold() uint32 {
	if x != nil {
		return x.HealthyThreshold
	}
	return 0
}

func (x *HealthCheck) GetUnhealthyThreshold() uint32 {
	if x != nil {
		return x.UnhealthyThreshold
	}
	return 0
}

func (x *HealthCheck) GetRestartThreshold() uint32 {
	if x != nil {
		return x.RestartThreshold
	}
	return 0
}

func (x *HealthCheck) GetCheckInterval() *durationpb.Duration {
	if x != nil {
		return x.CheckInterval
	}
	return nil
}

func (x *HealthCheck) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

// Readiness checking configuration for VM instances. Unhealthy instances
// are removed from traffic rotation.
type ReadinessCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request path.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Host header to send when performing a HTTP Readiness check.
	// Example: "myapp.appspot.com"
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// Number of consecutive failed checks required before removing
	// traffic.
	FailureThreshold uint32 `protobuf:"varint,3,opt,name=failure_threshold,json=failureThreshold,proto3" json:"failure_threshold,omitempty"`
	// Number of consecutive successful checks required before receiving
	// traffic.
	SuccessThreshold uint32 `protobuf:"varint,4,opt,name=success_threshold,json=successThreshold,proto3" json:"success_threshold,omitempty"`
	// Interval between health checks.
	CheckInterval *durationpb.Duration `protobuf:"bytes,5,opt,name=check_interval,json=checkInterval,proto3" json:"check_interval,omitempty"`
	// Time before the check is considered failed.
	Timeout *durationpb.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// A maximum time limit on application initialization, measured from moment
	// the application successfully replies to a healthcheck until it is ready to
	// serve traffic.
	AppStartTimeout *durationpb.Duration `protobuf:"bytes,7,opt,name=app_start_timeout,json=appStartTimeout,proto3" json:"app_start_timeout,omitempty"`
}

func (x *ReadinessCheck) Reset() {
	*x = ReadinessCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadinessCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadinessCheck) ProtoMessage() {}

func (x *ReadinessCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadinessCheck.ProtoReflect.Descriptor instead.
func (*ReadinessCheck) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{7}
}

func (x *ReadinessCheck) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ReadinessCheck) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *ReadinessCheck) GetFailureThreshold() uint32 {
	if x != nil {
		return x.FailureThreshold
	}
	return 0
}

func (x *ReadinessCheck) GetSuccessThreshold() uint32 {
	if x != nil {
		return x.SuccessThreshold
	}
	return 0
}

func (x *ReadinessCheck) GetCheckInterval() *durationpb.Duration {
	if x != nil {
		return x.CheckInterval
	}
	return nil
}

func (x *ReadinessCheck) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *ReadinessCheck) GetAppStartTimeout() *durationpb.Duration {
	if x != nil {
		return x.AppStartTimeout
	}
	return nil
}

// Health checking configuration for VM instances. Unhealthy instances
// are killed and replaced with new instances.
type LivenessCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request path.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Host header to send when performing a HTTP Liveness check.
	// Example: "myapp.appspot.com"
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// Number of consecutive failed checks required before considering the
	// VM unhealthy.
	FailureThreshold uint32 `protobuf:"varint,3,opt,name=failure_threshold,json=failureThreshold,proto3" json:"failure_threshold,omitempty"`
	// Number of consecutive successful checks required before considering
	// the VM healthy.
	SuccessThreshold uint32 `protobuf:"varint,4,opt,name=success_threshold,json=successThreshold,proto3" json:"success_threshold,omitempty"`
	// Interval between health checks.
	CheckInterval *durationpb.Duration `protobuf:"bytes,5,opt,name=check_interval,json=checkInterval,proto3" json:"check_interval,omitempty"`
	// Time before the check is considered failed.
	Timeout *durationpb.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The initial delay before starting to execute the checks.
	InitialDelay *durationpb.Duration `protobuf:"bytes,7,opt,name=initial_delay,json=initialDelay,proto3" json:"initial_delay,omitempty"`
}

func (x *LivenessCheck) Reset() {
	*x = LivenessCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LivenessCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LivenessCheck) ProtoMessage() {}

func (x *LivenessCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LivenessCheck.ProtoReflect.Descriptor instead.
func (*LivenessCheck) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{8}
}

func (x *LivenessCheck) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *LivenessCheck) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *LivenessCheck) GetFailureThreshold() uint32 {
	if x != nil {
		return x.FailureThreshold
	}
	return 0
}

func (x *LivenessCheck) GetSuccessThreshold() uint32 {
	if x != nil {
		return x.SuccessThreshold
	}
	return 0
}

func (x *LivenessCheck) GetCheckInterval() *durationpb.Duration {
	if x != nil {
		return x.CheckInterval
	}
	return nil
}

func (x *LivenessCheck) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *LivenessCheck) GetInitialDelay() *durationpb.Duration {
	if x != nil {
		return x.InitialDelay
	}
	return nil
}

// Third-party Python runtime library that is required by the application.
type Library struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the library. Example: "django".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version of the library to select, or "latest".
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Library) Reset() {
	*x = Library{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Library) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Library) ProtoMessage() {}

func (x *Library) ProtoReflect() protoreflect.Message {
	mi := &file_google_appengine_v1beta_app_yaml_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Library.ProtoReflect.Descriptor instead.
func (*Library) Descriptor() ([]byte, []int) {
	return file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP(), []int{9}
}

func (x *Library) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Library) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

var File_google_appengine_v1beta_app_yaml_proto protoreflect.FileDescriptor

var file_google_appengine_v1beta_app_yaml_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x79, 0x61,
	0x6d, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x9f, 0x02, 0x0a, 0x10, 0x41, 0x70, 0x69, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x51, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x66,
	0x61, 0x69, 0x6c, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x46,
	0x61, 0x69, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x46,
	0x61, 0x69, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x05, 0x6c, 0x6f, 0x67,
	0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x12, 0x4d, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x22, 0xb4, 0x02, 0x0a, 0x0c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x72, 0x12, 0x4e, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x2e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x63, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55,
	0x4c, 0x54, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f,
	0x44, 0x45, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x10, 0x01, 0x12,
	0x1d, 0x0a, 0x19, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x4f,
	0x53, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x16,
	0x0a, 0x12, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x4f, 0x55, 0x54, 0x10, 0x03, 0x1a, 0x02, 0x10, 0x01, 0x22, 0xd5, 0x06, 0x0a, 0x06, 0x55,
	0x72, 0x6c, 0x4d, 0x61, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x72, 0x6c, 0x5f, 0x72, 0x65, 0x67,
	0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x72, 0x6c, 0x52, 0x65, 0x67,
	0x65, 0x78, 0x12, 0x50, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x48, 0x00, 0x52, 0x06,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x50, 0x0a, 0x0c, 0x61, 0x70, 0x69, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x70, 0x69, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x70, 0x69,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x3f, 0x0a, 0x05, 0x6c, 0x6f, 0x67, 0x69, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x12, 0x51, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x68,
	0x5f, 0x66, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x46, 0x61, 0x69, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x61, 0x75, 0x74,
	0x68, 0x46, 0x61, 0x69, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x77, 0x0a, 0x1b, 0x72,
	0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x72, 0x6c, 0x4d, 0x61,
	0x70, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x18, 0x72, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x22, 0xdb, 0x01, 0x0a, 0x18, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x2b, 0x0a, 0x27, 0x52, 0x45, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x48, 0x54,
	0x54, 0x50, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x23,
	0x0a, 0x1f, 0x52, 0x45, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x5f,
	0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x33, 0x30,
	0x31, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f,
	0x48, 0x54, 0x54, 0x50, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x43, 0x4f,
	0x44, 0x45, 0x5f, 0x33, 0x30, 0x32, 0x10, 0x02, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x44, 0x49,
	0x52, 0x45, 0x43, 0x54, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e,
	0x53, 0x45, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x33, 0x30, 0x33, 0x10, 0x03, 0x12, 0x23, 0x0a,
	0x1f, 0x52, 0x45, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x52,
	0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x33, 0x30, 0x37,
	0x10, 0x04, 0x42, 0x0e, 0x0a, 0x0c, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x22, 0xb4, 0x03, 0x0a, 0x12, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x2a, 0x0a,
	0x11, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x72, 0x65, 0x67,
	0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x50, 0x61, 0x74, 0x68, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x5f, 0x0a, 0x0c, 0x68, 0x74, 0x74,
	0x70, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x2e, 0x48, 0x74, 0x74,
	0x70, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x68,
	0x74, 0x74, 0x70, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69,
	0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x13, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x31, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x61, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x3e, 0x0a, 0x10, 0x48, 0x74, 0x74,
	0x70, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x30, 0x0a, 0x0d, 0x53, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x50, 0x61, 0x74, 0x68, 0x22, 0x35, 0x0a, 0x12, 0x41,
	0x70, 0x69, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x22, 0xd5, 0x02, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x10, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x2f, 0x0a, 0x13, 0x75, 0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x12, 0x75, 0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x54, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x10, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x12, 0x40, 0x0a, 0x0e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0xd0, 0x02, 0x0a, 0x0e, 0x52,
	0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12,
	0x40, 0x0a, 0x0e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x61, 0x70,
	0x70, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0xc8, 0x02,
	0x0a, 0x0d, 0x4c, 0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x10, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x12, 0x40, 0x0a, 0x0e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x3e, 0x0a, 0x0d, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x22, 0x37, 0x0a, 0x07, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x2a, 0x74, 0x0a, 0x0e, 0x41, 0x75, 0x74, 0x68, 0x46, 0x61, 0x69, 0x6c, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x46, 0x41, 0x49, 0x4c,
	0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x46, 0x41,
	0x49, 0x4c, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x44, 0x49, 0x52, 0x45,
	0x43, 0x54, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48, 0x4f,
	0x52, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x02, 0x2a, 0x62, 0x0a, 0x10, 0x4c, 0x6f, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x11, 0x4c,
	0x4f, 0x47, 0x49, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x47, 0x49, 0x4e, 0x5f, 0x4f, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4c, 0x4f, 0x47, 0x49, 0x4e, 0x5f,
	0x41, 0x44, 0x4d, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x47, 0x49, 0x4e,
	0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x79, 0x0a, 0x0d, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x16, 0x0a, 0x12,
	0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x5f, 0x44,
	0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45, 0x43, 0x55,
	0x52, 0x45, 0x5f, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45,
	0x43, 0x55, 0x52, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x12,
	0x11, 0x0a, 0x0d, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45, 0x5f, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53,
	0x10, 0x03, 0x1a, 0x02, 0x10, 0x01, 0x42, 0xd2, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0c, 0x41, 0x70, 0x70, 0x59, 0x61, 0x6d, 0x6c, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70,
	0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x3b, 0x61,
	0x70, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_appengine_v1beta_app_yaml_proto_rawDescOnce sync.Once
	file_google_appengine_v1beta_app_yaml_proto_rawDescData = file_google_appengine_v1beta_app_yaml_proto_rawDesc
)

func file_google_appengine_v1beta_app_yaml_proto_rawDescGZIP() []byte {
	file_google_appengine_v1beta_app_yaml_proto_rawDescOnce.Do(func() {
		file_google_appengine_v1beta_app_yaml_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_appengine_v1beta_app_yaml_proto_rawDescData)
	})
	return file_google_appengine_v1beta_app_yaml_proto_rawDescData
}

var file_google_appengine_v1beta_app_yaml_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_appengine_v1beta_app_yaml_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_appengine_v1beta_app_yaml_proto_goTypes = []interface{}{
	(AuthFailAction)(0),                  // 0: google.appengine.v1beta.AuthFailAction
	(LoginRequirement)(0),                // 1: google.appengine.v1beta.LoginRequirement
	(SecurityLevel)(0),                   // 2: google.appengine.v1beta.SecurityLevel
	(ErrorHandler_ErrorCode)(0),          // 3: google.appengine.v1beta.ErrorHandler.ErrorCode
	(UrlMap_RedirectHttpResponseCode)(0), // 4: google.appengine.v1beta.UrlMap.RedirectHttpResponseCode
	(*ApiConfigHandler)(nil),             // 5: google.appengine.v1beta.ApiConfigHandler
	(*ErrorHandler)(nil),                 // 6: google.appengine.v1beta.ErrorHandler
	(*UrlMap)(nil),                       // 7: google.appengine.v1beta.UrlMap
	(*StaticFilesHandler)(nil),           // 8: google.appengine.v1beta.StaticFilesHandler
	(*ScriptHandler)(nil),                // 9: google.appengine.v1beta.ScriptHandler
	(*ApiEndpointHandler)(nil),           // 10: google.appengine.v1beta.ApiEndpointHandler
	(*HealthCheck)(nil),                  // 11: google.appengine.v1beta.HealthCheck
	(*ReadinessCheck)(nil),               // 12: google.appengine.v1beta.ReadinessCheck
	(*LivenessCheck)(nil),                // 13: google.appengine.v1beta.LivenessCheck
	(*Library)(nil),                      // 14: google.appengine.v1beta.Library
	nil,                                  // 15: google.appengine.v1beta.StaticFilesHandler.HttpHeadersEntry
	(*durationpb.Duration)(nil),          // 16: google.protobuf.Duration
}
var file_google_appengine_v1beta_app_yaml_proto_depIdxs = []int32{
	0,  // 0: google.appengine.v1beta.ApiConfigHandler.auth_fail_action:type_name -> google.appengine.v1beta.AuthFailAction
	1,  // 1: google.appengine.v1beta.ApiConfigHandler.login:type_name -> google.appengine.v1beta.LoginRequirement
	2,  // 2: google.appengine.v1beta.ApiConfigHandler.security_level:type_name -> google.appengine.v1beta.SecurityLevel
	3,  // 3: google.appengine.v1beta.ErrorHandler.error_code:type_name -> google.appengine.v1beta.ErrorHandler.ErrorCode
	8,  // 4: google.appengine.v1beta.UrlMap.static_files:type_name -> google.appengine.v1beta.StaticFilesHandler
	9,  // 5: google.appengine.v1beta.UrlMap.script:type_name -> google.appengine.v1beta.ScriptHandler
	10, // 6: google.appengine.v1beta.UrlMap.api_endpoint:type_name -> google.appengine.v1beta.ApiEndpointHandler
	2,  // 7: google.appengine.v1beta.UrlMap.security_level:type_name -> google.appengine.v1beta.SecurityLevel
	1,  // 8: google.appengine.v1beta.UrlMap.login:type_name -> google.appengine.v1beta.LoginRequirement
	0,  // 9: google.appengine.v1beta.UrlMap.auth_fail_action:type_name -> google.appengine.v1beta.AuthFailAction
	4,  // 10: google.appengine.v1beta.UrlMap.redirect_http_response_code:type_name -> google.appengine.v1beta.UrlMap.RedirectHttpResponseCode
	15, // 11: google.appengine.v1beta.StaticFilesHandler.http_headers:type_name -> google.appengine.v1beta.StaticFilesHandler.HttpHeadersEntry
	16, // 12: google.appengine.v1beta.StaticFilesHandler.expiration:type_name -> google.protobuf.Duration
	16, // 13: google.appengine.v1beta.HealthCheck.check_interval:type_name -> google.protobuf.Duration
	16, // 14: google.appengine.v1beta.HealthCheck.timeout:type_name -> google.protobuf.Duration
	16, // 15: google.appengine.v1beta.ReadinessCheck.check_interval:type_name -> google.protobuf.Duration
	16, // 16: google.appengine.v1beta.ReadinessCheck.timeout:type_name -> google.protobuf.Duration
	16, // 17: google.appengine.v1beta.ReadinessCheck.app_start_timeout:type_name -> google.protobuf.Duration
	16, // 18: google.appengine.v1beta.LivenessCheck.check_interval:type_name -> google.protobuf.Duration
	16, // 19: google.appengine.v1beta.LivenessCheck.timeout:type_name -> google.protobuf.Duration
	16, // 20: google.appengine.v1beta.LivenessCheck.initial_delay:type_name -> google.protobuf.Duration
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_appengine_v1beta_app_yaml_proto_init() }
func file_google_appengine_v1beta_app_yaml_proto_init() {
	if File_google_appengine_v1beta_app_yaml_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApiConfigHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UrlMap); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StaticFilesHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScriptHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApiEndpointHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadinessCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LivenessCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_appengine_v1beta_app_yaml_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Library); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_appengine_v1beta_app_yaml_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*UrlMap_StaticFiles)(nil),
		(*UrlMap_Script)(nil),
		(*UrlMap_ApiEndpoint)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_appengine_v1beta_app_yaml_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_appengine_v1beta_app_yaml_proto_goTypes,
		DependencyIndexes: file_google_appengine_v1beta_app_yaml_proto_depIdxs,
		EnumInfos:         file_google_appengine_v1beta_app_yaml_proto_enumTypes,
		MessageInfos:      file_google_appengine_v1beta_app_yaml_proto_msgTypes,
	}.Build()
	File_google_appengine_v1beta_app_yaml_proto = out.File
	file_google_appengine_v1beta_app_yaml_proto_rawDesc = nil
	file_google_appengine_v1beta_app_yaml_proto_goTypes = nil
	file_google_appengine_v1beta_app_yaml_proto_depIdxs = nil
}
