/*
 * libmaitretarot.
 * Copyright (C) 2002  Yves Mettier <ymettier@libertysurf.fr>
 * Code taken from the MyAM project, also (c) Yves Mettier
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,  59
 * Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <glib.h>

#include <config_utils.h>
#include <maitretarot.h>
#include <net.h>

#ifndef _
#define _(a) a
#endif

char **keys = NULL;
char **values = NULL;

gboolean
libmt_check_version (gint major, gint minor, gint micro)
{
  return ((LIBMT_MAJOR > major) ||
	  ((LIBMT_MAJOR == major) && (LIBMT_MINOR > minor)) ||
	  ((LIBMT_MAJOR == major) && (LIBMT_MINOR == minor)
	   && (LIBMT_MICRO >= micro)));
}


gchar *
libmt_load_file (gchar * filename)
{
  struct stat buf;
  int r;
  char *content;
  int fd;
  int len;

  fprintf (stderr, "libmt_load_file call in %s:%d is obsolete\n", __FILE__, __LINE__);
  /* Read the file */
  r = stat (filename, &buf);
  if (r != 0)
    return (NULL);		/* An error occured in stat() */
  if (!S_ISREG (buf.st_mode))
    return (NULL);		/* We only read regular files, not
				   directories! */
  content = (char *)g_malloc ((buf.st_size + 1) * sizeof (char));
  fd = open (filename, O_RDONLY);
  if ((len = libmt_read (fd, content, buf.st_size)) < 0)
  {
    g_free (content);
    return (NULL);
  }
  close (fd);
  content[len] = '\0';
  return (content);
}

gchar *
libmt_config_get_filename (char *default_name)
{
  fprintf (stderr, "libmt_config_get_filename call in %s:%d is obsolete\n", __FILE__, __LINE__);
  return (g_strdup (default_name));
}

void
libmt_config_free (void)
{
  int i;
  fprintf (stderr, "libmt_config_free call in %s:%d is obsolete\n", __FILE__, __LINE__);

  if (keys)
  {
    for (i = 0; keys[i]; i++)
    {
      g_free (keys[i]);
    }
    g_free (keys);
  }

  if (values)
  {
    for (i = 0; values[i]; i++)
    {
      g_free (values[i]);
    }
    g_free (values);
  }
}

int
libmt_config_load_config_file (gchar * filename)
{
  int nbn;
  int i, j;
  int k;
  int len;
  gboolean replacement;
  gchar *content;

  fprintf (stderr, "libmt_config_load_config_file call in %s:%d is obsolete\n", __FILE__, __LINE__);
  libmt_config_free ();

  content = libmt_load_file (filename);
  if (!content)
    g_error (_ ("Could not load the configuration file"));

  len = strlen (content);

  /* Count the nb of lines */
  nbn = 2;			/* 1 for the last one, and 1 if the last char
				   is not '\n' */
  for (i = 0; i < len; i++)
  {
    if (content[i] == '\n')
      nbn++;
  }
  keys = (char **)g_malloc0 (nbn * sizeof (char *));
  values = (char **)g_malloc0 (nbn * sizeof (char *));

  /* the parser */
  j = 0;
  k = 0;
  for (i = 0; i < len; i++)
  {
    if ((content[i] == '#') && ((i == 0) || (content[i - 1] == '\n')))
    {
      /* remove comments */
      while ((i < len) && (content[i] != '\n'))
	i++;
      if (i < len)
	i++;
      if (i >= len)
	break;
      k = i;
    }
    if (content[i] == '=')
    {
      content[i] = '\0';
      keys[j] = g_strdup (content + k);
      k = i + 1;
    }
    if (content[i] == '\n')
    {
      if (keys[j])
      {

	content[i] = '\0';
	values[j] = g_strdup (content + k);
	content[i] = '\n';
	k = i + 1;
	j++;
      }
    }
  }
  keys[j] = NULL;
  values[j] = NULL;

  /* Substitute variables with their value */
  replacement = TRUE;
  while (replacement)
  {
    replacement = FALSE;
    for (i = 0; keys[i]; i++)
    {
      for (j = 0; ((values[i][j])
		   && ((values[i][j] != '$')
		       || ((j > 0) && (values[i][j] == '$')
			   && (values[i][j - 1] == '\\')))); j++);
      if (values[i][j] == '$')
      {
	int k1, k2;
	gchar *new_value;

	replacement = TRUE;
	if (values[i][j + 1] == '{')
	{			/* This is a variable like ${VAR} */
	  k1 = j + 2;
	  for (k2 = k1;
	       ((values[i][k2]) && (values[i][k2] != '}')); k2++);
	  if (!values[i][k2])
	  {
	    g_log (NULL,
		   G_LOG_LEVEL_ERROR,
		   "Syntax error in config file with key '%s'",
		   keys[i]);
	  }
	  values[i][j] = '\0';
	  values[i][k2] = '\0';
	  if (!strcmp (keys[i], &(values[i][k1])))
	    g_log (NULL,
		   G_LOG_LEVEL_ERROR,
		   "Loop in resolving key '%s'", keys[i]);
	  new_value =
	    g_strdup_printf ("%s%s%s",
			     values[i],
			     libmt_config_get
			     (&
			      (values[i][k1])), &(values[i][k2 + 1]));
	}
	else
	{			/* This is a variable like $VAR */
	  gchar c;
	  k1 = j + 1;
	  for (k2 = k1; ((values[i][k2] == '_')
			 ||
			 ((values[i][k2] >= 'A')
			  && (values[i][k2] <=
			      'Z'))
			 ||
			 ((values[i][k2] >= 'a')
			  && (values[i][k2] <=
			      'z'))
			 ||
			 ((values[i][k2] >= '0')
			  && (values[i][k2] <= '9'))); k2++);
	  values[i][j] = '\0';
	  c = values[i][k2];
	  values[i][k2] = '\0';
	  if (!strcmp (keys[i], &(values[i][k1])))
	    g_log (NULL,
		   G_LOG_LEVEL_ERROR,
		   "Loop in resolving key '%s'", keys[i]);
	  if (c)
	  {
	    new_value =
	      g_strdup_printf
	      ("%s%s%c%s",
	       values[i],
	       libmt_config_get (&
				 (values
				  [i][k1])), c,
	       &(values[i][k2 + 1]));
	  }
	  else
	  {
	    new_value =
	      g_strdup_printf
	      ("%s%s", values[i],
	       libmt_config_get (&(values[i][k1])));
	  }

	}
	g_free (values[i]);
	values[i] = new_value;
      }
    }
  }
  g_free (content);
  return (0);
}

const char *
libmt_config_get (const char *key)
{
  int i;
  fprintf (stderr, "libmt_config_get call in %s:%d is obsolete\n", __FILE__, __LINE__);
  if (!keys)
    return (NULL);
  for (i = 0; keys[i]; i++)
  {
    if (!strcmp (key, keys[i]))
      return (values[i]);
  }
  return (NULL);
}

void
libmt_config_test (const gchar ** testkeys)
{
  int i;
  gboolean err = FALSE;
  fprintf (stderr, "libmt_config_test call in %s:%d is obsolete\n", __FILE__, __LINE__);
  for (i = 0; testkeys[i]; i++)
  {
    if (!libmt_config_get (testkeys[i]))
    {
      g_log (NULL, G_LOG_LEVEL_INFO, "Key '%s' undefined", testkeys[i]);
      err = TRUE;
    }
  }
  if (err)
    g_log (NULL, G_LOG_LEVEL_ERROR,
	   "Some keys are undefined. Please check your configuration file!");
}
