// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/firestore/admin/v1/operation.proto

package admin

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Describes the state of the operation.
type OperationState int32

const (
	// Unspecified.
	OperationState_OPERATION_STATE_UNSPECIFIED OperationState = 0
	// Request is being prepared for processing.
	OperationState_INITIALIZING OperationState = 1
	// Request is actively being processed.
	OperationState_PROCESSING OperationState = 2
	// Request is in the process of being cancelled after user called
	// google.longrunning.Operations.CancelOperation on the operation.
	OperationState_CANCELLING OperationState = 3
	// Request has been processed and is in its finalization stage.
	OperationState_FINALIZING OperationState = 4
	// Request has completed successfully.
	OperationState_SUCCESSFUL OperationState = 5
	// Request has finished being processed, but encountered an error.
	OperationState_FAILED OperationState = 6
	// Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	OperationState_CANCELLED OperationState = 7
)

// Enum value maps for OperationState.
var (
	OperationState_name = map[int32]string{
		0: "OPERATION_STATE_UNSPECIFIED",
		1: "INITIALIZING",
		2: "PROCESSING",
		3: "CANCELLING",
		4: "FINALIZING",
		5: "SUCCESSFUL",
		6: "FAILED",
		7: "CANCELLED",
	}
	OperationState_value = map[string]int32{
		"OPERATION_STATE_UNSPECIFIED": 0,
		"INITIALIZING":                1,
		"PROCESSING":                  2,
		"CANCELLING":                  3,
		"FINALIZING":                  4,
		"SUCCESSFUL":                  5,
		"FAILED":                      6,
		"CANCELLED":                   7,
	}
)

func (x OperationState) Enum() *OperationState {
	p := new(OperationState)
	*p = x
	return p
}

func (x OperationState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_admin_v1_operation_proto_enumTypes[0].Descriptor()
}

func (OperationState) Type() protoreflect.EnumType {
	return &file_google_firestore_admin_v1_operation_proto_enumTypes[0]
}

func (x OperationState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationState.Descriptor instead.
func (OperationState) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{0}
}

// Specifies how the index is changing.
type FieldOperationMetadata_IndexConfigDelta_ChangeType int32

const (
	// The type of change is not specified or known.
	FieldOperationMetadata_IndexConfigDelta_CHANGE_TYPE_UNSPECIFIED FieldOperationMetadata_IndexConfigDelta_ChangeType = 0
	// The single field index is being added.
	FieldOperationMetadata_IndexConfigDelta_ADD FieldOperationMetadata_IndexConfigDelta_ChangeType = 1
	// The single field index is being removed.
	FieldOperationMetadata_IndexConfigDelta_REMOVE FieldOperationMetadata_IndexConfigDelta_ChangeType = 2
)

// Enum value maps for FieldOperationMetadata_IndexConfigDelta_ChangeType.
var (
	FieldOperationMetadata_IndexConfigDelta_ChangeType_name = map[int32]string{
		0: "CHANGE_TYPE_UNSPECIFIED",
		1: "ADD",
		2: "REMOVE",
	}
	FieldOperationMetadata_IndexConfigDelta_ChangeType_value = map[string]int32{
		"CHANGE_TYPE_UNSPECIFIED": 0,
		"ADD":                     1,
		"REMOVE":                  2,
	}
)

func (x FieldOperationMetadata_IndexConfigDelta_ChangeType) Enum() *FieldOperationMetadata_IndexConfigDelta_ChangeType {
	p := new(FieldOperationMetadata_IndexConfigDelta_ChangeType)
	*p = x
	return p
}

func (x FieldOperationMetadata_IndexConfigDelta_ChangeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldOperationMetadata_IndexConfigDelta_ChangeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_admin_v1_operation_proto_enumTypes[1].Descriptor()
}

func (FieldOperationMetadata_IndexConfigDelta_ChangeType) Type() protoreflect.EnumType {
	return &file_google_firestore_admin_v1_operation_proto_enumTypes[1]
}

func (x FieldOperationMetadata_IndexConfigDelta_ChangeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldOperationMetadata_IndexConfigDelta_ChangeType.Descriptor instead.
func (FieldOperationMetadata_IndexConfigDelta_ChangeType) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{1, 0, 0}
}

// Metadata for [google.longrunning.Operation][google.longrunning.Operation] results from
// [FirestoreAdmin.CreateIndex][google.firestore.admin.v1.FirestoreAdmin.CreateIndex].
type IndexOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time this operation started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time this operation completed. Will be unset if operation still in
	// progress.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The index resource that this operation is acting on. For example:
	// `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
	Index string `protobuf:"bytes,3,opt,name=index,proto3" json:"index,omitempty"`
	// The state of the operation.
	State OperationState `protobuf:"varint,4,opt,name=state,proto3,enum=google.firestore.admin.v1.OperationState" json:"state,omitempty"`
	// The progress, in documents, of this operation.
	ProgressDocuments *Progress `protobuf:"bytes,5,opt,name=progress_documents,json=progressDocuments,proto3" json:"progress_documents,omitempty"`
	// The progress, in bytes, of this operation.
	ProgressBytes *Progress `protobuf:"bytes,6,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
}

func (x *IndexOperationMetadata) Reset() {
	*x = IndexOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexOperationMetadata) ProtoMessage() {}

func (x *IndexOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexOperationMetadata.ProtoReflect.Descriptor instead.
func (*IndexOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{0}
}

func (x *IndexOperationMetadata) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *IndexOperationMetadata) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *IndexOperationMetadata) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *IndexOperationMetadata) GetState() OperationState {
	if x != nil {
		return x.State
	}
	return OperationState_OPERATION_STATE_UNSPECIFIED
}

func (x *IndexOperationMetadata) GetProgressDocuments() *Progress {
	if x != nil {
		return x.ProgressDocuments
	}
	return nil
}

func (x *IndexOperationMetadata) GetProgressBytes() *Progress {
	if x != nil {
		return x.ProgressBytes
	}
	return nil
}

// Metadata for [google.longrunning.Operation][google.longrunning.Operation] results from
// [FirestoreAdmin.UpdateField][google.firestore.admin.v1.FirestoreAdmin.UpdateField].
type FieldOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time this operation started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time this operation completed. Will be unset if operation still in
	// progress.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The field resource that this operation is acting on. For example:
	// `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_path}`
	Field string `protobuf:"bytes,3,opt,name=field,proto3" json:"field,omitempty"`
	// A list of [IndexConfigDelta][google.firestore.admin.v1.FieldOperationMetadata.IndexConfigDelta], which describe the intent of this
	// operation.
	IndexConfigDeltas []*FieldOperationMetadata_IndexConfigDelta `protobuf:"bytes,4,rep,name=index_config_deltas,json=indexConfigDeltas,proto3" json:"index_config_deltas,omitempty"`
	// The state of the operation.
	State OperationState `protobuf:"varint,5,opt,name=state,proto3,enum=google.firestore.admin.v1.OperationState" json:"state,omitempty"`
	// The progress, in documents, of this operation.
	ProgressDocuments *Progress `protobuf:"bytes,6,opt,name=progress_documents,json=progressDocuments,proto3" json:"progress_documents,omitempty"`
	// The progress, in bytes, of this operation.
	ProgressBytes *Progress `protobuf:"bytes,7,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
}

func (x *FieldOperationMetadata) Reset() {
	*x = FieldOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldOperationMetadata) ProtoMessage() {}

func (x *FieldOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldOperationMetadata.ProtoReflect.Descriptor instead.
func (*FieldOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{1}
}

func (x *FieldOperationMetadata) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *FieldOperationMetadata) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *FieldOperationMetadata) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *FieldOperationMetadata) GetIndexConfigDeltas() []*FieldOperationMetadata_IndexConfigDelta {
	if x != nil {
		return x.IndexConfigDeltas
	}
	return nil
}

func (x *FieldOperationMetadata) GetState() OperationState {
	if x != nil {
		return x.State
	}
	return OperationState_OPERATION_STATE_UNSPECIFIED
}

func (x *FieldOperationMetadata) GetProgressDocuments() *Progress {
	if x != nil {
		return x.ProgressDocuments
	}
	return nil
}

func (x *FieldOperationMetadata) GetProgressBytes() *Progress {
	if x != nil {
		return x.ProgressBytes
	}
	return nil
}

// Metadata for [google.longrunning.Operation][google.longrunning.Operation] results from
// [FirestoreAdmin.ExportDocuments][google.firestore.admin.v1.FirestoreAdmin.ExportDocuments].
type ExportDocumentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time this operation started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time this operation completed. Will be unset if operation still in
	// progress.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The state of the export operation.
	OperationState OperationState `protobuf:"varint,3,opt,name=operation_state,json=operationState,proto3,enum=google.firestore.admin.v1.OperationState" json:"operation_state,omitempty"`
	// The progress, in documents, of this operation.
	ProgressDocuments *Progress `protobuf:"bytes,4,opt,name=progress_documents,json=progressDocuments,proto3" json:"progress_documents,omitempty"`
	// The progress, in bytes, of this operation.
	ProgressBytes *Progress `protobuf:"bytes,5,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Which collection ids are being exported.
	CollectionIds []string `protobuf:"bytes,6,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// Where the entities are being exported to.
	OutputUriPrefix string `protobuf:"bytes,7,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *ExportDocumentsMetadata) Reset() {
	*x = ExportDocumentsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDocumentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDocumentsMetadata) ProtoMessage() {}

func (x *ExportDocumentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDocumentsMetadata.ProtoReflect.Descriptor instead.
func (*ExportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{2}
}

func (x *ExportDocumentsMetadata) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetOperationState() OperationState {
	if x != nil {
		return x.OperationState
	}
	return OperationState_OPERATION_STATE_UNSPECIFIED
}

func (x *ExportDocumentsMetadata) GetProgressDocuments() *Progress {
	if x != nil {
		return x.ProgressDocuments
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetProgressBytes() *Progress {
	if x != nil {
		return x.ProgressBytes
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetCollectionIds() []string {
	if x != nil {
		return x.CollectionIds
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// Metadata for [google.longrunning.Operation][google.longrunning.Operation] results from
// [FirestoreAdmin.ImportDocuments][google.firestore.admin.v1.FirestoreAdmin.ImportDocuments].
type ImportDocumentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time this operation started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time this operation completed. Will be unset if operation still in
	// progress.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The state of the import operation.
	OperationState OperationState `protobuf:"varint,3,opt,name=operation_state,json=operationState,proto3,enum=google.firestore.admin.v1.OperationState" json:"operation_state,omitempty"`
	// The progress, in documents, of this operation.
	ProgressDocuments *Progress `protobuf:"bytes,4,opt,name=progress_documents,json=progressDocuments,proto3" json:"progress_documents,omitempty"`
	// The progress, in bytes, of this operation.
	ProgressBytes *Progress `protobuf:"bytes,5,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Which collection ids are being imported.
	CollectionIds []string `protobuf:"bytes,6,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// The location of the documents being imported.
	InputUriPrefix string `protobuf:"bytes,7,opt,name=input_uri_prefix,json=inputUriPrefix,proto3" json:"input_uri_prefix,omitempty"`
}

func (x *ImportDocumentsMetadata) Reset() {
	*x = ImportDocumentsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDocumentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsMetadata) ProtoMessage() {}

func (x *ImportDocumentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsMetadata.ProtoReflect.Descriptor instead.
func (*ImportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{3}
}

func (x *ImportDocumentsMetadata) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetOperationState() OperationState {
	if x != nil {
		return x.OperationState
	}
	return OperationState_OPERATION_STATE_UNSPECIFIED
}

func (x *ImportDocumentsMetadata) GetProgressDocuments() *Progress {
	if x != nil {
		return x.ProgressDocuments
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetProgressBytes() *Progress {
	if x != nil {
		return x.ProgressBytes
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetCollectionIds() []string {
	if x != nil {
		return x.CollectionIds
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetInputUriPrefix() string {
	if x != nil {
		return x.InputUriPrefix
	}
	return ""
}

// Returned in the [google.longrunning.Operation][google.longrunning.Operation] response field.
type ExportDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the output files. This can be used to begin an import
	// into Cloud Firestore (this project or another project) after the operation
	// completes successfully.
	OutputUriPrefix string `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *ExportDocumentsResponse) Reset() {
	*x = ExportDocumentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDocumentsResponse) ProtoMessage() {}

func (x *ExportDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ExportDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{4}
}

func (x *ExportDocumentsResponse) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// Describes the progress of the operation.
// Unit of work is generic and must be interpreted based on where [Progress][google.firestore.admin.v1.Progress]
// is used.
type Progress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount of work estimated.
	EstimatedWork int64 `protobuf:"varint,1,opt,name=estimated_work,json=estimatedWork,proto3" json:"estimated_work,omitempty"`
	// The amount of work completed.
	CompletedWork int64 `protobuf:"varint,2,opt,name=completed_work,json=completedWork,proto3" json:"completed_work,omitempty"`
}

func (x *Progress) Reset() {
	*x = Progress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Progress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Progress) ProtoMessage() {}

func (x *Progress) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Progress.ProtoReflect.Descriptor instead.
func (*Progress) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{5}
}

func (x *Progress) GetEstimatedWork() int64 {
	if x != nil {
		return x.EstimatedWork
	}
	return 0
}

func (x *Progress) GetCompletedWork() int64 {
	if x != nil {
		return x.CompletedWork
	}
	return 0
}

// Information about an index configuration change.
type FieldOperationMetadata_IndexConfigDelta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies how the index is changing.
	ChangeType FieldOperationMetadata_IndexConfigDelta_ChangeType `protobuf:"varint,1,opt,name=change_type,json=changeType,proto3,enum=google.firestore.admin.v1.FieldOperationMetadata_IndexConfigDelta_ChangeType" json:"change_type,omitempty"`
	// The index being changed.
	Index *Index `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *FieldOperationMetadata_IndexConfigDelta) Reset() {
	*x = FieldOperationMetadata_IndexConfigDelta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldOperationMetadata_IndexConfigDelta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldOperationMetadata_IndexConfigDelta) ProtoMessage() {}

func (x *FieldOperationMetadata_IndexConfigDelta) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1_operation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldOperationMetadata_IndexConfigDelta.ProtoReflect.Descriptor instead.
func (*FieldOperationMetadata_IndexConfigDelta) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1_operation_proto_rawDescGZIP(), []int{1, 0}
}

func (x *FieldOperationMetadata_IndexConfigDelta) GetChangeType() FieldOperationMetadata_IndexConfigDelta_ChangeType {
	if x != nil {
		return x.ChangeType
	}
	return FieldOperationMetadata_IndexConfigDelta_CHANGE_TYPE_UNSPECIFIED
}

func (x *FieldOperationMetadata_IndexConfigDelta) GetIndex() *Index {
	if x != nil {
		return x.Index
	}
	return nil
}

var File_google_firestore_admin_v1_operation_proto protoreflect.FileDescriptor

var file_google_firestore_admin_v1_operation_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76,
	0x31, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x81, 0x03, 0x0a,
	0x16, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x52, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x4a, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x22, 0xf2, 0x05, 0x0a, 0x16, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x12, 0x72, 0x0a, 0x13, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44,
	0x65, 0x6c, 0x74, 0x61, 0x52, 0x11, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x73, 0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x52, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4a, 0x0a, 0x0e,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x1a, 0xfa, 0x01, 0x0a, 0x10, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x12, 0x6e, 0x0a,
	0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x36, 0x0a,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x3e, 0x0a, 0x0a, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4d,
	0x4f, 0x56, 0x45, 0x10, 0x02, 0x22, 0xd2, 0x03, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x52, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4a, 0x0a, 0x0e, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0xd0, 0x03, 0x0a, 0x17, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x52, 0x0a, 0x12,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x11, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x4a, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0d, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0x45, 0x0a,
	0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x22, 0x58, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61,
	0x74, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x2a, 0x9e,
	0x01, 0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x46,
	0x55, 0x4c, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x42,
	0xbc, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x42, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x46, 0x53, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x46, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_firestore_admin_v1_operation_proto_rawDescOnce sync.Once
	file_google_firestore_admin_v1_operation_proto_rawDescData = file_google_firestore_admin_v1_operation_proto_rawDesc
)

func file_google_firestore_admin_v1_operation_proto_rawDescGZIP() []byte {
	file_google_firestore_admin_v1_operation_proto_rawDescOnce.Do(func() {
		file_google_firestore_admin_v1_operation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_firestore_admin_v1_operation_proto_rawDescData)
	})
	return file_google_firestore_admin_v1_operation_proto_rawDescData
}

var file_google_firestore_admin_v1_operation_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_firestore_admin_v1_operation_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_firestore_admin_v1_operation_proto_goTypes = []interface{}{
	(OperationState)(0), // 0: google.firestore.admin.v1.OperationState
	(FieldOperationMetadata_IndexConfigDelta_ChangeType)(0), // 1: google.firestore.admin.v1.FieldOperationMetadata.IndexConfigDelta.ChangeType
	(*IndexOperationMetadata)(nil),                          // 2: google.firestore.admin.v1.IndexOperationMetadata
	(*FieldOperationMetadata)(nil),                          // 3: google.firestore.admin.v1.FieldOperationMetadata
	(*ExportDocumentsMetadata)(nil),                         // 4: google.firestore.admin.v1.ExportDocumentsMetadata
	(*ImportDocumentsMetadata)(nil),                         // 5: google.firestore.admin.v1.ImportDocumentsMetadata
	(*ExportDocumentsResponse)(nil),                         // 6: google.firestore.admin.v1.ExportDocumentsResponse
	(*Progress)(nil),                                        // 7: google.firestore.admin.v1.Progress
	(*FieldOperationMetadata_IndexConfigDelta)(nil),         // 8: google.firestore.admin.v1.FieldOperationMetadata.IndexConfigDelta
	(*timestamp.Timestamp)(nil),                             // 9: google.protobuf.Timestamp
	(*Index)(nil),                                           // 10: google.firestore.admin.v1.Index
}
var file_google_firestore_admin_v1_operation_proto_depIdxs = []int32{
	9,  // 0: google.firestore.admin.v1.IndexOperationMetadata.start_time:type_name -> google.protobuf.Timestamp
	9,  // 1: google.firestore.admin.v1.IndexOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.firestore.admin.v1.IndexOperationMetadata.state:type_name -> google.firestore.admin.v1.OperationState
	7,  // 3: google.firestore.admin.v1.IndexOperationMetadata.progress_documents:type_name -> google.firestore.admin.v1.Progress
	7,  // 4: google.firestore.admin.v1.IndexOperationMetadata.progress_bytes:type_name -> google.firestore.admin.v1.Progress
	9,  // 5: google.firestore.admin.v1.FieldOperationMetadata.start_time:type_name -> google.protobuf.Timestamp
	9,  // 6: google.firestore.admin.v1.FieldOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	8,  // 7: google.firestore.admin.v1.FieldOperationMetadata.index_config_deltas:type_name -> google.firestore.admin.v1.FieldOperationMetadata.IndexConfigDelta
	0,  // 8: google.firestore.admin.v1.FieldOperationMetadata.state:type_name -> google.firestore.admin.v1.OperationState
	7,  // 9: google.firestore.admin.v1.FieldOperationMetadata.progress_documents:type_name -> google.firestore.admin.v1.Progress
	7,  // 10: google.firestore.admin.v1.FieldOperationMetadata.progress_bytes:type_name -> google.firestore.admin.v1.Progress
	9,  // 11: google.firestore.admin.v1.ExportDocumentsMetadata.start_time:type_name -> google.protobuf.Timestamp
	9,  // 12: google.firestore.admin.v1.ExportDocumentsMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 13: google.firestore.admin.v1.ExportDocumentsMetadata.operation_state:type_name -> google.firestore.admin.v1.OperationState
	7,  // 14: google.firestore.admin.v1.ExportDocumentsMetadata.progress_documents:type_name -> google.firestore.admin.v1.Progress
	7,  // 15: google.firestore.admin.v1.ExportDocumentsMetadata.progress_bytes:type_name -> google.firestore.admin.v1.Progress
	9,  // 16: google.firestore.admin.v1.ImportDocumentsMetadata.start_time:type_name -> google.protobuf.Timestamp
	9,  // 17: google.firestore.admin.v1.ImportDocumentsMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 18: google.firestore.admin.v1.ImportDocumentsMetadata.operation_state:type_name -> google.firestore.admin.v1.OperationState
	7,  // 19: google.firestore.admin.v1.ImportDocumentsMetadata.progress_documents:type_name -> google.firestore.admin.v1.Progress
	7,  // 20: google.firestore.admin.v1.ImportDocumentsMetadata.progress_bytes:type_name -> google.firestore.admin.v1.Progress
	1,  // 21: google.firestore.admin.v1.FieldOperationMetadata.IndexConfigDelta.change_type:type_name -> google.firestore.admin.v1.FieldOperationMetadata.IndexConfigDelta.ChangeType
	10, // 22: google.firestore.admin.v1.FieldOperationMetadata.IndexConfigDelta.index:type_name -> google.firestore.admin.v1.Index
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_firestore_admin_v1_operation_proto_init() }
func file_google_firestore_admin_v1_operation_proto_init() {
	if File_google_firestore_admin_v1_operation_proto != nil {
		return
	}
	file_google_firestore_admin_v1_index_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_firestore_admin_v1_operation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1_operation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1_operation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDocumentsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1_operation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDocumentsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1_operation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDocumentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1_operation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Progress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1_operation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldOperationMetadata_IndexConfigDelta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_firestore_admin_v1_operation_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_firestore_admin_v1_operation_proto_goTypes,
		DependencyIndexes: file_google_firestore_admin_v1_operation_proto_depIdxs,
		EnumInfos:         file_google_firestore_admin_v1_operation_proto_enumTypes,
		MessageInfos:      file_google_firestore_admin_v1_operation_proto_msgTypes,
	}.Build()
	File_google_firestore_admin_v1_operation_proto = out.File
	file_google_firestore_admin_v1_operation_proto_rawDesc = nil
	file_google_firestore_admin_v1_operation_proto_goTypes = nil
	file_google_firestore_admin_v1_operation_proto_depIdxs = nil
}
