# Stefan Achatz 2012
#
# Tries to find libcanberra and sets following variables according to found capabilities:
#
# CANBERRA_FOUND
# CANBERRA_INCLUDE_DIRS
# CANBERRA_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_CANBERRA libcanberra)

FIND_PATH(CANBERRA_INCLUDE_DIRS canberra.h
  HINTS
    ${PKG_CANBERRA_INCLUDE_DIRS}
    ${PKG_CANBERRA_INCLUDEDIR}
)

FIND_LIBRARY(CANBERRA_LIBRARIES canberra
  HINTS ${PKG_CANBERRA_LIBRARY_DIRS}
)

IF(CANBERRA_LIBRARIES AND CANBERRA_INCLUDE_DIRS)
  SET(CANBERRA_FOUND true)
ENDIF()

IF(CANBERRA_FIND_REQUIRED AND NOT CANBERRA_FOUND)
  MESSAGE(FATAL_ERROR "Could not find CANBERRA")
ENDIF()
