#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1560
#define LARGE_STATE_COUNT 6
#define SYMBOL_COUNT 271
#define ALIAS_COUNT 1
#define TOKEN_COUNT 95
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 76

enum {
  sym_module_comment = 1,
  sym_statement_comment = 2,
  sym_comment = 3,
  anon_sym_if = 4,
  anon_sym_LBRACE = 5,
  anon_sym_RBRACE = 6,
  anon_sym_erlang = 7,
  anon_sym_javascript = 8,
  anon_sym_AT = 9,
  anon_sym_LPAREN = 10,
  anon_sym_COMMA = 11,
  anon_sym_RPAREN = 12,
  anon_sym_COLON = 13,
  anon_sym_import = 14,
  anon_sym_DOT = 15,
  anon_sym_as = 16,
  anon_sym_SLASH = 17,
  anon_sym_type = 18,
  anon_sym_const = 19,
  anon_sym_EQ = 20,
  anon_sym_POUND = 21,
  anon_sym_LBRACK = 22,
  anon_sym_RBRACK = 23,
  anon_sym_LT_LT = 24,
  anon_sym_GT_GT = 25,
  anon_sym_DASH = 26,
  anon_sym_size = 27,
  anon_sym_fn = 28,
  anon_sym_DASH_GT = 29,
  anon_sym_external = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_AMP_AMP = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_LT = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_LT_DOT = 37,
  anon_sym_LT_EQ_DOT = 38,
  anon_sym_GT = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_GT_DOT = 41,
  anon_sym_GT_EQ_DOT = 42,
  anon_sym_PIPE_GT = 43,
  anon_sym_PLUS = 44,
  anon_sym_PLUS_DOT = 45,
  anon_sym_DASH_DOT = 46,
  anon_sym_STAR = 47,
  anon_sym_STAR_DOT = 48,
  anon_sym_SLASH_DOT = 49,
  anon_sym_PERCENT = 50,
  anon_sym_LT_GT = 51,
  anon_sym_todo = 52,
  anon_sym_panic = 53,
  anon_sym_DOT_DOT = 54,
  anon_sym_case = 55,
  anon_sym_PIPE = 56,
  anon_sym_let = 57,
  anon_sym_assert = 58,
  anon_sym_use = 59,
  anon_sym_LT_DASH = 60,
  anon_sym_BANG = 61,
  sym_visibility_modifier = 62,
  sym_opacity_modifier = 63,
  anon_sym_DQUOTE = 64,
  anon_sym_DQUOTE2 = 65,
  aux_sym_escape_sequence_token1 = 66,
  aux_sym_escape_sequence_token2 = 67,
  sym_float = 68,
  sym__hex = 69,
  sym__decimal = 70,
  sym__octal = 71,
  sym__binary = 72,
  anon_sym_binary = 73,
  anon_sym_bytes = 74,
  anon_sym_int = 75,
  anon_sym_float = 76,
  anon_sym_bit_string = 77,
  anon_sym_bits = 78,
  anon_sym_utf8 = 79,
  anon_sym_utf16 = 80,
  anon_sym_utf32 = 81,
  anon_sym_utf8_codepoint = 82,
  anon_sym_utf16_codepoint = 83,
  anon_sym_utf32_codepoint = 84,
  anon_sym_signed = 85,
  anon_sym_unsigned = 86,
  anon_sym_big = 87,
  anon_sym_little = 88,
  anon_sym_native = 89,
  anon_sym_unit = 90,
  sym__discard_name = 91,
  sym__name = 92,
  sym__upname = 93,
  sym_quoted_content = 94,
  sym_source_file = 95,
  sym__module_statement = 96,
  sym_target_group = 97,
  sym_target = 98,
  sym_attribute = 99,
  sym__attribute_arguments = 100,
  sym_attribute_value = 101,
  sym_import = 102,
  sym_module = 103,
  sym_unqualified_imports = 104,
  sym_unqualified_import = 105,
  sym_constant = 106,
  sym__constant_value = 107,
  sym_constant_tuple = 108,
  sym_constant_list = 109,
  sym__constant_bit_string = 110,
  sym_constant_bit_string_segment = 111,
  sym_constant_bit_string_segment_options = 112,
  sym__constant_bit_string_segment_option = 113,
  sym__constant_bit_string_named_segment_option = 114,
  sym__constant_bit_string_segment_option_size = 115,
  sym_constant_record = 116,
  sym_constant_record_arguments = 117,
  sym_constant_record_argument = 118,
  sym_constant_field_access = 119,
  sym__constant_type = 120,
  sym__constant_type_annotation = 121,
  sym_constant_tuple_type = 122,
  sym_constant_function_type = 123,
  sym_constant_function_parameter_types = 124,
  sym_constant_type = 125,
  sym_constant_type_arguments = 126,
  sym_constant_type_argument = 127,
  sym_external_type = 128,
  sym_external_function = 129,
  sym_external_function_parameters = 130,
  sym_external_function_parameter = 131,
  sym_external_function_body = 132,
  sym_function = 133,
  sym_function_parameters = 134,
  sym_function_parameter = 135,
  sym__labeled_discard_param = 136,
  sym__discard_param = 137,
  sym__labeled_name_param = 138,
  sym__name_param = 139,
  aux_sym__statement_seq = 140,
  sym__statement = 141,
  sym__expression = 142,
  sym_binary_expression = 143,
  sym__expression_unit = 144,
  sym_record = 145,
  sym_todo = 146,
  sym_panic = 147,
  sym_tuple = 148,
  sym_list = 149,
  sym__expression_bit_string = 150,
  sym_expression_bit_string_segment = 151,
  sym_expression_bit_string_segment_options = 152,
  sym__expression_bit_string_segment_option = 153,
  sym__expression_bit_string_named_segment_option = 154,
  sym__expression_bit_string_segment_option_size = 155,
  sym_anonymous_function = 156,
  sym_anonymous_function_parameters = 157,
  sym_anonymous_function_parameter = 158,
  sym_block = 159,
  sym_case = 160,
  sym_case_subjects = 161,
  sym_case_clauses = 162,
  sym_case_clause = 163,
  sym_case_clause_patterns = 164,
  sym_case_clause_pattern = 165,
  sym_case_clause_guard = 166,
  sym__case_clause_guard_expression = 167,
  sym__case_clause_guard_binary_expression = 168,
  sym__case_clause_guard_unit = 169,
  sym__case_clause_tuple_access = 170,
  sym_let_assert = 171,
  sym_let = 172,
  sym_use = 173,
  sym_use_assignments = 174,
  sym_use_assignment = 175,
  sym_assert = 176,
  sym_boolean_negation = 177,
  sym_integer_negation = 178,
  sym__assignment = 179,
  sym_record_update = 180,
  sym_record_update_arguments = 181,
  sym_record_update_argument = 182,
  sym__maybe_tuple_expression = 183,
  sym_tuple_access = 184,
  sym__maybe_record_expression = 185,
  sym_field_access = 186,
  sym__maybe_function_expression = 187,
  sym_arguments = 188,
  sym_argument = 189,
  sym_hole = 190,
  sym_function_call = 191,
  sym__pattern_expression = 192,
  sym__pattern_binary_expression = 193,
  sym__pattern = 194,
  sym_record_pattern = 195,
  sym_record_pattern_arguments = 196,
  sym_record_pattern_argument = 197,
  sym_pattern_spread = 198,
  sym_tuple_pattern = 199,
  sym__pattern_bit_string = 200,
  sym_pattern_bit_string_segment = 201,
  sym_pattern_bit_string_segment_options = 202,
  sym__pattern_bit_string_segment_option = 203,
  sym__pattern_bit_string_named_segment_option = 204,
  sym__pattern_bit_string_segment_option_size = 205,
  sym__pattern_bit_string_segment_argument = 206,
  sym_list_pattern = 207,
  sym_list_pattern_tail = 208,
  sym_type_definition = 209,
  sym_data_constructors = 210,
  sym_data_constructor = 211,
  sym_data_constructor_arguments = 212,
  sym_data_constructor_argument = 213,
  sym_type_alias = 214,
  sym_string = 215,
  sym_escape_sequence = 216,
  sym_integer = 217,
  sym__bit_string_segment_option = 218,
  sym__type = 219,
  sym__type_annotation = 220,
  sym_type_hole = 221,
  sym_tuple_type = 222,
  sym_function_type = 223,
  sym_function_parameter_types = 224,
  sym_type = 225,
  sym_type_arguments = 226,
  sym_type_argument = 227,
  sym_type_var = 228,
  sym_type_name = 229,
  sym_type_parameters = 230,
  sym_type_parameter = 231,
  sym_identifier = 232,
  sym_label = 233,
  sym_discard = 234,
  sym_type_identifier = 235,
  sym_remote_type_identifier = 236,
  sym_constructor_name = 237,
  sym_remote_constructor_name = 238,
  aux_sym_source_file_repeat1 = 239,
  aux_sym_target_group_repeat1 = 240,
  aux_sym__attribute_arguments_repeat1 = 241,
  aux_sym_module_repeat1 = 242,
  aux_sym_unqualified_imports_repeat1 = 243,
  aux_sym_constant_tuple_repeat1 = 244,
  aux_sym__constant_bit_string_repeat1 = 245,
  aux_sym_constant_bit_string_segment_options_repeat1 = 246,
  aux_sym_constant_record_arguments_repeat1 = 247,
  aux_sym_constant_tuple_type_repeat1 = 248,
  aux_sym_constant_type_arguments_repeat1 = 249,
  aux_sym_external_function_parameters_repeat1 = 250,
  aux_sym_function_parameters_repeat1 = 251,
  aux_sym_tuple_repeat1 = 252,
  aux_sym__expression_bit_string_repeat1 = 253,
  aux_sym_expression_bit_string_segment_options_repeat1 = 254,
  aux_sym_anonymous_function_parameters_repeat1 = 255,
  aux_sym_case_clauses_repeat1 = 256,
  aux_sym_case_clause_patterns_repeat1 = 257,
  aux_sym_case_clause_pattern_repeat1 = 258,
  aux_sym_use_assignments_repeat1 = 259,
  aux_sym_record_update_arguments_repeat1 = 260,
  aux_sym_arguments_repeat1 = 261,
  aux_sym_record_pattern_arguments_repeat1 = 262,
  aux_sym__pattern_bit_string_repeat1 = 263,
  aux_sym_pattern_bit_string_segment_options_repeat1 = 264,
  aux_sym_data_constructors_repeat1 = 265,
  aux_sym_data_constructor_arguments_repeat1 = 266,
  aux_sym_string_repeat1 = 267,
  aux_sym_tuple_type_repeat1 = 268,
  aux_sym_type_arguments_repeat1 = 269,
  aux_sym_type_parameters_repeat1 = 270,
  alias_sym_function_body = 271,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_module_comment] = "module_comment",
  [sym_statement_comment] = "statement_comment",
  [sym_comment] = "comment",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_erlang] = "erlang",
  [anon_sym_javascript] = "javascript",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_SLASH] = "/",
  [anon_sym_type] = "type",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_DASH] = "-",
  [anon_sym_size] = "size",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_external] = "external",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_DOT] = "<.",
  [anon_sym_LT_EQ_DOT] = "<=.",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT_DOT] = ">.",
  [anon_sym_GT_EQ_DOT] = ">=.",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_PLUS] = "+",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_DOT] = "*.",
  [anon_sym_SLASH_DOT] = "/.",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_todo] = "todo",
  [anon_sym_panic] = "panic",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_case] = "case",
  [anon_sym_PIPE] = "|",
  [anon_sym_let] = "let",
  [anon_sym_assert] = "assert",
  [anon_sym_use] = "use",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_BANG] = "!",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_opacity_modifier] = "opacity_modifier",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [aux_sym_escape_sequence_token2] = "escape_sequence_token2",
  [sym_float] = "float",
  [sym__hex] = "_hex",
  [sym__decimal] = "_decimal",
  [sym__octal] = "_octal",
  [sym__binary] = "_binary",
  [anon_sym_binary] = "binary",
  [anon_sym_bytes] = "bytes",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bit_string] = "bit_string",
  [anon_sym_bits] = "bits",
  [anon_sym_utf8] = "utf8",
  [anon_sym_utf16] = "utf16",
  [anon_sym_utf32] = "utf32",
  [anon_sym_utf8_codepoint] = "utf8_codepoint",
  [anon_sym_utf16_codepoint] = "utf16_codepoint",
  [anon_sym_utf32_codepoint] = "utf32_codepoint",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_big] = "big",
  [anon_sym_little] = "little",
  [anon_sym_native] = "native",
  [anon_sym_unit] = "unit",
  [sym__discard_name] = "_discard_name",
  [sym__name] = "_name",
  [sym__upname] = "_upname",
  [sym_quoted_content] = "quoted_content",
  [sym_source_file] = "source_file",
  [sym__module_statement] = "_module_statement",
  [sym_target_group] = "target_group",
  [sym_target] = "target",
  [sym_attribute] = "attribute",
  [sym__attribute_arguments] = "arguments",
  [sym_attribute_value] = "attribute_value",
  [sym_import] = "import",
  [sym_module] = "module",
  [sym_unqualified_imports] = "unqualified_imports",
  [sym_unqualified_import] = "unqualified_import",
  [sym_constant] = "constant",
  [sym__constant_value] = "_constant_value",
  [sym_constant_tuple] = "tuple",
  [sym_constant_list] = "list",
  [sym__constant_bit_string] = "bit_string",
  [sym_constant_bit_string_segment] = "bit_string_segment",
  [sym_constant_bit_string_segment_options] = "bit_string_segment_options",
  [sym__constant_bit_string_segment_option] = "_constant_bit_string_segment_option",
  [sym__constant_bit_string_named_segment_option] = "_constant_bit_string_named_segment_option",
  [sym__constant_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_constant_record] = "record",
  [sym_constant_record_arguments] = "arguments",
  [sym_constant_record_argument] = "argument",
  [sym_constant_field_access] = "field_access",
  [sym__constant_type] = "_constant_type",
  [sym__constant_type_annotation] = "_constant_type_annotation",
  [sym_constant_tuple_type] = "tuple_type",
  [sym_constant_function_type] = "function_type",
  [sym_constant_function_parameter_types] = "function_parameter_types",
  [sym_constant_type] = "type",
  [sym_constant_type_arguments] = "type_arguments",
  [sym_constant_type_argument] = "type_argument",
  [sym_external_type] = "external_type",
  [sym_external_function] = "external_function",
  [sym_external_function_parameters] = "function_parameters",
  [sym_external_function_parameter] = "function_parameter",
  [sym_external_function_body] = "external_function_body",
  [sym_function] = "function",
  [sym_function_parameters] = "function_parameters",
  [sym_function_parameter] = "function_parameter",
  [sym__labeled_discard_param] = "_labeled_discard_param",
  [sym__discard_param] = "_discard_param",
  [sym__labeled_name_param] = "_labeled_name_param",
  [sym__name_param] = "_name_param",
  [aux_sym__statement_seq] = "_statement_seq",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expression_unit] = "_expression_unit",
  [sym_record] = "record",
  [sym_todo] = "todo",
  [sym_panic] = "panic",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym__expression_bit_string] = "bit_string",
  [sym_expression_bit_string_segment] = "bit_string_segment",
  [sym_expression_bit_string_segment_options] = "bit_string_segment_options",
  [sym__expression_bit_string_segment_option] = "_expression_bit_string_segment_option",
  [sym__expression_bit_string_named_segment_option] = "_expression_bit_string_named_segment_option",
  [sym__expression_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_anonymous_function] = "anonymous_function",
  [sym_anonymous_function_parameters] = "function_parameters",
  [sym_anonymous_function_parameter] = "function_parameter",
  [sym_block] = "block",
  [sym_case] = "case",
  [sym_case_subjects] = "case_subjects",
  [sym_case_clauses] = "case_clauses",
  [sym_case_clause] = "case_clause",
  [sym_case_clause_patterns] = "case_clause_patterns",
  [sym_case_clause_pattern] = "case_clause_pattern",
  [sym_case_clause_guard] = "case_clause_guard",
  [sym__case_clause_guard_expression] = "_case_clause_guard_expression",
  [sym__case_clause_guard_binary_expression] = "binary_expression",
  [sym__case_clause_guard_unit] = "_case_clause_guard_unit",
  [sym__case_clause_tuple_access] = "tuple_access",
  [sym_let_assert] = "let_assert",
  [sym_let] = "let",
  [sym_use] = "use",
  [sym_use_assignments] = "use_assignments",
  [sym_use_assignment] = "use_assignment",
  [sym_assert] = "assert",
  [sym_boolean_negation] = "boolean_negation",
  [sym_integer_negation] = "integer_negation",
  [sym__assignment] = "_assignment",
  [sym_record_update] = "record_update",
  [sym_record_update_arguments] = "record_update_arguments",
  [sym_record_update_argument] = "record_update_argument",
  [sym__maybe_tuple_expression] = "_maybe_tuple_expression",
  [sym_tuple_access] = "tuple_access",
  [sym__maybe_record_expression] = "_maybe_record_expression",
  [sym_field_access] = "field_access",
  [sym__maybe_function_expression] = "_maybe_function_expression",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_hole] = "hole",
  [sym_function_call] = "function_call",
  [sym__pattern_expression] = "_pattern_expression",
  [sym__pattern_binary_expression] = "binary_expression",
  [sym__pattern] = "_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_record_pattern_arguments] = "record_pattern_arguments",
  [sym_record_pattern_argument] = "record_pattern_argument",
  [sym_pattern_spread] = "pattern_spread",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__pattern_bit_string] = "bit_string_pattern",
  [sym_pattern_bit_string_segment] = "bit_string_segment",
  [sym_pattern_bit_string_segment_options] = "bit_string_segment_options",
  [sym__pattern_bit_string_segment_option] = "_pattern_bit_string_segment_option",
  [sym__pattern_bit_string_named_segment_option] = "_pattern_bit_string_named_segment_option",
  [sym__pattern_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym__pattern_bit_string_segment_argument] = "_pattern_bit_string_segment_argument",
  [sym_list_pattern] = "list_pattern",
  [sym_list_pattern_tail] = "list_pattern_tail",
  [sym_type_definition] = "type_definition",
  [sym_data_constructors] = "data_constructors",
  [sym_data_constructor] = "data_constructor",
  [sym_data_constructor_arguments] = "data_constructor_arguments",
  [sym_data_constructor_argument] = "data_constructor_argument",
  [sym_type_alias] = "type_alias",
  [sym_string] = "string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_integer] = "integer",
  [sym__bit_string_segment_option] = "bit_string_segment_option",
  [sym__type] = "_type",
  [sym__type_annotation] = "_type_annotation",
  [sym_type_hole] = "type_hole",
  [sym_tuple_type] = "tuple_type",
  [sym_function_type] = "function_type",
  [sym_function_parameter_types] = "function_parameter_types",
  [sym_type] = "type",
  [sym_type_arguments] = "type_arguments",
  [sym_type_argument] = "type_argument",
  [sym_type_var] = "type_var",
  [sym_type_name] = "type_name",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_identifier] = "identifier",
  [sym_label] = "label",
  [sym_discard] = "discard",
  [sym_type_identifier] = "type_identifier",
  [sym_remote_type_identifier] = "remote_type_identifier",
  [sym_constructor_name] = "constructor_name",
  [sym_remote_constructor_name] = "remote_constructor_name",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_target_group_repeat1] = "target_group_repeat1",
  [aux_sym__attribute_arguments_repeat1] = "_attribute_arguments_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_unqualified_imports_repeat1] = "unqualified_imports_repeat1",
  [aux_sym_constant_tuple_repeat1] = "constant_tuple_repeat1",
  [aux_sym__constant_bit_string_repeat1] = "_constant_bit_string_repeat1",
  [aux_sym_constant_bit_string_segment_options_repeat1] = "constant_bit_string_segment_options_repeat1",
  [aux_sym_constant_record_arguments_repeat1] = "constant_record_arguments_repeat1",
  [aux_sym_constant_tuple_type_repeat1] = "constant_tuple_type_repeat1",
  [aux_sym_constant_type_arguments_repeat1] = "constant_type_arguments_repeat1",
  [aux_sym_external_function_parameters_repeat1] = "external_function_parameters_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym__expression_bit_string_repeat1] = "_expression_bit_string_repeat1",
  [aux_sym_expression_bit_string_segment_options_repeat1] = "expression_bit_string_segment_options_repeat1",
  [aux_sym_anonymous_function_parameters_repeat1] = "anonymous_function_parameters_repeat1",
  [aux_sym_case_clauses_repeat1] = "case_clauses_repeat1",
  [aux_sym_case_clause_patterns_repeat1] = "case_clause_patterns_repeat1",
  [aux_sym_case_clause_pattern_repeat1] = "case_clause_pattern_repeat1",
  [aux_sym_use_assignments_repeat1] = "use_assignments_repeat1",
  [aux_sym_record_update_arguments_repeat1] = "record_update_arguments_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_record_pattern_arguments_repeat1] = "record_pattern_arguments_repeat1",
  [aux_sym__pattern_bit_string_repeat1] = "_pattern_bit_string_repeat1",
  [aux_sym_pattern_bit_string_segment_options_repeat1] = "pattern_bit_string_segment_options_repeat1",
  [aux_sym_data_constructors_repeat1] = "data_constructors_repeat1",
  [aux_sym_data_constructor_arguments_repeat1] = "data_constructor_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [alias_sym_function_body] = "function_body",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_module_comment] = sym_module_comment,
  [sym_statement_comment] = sym_statement_comment,
  [sym_comment] = sym_comment,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_erlang] = anon_sym_erlang,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_size] = anon_sym_size,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_DOT] = anon_sym_LT_DOT,
  [anon_sym_LT_EQ_DOT] = anon_sym_LT_EQ_DOT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT_DOT] = anon_sym_GT_DOT,
  [anon_sym_GT_EQ_DOT] = anon_sym_GT_EQ_DOT,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_DOT] = anon_sym_STAR_DOT,
  [anon_sym_SLASH_DOT] = anon_sym_SLASH_DOT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_todo] = anon_sym_todo,
  [anon_sym_panic] = anon_sym_panic,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_opacity_modifier] = sym_opacity_modifier,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [aux_sym_escape_sequence_token2] = aux_sym_escape_sequence_token2,
  [sym_float] = sym_float,
  [sym__hex] = sym__hex,
  [sym__decimal] = sym__decimal,
  [sym__octal] = sym__octal,
  [sym__binary] = sym__binary,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bit_string] = anon_sym_bit_string,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_utf8] = anon_sym_utf8,
  [anon_sym_utf16] = anon_sym_utf16,
  [anon_sym_utf32] = anon_sym_utf32,
  [anon_sym_utf8_codepoint] = anon_sym_utf8_codepoint,
  [anon_sym_utf16_codepoint] = anon_sym_utf16_codepoint,
  [anon_sym_utf32_codepoint] = anon_sym_utf32_codepoint,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_big] = anon_sym_big,
  [anon_sym_little] = anon_sym_little,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_unit] = anon_sym_unit,
  [sym__discard_name] = sym__discard_name,
  [sym__name] = sym__name,
  [sym__upname] = sym__upname,
  [sym_quoted_content] = sym_quoted_content,
  [sym_source_file] = sym_source_file,
  [sym__module_statement] = sym__module_statement,
  [sym_target_group] = sym_target_group,
  [sym_target] = sym_target,
  [sym_attribute] = sym_attribute,
  [sym__attribute_arguments] = sym_arguments,
  [sym_attribute_value] = sym_attribute_value,
  [sym_import] = sym_import,
  [sym_module] = sym_module,
  [sym_unqualified_imports] = sym_unqualified_imports,
  [sym_unqualified_import] = sym_unqualified_import,
  [sym_constant] = sym_constant,
  [sym__constant_value] = sym__constant_value,
  [sym_constant_tuple] = sym_tuple,
  [sym_constant_list] = sym_list,
  [sym__constant_bit_string] = sym__constant_bit_string,
  [sym_constant_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_constant_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__constant_bit_string_segment_option] = sym__constant_bit_string_segment_option,
  [sym__constant_bit_string_named_segment_option] = sym__constant_bit_string_named_segment_option,
  [sym__constant_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_constant_record] = sym_record,
  [sym_constant_record_arguments] = sym_arguments,
  [sym_constant_record_argument] = sym_argument,
  [sym_constant_field_access] = sym_field_access,
  [sym__constant_type] = sym__constant_type,
  [sym__constant_type_annotation] = sym__constant_type_annotation,
  [sym_constant_tuple_type] = sym_tuple_type,
  [sym_constant_function_type] = sym_function_type,
  [sym_constant_function_parameter_types] = sym_function_parameter_types,
  [sym_constant_type] = sym_type,
  [sym_constant_type_arguments] = sym_type_arguments,
  [sym_constant_type_argument] = sym_type_argument,
  [sym_external_type] = sym_external_type,
  [sym_external_function] = sym_external_function,
  [sym_external_function_parameters] = sym_function_parameters,
  [sym_external_function_parameter] = sym_function_parameter,
  [sym_external_function_body] = sym_external_function_body,
  [sym_function] = sym_function,
  [sym_function_parameters] = sym_function_parameters,
  [sym_function_parameter] = sym_function_parameter,
  [sym__labeled_discard_param] = sym__labeled_discard_param,
  [sym__discard_param] = sym__discard_param,
  [sym__labeled_name_param] = sym__labeled_name_param,
  [sym__name_param] = sym__name_param,
  [aux_sym__statement_seq] = aux_sym__statement_seq,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expression_unit] = sym__expression_unit,
  [sym_record] = sym_record,
  [sym_todo] = sym_todo,
  [sym_panic] = sym_panic,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym__expression_bit_string] = sym__constant_bit_string,
  [sym_expression_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_expression_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__expression_bit_string_segment_option] = sym__expression_bit_string_segment_option,
  [sym__expression_bit_string_named_segment_option] = sym__expression_bit_string_named_segment_option,
  [sym__expression_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_anonymous_function_parameters] = sym_function_parameters,
  [sym_anonymous_function_parameter] = sym_function_parameter,
  [sym_block] = sym_block,
  [sym_case] = sym_case,
  [sym_case_subjects] = sym_case_subjects,
  [sym_case_clauses] = sym_case_clauses,
  [sym_case_clause] = sym_case_clause,
  [sym_case_clause_patterns] = sym_case_clause_patterns,
  [sym_case_clause_pattern] = sym_case_clause_pattern,
  [sym_case_clause_guard] = sym_case_clause_guard,
  [sym__case_clause_guard_expression] = sym__case_clause_guard_expression,
  [sym__case_clause_guard_binary_expression] = sym_binary_expression,
  [sym__case_clause_guard_unit] = sym__case_clause_guard_unit,
  [sym__case_clause_tuple_access] = sym_tuple_access,
  [sym_let_assert] = sym_let_assert,
  [sym_let] = sym_let,
  [sym_use] = sym_use,
  [sym_use_assignments] = sym_use_assignments,
  [sym_use_assignment] = sym_use_assignment,
  [sym_assert] = sym_assert,
  [sym_boolean_negation] = sym_boolean_negation,
  [sym_integer_negation] = sym_integer_negation,
  [sym__assignment] = sym__assignment,
  [sym_record_update] = sym_record_update,
  [sym_record_update_arguments] = sym_record_update_arguments,
  [sym_record_update_argument] = sym_record_update_argument,
  [sym__maybe_tuple_expression] = sym__maybe_tuple_expression,
  [sym_tuple_access] = sym_tuple_access,
  [sym__maybe_record_expression] = sym__maybe_record_expression,
  [sym_field_access] = sym_field_access,
  [sym__maybe_function_expression] = sym__maybe_function_expression,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_hole] = sym_hole,
  [sym_function_call] = sym_function_call,
  [sym__pattern_expression] = sym__pattern_expression,
  [sym__pattern_binary_expression] = sym_binary_expression,
  [sym__pattern] = sym__pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_record_pattern_arguments] = sym_record_pattern_arguments,
  [sym_record_pattern_argument] = sym_record_pattern_argument,
  [sym_pattern_spread] = sym_pattern_spread,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__pattern_bit_string] = sym__pattern_bit_string,
  [sym_pattern_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_pattern_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__pattern_bit_string_segment_option] = sym__pattern_bit_string_segment_option,
  [sym__pattern_bit_string_named_segment_option] = sym__pattern_bit_string_named_segment_option,
  [sym__pattern_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym__pattern_bit_string_segment_argument] = sym__pattern_bit_string_segment_argument,
  [sym_list_pattern] = sym_list_pattern,
  [sym_list_pattern_tail] = sym_list_pattern_tail,
  [sym_type_definition] = sym_type_definition,
  [sym_data_constructors] = sym_data_constructors,
  [sym_data_constructor] = sym_data_constructor,
  [sym_data_constructor_arguments] = sym_data_constructor_arguments,
  [sym_data_constructor_argument] = sym_data_constructor_argument,
  [sym_type_alias] = sym_type_alias,
  [sym_string] = sym_string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_integer] = sym_integer,
  [sym__bit_string_segment_option] = sym__constant_bit_string_segment_option_size,
  [sym__type] = sym__type,
  [sym__type_annotation] = sym__type_annotation,
  [sym_type_hole] = sym_type_hole,
  [sym_tuple_type] = sym_tuple_type,
  [sym_function_type] = sym_function_type,
  [sym_function_parameter_types] = sym_function_parameter_types,
  [sym_type] = sym_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_type_argument] = sym_type_argument,
  [sym_type_var] = sym_type_var,
  [sym_type_name] = sym_type_name,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_identifier] = sym_identifier,
  [sym_label] = sym_label,
  [sym_discard] = sym_discard,
  [sym_type_identifier] = sym_type_identifier,
  [sym_remote_type_identifier] = sym_remote_type_identifier,
  [sym_constructor_name] = sym_constructor_name,
  [sym_remote_constructor_name] = sym_remote_constructor_name,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_target_group_repeat1] = aux_sym_target_group_repeat1,
  [aux_sym__attribute_arguments_repeat1] = aux_sym__attribute_arguments_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_unqualified_imports_repeat1] = aux_sym_unqualified_imports_repeat1,
  [aux_sym_constant_tuple_repeat1] = aux_sym_constant_tuple_repeat1,
  [aux_sym__constant_bit_string_repeat1] = aux_sym__constant_bit_string_repeat1,
  [aux_sym_constant_bit_string_segment_options_repeat1] = aux_sym_constant_bit_string_segment_options_repeat1,
  [aux_sym_constant_record_arguments_repeat1] = aux_sym_constant_record_arguments_repeat1,
  [aux_sym_constant_tuple_type_repeat1] = aux_sym_constant_tuple_type_repeat1,
  [aux_sym_constant_type_arguments_repeat1] = aux_sym_constant_type_arguments_repeat1,
  [aux_sym_external_function_parameters_repeat1] = aux_sym_external_function_parameters_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym__expression_bit_string_repeat1] = aux_sym__expression_bit_string_repeat1,
  [aux_sym_expression_bit_string_segment_options_repeat1] = aux_sym_expression_bit_string_segment_options_repeat1,
  [aux_sym_anonymous_function_parameters_repeat1] = aux_sym_anonymous_function_parameters_repeat1,
  [aux_sym_case_clauses_repeat1] = aux_sym_case_clauses_repeat1,
  [aux_sym_case_clause_patterns_repeat1] = aux_sym_case_clause_patterns_repeat1,
  [aux_sym_case_clause_pattern_repeat1] = aux_sym_case_clause_pattern_repeat1,
  [aux_sym_use_assignments_repeat1] = aux_sym_use_assignments_repeat1,
  [aux_sym_record_update_arguments_repeat1] = aux_sym_record_update_arguments_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_record_pattern_arguments_repeat1] = aux_sym_record_pattern_arguments_repeat1,
  [aux_sym__pattern_bit_string_repeat1] = aux_sym__pattern_bit_string_repeat1,
  [aux_sym_pattern_bit_string_segment_options_repeat1] = aux_sym_pattern_bit_string_segment_options_repeat1,
  [aux_sym_data_constructors_repeat1] = aux_sym_data_constructors_repeat1,
  [aux_sym_data_constructor_arguments_repeat1] = aux_sym_data_constructor_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [alias_sym_function_body] = alias_sym_function_body,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_module_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_erlang] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_size] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_todo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_panic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_opacity_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_sequence_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex] = {
    .visible = false,
    .named = true,
  },
  [sym__decimal] = {
    .visible = false,
    .named = true,
  },
  [sym__octal] = {
    .visible = false,
    .named = true,
  },
  [sym__binary] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_big] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_little] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unit] = {
    .visible = true,
    .named = false,
  },
  [sym__discard_name] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym__upname] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__module_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_target_group] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_import] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_value] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_list] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_type] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_external_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_name_param] = {
    .visible = false,
    .named = true,
  },
  [sym__name_param] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statement_seq] = {
    .visible = false,
    .named = false,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_unit] = {
    .visible = false,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym_todo] = {
    .visible = true,
    .named = true,
  },
  [sym_panic] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_subjects] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_guard] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_guard_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym_let_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_use] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_negation] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_record_update] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_tuple_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_record_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__bit_string_segment_option] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_type_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_var] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_target_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unqualified_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constant_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_record_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_external_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_update_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructor_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_function_body] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_arguments = 2,
  field_assign = 3,
  field_assignments = 4,
  field_body = 5,
  field_clauses = 6,
  field_constructor = 7,
  field_field = 8,
  field_function = 9,
  field_guard = 10,
  field_imports = 11,
  field_index = 12,
  field_label = 13,
  field_left = 14,
  field_message = 15,
  field_module = 16,
  field_name = 17,
  field_operator = 18,
  field_options = 19,
  field_parameter_types = 20,
  field_parameters = 21,
  field_pattern = 22,
  field_patterns = 23,
  field_record = 24,
  field_return_type = 25,
  field_right = 26,
  field_spread = 27,
  field_subjects = 28,
  field_target = 29,
  field_tuple = 30,
  field_type = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arguments] = "arguments",
  [field_assign] = "assign",
  [field_assignments] = "assignments",
  [field_body] = "body",
  [field_clauses] = "clauses",
  [field_constructor] = "constructor",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_imports] = "imports",
  [field_index] = "index",
  [field_label] = "label",
  [field_left] = "left",
  [field_message] = "message",
  [field_module] = "module",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_options] = "options",
  [field_parameter_types] = "parameter_types",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_patterns] = "patterns",
  [field_record] = "record",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_spread] = "spread",
  [field_subjects] = "subjects",
  [field_target] = "target",
  [field_tuple] = "tuple",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 4},
  [5] = {.index = 7, .length = 3},
  [6] = {.index = 10, .length = 1},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 2},
  [9] = {.index = 15, .length = 2},
  [10] = {.index = 17, .length = 2},
  [11] = {.index = 19, .length = 1},
  [12] = {.index = 20, .length = 2},
  [13] = {.index = 22, .length = 1},
  [14] = {.index = 23, .length = 2},
  [15] = {.index = 25, .length = 4},
  [16] = {.index = 29, .length = 1},
  [17] = {.index = 30, .length = 2},
  [18] = {.index = 32, .length = 3},
  [19] = {.index = 35, .length = 2},
  [20] = {.index = 37, .length = 2},
  [21] = {.index = 39, .length = 2},
  [22] = {.index = 41, .length = 1},
  [23] = {.index = 42, .length = 2},
  [24] = {.index = 44, .length = 2},
  [25] = {.index = 46, .length = 1},
  [26] = {.index = 47, .length = 2},
  [27] = {.index = 49, .length = 3},
  [28] = {.index = 52, .length = 2},
  [29] = {.index = 54, .length = 2},
  [30] = {.index = 56, .length = 1},
  [31] = {.index = 57, .length = 1},
  [32] = {.index = 58, .length = 2},
  [33] = {.index = 60, .length = 3},
  [34] = {.index = 63, .length = 2},
  [35] = {.index = 65, .length = 2},
  [36] = {.index = 67, .length = 2},
  [37] = {.index = 69, .length = 3},
  [38] = {.index = 72, .length = 1},
  [39] = {.index = 73, .length = 2},
  [40] = {.index = 75, .length = 3},
  [41] = {.index = 78, .length = 2},
  [42] = {.index = 80, .length = 3},
  [43] = {.index = 83, .length = 1},
  [44] = {.index = 84, .length = 2},
  [45] = {.index = 86, .length = 2},
  [46] = {.index = 88, .length = 1},
  [47] = {.index = 89, .length = 2},
  [48] = {.index = 91, .length = 4},
  [49] = {.index = 95, .length = 4},
  [50] = {.index = 99, .length = 2},
  [51] = {.index = 101, .length = 2},
  [52] = {.index = 103, .length = 1},
  [53] = {.index = 104, .length = 3},
  [54] = {.index = 107, .length = 1},
  [55] = {.index = 108, .length = 1},
  [56] = {.index = 109, .length = 3},
  [57] = {.index = 112, .length = 2},
  [58] = {.index = 114, .length = 2},
  [59] = {.index = 116, .length = 2},
  [60] = {.index = 118, .length = 3},
  [61] = {.index = 121, .length = 3},
  [62] = {.index = 124, .length = 3},
  [63] = {.index = 127, .length = 2},
  [64] = {.index = 129, .length = 2},
  [65] = {.index = 131, .length = 1},
  [66] = {.index = 132, .length = 3},
  [67] = {.index = 135, .length = 2},
  [68] = {.index = 137, .length = 3},
  [69] = {.index = 140, .length = 3},
  [70] = {.index = 143, .length = 3},
  [71] = {.index = 146, .length = 2},
  [72] = {.index = 148, .length = 4},
  [73] = {.index = 152, .length = 4},
  [74] = {.index = 152, .length = 4},
  [75] = {.index = 156, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_module, 1},
  [2] =
    {field_value, 0},
  [3] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [7] =
    {field_left, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [10] =
    {field_assign, 0, .inherited = true},
  [11] =
    {field_arguments, 1},
    {field_function, 0},
  [13] =
    {field_arguments, 1},
    {field_name, 0},
  [15] =
    {field_arguments, 2},
    {field_name, 1},
  [17] =
    {field_name, 0},
    {field_parameters, 1},
  [19] =
    {field_name, 0, .inherited = true},
  [20] =
    {field_name, 1},
    {field_parameters, 2},
  [22] =
    {field_message, 2},
  [23] =
    {field_assign, 0, .inherited = true},
    {field_value, 0},
  [25] =
    {field_assign, 2, .inherited = true},
    {field_pattern, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [29] =
    {field_value, 2},
  [30] =
    {field_assign, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [32] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [35] =
    {field_index, 2},
    {field_tuple, 0},
  [37] =
    {field_field, 2},
    {field_record, 0},
  [39] =
    {field_module, 0},
    {field_name, 2},
  [41] =
    {field_target, 1},
  [42] =
    {field_imports, 3},
    {field_module, 1},
  [44] =
    {field_alias, 3},
    {field_module, 1},
  [46] =
    {field_type, 1},
  [47] =
    {field_name, 1},
    {field_value, 3},
  [49] =
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [52] =
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [54] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [56] =
    {field_subjects, 1},
  [57] =
    {field_assign, 1, .inherited = true},
  [58] =
    {field_assign, 1},
    {field_assign, 2},
  [60] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_value, 2},
  [63] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
  [65] =
    {field_assignments, 1},
    {field_value, 3},
  [67] =
    {field_name, 2},
    {field_parameters, 3},
  [69] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [72] =
    {field_spread, 3},
  [73] =
    {field_body, 3},
    {field_parameters, 1},
  [75] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [78] =
    {field_label, 0},
    {field_name, 1},
  [80] =
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [83] =
    {field_type, 0},
  [84] =
    {field_clauses, 3},
    {field_subjects, 1},
  [86] =
    {field_assign, 0, .inherited = true},
    {field_assign, 1, .inherited = true},
  [88] =
    {field_assign, 2, .inherited = true},
  [89] =
    {field_assign, 1, .inherited = true},
    {field_assign, 2, .inherited = true},
  [91] =
    {field_assign, 0, .inherited = true},
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [95] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_type, 1, .inherited = true},
    {field_value, 3},
  [99] =
    {field_name, 2},
    {field_value, 4},
  [101] =
    {field_label, 0},
    {field_value, 2},
  [103] =
    {field_name, 1},
  [104] =
    {field_alias, 5},
    {field_imports, 3},
    {field_module, 1},
  [107] =
    {field_return_type, 2},
  [108] =
    {field_spread, 4},
  [109] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [112] =
    {field_index, 0, .inherited = true},
    {field_tuple, 0, .inherited = true},
  [114] =
    {field_patterns, 0},
    {field_value, 2},
  [116] =
    {field_assign, 2, .inherited = true},
    {field_assign, 3, .inherited = true},
  [118] =
    {field_assign, 2, .inherited = true},
    {field_label, 0},
    {field_pattern, 2},
  [121] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 5},
  [124] =
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [127] =
    {field_alias, 2},
    {field_name, 0},
  [129] =
    {field_parameter_types, 1},
    {field_return_type, 3},
  [131] =
    {field_spread, 5},
  [132] =
    {field_body, 5},
    {field_parameters, 1},
    {field_return_type, 3},
  [135] =
    {field_name, 0},
    {field_type, 2},
  [137] =
    {field_guard, 1},
    {field_patterns, 0},
    {field_value, 3},
  [140] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [143] =
    {field_arguments, 5},
    {field_constructor, 0},
    {field_spread, 3},
  [146] =
    {field_alias, 3},
    {field_name, 1},
  [148] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [152] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [156] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [39] = {
    [3] = alias_sym_function_body,
  },
  [56] = {
    [4] = alias_sym_function_body,
  },
  [66] = {
    [5] = alias_sym_function_body,
  },
  [69] = {
    [5] = alias_sym_function_body,
  },
  [72] = {
    [6] = alias_sym_function_body,
  },
  [74] = {
    [7] = alias_sym_function_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__statement_seq, 2,
    aux_sym__statement_seq,
    alias_sym_function_body,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(168)
      if (lookahead == '\r') SKIP(168)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '\\') ADVANCE(126);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(423);
      if (lookahead == 'b') ADVANCE(370);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'e') ADVANCE(416);
      if (lookahead == 'f') ADVANCE(381);
      if (lookahead == 'i') ADVANCE(361);
      if (lookahead == 'j') ADVANCE(320);
      if (lookahead == 'l') ADVANCE(353);
      if (lookahead == 'n') ADVANCE(330);
      if (lookahead == 'o') ADVANCE(409);
      if (lookahead == 'p') ADVANCE(324);
      if (lookahead == 's') ADVANCE(371);
      if (lookahead == 't') ADVANCE(397);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(253);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 1:
      if (lookahead == '&') ADVANCE(226);
      END_STATE();
    case 2:
      if (lookahead == '-') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(269);
      END_STATE();
    case 3:
      if (lookahead == '-') ADVANCE(257);
      if (lookahead == '<') ADVANCE(209);
      END_STATE();
    case 4:
      if (lookahead == '-') ADVANCE(257);
      if (lookahead == '>') ADVANCE(247);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(250);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(177);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(10);
      if (lookahead == '3') ADVANCE(9);
      if (lookahead == '8') ADVANCE(289);
      END_STATE();
    case 9:
      if (lookahead == '2') ADVANCE(293);
      END_STATE();
    case 10:
      if (lookahead == '6') ADVANCE(291);
      END_STATE();
    case 11:
      if (lookahead == '<') ADVANCE(209);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(228);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(227);
      END_STATE();
    case 14:
      if (lookahead == '>') ADVANCE(222);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(210);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(239);
      if (lookahead == '|') ADVANCE(225);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(110);
      if (lookahead == 's') ADVANCE(287);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(99);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(66);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(115);
      END_STATE();
    case 26:
      if (lookahead == 'b') ADVANCE(260);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(85);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(104);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(90);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(301);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(303);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(307);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(309);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 48:
      if (lookahead == 'f') ADVANCE(8);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(179);
      if (lookahead == 'm') ADVANCE(92);
      END_STATE();
    case 50:
      if (lookahead == 'g') ADVANCE(305);
      if (lookahead == 'n') ADVANCE(20);
      if (lookahead == 't') ADVANCE(17);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(183);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(285);
      END_STATE();
    case 53:
      if (lookahead == 'g') ADVANCE(77);
      if (lookahead == 'z') ADVANCE(36);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(79);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'y') ADVANCE(111);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(96);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(113);
      if (lookahead == 's') ADVANCE(57);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(80);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(223);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(86);
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 70:
      if (lookahead == 'm') ADVANCE(92);
      END_STATE();
    case 71:
      if (lookahead == 'm') ADVANCE(92);
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 83:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 90:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 92:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(19);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 95:
      if (lookahead == 'p') ADVANCE(87);
      END_STATE();
    case 96:
      if (lookahead == 'p') ADVANCE(117);
      END_STATE();
    case 97:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 98:
      if (lookahead == 'p') ADVANCE(89);
      END_STATE();
    case 99:
      if (lookahead == 'q') ADVANCE(128);
      END_STATE();
    case 100:
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 'x') ADVANCE(122);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(196);
      END_STATE();
    case 107:
      if (lookahead == 's') ADVANCE(279);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(28);
      END_STATE();
    case 109:
      if (lookahead == 's') ADVANCE(114);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(311);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(283);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(192);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(185);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(295);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(297);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(299);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 126:
      if (lookahead == 'u') ADVANCE(134);
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(266);
      END_STATE();
    case 127:
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 129:
      if (lookahead == 'v') ADVANCE(23);
      END_STATE();
    case 130:
      if (lookahead == 'v') ADVANCE(40);
      END_STATE();
    case 131:
      if (lookahead == 'x') ADVANCE(122);
      END_STATE();
    case 132:
      if (lookahead == 'y') ADVANCE(277);
      END_STATE();
    case 133:
      if (lookahead == 'y') ADVANCE(94);
      END_STATE();
    case 134:
      if (lookahead == '{') ADVANCE(166);
      END_STATE();
    case 135:
      if (lookahead == '}') ADVANCE(267);
      END_STATE();
    case 136:
      if (lookahead == '}') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(135);
      END_STATE();
    case 137:
      if (lookahead == '}') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 138:
      if (lookahead == '}') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 139:
      if (lookahead == '}') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(138);
      END_STATE();
    case 140:
      if (lookahead == '}') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(139);
      END_STATE();
    case 141:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(141)
      if (lookahead == '\r') SKIP(141)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'a') ADVANCE(432);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(424);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(142)
      if (lookahead == '\r') SKIP(142)
      if (lookahead == '!') ADVANCE(258);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '=') ADVANCE(204);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(432);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == '{') ADVANCE(181);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(143)
      if (lookahead == '\r') SKIP(143)
      if (lookahead == '!') ADVANCE(258);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'a') ADVANCE(432);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == '{') ADVANCE(181);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(144)
      if (lookahead == '\r') SKIP(144)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(234);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'a') ADVANCE(423);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(424);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(146)
      if (lookahead == '\r') SKIP(146)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(212);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(273);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '\\') ADVANCE(126);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'c') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'f') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(93);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 's') ADVANCE(56);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == 'u') ADVANCE(73);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(274);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(146)
      if (lookahead == '\r') SKIP(146)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(212);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(273);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'c') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'f') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(93);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 's') ADVANCE(56);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == 'u') ADVANCE(73);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(274);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(147)
      if (lookahead == '\r') SKIP(147)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(212);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'c') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(72);
      if (lookahead == 'i') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(93);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(148)
      if (lookahead == '\r') SKIP(148)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 149:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(149)
      if (lookahead == '\r') SKIP(149)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(234);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(150)
      if (lookahead == '\r') SKIP(150)
      if (lookahead == '!') ADVANCE(258);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == '{') ADVANCE(181);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 151:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(151)
      if (lookahead == '\r') SKIP(151)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(194);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(234);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'c') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(72);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(93);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(253);
      if (lookahead == '}') ADVANCE(182);
      END_STATE();
    case 152:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(152)
      if (lookahead == '\r') SKIP(152)
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'i') ADVANCE(363);
      if (lookahead == '|') ADVANCE(252);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 153:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(153)
      if (lookahead == '\r') SKIP(153)
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(313);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 154:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(154)
      if (lookahead == '\r') SKIP(154)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(194);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'c') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(72);
      if (lookahead == 'i') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(93);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      END_STATE();
    case 155:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(155)
      if (lookahead == '\r') SKIP(155)
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(432);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 156:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(156)
      if (lookahead == '\r') SKIP(156)
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(211);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(204);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'c') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(72);
      if (lookahead == 'i') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(93);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '}') ADVANCE(182);
      END_STATE();
    case 157:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(157)
      if (lookahead == '\r') SKIP(157)
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(204);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'c') ADVANCE(83);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(72);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(93);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == '|') ADVANCE(252);
      if (lookahead == '}') ADVANCE(182);
      END_STATE();
    case 158:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(158)
      if (lookahead == '\r') SKIP(158)
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '_') ADVANCE(314);
      if (lookahead == 'f') ADVANCE(385);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 159:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(159)
      if (lookahead == '\r') SKIP(159)
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == '_') ADVANCE(314);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 160:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(160)
      if (lookahead == '\r') SKIP(160)
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '-') ADVANCE(211);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(273);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(274);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 161:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(161)
      if (lookahead == '\r') SKIP(161)
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == 't') ADVANCE(455);
      if (lookahead == '}') ADVANCE(182);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 162:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(162)
      if (lookahead == '\r') SKIP(162)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(194);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'a') ADVANCE(432);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(424);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 163:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(276);
      END_STATE();
    case 164:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(275);
      END_STATE();
    case 165:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(269);
      END_STATE();
    case 166:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(140);
      END_STATE();
    case 167:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(270);
      END_STATE();
    case 168:
      if (eof) ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(168)
      if (lookahead == '\r') SKIP(168)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == ')') ADVANCE(190);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == ',') ADVANCE(189);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == ']') ADVANCE(208);
      if (lookahead == '_') ADVANCE(313);
      if (lookahead == 'a') ADVANCE(423);
      if (lookahead == 'b') ADVANCE(370);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'e') ADVANCE(416);
      if (lookahead == 'f') ADVANCE(381);
      if (lookahead == 'i') ADVANCE(361);
      if (lookahead == 'j') ADVANCE(320);
      if (lookahead == 'l') ADVANCE(353);
      if (lookahead == 'n') ADVANCE(330);
      if (lookahead == 'o') ADVANCE(409);
      if (lookahead == 'p') ADVANCE(324);
      if (lookahead == 's') ADVANCE(371);
      if (lookahead == 't') ADVANCE(397);
      if (lookahead == 'u') ADVANCE(386);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(253);
      if (lookahead == '}') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 169:
      if (eof) ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(169)
      if (lookahead == '\r') SKIP(169)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(194);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(234);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'a') ADVANCE(432);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'e') ADVANCE(453);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'o') ADVANCE(409);
      if (lookahead == 'p') ADVANCE(324);
      if (lookahead == 't') ADVANCE(397);
      if (lookahead == 'u') ADVANCE(424);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 170:
      if (eof) ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(170)
      if (lookahead == '\r') SKIP(170)
      if (lookahead == '!') ADVANCE(258);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '=') ADVANCE(204);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'a') ADVANCE(432);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'e') ADVANCE(453);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'o') ADVANCE(409);
      if (lookahead == 'p') ADVANCE(324);
      if (lookahead == 't') ADVANCE(397);
      if (lookahead == 'u') ADVANCE(424);
      if (lookahead == '{') ADVANCE(181);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 171:
      if (eof) ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(171)
      if (lookahead == '\r') SKIP(171)
      if (lookahead == '!') ADVANCE(258);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'a') ADVANCE(432);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'e') ADVANCE(453);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'o') ADVANCE(409);
      if (lookahead == 'p') ADVANCE(324);
      if (lookahead == 't') ADVANCE(397);
      if (lookahead == 'u') ADVANCE(424);
      if (lookahead == '{') ADVANCE(181);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 172:
      if (eof) ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(172)
      if (lookahead == '\r') SKIP(172)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(264);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '%') ADVANCE(246);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(188);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '+') ADVANCE(240);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(194);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead == '0') ADVANCE(271);
      if (lookahead == '<') ADVANCE(229);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(234);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(207);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'a') ADVANCE(423);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'e') ADVANCE(453);
      if (lookahead == 'f') ADVANCE(385);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'o') ADVANCE(409);
      if (lookahead == 'p') ADVANCE(324);
      if (lookahead == 't') ADVANCE(397);
      if (lookahead == 'u') ADVANCE(424);
      if (lookahead == '{') ADVANCE(181);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(457);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(174);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(176);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(176);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_erlang);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_erlang);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_javascript);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(250);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(245);
      if (lookahead == '/') ADVANCE(177);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(227);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(242);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(242);
      if (lookahead == '>') ADVANCE(222);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(242);
      if (lookahead == '>') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_size);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_size);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_external);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(232);
      if (lookahead == '<') ADVANCE(209);
      if (lookahead == '=') ADVANCE(231);
      if (lookahead == '>') ADVANCE(247);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(232);
      if (lookahead == '=') ADVANCE(231);
      if (lookahead == '>') ADVANCE(247);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '.') ADVANCE(233);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LT_DOT);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_LT_EQ_DOT);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(237);
      if (lookahead == '=') ADVANCE(236);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(237);
      if (lookahead == '=') ADVANCE(236);
      if (lookahead == '>') ADVANCE(210);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (lookahead == '.') ADVANCE(238);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_GT_DOT);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_GT_EQ_DOT);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(241);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(244);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_STAR_DOT);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_SLASH_DOT);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_todo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_panic);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(239);
      if (lookahead == '|') ADVANCE(225);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_use);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(228);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_visibility_modifier);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_visibility_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_opacity_modifier);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_opacity_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'e') ADVANCE(2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(268);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(269);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym__hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(270);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(268);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(163);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(164);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(163);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(164);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(274);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym__decimal);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(274);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym__octal);
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(275);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym__binary);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(276);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_binary);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_bit_string);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_bit_string);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_bits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(29);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(30);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_signed);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_big);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_big);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_little);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_little);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_native);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_unit);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_unit);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym__discard_name);
      if (lookahead == '.') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(313);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(314);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym__discard_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(314);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '.') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(315);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '1') ADVANCE(318);
      if (lookahead == '3') ADVANCE(317);
      if (lookahead == '8') ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '2') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '6') ADVANCE(292);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '_') ADVANCE(431);
      if (lookahead == 's') ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(451);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(429);
      if (lookahead == 'o') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(429);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(389);
      if (lookahead == 'u') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(417);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(428);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(437);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'b') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(420);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(360);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(308);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(434);
      if (lookahead == 'i') ADVANCE(449);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(425);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(410);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(180);
      if (lookahead == 'm') ADVANCE(408);
      if (lookahead == 'n') ADVANCE(433);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(180);
      if (lookahead == 'm') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(306);
      if (lookahead == 'n') ADVANCE(326);
      if (lookahead == 't') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(286);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(392);
      if (lookahead == 'z') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(456);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(365);
      if (lookahead == 'y') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(452);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(435);
      if (lookahead == 's') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(402);
      if (lookahead == 'n') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(377);
      if (lookahead == 's') ADVANCE(344);
      if (lookahead == 't') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(430);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(441);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(442);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(443);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(340);
      if (lookahead == 'y') ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(343);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(403);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(440);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'q') ADVANCE(450);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(383);
      if (lookahead == 'x') ADVANCE(448);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(454);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(438);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(439);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(436);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(447);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(427);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(418);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(329);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'x') ADVANCE(448);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym__name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(456);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym__upname);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 169},
  [2] = {.lex_state = 169},
  [3] = {.lex_state = 169},
  [4] = {.lex_state = 169},
  [5] = {.lex_state = 169},
  [6] = {.lex_state = 169},
  [7] = {.lex_state = 169},
  [8] = {.lex_state = 141},
  [9] = {.lex_state = 169},
  [10] = {.lex_state = 141},
  [11] = {.lex_state = 141},
  [12] = {.lex_state = 141},
  [13] = {.lex_state = 169},
  [14] = {.lex_state = 169},
  [15] = {.lex_state = 141},
  [16] = {.lex_state = 169},
  [17] = {.lex_state = 172},
  [18] = {.lex_state = 141},
  [19] = {.lex_state = 141},
  [20] = {.lex_state = 141},
  [21] = {.lex_state = 141},
  [22] = {.lex_state = 141},
  [23] = {.lex_state = 141},
  [24] = {.lex_state = 141},
  [25] = {.lex_state = 169},
  [26] = {.lex_state = 141},
  [27] = {.lex_state = 169},
  [28] = {.lex_state = 169},
  [29] = {.lex_state = 169},
  [30] = {.lex_state = 141},
  [31] = {.lex_state = 169},
  [32] = {.lex_state = 141},
  [33] = {.lex_state = 141},
  [34] = {.lex_state = 141},
  [35] = {.lex_state = 141},
  [36] = {.lex_state = 169},
  [37] = {.lex_state = 169},
  [38] = {.lex_state = 141},
  [39] = {.lex_state = 141},
  [40] = {.lex_state = 169},
  [41] = {.lex_state = 141},
  [42] = {.lex_state = 141},
  [43] = {.lex_state = 141},
  [44] = {.lex_state = 141},
  [45] = {.lex_state = 169},
  [46] = {.lex_state = 141},
  [47] = {.lex_state = 169},
  [48] = {.lex_state = 141},
  [49] = {.lex_state = 141},
  [50] = {.lex_state = 169},
  [51] = {.lex_state = 141},
  [52] = {.lex_state = 141},
  [53] = {.lex_state = 141},
  [54] = {.lex_state = 141},
  [55] = {.lex_state = 169},
  [56] = {.lex_state = 141},
  [57] = {.lex_state = 169},
  [58] = {.lex_state = 141},
  [59] = {.lex_state = 169},
  [60] = {.lex_state = 141},
  [61] = {.lex_state = 169},
  [62] = {.lex_state = 141},
  [63] = {.lex_state = 141},
  [64] = {.lex_state = 141},
  [65] = {.lex_state = 169},
  [66] = {.lex_state = 141},
  [67] = {.lex_state = 141},
  [68] = {.lex_state = 141},
  [69] = {.lex_state = 141},
  [70] = {.lex_state = 169},
  [71] = {.lex_state = 141},
  [72] = {.lex_state = 141},
  [73] = {.lex_state = 169},
  [74] = {.lex_state = 169},
  [75] = {.lex_state = 169},
  [76] = {.lex_state = 141},
  [77] = {.lex_state = 141},
  [78] = {.lex_state = 141},
  [79] = {.lex_state = 169},
  [80] = {.lex_state = 172},
  [81] = {.lex_state = 141},
  [82] = {.lex_state = 169},
  [83] = {.lex_state = 141},
  [84] = {.lex_state = 169},
  [85] = {.lex_state = 169},
  [86] = {.lex_state = 169},
  [87] = {.lex_state = 169},
  [88] = {.lex_state = 169},
  [89] = {.lex_state = 169},
  [90] = {.lex_state = 142},
  [91] = {.lex_state = 142},
  [92] = {.lex_state = 169},
  [93] = {.lex_state = 169},
  [94] = {.lex_state = 169},
  [95] = {.lex_state = 169},
  [96] = {.lex_state = 169},
  [97] = {.lex_state = 169},
  [98] = {.lex_state = 169},
  [99] = {.lex_state = 169},
  [100] = {.lex_state = 169},
  [101] = {.lex_state = 169},
  [102] = {.lex_state = 169},
  [103] = {.lex_state = 169},
  [104] = {.lex_state = 169},
  [105] = {.lex_state = 169},
  [106] = {.lex_state = 169},
  [107] = {.lex_state = 169},
  [108] = {.lex_state = 142},
  [109] = {.lex_state = 169},
  [110] = {.lex_state = 169},
  [111] = {.lex_state = 169},
  [112] = {.lex_state = 142},
  [113] = {.lex_state = 169},
  [114] = {.lex_state = 169},
  [115] = {.lex_state = 169},
  [116] = {.lex_state = 169},
  [117] = {.lex_state = 169},
  [118] = {.lex_state = 142},
  [119] = {.lex_state = 169},
  [120] = {.lex_state = 169},
  [121] = {.lex_state = 169},
  [122] = {.lex_state = 169},
  [123] = {.lex_state = 142},
  [124] = {.lex_state = 142},
  [125] = {.lex_state = 142},
  [126] = {.lex_state = 142},
  [127] = {.lex_state = 142},
  [128] = {.lex_state = 162},
  [129] = {.lex_state = 162},
  [130] = {.lex_state = 142},
  [131] = {.lex_state = 142},
  [132] = {.lex_state = 142},
  [133] = {.lex_state = 142},
  [134] = {.lex_state = 142},
  [135] = {.lex_state = 142},
  [136] = {.lex_state = 162},
  [137] = {.lex_state = 142},
  [138] = {.lex_state = 142},
  [139] = {.lex_state = 142},
  [140] = {.lex_state = 162},
  [141] = {.lex_state = 142},
  [142] = {.lex_state = 162},
  [143] = {.lex_state = 142},
  [144] = {.lex_state = 162},
  [145] = {.lex_state = 162},
  [146] = {.lex_state = 162},
  [147] = {.lex_state = 162},
  [148] = {.lex_state = 162},
  [149] = {.lex_state = 162},
  [150] = {.lex_state = 162},
  [151] = {.lex_state = 162},
  [152] = {.lex_state = 162},
  [153] = {.lex_state = 162},
  [154] = {.lex_state = 162},
  [155] = {.lex_state = 162},
  [156] = {.lex_state = 162},
  [157] = {.lex_state = 162},
  [158] = {.lex_state = 162},
  [159] = {.lex_state = 162},
  [160] = {.lex_state = 162},
  [161] = {.lex_state = 142},
  [162] = {.lex_state = 143},
  [163] = {.lex_state = 143},
  [164] = {.lex_state = 143},
  [165] = {.lex_state = 162},
  [166] = {.lex_state = 143},
  [167] = {.lex_state = 143},
  [168] = {.lex_state = 162},
  [169] = {.lex_state = 162},
  [170] = {.lex_state = 143},
  [171] = {.lex_state = 143},
  [172] = {.lex_state = 162},
  [173] = {.lex_state = 162},
  [174] = {.lex_state = 162},
  [175] = {.lex_state = 143},
  [176] = {.lex_state = 143},
  [177] = {.lex_state = 162},
  [178] = {.lex_state = 143},
  [179] = {.lex_state = 162},
  [180] = {.lex_state = 162},
  [181] = {.lex_state = 143},
  [182] = {.lex_state = 162},
  [183] = {.lex_state = 143},
  [184] = {.lex_state = 162},
  [185] = {.lex_state = 143},
  [186] = {.lex_state = 143},
  [187] = {.lex_state = 143},
  [188] = {.lex_state = 143},
  [189] = {.lex_state = 143},
  [190] = {.lex_state = 143},
  [191] = {.lex_state = 143},
  [192] = {.lex_state = 143},
  [193] = {.lex_state = 143},
  [194] = {.lex_state = 143},
  [195] = {.lex_state = 143},
  [196] = {.lex_state = 143},
  [197] = {.lex_state = 162},
  [198] = {.lex_state = 162},
  [199] = {.lex_state = 143},
  [200] = {.lex_state = 143},
  [201] = {.lex_state = 143},
  [202] = {.lex_state = 162},
  [203] = {.lex_state = 162},
  [204] = {.lex_state = 143},
  [205] = {.lex_state = 143},
  [206] = {.lex_state = 143},
  [207] = {.lex_state = 143},
  [208] = {.lex_state = 162},
  [209] = {.lex_state = 162},
  [210] = {.lex_state = 162},
  [211] = {.lex_state = 162},
  [212] = {.lex_state = 162},
  [213] = {.lex_state = 162},
  [214] = {.lex_state = 162},
  [215] = {.lex_state = 162},
  [216] = {.lex_state = 143},
  [217] = {.lex_state = 143},
  [218] = {.lex_state = 162},
  [219] = {.lex_state = 143},
  [220] = {.lex_state = 143},
  [221] = {.lex_state = 143},
  [222] = {.lex_state = 143},
  [223] = {.lex_state = 143},
  [224] = {.lex_state = 143},
  [225] = {.lex_state = 143},
  [226] = {.lex_state = 143},
  [227] = {.lex_state = 143},
  [228] = {.lex_state = 143},
  [229] = {.lex_state = 143},
  [230] = {.lex_state = 143},
  [231] = {.lex_state = 143},
  [232] = {.lex_state = 143},
  [233] = {.lex_state = 143},
  [234] = {.lex_state = 143},
  [235] = {.lex_state = 143},
  [236] = {.lex_state = 143},
  [237] = {.lex_state = 143},
  [238] = {.lex_state = 143},
  [239] = {.lex_state = 143},
  [240] = {.lex_state = 143},
  [241] = {.lex_state = 143},
  [242] = {.lex_state = 143},
  [243] = {.lex_state = 143},
  [244] = {.lex_state = 143},
  [245] = {.lex_state = 143},
  [246] = {.lex_state = 143},
  [247] = {.lex_state = 143},
  [248] = {.lex_state = 143},
  [249] = {.lex_state = 143},
  [250] = {.lex_state = 143},
  [251] = {.lex_state = 143},
  [252] = {.lex_state = 143},
  [253] = {.lex_state = 143},
  [254] = {.lex_state = 144},
  [255] = {.lex_state = 143},
  [256] = {.lex_state = 143},
  [257] = {.lex_state = 143},
  [258] = {.lex_state = 143},
  [259] = {.lex_state = 143},
  [260] = {.lex_state = 143},
  [261] = {.lex_state = 143},
  [262] = {.lex_state = 143},
  [263] = {.lex_state = 143},
  [264] = {.lex_state = 143},
  [265] = {.lex_state = 143},
  [266] = {.lex_state = 143},
  [267] = {.lex_state = 143},
  [268] = {.lex_state = 143},
  [269] = {.lex_state = 143},
  [270] = {.lex_state = 143},
  [271] = {.lex_state = 143},
  [272] = {.lex_state = 143},
  [273] = {.lex_state = 143},
  [274] = {.lex_state = 143},
  [275] = {.lex_state = 143},
  [276] = {.lex_state = 143},
  [277] = {.lex_state = 143},
  [278] = {.lex_state = 143},
  [279] = {.lex_state = 143},
  [280] = {.lex_state = 143},
  [281] = {.lex_state = 143},
  [282] = {.lex_state = 143},
  [283] = {.lex_state = 143},
  [284] = {.lex_state = 143},
  [285] = {.lex_state = 143},
  [286] = {.lex_state = 143},
  [287] = {.lex_state = 143},
  [288] = {.lex_state = 143},
  [289] = {.lex_state = 143},
  [290] = {.lex_state = 143},
  [291] = {.lex_state = 143},
  [292] = {.lex_state = 143},
  [293] = {.lex_state = 143},
  [294] = {.lex_state = 143},
  [295] = {.lex_state = 143},
  [296] = {.lex_state = 143},
  [297] = {.lex_state = 143},
  [298] = {.lex_state = 143},
  [299] = {.lex_state = 143},
  [300] = {.lex_state = 143},
  [301] = {.lex_state = 143},
  [302] = {.lex_state = 143},
  [303] = {.lex_state = 143},
  [304] = {.lex_state = 143},
  [305] = {.lex_state = 143},
  [306] = {.lex_state = 143},
  [307] = {.lex_state = 143},
  [308] = {.lex_state = 143},
  [309] = {.lex_state = 143},
  [310] = {.lex_state = 143},
  [311] = {.lex_state = 143},
  [312] = {.lex_state = 143},
  [313] = {.lex_state = 143},
  [314] = {.lex_state = 143},
  [315] = {.lex_state = 143},
  [316] = {.lex_state = 143},
  [317] = {.lex_state = 143},
  [318] = {.lex_state = 143},
  [319] = {.lex_state = 162},
  [320] = {.lex_state = 143},
  [321] = {.lex_state = 143},
  [322] = {.lex_state = 143},
  [323] = {.lex_state = 143},
  [324] = {.lex_state = 143},
  [325] = {.lex_state = 144},
  [326] = {.lex_state = 162},
  [327] = {.lex_state = 162},
  [328] = {.lex_state = 143},
  [329] = {.lex_state = 143},
  [330] = {.lex_state = 143},
  [331] = {.lex_state = 162},
  [332] = {.lex_state = 143},
  [333] = {.lex_state = 162},
  [334] = {.lex_state = 143},
  [335] = {.lex_state = 162},
  [336] = {.lex_state = 162},
  [337] = {.lex_state = 162},
  [338] = {.lex_state = 143},
  [339] = {.lex_state = 162},
  [340] = {.lex_state = 143},
  [341] = {.lex_state = 162},
  [342] = {.lex_state = 143},
  [343] = {.lex_state = 143},
  [344] = {.lex_state = 162},
  [345] = {.lex_state = 143},
  [346] = {.lex_state = 162},
  [347] = {.lex_state = 143},
  [348] = {.lex_state = 162},
  [349] = {.lex_state = 162},
  [350] = {.lex_state = 162},
  [351] = {.lex_state = 143},
  [352] = {.lex_state = 145},
  [353] = {.lex_state = 145},
  [354] = {.lex_state = 145},
  [355] = {.lex_state = 145},
  [356] = {.lex_state = 147},
  [357] = {.lex_state = 145},
  [358] = {.lex_state = 145},
  [359] = {.lex_state = 148},
  [360] = {.lex_state = 148},
  [361] = {.lex_state = 148},
  [362] = {.lex_state = 148},
  [363] = {.lex_state = 148},
  [364] = {.lex_state = 148},
  [365] = {.lex_state = 148},
  [366] = {.lex_state = 149},
  [367] = {.lex_state = 148},
  [368] = {.lex_state = 148},
  [369] = {.lex_state = 148},
  [370] = {.lex_state = 148},
  [371] = {.lex_state = 148},
  [372] = {.lex_state = 148},
  [373] = {.lex_state = 148},
  [374] = {.lex_state = 148},
  [375] = {.lex_state = 148},
  [376] = {.lex_state = 148},
  [377] = {.lex_state = 148},
  [378] = {.lex_state = 148},
  [379] = {.lex_state = 148},
  [380] = {.lex_state = 148},
  [381] = {.lex_state = 148},
  [382] = {.lex_state = 148},
  [383] = {.lex_state = 148},
  [384] = {.lex_state = 148},
  [385] = {.lex_state = 148},
  [386] = {.lex_state = 148},
  [387] = {.lex_state = 148},
  [388] = {.lex_state = 148},
  [389] = {.lex_state = 148},
  [390] = {.lex_state = 149},
  [391] = {.lex_state = 148},
  [392] = {.lex_state = 148},
  [393] = {.lex_state = 148},
  [394] = {.lex_state = 148},
  [395] = {.lex_state = 148},
  [396] = {.lex_state = 148},
  [397] = {.lex_state = 148},
  [398] = {.lex_state = 148},
  [399] = {.lex_state = 148},
  [400] = {.lex_state = 148},
  [401] = {.lex_state = 148},
  [402] = {.lex_state = 148},
  [403] = {.lex_state = 148},
  [404] = {.lex_state = 148},
  [405] = {.lex_state = 148},
  [406] = {.lex_state = 148},
  [407] = {.lex_state = 148},
  [408] = {.lex_state = 148},
  [409] = {.lex_state = 148},
  [410] = {.lex_state = 148},
  [411] = {.lex_state = 148},
  [412] = {.lex_state = 148},
  [413] = {.lex_state = 148},
  [414] = {.lex_state = 148},
  [415] = {.lex_state = 148},
  [416] = {.lex_state = 148},
  [417] = {.lex_state = 148},
  [418] = {.lex_state = 148},
  [419] = {.lex_state = 148},
  [420] = {.lex_state = 148},
  [421] = {.lex_state = 148},
  [422] = {.lex_state = 172},
  [423] = {.lex_state = 147},
  [424] = {.lex_state = 172},
  [425] = {.lex_state = 172},
  [426] = {.lex_state = 147},
  [427] = {.lex_state = 147},
  [428] = {.lex_state = 147},
  [429] = {.lex_state = 170},
  [430] = {.lex_state = 147},
  [431] = {.lex_state = 147},
  [432] = {.lex_state = 147},
  [433] = {.lex_state = 147},
  [434] = {.lex_state = 147},
  [435] = {.lex_state = 147},
  [436] = {.lex_state = 147},
  [437] = {.lex_state = 147},
  [438] = {.lex_state = 172},
  [439] = {.lex_state = 147},
  [440] = {.lex_state = 147},
  [441] = {.lex_state = 147},
  [442] = {.lex_state = 147},
  [443] = {.lex_state = 147},
  [444] = {.lex_state = 169},
  [445] = {.lex_state = 169},
  [446] = {.lex_state = 147},
  [447] = {.lex_state = 147},
  [448] = {.lex_state = 147},
  [449] = {.lex_state = 147},
  [450] = {.lex_state = 147},
  [451] = {.lex_state = 147},
  [452] = {.lex_state = 147},
  [453] = {.lex_state = 147},
  [454] = {.lex_state = 170},
  [455] = {.lex_state = 148},
  [456] = {.lex_state = 148},
  [457] = {.lex_state = 170},
  [458] = {.lex_state = 148},
  [459] = {.lex_state = 148},
  [460] = {.lex_state = 147},
  [461] = {.lex_state = 147},
  [462] = {.lex_state = 148},
  [463] = {.lex_state = 172},
  [464] = {.lex_state = 171},
  [465] = {.lex_state = 171},
  [466] = {.lex_state = 145},
  [467] = {.lex_state = 172},
  [468] = {.lex_state = 145},
  [469] = {.lex_state = 148},
  [470] = {.lex_state = 170},
  [471] = {.lex_state = 145},
  [472] = {.lex_state = 148},
  [473] = {.lex_state = 171},
  [474] = {.lex_state = 169},
  [475] = {.lex_state = 145},
  [476] = {.lex_state = 170},
  [477] = {.lex_state = 170},
  [478] = {.lex_state = 172},
  [479] = {.lex_state = 172},
  [480] = {.lex_state = 172},
  [481] = {.lex_state = 147},
  [482] = {.lex_state = 147},
  [483] = {.lex_state = 147},
  [484] = {.lex_state = 172},
  [485] = {.lex_state = 147},
  [486] = {.lex_state = 147},
  [487] = {.lex_state = 147},
  [488] = {.lex_state = 147},
  [489] = {.lex_state = 147},
  [490] = {.lex_state = 147},
  [491] = {.lex_state = 147},
  [492] = {.lex_state = 147},
  [493] = {.lex_state = 147},
  [494] = {.lex_state = 169},
  [495] = {.lex_state = 147},
  [496] = {.lex_state = 147},
  [497] = {.lex_state = 170},
  [498] = {.lex_state = 170},
  [499] = {.lex_state = 171},
  [500] = {.lex_state = 170},
  [501] = {.lex_state = 148},
  [502] = {.lex_state = 147},
  [503] = {.lex_state = 170},
  [504] = {.lex_state = 147},
  [505] = {.lex_state = 147},
  [506] = {.lex_state = 147},
  [507] = {.lex_state = 145},
  [508] = {.lex_state = 147},
  [509] = {.lex_state = 147},
  [510] = {.lex_state = 148},
  [511] = {.lex_state = 147},
  [512] = {.lex_state = 147},
  [513] = {.lex_state = 171},
  [514] = {.lex_state = 147},
  [515] = {.lex_state = 148},
  [516] = {.lex_state = 171},
  [517] = {.lex_state = 145},
  [518] = {.lex_state = 147},
  [519] = {.lex_state = 147},
  [520] = {.lex_state = 147},
  [521] = {.lex_state = 147},
  [522] = {.lex_state = 169},
  [523] = {.lex_state = 169},
  [524] = {.lex_state = 169},
  [525] = {.lex_state = 169},
  [526] = {.lex_state = 169},
  [527] = {.lex_state = 169},
  [528] = {.lex_state = 169},
  [529] = {.lex_state = 169},
  [530] = {.lex_state = 169},
  [531] = {.lex_state = 169},
  [532] = {.lex_state = 169},
  [533] = {.lex_state = 169},
  [534] = {.lex_state = 150},
  [535] = {.lex_state = 169},
  [536] = {.lex_state = 169},
  [537] = {.lex_state = 145},
  [538] = {.lex_state = 150},
  [539] = {.lex_state = 169},
  [540] = {.lex_state = 150},
  [541] = {.lex_state = 169},
  [542] = {.lex_state = 150},
  [543] = {.lex_state = 169},
  [544] = {.lex_state = 169},
  [545] = {.lex_state = 169},
  [546] = {.lex_state = 145},
  [547] = {.lex_state = 169},
  [548] = {.lex_state = 169},
  [549] = {.lex_state = 151},
  [550] = {.lex_state = 169},
  [551] = {.lex_state = 145},
  [552] = {.lex_state = 150},
  [553] = {.lex_state = 169},
  [554] = {.lex_state = 169},
  [555] = {.lex_state = 169},
  [556] = {.lex_state = 169},
  [557] = {.lex_state = 169},
  [558] = {.lex_state = 169},
  [559] = {.lex_state = 150},
  [560] = {.lex_state = 150},
  [561] = {.lex_state = 150},
  [562] = {.lex_state = 169},
  [563] = {.lex_state = 150},
  [564] = {.lex_state = 169},
  [565] = {.lex_state = 169},
  [566] = {.lex_state = 169},
  [567] = {.lex_state = 150},
  [568] = {.lex_state = 169},
  [569] = {.lex_state = 169},
  [570] = {.lex_state = 169},
  [571] = {.lex_state = 169},
  [572] = {.lex_state = 169},
  [573] = {.lex_state = 169},
  [574] = {.lex_state = 169},
  [575] = {.lex_state = 169},
  [576] = {.lex_state = 169},
  [577] = {.lex_state = 169},
  [578] = {.lex_state = 169},
  [579] = {.lex_state = 169},
  [580] = {.lex_state = 147},
  [581] = {.lex_state = 169},
  [582] = {.lex_state = 169},
  [583] = {.lex_state = 169},
  [584] = {.lex_state = 169},
  [585] = {.lex_state = 169},
  [586] = {.lex_state = 169},
  [587] = {.lex_state = 169},
  [588] = {.lex_state = 169},
  [589] = {.lex_state = 169},
  [590] = {.lex_state = 169},
  [591] = {.lex_state = 169},
  [592] = {.lex_state = 169},
  [593] = {.lex_state = 169},
  [594] = {.lex_state = 169},
  [595] = {.lex_state = 169},
  [596] = {.lex_state = 169},
  [597] = {.lex_state = 169},
  [598] = {.lex_state = 169},
  [599] = {.lex_state = 169},
  [600] = {.lex_state = 169},
  [601] = {.lex_state = 169},
  [602] = {.lex_state = 169},
  [603] = {.lex_state = 169},
  [604] = {.lex_state = 152},
  [605] = {.lex_state = 148},
  [606] = {.lex_state = 145},
  [607] = {.lex_state = 153},
  [608] = {.lex_state = 148},
  [609] = {.lex_state = 152},
  [610] = {.lex_state = 152},
  [611] = {.lex_state = 145},
  [612] = {.lex_state = 153},
  [613] = {.lex_state = 154},
  [614] = {.lex_state = 145},
  [615] = {.lex_state = 148},
  [616] = {.lex_state = 152},
  [617] = {.lex_state = 153},
  [618] = {.lex_state = 148},
  [619] = {.lex_state = 153},
  [620] = {.lex_state = 155},
  [621] = {.lex_state = 148},
  [622] = {.lex_state = 148},
  [623] = {.lex_state = 147},
  [624] = {.lex_state = 148},
  [625] = {.lex_state = 155},
  [626] = {.lex_state = 148},
  [627] = {.lex_state = 148},
  [628] = {.lex_state = 148},
  [629] = {.lex_state = 147},
  [630] = {.lex_state = 154},
  [631] = {.lex_state = 148},
  [632] = {.lex_state = 154},
  [633] = {.lex_state = 147},
  [634] = {.lex_state = 154},
  [635] = {.lex_state = 147},
  [636] = {.lex_state = 154},
  [637] = {.lex_state = 154},
  [638] = {.lex_state = 154},
  [639] = {.lex_state = 154},
  [640] = {.lex_state = 154},
  [641] = {.lex_state = 147},
  [642] = {.lex_state = 147},
  [643] = {.lex_state = 154},
  [644] = {.lex_state = 148},
  [645] = {.lex_state = 148},
  [646] = {.lex_state = 148},
  [647] = {.lex_state = 148},
  [648] = {.lex_state = 148},
  [649] = {.lex_state = 154},
  [650] = {.lex_state = 148},
  [651] = {.lex_state = 154},
  [652] = {.lex_state = 148},
  [653] = {.lex_state = 154},
  [654] = {.lex_state = 154},
  [655] = {.lex_state = 148},
  [656] = {.lex_state = 148},
  [657] = {.lex_state = 154},
  [658] = {.lex_state = 154},
  [659] = {.lex_state = 154},
  [660] = {.lex_state = 154},
  [661] = {.lex_state = 154},
  [662] = {.lex_state = 154},
  [663] = {.lex_state = 148},
  [664] = {.lex_state = 150},
  [665] = {.lex_state = 148},
  [666] = {.lex_state = 154},
  [667] = {.lex_state = 150},
  [668] = {.lex_state = 154},
  [669] = {.lex_state = 150},
  [670] = {.lex_state = 154},
  [671] = {.lex_state = 154},
  [672] = {.lex_state = 150},
  [673] = {.lex_state = 154},
  [674] = {.lex_state = 150},
  [675] = {.lex_state = 147},
  [676] = {.lex_state = 154},
  [677] = {.lex_state = 148},
  [678] = {.lex_state = 154},
  [679] = {.lex_state = 150},
  [680] = {.lex_state = 154},
  [681] = {.lex_state = 154},
  [682] = {.lex_state = 147},
  [683] = {.lex_state = 154},
  [684] = {.lex_state = 154},
  [685] = {.lex_state = 147},
  [686] = {.lex_state = 154},
  [687] = {.lex_state = 150},
  [688] = {.lex_state = 148},
  [689] = {.lex_state = 147},
  [690] = {.lex_state = 147},
  [691] = {.lex_state = 150},
  [692] = {.lex_state = 154},
  [693] = {.lex_state = 150},
  [694] = {.lex_state = 154},
  [695] = {.lex_state = 150},
  [696] = {.lex_state = 154},
  [697] = {.lex_state = 154},
  [698] = {.lex_state = 147},
  [699] = {.lex_state = 154},
  [700] = {.lex_state = 154},
  [701] = {.lex_state = 147},
  [702] = {.lex_state = 150},
  [703] = {.lex_state = 150},
  [704] = {.lex_state = 150},
  [705] = {.lex_state = 154},
  [706] = {.lex_state = 154},
  [707] = {.lex_state = 154},
  [708] = {.lex_state = 154},
  [709] = {.lex_state = 150},
  [710] = {.lex_state = 154},
  [711] = {.lex_state = 154},
  [712] = {.lex_state = 154},
  [713] = {.lex_state = 154},
  [714] = {.lex_state = 154},
  [715] = {.lex_state = 148},
  [716] = {.lex_state = 154},
  [717] = {.lex_state = 150},
  [718] = {.lex_state = 150},
  [719] = {.lex_state = 147},
  [720] = {.lex_state = 148},
  [721] = {.lex_state = 150},
  [722] = {.lex_state = 154},
  [723] = {.lex_state = 150},
  [724] = {.lex_state = 148},
  [725] = {.lex_state = 150},
  [726] = {.lex_state = 154},
  [727] = {.lex_state = 150},
  [728] = {.lex_state = 147},
  [729] = {.lex_state = 150},
  [730] = {.lex_state = 147},
  [731] = {.lex_state = 147},
  [732] = {.lex_state = 150},
  [733] = {.lex_state = 147},
  [734] = {.lex_state = 147},
  [735] = {.lex_state = 150},
  [736] = {.lex_state = 147},
  [737] = {.lex_state = 154},
  [738] = {.lex_state = 154},
  [739] = {.lex_state = 154},
  [740] = {.lex_state = 150},
  [741] = {.lex_state = 154},
  [742] = {.lex_state = 150},
  [743] = {.lex_state = 154},
  [744] = {.lex_state = 154},
  [745] = {.lex_state = 154},
  [746] = {.lex_state = 150},
  [747] = {.lex_state = 154},
  [748] = {.lex_state = 154},
  [749] = {.lex_state = 147},
  [750] = {.lex_state = 150},
  [751] = {.lex_state = 154},
  [752] = {.lex_state = 147},
  [753] = {.lex_state = 150},
  [754] = {.lex_state = 154},
  [755] = {.lex_state = 147},
  [756] = {.lex_state = 154},
  [757] = {.lex_state = 147},
  [758] = {.lex_state = 154},
  [759] = {.lex_state = 154},
  [760] = {.lex_state = 147},
  [761] = {.lex_state = 147},
  [762] = {.lex_state = 150},
  [763] = {.lex_state = 154},
  [764] = {.lex_state = 150},
  [765] = {.lex_state = 154},
  [766] = {.lex_state = 147},
  [767] = {.lex_state = 150},
  [768] = {.lex_state = 147},
  [769] = {.lex_state = 154},
  [770] = {.lex_state = 154},
  [771] = {.lex_state = 154},
  [772] = {.lex_state = 150},
  [773] = {.lex_state = 154},
  [774] = {.lex_state = 154},
  [775] = {.lex_state = 147},
  [776] = {.lex_state = 147},
  [777] = {.lex_state = 147},
  [778] = {.lex_state = 147},
  [779] = {.lex_state = 154},
  [780] = {.lex_state = 147},
  [781] = {.lex_state = 154},
  [782] = {.lex_state = 154},
  [783] = {.lex_state = 154},
  [784] = {.lex_state = 147},
  [785] = {.lex_state = 147},
  [786] = {.lex_state = 154},
  [787] = {.lex_state = 147},
  [788] = {.lex_state = 154},
  [789] = {.lex_state = 150},
  [790] = {.lex_state = 154},
  [791] = {.lex_state = 154},
  [792] = {.lex_state = 150},
  [793] = {.lex_state = 150},
  [794] = {.lex_state = 150},
  [795] = {.lex_state = 150},
  [796] = {.lex_state = 150},
  [797] = {.lex_state = 150},
  [798] = {.lex_state = 150},
  [799] = {.lex_state = 150},
  [800] = {.lex_state = 150},
  [801] = {.lex_state = 150},
  [802] = {.lex_state = 150},
  [803] = {.lex_state = 141},
  [804] = {.lex_state = 156},
  [805] = {.lex_state = 141},
  [806] = {.lex_state = 157},
  [807] = {.lex_state = 141},
  [808] = {.lex_state = 145},
  [809] = {.lex_state = 145},
  [810] = {.lex_state = 145},
  [811] = {.lex_state = 158},
  [812] = {.lex_state = 158},
  [813] = {.lex_state = 158},
  [814] = {.lex_state = 156},
  [815] = {.lex_state = 158},
  [816] = {.lex_state = 158},
  [817] = {.lex_state = 158},
  [818] = {.lex_state = 158},
  [819] = {.lex_state = 158},
  [820] = {.lex_state = 158},
  [821] = {.lex_state = 158},
  [822] = {.lex_state = 158},
  [823] = {.lex_state = 156},
  [824] = {.lex_state = 158},
  [825] = {.lex_state = 156},
  [826] = {.lex_state = 158},
  [827] = {.lex_state = 158},
  [828] = {.lex_state = 157},
  [829] = {.lex_state = 158},
  [830] = {.lex_state = 158},
  [831] = {.lex_state = 158},
  [832] = {.lex_state = 158},
  [833] = {.lex_state = 158},
  [834] = {.lex_state = 158},
  [835] = {.lex_state = 158},
  [836] = {.lex_state = 158},
  [837] = {.lex_state = 156},
  [838] = {.lex_state = 158},
  [839] = {.lex_state = 158},
  [840] = {.lex_state = 158},
  [841] = {.lex_state = 158},
  [842] = {.lex_state = 158},
  [843] = {.lex_state = 158},
  [844] = {.lex_state = 147},
  [845] = {.lex_state = 158},
  [846] = {.lex_state = 158},
  [847] = {.lex_state = 158},
  [848] = {.lex_state = 158},
  [849] = {.lex_state = 156},
  [850] = {.lex_state = 158},
  [851] = {.lex_state = 158},
  [852] = {.lex_state = 158},
  [853] = {.lex_state = 158},
  [854] = {.lex_state = 158},
  [855] = {.lex_state = 158},
  [856] = {.lex_state = 154},
  [857] = {.lex_state = 154},
  [858] = {.lex_state = 154},
  [859] = {.lex_state = 156},
  [860] = {.lex_state = 158},
  [861] = {.lex_state = 158},
  [862] = {.lex_state = 154},
  [863] = {.lex_state = 156},
  [864] = {.lex_state = 158},
  [865] = {.lex_state = 158},
  [866] = {.lex_state = 156},
  [867] = {.lex_state = 158},
  [868] = {.lex_state = 156},
  [869] = {.lex_state = 158},
  [870] = {.lex_state = 158},
  [871] = {.lex_state = 158},
  [872] = {.lex_state = 158},
  [873] = {.lex_state = 158},
  [874] = {.lex_state = 158},
  [875] = {.lex_state = 156},
  [876] = {.lex_state = 156},
  [877] = {.lex_state = 156},
  [878] = {.lex_state = 156},
  [879] = {.lex_state = 154},
  [880] = {.lex_state = 158},
  [881] = {.lex_state = 158},
  [882] = {.lex_state = 158},
  [883] = {.lex_state = 158},
  [884] = {.lex_state = 158},
  [885] = {.lex_state = 158},
  [886] = {.lex_state = 158},
  [887] = {.lex_state = 158},
  [888] = {.lex_state = 158},
  [889] = {.lex_state = 158},
  [890] = {.lex_state = 156},
  [891] = {.lex_state = 156},
  [892] = {.lex_state = 158},
  [893] = {.lex_state = 156},
  [894] = {.lex_state = 154},
  [895] = {.lex_state = 158},
  [896] = {.lex_state = 157},
  [897] = {.lex_state = 145},
  [898] = {.lex_state = 147},
  [899] = {.lex_state = 147},
  [900] = {.lex_state = 145},
  [901] = {.lex_state = 147},
  [902] = {.lex_state = 157},
  [903] = {.lex_state = 154},
  [904] = {.lex_state = 157},
  [905] = {.lex_state = 154},
  [906] = {.lex_state = 157},
  [907] = {.lex_state = 154},
  [908] = {.lex_state = 157},
  [909] = {.lex_state = 157},
  [910] = {.lex_state = 157},
  [911] = {.lex_state = 157},
  [912] = {.lex_state = 158},
  [913] = {.lex_state = 158},
  [914] = {.lex_state = 157},
  [915] = {.lex_state = 157},
  [916] = {.lex_state = 157},
  [917] = {.lex_state = 145},
  [918] = {.lex_state = 157},
  [919] = {.lex_state = 154},
  [920] = {.lex_state = 156},
  [921] = {.lex_state = 157},
  [922] = {.lex_state = 157},
  [923] = {.lex_state = 157},
  [924] = {.lex_state = 157},
  [925] = {.lex_state = 157},
  [926] = {.lex_state = 157},
  [927] = {.lex_state = 158},
  [928] = {.lex_state = 157},
  [929] = {.lex_state = 157},
  [930] = {.lex_state = 158},
  [931] = {.lex_state = 157},
  [932] = {.lex_state = 157},
  [933] = {.lex_state = 157},
  [934] = {.lex_state = 157},
  [935] = {.lex_state = 157},
  [936] = {.lex_state = 157},
  [937] = {.lex_state = 157},
  [938] = {.lex_state = 147},
  [939] = {.lex_state = 157},
  [940] = {.lex_state = 145},
  [941] = {.lex_state = 156},
  [942] = {.lex_state = 151},
  [943] = {.lex_state = 156},
  [944] = {.lex_state = 156},
  [945] = {.lex_state = 159},
  [946] = {.lex_state = 159},
  [947] = {.lex_state = 151},
  [948] = {.lex_state = 159},
  [949] = {.lex_state = 157},
  [950] = {.lex_state = 151},
  [951] = {.lex_state = 156},
  [952] = {.lex_state = 159},
  [953] = {.lex_state = 151},
  [954] = {.lex_state = 156},
  [955] = {.lex_state = 159},
  [956] = {.lex_state = 159},
  [957] = {.lex_state = 151},
  [958] = {.lex_state = 156},
  [959] = {.lex_state = 151},
  [960] = {.lex_state = 156},
  [961] = {.lex_state = 145},
  [962] = {.lex_state = 145},
  [963] = {.lex_state = 145},
  [964] = {.lex_state = 160},
  [965] = {.lex_state = 145},
  [966] = {.lex_state = 156},
  [967] = {.lex_state = 159},
  [968] = {.lex_state = 145},
  [969] = {.lex_state = 145},
  [970] = {.lex_state = 145},
  [971] = {.lex_state = 145},
  [972] = {.lex_state = 145},
  [973] = {.lex_state = 160},
  [974] = {.lex_state = 157},
  [975] = {.lex_state = 145},
  [976] = {.lex_state = 145},
  [977] = {.lex_state = 145},
  [978] = {.lex_state = 145},
  [979] = {.lex_state = 145},
  [980] = {.lex_state = 157},
  [981] = {.lex_state = 156},
  [982] = {.lex_state = 145},
  [983] = {.lex_state = 145},
  [984] = {.lex_state = 145},
  [985] = {.lex_state = 145},
  [986] = {.lex_state = 145},
  [987] = {.lex_state = 145},
  [988] = {.lex_state = 145},
  [989] = {.lex_state = 145},
  [990] = {.lex_state = 145},
  [991] = {.lex_state = 145},
  [992] = {.lex_state = 145},
  [993] = {.lex_state = 145},
  [994] = {.lex_state = 145},
  [995] = {.lex_state = 145},
  [996] = {.lex_state = 145},
  [997] = {.lex_state = 145},
  [998] = {.lex_state = 145},
  [999] = {.lex_state = 145},
  [1000] = {.lex_state = 145},
  [1001] = {.lex_state = 145},
  [1002] = {.lex_state = 160},
  [1003] = {.lex_state = 156},
  [1004] = {.lex_state = 145},
  [1005] = {.lex_state = 157},
  [1006] = {.lex_state = 145},
  [1007] = {.lex_state = 157},
  [1008] = {.lex_state = 145},
  [1009] = {.lex_state = 145},
  [1010] = {.lex_state = 157},
  [1011] = {.lex_state = 159},
  [1012] = {.lex_state = 157},
  [1013] = {.lex_state = 157},
  [1014] = {.lex_state = 157},
  [1015] = {.lex_state = 159},
  [1016] = {.lex_state = 159},
  [1017] = {.lex_state = 159},
  [1018] = {.lex_state = 157},
  [1019] = {.lex_state = 161},
  [1020] = {.lex_state = 161},
  [1021] = {.lex_state = 161},
  [1022] = {.lex_state = 161},
  [1023] = {.lex_state = 161},
  [1024] = {.lex_state = 161},
  [1025] = {.lex_state = 145},
  [1026] = {.lex_state = 145},
  [1027] = {.lex_state = 145, .external_lex_state = 1},
  [1028] = {.lex_state = 145},
  [1029] = {.lex_state = 145, .external_lex_state = 1},
  [1030] = {.lex_state = 145, .external_lex_state = 1},
  [1031] = {.lex_state = 160},
  [1032] = {.lex_state = 157},
  [1033] = {.lex_state = 160},
  [1034] = {.lex_state = 145},
  [1035] = {.lex_state = 145, .external_lex_state = 1},
  [1036] = {.lex_state = 160},
  [1037] = {.lex_state = 145, .external_lex_state = 1},
  [1038] = {.lex_state = 145, .external_lex_state = 1},
  [1039] = {.lex_state = 145, .external_lex_state = 1},
  [1040] = {.lex_state = 160},
  [1041] = {.lex_state = 145, .external_lex_state = 1},
  [1042] = {.lex_state = 160},
  [1043] = {.lex_state = 145},
  [1044] = {.lex_state = 160},
  [1045] = {.lex_state = 145, .external_lex_state = 1},
  [1046] = {.lex_state = 160},
  [1047] = {.lex_state = 145, .external_lex_state = 1},
  [1048] = {.lex_state = 161},
  [1049] = {.lex_state = 145},
  [1050] = {.lex_state = 145},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 145, .external_lex_state = 1},
  [1053] = {.lex_state = 160},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 160},
  [1056] = {.lex_state = 145, .external_lex_state = 1},
  [1057] = {.lex_state = 160},
  [1058] = {.lex_state = 145, .external_lex_state = 1},
  [1059] = {.lex_state = 160},
  [1060] = {.lex_state = 160},
  [1061] = {.lex_state = 145},
  [1062] = {.lex_state = 159},
  [1063] = {.lex_state = 142},
  [1064] = {.lex_state = 145},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 157},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 157},
  [1074] = {.lex_state = 145},
  [1075] = {.lex_state = 159},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 145},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 156},
  [1084] = {.lex_state = 157},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 160},
  [1087] = {.lex_state = 160},
  [1088] = {.lex_state = 159},
  [1089] = {.lex_state = 160},
  [1090] = {.lex_state = 142},
  [1091] = {.lex_state = 145},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 145},
  [1096] = {.lex_state = 145},
  [1097] = {.lex_state = 160},
  [1098] = {.lex_state = 160},
  [1099] = {.lex_state = 145},
  [1100] = {.lex_state = 157},
  [1101] = {.lex_state = 159},
  [1102] = {.lex_state = 145},
  [1103] = {.lex_state = 159},
  [1104] = {.lex_state = 157},
  [1105] = {.lex_state = 160},
  [1106] = {.lex_state = 160},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 160},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 159},
  [1113] = {.lex_state = 145},
  [1114] = {.lex_state = 145},
  [1115] = {.lex_state = 145},
  [1116] = {.lex_state = 159},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 160},
  [1120] = {.lex_state = 145},
  [1121] = {.lex_state = 145},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 145},
  [1124] = {.lex_state = 145},
  [1125] = {.lex_state = 160},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 145},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 145, .external_lex_state = 1},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 157},
  [1133] = {.lex_state = 160},
  [1134] = {.lex_state = 145},
  [1135] = {.lex_state = 145},
  [1136] = {.lex_state = 142},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 145},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 160},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 142},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 142},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 145},
  [1161] = {.lex_state = 142},
  [1162] = {.lex_state = 142},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 145},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 157},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 151},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 142},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 142},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 145},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 142},
  [1192] = {.lex_state = 142},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 142},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 142},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 142},
  [1201] = {.lex_state = 142},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 142},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 142},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 160},
  [1218] = {.lex_state = 142},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 145},
  [1221] = {.lex_state = 145},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 142},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 160},
  [1227] = {.lex_state = 145},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 145},
  [1230] = {.lex_state = 142},
  [1231] = {.lex_state = 142},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 169},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 145},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 160},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 142},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 160},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 142},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 142},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 169},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 0},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 160},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 145},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 145},
  [1292] = {.lex_state = 142},
  [1293] = {.lex_state = 169},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 142},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 169},
  [1299] = {.lex_state = 0},
  [1300] = {.lex_state = 145},
  [1301] = {.lex_state = 160},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 0},
  [1304] = {.lex_state = 160},
  [1305] = {.lex_state = 160},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 160},
  [1309] = {.lex_state = 0},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 160},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 160},
  [1319] = {.lex_state = 169},
  [1320] = {.lex_state = 169},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 160},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 0},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 0},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 160},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 160},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 0},
  [1352] = {.lex_state = 145},
  [1353] = {.lex_state = 142},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 0},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 0},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 0},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 169},
  [1366] = {.lex_state = 0},
  [1367] = {.lex_state = 0},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 0},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 169},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 142},
  [1379] = {.lex_state = 169},
  [1380] = {.lex_state = 142},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 160},
  [1383] = {.lex_state = 160},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 0},
  [1386] = {.lex_state = 0},
  [1387] = {.lex_state = 160},
  [1388] = {.lex_state = 160},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 160},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 0},
  [1396] = {.lex_state = 0},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 0},
  [1399] = {.lex_state = 0},
  [1400] = {.lex_state = 145},
  [1401] = {.lex_state = 0},
  [1402] = {.lex_state = 160},
  [1403] = {.lex_state = 0},
  [1404] = {.lex_state = 160},
  [1405] = {.lex_state = 160},
  [1406] = {.lex_state = 160},
  [1407] = {.lex_state = 145},
  [1408] = {.lex_state = 142},
  [1409] = {.lex_state = 160},
  [1410] = {.lex_state = 0},
  [1411] = {.lex_state = 160},
  [1412] = {.lex_state = 169},
  [1413] = {.lex_state = 160},
  [1414] = {.lex_state = 160},
  [1415] = {.lex_state = 160},
  [1416] = {.lex_state = 0},
  [1417] = {.lex_state = 0},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 0},
  [1422] = {.lex_state = 160},
  [1423] = {.lex_state = 0},
  [1424] = {.lex_state = 160},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 160},
  [1427] = {.lex_state = 142},
  [1428] = {.lex_state = 145},
  [1429] = {.lex_state = 0},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 169},
  [1432] = {.lex_state = 0},
  [1433] = {.lex_state = 160},
  [1434] = {.lex_state = 142},
  [1435] = {.lex_state = 0},
  [1436] = {.lex_state = 0},
  [1437] = {.lex_state = 0},
  [1438] = {.lex_state = 142},
  [1439] = {.lex_state = 0},
  [1440] = {.lex_state = 0},
  [1441] = {.lex_state = 0},
  [1442] = {.lex_state = 0},
  [1443] = {.lex_state = 0},
  [1444] = {.lex_state = 0},
  [1445] = {.lex_state = 0},
  [1446] = {.lex_state = 0},
  [1447] = {.lex_state = 0},
  [1448] = {.lex_state = 0},
  [1449] = {.lex_state = 0},
  [1450] = {.lex_state = 0},
  [1451] = {.lex_state = 0},
  [1452] = {.lex_state = 0},
  [1453] = {.lex_state = 0},
  [1454] = {.lex_state = 142},
  [1455] = {.lex_state = 0},
  [1456] = {.lex_state = 0},
  [1457] = {.lex_state = 0},
  [1458] = {.lex_state = 0},
  [1459] = {.lex_state = 0},
  [1460] = {.lex_state = 0},
  [1461] = {.lex_state = 0},
  [1462] = {.lex_state = 0},
  [1463] = {.lex_state = 142},
  [1464] = {.lex_state = 0},
  [1465] = {.lex_state = 0},
  [1466] = {.lex_state = 142},
  [1467] = {.lex_state = 0},
  [1468] = {.lex_state = 0},
  [1469] = {.lex_state = 142},
  [1470] = {.lex_state = 142},
  [1471] = {.lex_state = 0},
  [1472] = {.lex_state = 145},
  [1473] = {.lex_state = 0},
  [1474] = {.lex_state = 0},
  [1475] = {.lex_state = 0},
  [1476] = {.lex_state = 0},
  [1477] = {.lex_state = 0},
  [1478] = {.lex_state = 160},
  [1479] = {.lex_state = 142},
  [1480] = {.lex_state = 142},
  [1481] = {.lex_state = 0},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 142},
  [1484] = {.lex_state = 0},
  [1485] = {.lex_state = 142},
  [1486] = {.lex_state = 0},
  [1487] = {.lex_state = 0},
  [1488] = {.lex_state = 0},
  [1489] = {.lex_state = 0},
  [1490] = {.lex_state = 142},
  [1491] = {.lex_state = 0},
  [1492] = {.lex_state = 0},
  [1493] = {.lex_state = 0},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 142},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 0},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 0},
  [1500] = {.lex_state = 0},
  [1501] = {.lex_state = 0},
  [1502] = {.lex_state = 0},
  [1503] = {.lex_state = 0},
  [1504] = {.lex_state = 0},
  [1505] = {.lex_state = 160},
  [1506] = {.lex_state = 0},
  [1507] = {.lex_state = 0},
  [1508] = {.lex_state = 0},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 0},
  [1511] = {.lex_state = 0},
  [1512] = {.lex_state = 0},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 0},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 145},
  [1517] = {.lex_state = 0},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 0},
  [1520] = {.lex_state = 0},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 145},
  [1523] = {.lex_state = 142},
  [1524] = {.lex_state = 145},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 0},
  [1527] = {.lex_state = 0},
  [1528] = {.lex_state = 0},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 142},
  [1531] = {.lex_state = 142},
  [1532] = {.lex_state = 0},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 0},
  [1535] = {.lex_state = 0},
  [1536] = {.lex_state = 0},
  [1537] = {.lex_state = 0},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 0},
  [1540] = {.lex_state = 0},
  [1541] = {.lex_state = 0},
  [1542] = {.lex_state = 0},
  [1543] = {.lex_state = 0},
  [1544] = {.lex_state = 0},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 0},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 0},
  [1551] = {.lex_state = 0},
  [1552] = {.lex_state = 0},
  [1553] = {.lex_state = 0},
  [1554] = {.lex_state = 0},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 142},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 0},
};

enum {
  ts_external_token_quoted_content = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_quoted_content] = sym_quoted_content,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_quoted_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_erlang] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_size] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_DOT] = ACTIONS(1),
    [anon_sym_LT_EQ_DOT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_DOT] = ACTIONS(1),
    [anon_sym_GT_EQ_DOT] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_DOT] = ACTIONS(1),
    [anon_sym_DASH_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_DOT] = ACTIONS(1),
    [anon_sym_SLASH_DOT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_todo] = ACTIONS(1),
    [anon_sym_panic] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_visibility_modifier] = ACTIONS(1),
    [sym_opacity_modifier] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [aux_sym_escape_sequence_token2] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym__hex] = ACTIONS(1),
    [sym__decimal] = ACTIONS(1),
    [sym__octal] = ACTIONS(1),
    [sym__binary] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bit_string] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_utf8] = ACTIONS(1),
    [anon_sym_utf16] = ACTIONS(1),
    [anon_sym_utf32] = ACTIONS(1),
    [anon_sym_utf8_codepoint] = ACTIONS(1),
    [anon_sym_utf16_codepoint] = ACTIONS(1),
    [anon_sym_utf32_codepoint] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_big] = ACTIONS(1),
    [anon_sym_little] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_unit] = ACTIONS(1),
    [sym__discard_name] = ACTIONS(1),
    [sym__name] = ACTIONS(1),
    [sym__upname] = ACTIONS(1),
    [sym_quoted_content] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1510),
    [sym__module_statement] = STATE(3),
    [sym_target_group] = STATE(3),
    [sym_attribute] = STATE(3),
    [sym_import] = STATE(3),
    [sym_constant] = STATE(3),
    [sym_external_type] = STATE(3),
    [sym_external_function] = STATE(3),
    [sym_function] = STATE(3),
    [aux_sym__statement_seq] = STATE(5),
    [sym__statement] = STATE(533),
    [sym__expression] = STATE(113),
    [sym_binary_expression] = STATE(113),
    [sym__expression_unit] = STATE(113),
    [sym_record] = STATE(75),
    [sym_todo] = STATE(113),
    [sym_panic] = STATE(113),
    [sym_tuple] = STATE(74),
    [sym_list] = STATE(113),
    [sym__expression_bit_string] = STATE(113),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(533),
    [sym_let] = STATE(533),
    [sym_use] = STATE(533),
    [sym_assert] = STATE(113),
    [sym_boolean_negation] = STATE(113),
    [sym_integer_negation] = STATE(113),
    [sym_record_update] = STATE(75),
    [sym__maybe_tuple_expression] = STATE(1507),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1506),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1368),
    [sym_function_call] = STATE(36),
    [sym_type_definition] = STATE(3),
    [sym_type_alias] = STATE(3),
    [sym_string] = STATE(113),
    [sym_integer] = STATE(113),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LT_LT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_panic] = ACTIONS(35),
    [anon_sym_case] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_assert] = ACTIONS(41),
    [anon_sym_use] = ACTIONS(43),
    [anon_sym_BANG] = ACTIONS(45),
    [sym_visibility_modifier] = ACTIONS(47),
    [sym_opacity_modifier] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [sym_float] = ACTIONS(53),
    [sym__hex] = ACTIONS(55),
    [sym__decimal] = ACTIONS(57),
    [sym__octal] = ACTIONS(55),
    [sym__binary] = ACTIONS(55),
    [sym__name] = ACTIONS(59),
    [sym__upname] = ACTIONS(61),
  },
  [2] = {
    [sym__module_statement] = STATE(2),
    [sym_target_group] = STATE(2),
    [sym_attribute] = STATE(2),
    [sym_import] = STATE(2),
    [sym_constant] = STATE(2),
    [sym_external_type] = STATE(2),
    [sym_external_function] = STATE(2),
    [sym_function] = STATE(2),
    [aux_sym__statement_seq] = STATE(5),
    [sym__statement] = STATE(533),
    [sym__expression] = STATE(113),
    [sym_binary_expression] = STATE(113),
    [sym__expression_unit] = STATE(113),
    [sym_record] = STATE(75),
    [sym_todo] = STATE(113),
    [sym_panic] = STATE(113),
    [sym_tuple] = STATE(74),
    [sym_list] = STATE(113),
    [sym__expression_bit_string] = STATE(113),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(533),
    [sym_let] = STATE(533),
    [sym_use] = STATE(533),
    [sym_assert] = STATE(113),
    [sym_boolean_negation] = STATE(113),
    [sym_integer_negation] = STATE(113),
    [sym_record_update] = STATE(75),
    [sym__maybe_tuple_expression] = STATE(1507),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1506),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1368),
    [sym_function_call] = STATE(36),
    [sym_type_definition] = STATE(2),
    [sym_type_alias] = STATE(2),
    [sym_string] = STATE(113),
    [sym_integer] = STATE(113),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(68),
    [anon_sym_AT] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(74),
    [anon_sym_type] = ACTIONS(77),
    [anon_sym_const] = ACTIONS(80),
    [anon_sym_POUND] = ACTIONS(83),
    [anon_sym_LBRACK] = ACTIONS(86),
    [anon_sym_LT_LT] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(92),
    [anon_sym_fn] = ACTIONS(95),
    [anon_sym_external] = ACTIONS(98),
    [anon_sym_todo] = ACTIONS(101),
    [anon_sym_panic] = ACTIONS(104),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_let] = ACTIONS(110),
    [anon_sym_assert] = ACTIONS(113),
    [anon_sym_use] = ACTIONS(116),
    [anon_sym_BANG] = ACTIONS(119),
    [sym_visibility_modifier] = ACTIONS(122),
    [sym_opacity_modifier] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(128),
    [sym_float] = ACTIONS(131),
    [sym__hex] = ACTIONS(134),
    [sym__decimal] = ACTIONS(137),
    [sym__octal] = ACTIONS(134),
    [sym__binary] = ACTIONS(134),
    [sym__name] = ACTIONS(140),
    [sym__upname] = ACTIONS(143),
  },
  [3] = {
    [sym__module_statement] = STATE(2),
    [sym_target_group] = STATE(2),
    [sym_attribute] = STATE(2),
    [sym_import] = STATE(2),
    [sym_constant] = STATE(2),
    [sym_external_type] = STATE(2),
    [sym_external_function] = STATE(2),
    [sym_function] = STATE(2),
    [aux_sym__statement_seq] = STATE(5),
    [sym__statement] = STATE(533),
    [sym__expression] = STATE(113),
    [sym_binary_expression] = STATE(113),
    [sym__expression_unit] = STATE(113),
    [sym_record] = STATE(75),
    [sym_todo] = STATE(113),
    [sym_panic] = STATE(113),
    [sym_tuple] = STATE(74),
    [sym_list] = STATE(113),
    [sym__expression_bit_string] = STATE(113),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(533),
    [sym_let] = STATE(533),
    [sym_use] = STATE(533),
    [sym_assert] = STATE(113),
    [sym_boolean_negation] = STATE(113),
    [sym_integer_negation] = STATE(113),
    [sym_record_update] = STATE(75),
    [sym__maybe_tuple_expression] = STATE(1507),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1506),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1368),
    [sym_function_call] = STATE(36),
    [sym_type_definition] = STATE(2),
    [sym_type_alias] = STATE(2),
    [sym_string] = STATE(113),
    [sym_integer] = STATE(113),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(146),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LT_LT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_panic] = ACTIONS(35),
    [anon_sym_case] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_assert] = ACTIONS(41),
    [anon_sym_use] = ACTIONS(43),
    [anon_sym_BANG] = ACTIONS(45),
    [sym_visibility_modifier] = ACTIONS(47),
    [sym_opacity_modifier] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [sym_float] = ACTIONS(53),
    [sym__hex] = ACTIONS(55),
    [sym__decimal] = ACTIONS(57),
    [sym__octal] = ACTIONS(55),
    [sym__binary] = ACTIONS(55),
    [sym__name] = ACTIONS(59),
    [sym__upname] = ACTIONS(61),
  },
  [4] = {
    [aux_sym__statement_seq] = STATE(4),
    [sym__statement] = STATE(533),
    [sym__expression] = STATE(113),
    [sym_binary_expression] = STATE(113),
    [sym__expression_unit] = STATE(113),
    [sym_record] = STATE(75),
    [sym_todo] = STATE(113),
    [sym_panic] = STATE(113),
    [sym_tuple] = STATE(74),
    [sym_list] = STATE(113),
    [sym__expression_bit_string] = STATE(113),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(533),
    [sym_let] = STATE(533),
    [sym_use] = STATE(533),
    [sym_assert] = STATE(113),
    [sym_boolean_negation] = STATE(113),
    [sym_integer_negation] = STATE(113),
    [sym_record_update] = STATE(75),
    [sym__maybe_tuple_expression] = STATE(1507),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1506),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1368),
    [sym_function_call] = STATE(36),
    [sym_string] = STATE(113),
    [sym_integer] = STATE(113),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(148),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_LBRACE] = ACTIONS(152),
    [anon_sym_AT] = ACTIONS(148),
    [anon_sym_import] = ACTIONS(150),
    [anon_sym_type] = ACTIONS(150),
    [anon_sym_const] = ACTIONS(150),
    [anon_sym_POUND] = ACTIONS(155),
    [anon_sym_LBRACK] = ACTIONS(158),
    [anon_sym_LT_LT] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(164),
    [anon_sym_fn] = ACTIONS(167),
    [anon_sym_external] = ACTIONS(150),
    [anon_sym_todo] = ACTIONS(170),
    [anon_sym_panic] = ACTIONS(173),
    [anon_sym_case] = ACTIONS(176),
    [anon_sym_let] = ACTIONS(179),
    [anon_sym_assert] = ACTIONS(182),
    [anon_sym_use] = ACTIONS(185),
    [anon_sym_BANG] = ACTIONS(188),
    [sym_visibility_modifier] = ACTIONS(150),
    [sym_opacity_modifier] = ACTIONS(150),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_float] = ACTIONS(194),
    [sym__hex] = ACTIONS(197),
    [sym__decimal] = ACTIONS(200),
    [sym__octal] = ACTIONS(197),
    [sym__binary] = ACTIONS(197),
    [sym__name] = ACTIONS(203),
    [sym__upname] = ACTIONS(206),
  },
  [5] = {
    [aux_sym__statement_seq] = STATE(4),
    [sym__statement] = STATE(533),
    [sym__expression] = STATE(113),
    [sym_binary_expression] = STATE(113),
    [sym__expression_unit] = STATE(113),
    [sym_record] = STATE(75),
    [sym_todo] = STATE(113),
    [sym_panic] = STATE(113),
    [sym_tuple] = STATE(74),
    [sym_list] = STATE(113),
    [sym__expression_bit_string] = STATE(113),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(533),
    [sym_let] = STATE(533),
    [sym_use] = STATE(533),
    [sym_assert] = STATE(113),
    [sym_boolean_negation] = STATE(113),
    [sym_integer_negation] = STATE(113),
    [sym_record_update] = STATE(75),
    [sym__maybe_tuple_expression] = STATE(1507),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1506),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1368),
    [sym_function_call] = STATE(36),
    [sym_string] = STATE(113),
    [sym_integer] = STATE(113),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(209),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(211),
    [anon_sym_LBRACE] = ACTIONS(213),
    [anon_sym_AT] = ACTIONS(209),
    [anon_sym_import] = ACTIONS(211),
    [anon_sym_type] = ACTIONS(211),
    [anon_sym_const] = ACTIONS(211),
    [anon_sym_POUND] = ACTIONS(216),
    [anon_sym_LBRACK] = ACTIONS(219),
    [anon_sym_LT_LT] = ACTIONS(222),
    [anon_sym_DASH] = ACTIONS(225),
    [anon_sym_fn] = ACTIONS(228),
    [anon_sym_external] = ACTIONS(211),
    [anon_sym_todo] = ACTIONS(231),
    [anon_sym_panic] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(237),
    [anon_sym_let] = ACTIONS(240),
    [anon_sym_assert] = ACTIONS(243),
    [anon_sym_use] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(249),
    [sym_visibility_modifier] = ACTIONS(211),
    [sym_opacity_modifier] = ACTIONS(211),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_float] = ACTIONS(255),
    [sym__hex] = ACTIONS(258),
    [sym__decimal] = ACTIONS(261),
    [sym__octal] = ACTIONS(258),
    [sym__binary] = ACTIONS(258),
    [sym__name] = ACTIONS(264),
    [sym__upname] = ACTIONS(267),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(274), 1,
      anon_sym_LPAREN,
    STATE(79), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(272), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(270), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [71] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(278), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(276), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [137] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_RBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [263] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(322), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(320), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [329] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(324), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [455] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(326), 1,
      anon_sym_RBRACE,
    STATE(56), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [581] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(328), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [707] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(332), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(330), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [773] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(336), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(334), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [839] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(338), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [965] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(342), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(340), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1031] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(350), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(346), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(344), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1101] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(352), 1,
      anon_sym_RBRACE,
    STATE(15), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1227] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(354), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1353] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(356), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1479] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(358), 1,
      anon_sym_RBRACE,
    STATE(22), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1605] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(360), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1731] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(362), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1857] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(364), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1983] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(366), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2049] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(370), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2175] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(374), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(372), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2241] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(378), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(376), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2307] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(382), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(380), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2373] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(384), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2499] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(388), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(386), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2565] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(390), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2691] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(392), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2817] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(148), 1,
      anon_sym_RBRACE,
    ACTIONS(394), 1,
      anon_sym_LBRACE,
    ACTIONS(397), 1,
      anon_sym_POUND,
    ACTIONS(400), 1,
      anon_sym_LBRACK,
    ACTIONS(403), 1,
      anon_sym_LT_LT,
    ACTIONS(406), 1,
      anon_sym_DASH,
    ACTIONS(409), 1,
      anon_sym_fn,
    ACTIONS(412), 1,
      anon_sym_todo,
    ACTIONS(415), 1,
      anon_sym_panic,
    ACTIONS(418), 1,
      anon_sym_case,
    ACTIONS(421), 1,
      anon_sym_let,
    ACTIONS(424), 1,
      anon_sym_assert,
    ACTIONS(427), 1,
      anon_sym_use,
    ACTIONS(430), 1,
      anon_sym_BANG,
    ACTIONS(433), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      sym_float,
    ACTIONS(442), 1,
      sym__decimal,
    ACTIONS(445), 1,
      sym__name,
    ACTIONS(448), 1,
      sym__upname,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(439), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2943] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(451), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3069] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(453), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3139] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(464), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(462), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3205] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(466), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3331] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(468), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3457] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(453), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3527] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(474), 1,
      anon_sym_RBRACE,
    STATE(43), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3653] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(476), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3779] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(478), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3905] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(480), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4031] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(484), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(482), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4097] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(486), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4223] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(490), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(488), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4289] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(492), 1,
      anon_sym_RBRACE,
    STATE(33), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4415] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(494), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4541] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(496), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4607] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(500), 1,
      anon_sym_RBRACE,
    STATE(39), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4733] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(502), 1,
      anon_sym_RBRACE,
    STATE(54), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4859] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(504), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4985] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(506), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5111] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(508), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5177] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(512), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5303] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(514), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5369] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(12), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5492] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(520), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(518), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5557] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(32), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5680] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(524), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(522), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5745] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(23), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5868] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(26), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5991] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(53), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6114] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(526), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6179] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(8), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6302] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(44), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6425] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(24), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6548] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(10), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6671] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(530), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6736] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(49), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6859] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(378), 20,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(376), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6924] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(453), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6991] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(534), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(453), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7058] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(453), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7125] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(30), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7248] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(38), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7371] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(46), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7494] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(540), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(538), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7559] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(546), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(544), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(542), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7626] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7749] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(550), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(548), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7814] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(300), 1,
      anon_sym_let,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(304), 1,
      anon_sym_use,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym_float,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    STATE(19), 1,
      aux_sym__statement_seq,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(805), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(339), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7937] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(554), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(552), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8002] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(558), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(556), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8067] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(563), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(560), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8131] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(568), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(566), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8195] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(570), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(572), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8273] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(590), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(588), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8337] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(594), 1,
      anon_sym_RPAREN,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(610), 1,
      anon_sym_DOT_DOT,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1234), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8463] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(632), 1,
      anon_sym_RPAREN,
    ACTIONS(634), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1185), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8589] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(570), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(572), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8669] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(570), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(572), 21,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8741] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(638), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(570), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(572), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8823] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(570), 23,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(572), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8891] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(640), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8955] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(572), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(570), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9019] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(646), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(644), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9083] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(570), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(572), 21,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9157] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(638), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(648), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(650), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9241] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(638), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(654), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(656), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9325] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(638), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(658), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(660), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9409] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(664), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(662), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9473] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(666), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9537] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(670), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9601] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(676), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(674), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9665] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(638), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(678), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(680), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9749] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(682), 1,
      anon_sym_RPAREN,
    ACTIONS(684), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1216), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [9875] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(686), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9939] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(692), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(690), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10003] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(694), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10067] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(698), 1,
      anon_sym_RPAREN,
    ACTIONS(700), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1140), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10193] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(638), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(702), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(704), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10277] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(708), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(706), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10341] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(712), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(710), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10405] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(716), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(714), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10469] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(638), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(718), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(720), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10553] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(722), 1,
      anon_sym_RPAREN,
    ACTIONS(724), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1251), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10679] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(728), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(726), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10743] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(732), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(730), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10807] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(736), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(734), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10871] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_GT,
    ACTIONS(638), 1,
      anon_sym_AMP_AMP,
    ACTIONS(652), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(576), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(584), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(636), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(578), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(580), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(586), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(738), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(740), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10955] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(742), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11078] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(698), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1140), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11201] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(744), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11324] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(746), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11447] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(748), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11570] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(382), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(380), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11633] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(374), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(372), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11696] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(750), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11819] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(752), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11942] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12065] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(594), 1,
      anon_sym_RPAREN,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1234), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12188] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(756), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12311] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(758), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12434] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(514), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12497] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12620] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(722), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1251), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12743] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(632), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1185), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12866] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(278), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(276), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12929] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(682), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1216), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13052] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(762), 1,
      anon_sym_LPAREN,
    STATE(173), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(272), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(270), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13118] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(620), 1,
      sym_float,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1303), 1,
      sym_argument,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1347), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1534), 1,
      sym_label,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(728), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13238] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(322), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(320), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13299] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(568), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(566), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13360] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(490), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(488), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13421] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(388), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(386), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13482] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(496), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13543] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(484), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(482), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13604] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(508), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13665] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(640), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13726] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(336), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(334), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13787] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(332), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(330), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13848] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(464), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(462), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13909] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(453), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13974] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(453), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14039] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(342), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(340), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14100] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(520), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(518), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14160] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(534), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(453), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14222] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(524), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(522), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14282] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(626), 1,
      sym__discard_name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(768), 1,
      sym_float,
    ACTIONS(770), 1,
      sym__name,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1386), 1,
      sym_hole,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(701), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14396] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(772), 1,
      anon_sym_RBRACK,
    ACTIONS(774), 1,
      anon_sym_DOT_DOT,
    ACTIONS(776), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14510] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(778), 1,
      anon_sym_RBRACK,
    ACTIONS(780), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14624] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(782), 1,
      anon_sym_RBRACK,
    ACTIONS(784), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14738] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(558), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(556), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14798] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(786), 1,
      anon_sym_RBRACK,
    ACTIONS(788), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14912] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(790), 1,
      anon_sym_RBRACK,
    ACTIONS(792), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15026] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(453), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15088] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(550), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(548), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15148] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(794), 1,
      anon_sym_RBRACK,
    ACTIONS(796), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15262] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(798), 1,
      anon_sym_RBRACK,
    ACTIONS(800), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15376] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(453), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15438] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(540), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(538), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15498] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(554), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(552), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15558] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(802), 1,
      anon_sym_RBRACK,
    ACTIONS(804), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15672] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(806), 1,
      anon_sym_RBRACK,
    ACTIONS(808), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15786] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(530), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15846] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(810), 1,
      anon_sym_RBRACK,
    ACTIONS(812), 1,
      anon_sym_DOT_DOT,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15960] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(526), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16020] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(716), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(714), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16079] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(814), 1,
      anon_sym_RBRACK,
    ACTIONS(816), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(629), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16190] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(686), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16249] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(818), 1,
      anon_sym_RBRACK,
    ACTIONS(820), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(635), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16360] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(736), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(734), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16419] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(822), 1,
      anon_sym_RPAREN,
    ACTIONS(824), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(675), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16530] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(826), 1,
      anon_sym_RBRACK,
    ACTIONS(828), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(633), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16641] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(830), 1,
      anon_sym_RPAREN,
    ACTIONS(832), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(685), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16752] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(834), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16863] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(836), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1503), 1,
      sym_case_subjects,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(690), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16974] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(836), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1462), 1,
      sym_case_subjects,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(690), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17085] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(838), 1,
      anon_sym_RPAREN,
    ACTIONS(840), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(698), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17196] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(842), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17307] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(836), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1514), 1,
      sym_case_subjects,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(690), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17418] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(836), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1445), 1,
      sym_case_subjects,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(690), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17529] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(844), 1,
      anon_sym_RPAREN,
    ACTIONS(846), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(689), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17640] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(848), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17751] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(712), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(710), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17810] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(728), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(726), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17869] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(850), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17980] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(836), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1491), 1,
      sym_case_subjects,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(690), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18091] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(852), 1,
      anon_sym_RBRACK,
    ACTIONS(854), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(642), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18202] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(732), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(730), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18261] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(708), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(706), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18320] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(856), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18431] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(858), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18542] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(860), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18653] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(862), 1,
      anon_sym_RPAREN,
    ACTIONS(864), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(682), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18764] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(664), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(662), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18823] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(692), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(690), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18882] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(694), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18941] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(676), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(674), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19000] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(670), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19059] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(563), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(560), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19118] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(666), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19177] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(646), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(644), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19236] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(866), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19347] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(868), 1,
      anon_sym_RBRACK,
    ACTIONS(870), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19458] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(590), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(588), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19517] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(872), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19628] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(874), 1,
      anon_sym_RPAREN,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19739] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(876), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(336), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19847] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(878), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(511), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19955] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(904), 1,
      sym_float,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(748), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20063] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(914), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(758), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20171] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(916), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(734), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20279] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(918), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(730), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20387] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(920), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(737), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20495] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(922), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(741), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20603] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(924), 1,
      anon_sym_GT_GT,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20715] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(936), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(779), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20823] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(938), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(765), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20931] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(940), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(348), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21039] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(942), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(787), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21147] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(944), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(780), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21255] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(946), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1233), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21367] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(972), 1,
      sym_float,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(398), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21475] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(982), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(419), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21583] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(984), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(350), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21691] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(986), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(349), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21799] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(988), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(346), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21907] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(990), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(752), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22015] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(992), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(327), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22123] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(994), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(326), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22231] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(996), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(341), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22339] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(998), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22451] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1000), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(775), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22559] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(1002), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(344), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22667] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1004), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(785), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22775] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1006), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(731), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22883] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(1008), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(335), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22991] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(1010), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(331), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23099] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(1012), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(771), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23207] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(1014), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(773), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23315] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    ACTIONS(1018), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(346), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(344), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23377] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1020), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(776), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23485] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1022), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(393), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23593] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1024), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(394), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23701] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1026), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23813] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1028), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(733), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23921] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1030), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(736), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24029] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1032), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24141] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1034), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(755), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24249] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1038), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(101), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24357] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1040), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1264), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24469] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1042), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(93), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24577] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(760), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24685] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(1046), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(333), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24793] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1048), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(749), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24901] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1050), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(99), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25009] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1052), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(416), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25117] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1054), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(415), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25225] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1056), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(414), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25333] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1058), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(413), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25441] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1060), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(412), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25549] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1062), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(391), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25657] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1064), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(410), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25765] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1066), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(778), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25873] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1068), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(88), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25981] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1070), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(392), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26089] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1072), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(407), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26197] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1074), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(784), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26305] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(1076), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26413] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1079), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(100), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26521] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(1081), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(337), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26629] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1083), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26741] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1085), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(92), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26849] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1087), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(94), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26957] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1089), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(95), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27065] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    ACTIONS(1091), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27173] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1094), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(97), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27281] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1096), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27389] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1098), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27501] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1100), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(508), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27609] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1102), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(491), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27717] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(1104), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(788), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27825] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1106), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(489), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27933] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1108), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(521), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28041] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(1110), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(770), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28149] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1112), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(520), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28257] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1114), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(719), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28365] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1116), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(519), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28473] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1118), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1166), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28585] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1120), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28697] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1122), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1195), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28809] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1124), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(107), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28917] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1126), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(102), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29025] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1128), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(757), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29133] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1130), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(492), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29241] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(776), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(623), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29349] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1132), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(766), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29457] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1134), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(514), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29565] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1136), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(122), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29673] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1138), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1203), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29785] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1140), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(777), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29893] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1142), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(761), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30001] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1144), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30113] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(1146), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(769), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30221] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1148), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(502), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30329] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(366), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30387] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1150), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(117), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30495] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1152), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(768), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30603] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1154), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30715] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    ACTIONS(1156), 1,
      anon_sym_GT_GT,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30827] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(934), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1389), 1,
      sym_expression_bit_string_segment,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1165), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30936] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1158), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(544), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(542), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30995] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(570), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31069] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(572), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(570), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31125] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(1178), 1,
      sym_float,
    ACTIONS(1182), 1,
      sym__decimal,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1180), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(214), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31231] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1184), 1,
      sym_float,
    ACTIONS(1188), 1,
      sym__decimal,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1186), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(403), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31337] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(948), 1,
      anon_sym_LBRACE,
    ACTIONS(950), 1,
      anon_sym_POUND,
    ACTIONS(952), 1,
      anon_sym_LBRACK,
    ACTIONS(954), 1,
      anon_sym_LT_LT,
    ACTIONS(956), 1,
      anon_sym_DASH,
    ACTIONS(958), 1,
      anon_sym_fn,
    ACTIONS(960), 1,
      anon_sym_todo,
    ACTIONS(962), 1,
      anon_sym_panic,
    ACTIONS(964), 1,
      anon_sym_case,
    ACTIONS(966), 1,
      anon_sym_assert,
    ACTIONS(968), 1,
      anon_sym_BANG,
    ACTIONS(970), 1,
      anon_sym_DQUOTE,
    ACTIONS(976), 1,
      sym__decimal,
    ACTIONS(978), 1,
      sym__name,
    ACTIONS(980), 1,
      sym__upname,
    ACTIONS(1190), 1,
      sym_float,
    STATE(372), 1,
      sym_identifier,
    STATE(380), 1,
      sym_tuple,
    STATE(381), 1,
      sym_anonymous_function,
    STATE(1375), 1,
      sym__maybe_function_expression,
    STATE(1458), 1,
      sym__maybe_tuple_expression,
    STATE(1501), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(359), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(382), 2,
      sym_record,
      sym_record_update,
    ACTIONS(974), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(361), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(399), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31443] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 14,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(570), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31507] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1192), 1,
      sym_float,
    ACTIONS(1196), 1,
      sym__decimal,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1194), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(104), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31613] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1198), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(720), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(718), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31689] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(1200), 1,
      sym_float,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(751), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31795] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 14,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(570), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31861] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 16,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(570), 22,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31921] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1198), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(740), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(738), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31997] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(290), 1,
      anon_sym_DASH,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_todo,
    ACTIONS(296), 1,
      anon_sym_panic,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(302), 1,
      anon_sym_assert,
    ACTIONS(306), 1,
      anon_sym_BANG,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(1202), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1457), 1,
      sym__maybe_tuple_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(218), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32103] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1198), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(704), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(702), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32179] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1204), 1,
      sym_float,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(487), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32285] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(570), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32357] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(314), 1,
      sym__decimal,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(1202), 1,
      sym_float,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(312), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(218), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32463] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(880), 1,
      anon_sym_LBRACE,
    ACTIONS(882), 1,
      anon_sym_POUND,
    ACTIONS(884), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LT_LT,
    ACTIONS(888), 1,
      anon_sym_DASH,
    ACTIONS(890), 1,
      anon_sym_fn,
    ACTIONS(892), 1,
      anon_sym_todo,
    ACTIONS(894), 1,
      anon_sym_panic,
    ACTIONS(896), 1,
      anon_sym_case,
    ACTIONS(898), 1,
      anon_sym_assert,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(1206), 1,
      sym_float,
    ACTIONS(1210), 1,
      sym__decimal,
    STATE(694), 1,
      sym_identifier,
    STATE(714), 1,
      sym_tuple,
    STATE(716), 1,
      sym_anonymous_function,
    STATE(1416), 1,
      sym__maybe_function_expression,
    STATE(1453), 1,
      sym__maybe_tuple_expression,
    STATE(1512), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(638), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(713), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1208), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(699), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(744), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32569] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(570), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32639] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(280), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_POUND,
    ACTIONS(286), 1,
      anon_sym_LBRACK,
    ACTIONS(288), 1,
      anon_sym_LT_LT,
    ACTIONS(292), 1,
      anon_sym_fn,
    ACTIONS(298), 1,
      anon_sym_case,
    ACTIONS(308), 1,
      anon_sym_DQUOTE,
    ACTIONS(316), 1,
      sym__name,
    ACTIONS(318), 1,
      sym__upname,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(926), 1,
      anon_sym_DASH,
    ACTIONS(928), 1,
      anon_sym_todo,
    ACTIONS(930), 1,
      anon_sym_assert,
    ACTIONS(932), 1,
      anon_sym_BANG,
    ACTIONS(1178), 1,
      sym_float,
    ACTIONS(1182), 1,
      sym__decimal,
    STATE(156), 1,
      sym_identifier,
    STATE(159), 1,
      sym_tuple,
    STATE(168), 1,
      sym_anonymous_function,
    STATE(1420), 1,
      sym__maybe_function_expression,
    STATE(1460), 1,
      sym__maybe_record_expression,
    STATE(1502), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(142), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(172), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1180), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(155), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(214), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32745] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1198), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(658), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32821] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1036), 1,
      anon_sym_fn,
    ACTIONS(1212), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(74), 1,
      sym_tuple,
    STATE(1368), 1,
      sym__maybe_function_expression,
    STATE(1506), 1,
      sym__maybe_record_expression,
    STATE(1507), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(75), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(89), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32927] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1198), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(680), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(678), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33003] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1198), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(648), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33079] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1164), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1172), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1198), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1160), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1162), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1166), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1174), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1168), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1170), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1176), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(656), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(654), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33155] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_LT_LT,
    ACTIONS(602), 1,
      anon_sym_DASH,
    ACTIONS(604), 1,
      anon_sym_fn,
    ACTIONS(606), 1,
      anon_sym_todo,
    ACTIONS(608), 1,
      anon_sym_panic,
    ACTIONS(612), 1,
      anon_sym_case,
    ACTIONS(614), 1,
      anon_sym_assert,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1214), 1,
      sym_float,
    ACTIONS(1218), 1,
      sym__decimal,
    STATE(441), 1,
      sym_identifier,
    STATE(443), 1,
      sym_tuple,
    STATE(452), 1,
      sym_anonymous_function,
    STATE(1333), 1,
      sym__maybe_function_expression,
    STATE(1489), 1,
      sym__maybe_record_expression,
    STATE(1539), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(423), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(446), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1216), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(437), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(485), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33261] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(374), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(372), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33316] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(378), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(376), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33371] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(382), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(380), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33426] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(514), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33481] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(278), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(276), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33534] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(640), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33587] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(568), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(566), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33640] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1220), 1,
      anon_sym_LPAREN,
    STATE(387), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(272), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(270), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33695] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(322), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(320), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33745] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(459), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(453), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33799] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(382), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(380), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33849] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(378), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(376), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33899] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(374), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(372), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33949] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(278), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(276), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33999] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1222), 1,
      anon_sym_LPAREN,
    ACTIONS(1224), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(346), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(344), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34053] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(332), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(330), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34103] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(336), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(334), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34153] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(464), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(462), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34203] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(484), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(482), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34253] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(388), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(386), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34303] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(1226), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(453), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34357] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(514), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34407] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(342), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(340), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34457] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(366), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34507] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(508), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34557] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(496), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34607] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(490), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(488), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34657] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(520), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(518), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34706] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(534), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(453), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34757] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(453), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34808] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(453), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34859] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(558), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(556), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34908] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(530), 26,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34957] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(554), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(552), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35006] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(526), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35055] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(540), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(538), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35104] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(550), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(548), 26,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35153] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(524), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(522), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35202] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1230), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(544), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(542), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35253] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 9,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(570), 21,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35305] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(650), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(648), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35373] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1254), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1252), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35441] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(720), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(718), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35509] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(732), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(730), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35557] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(568), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(566), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35605] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(640), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35653] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1258), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1256), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35721] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(590), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(588), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35769] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(676), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(674), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35817] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(670), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35865] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(563), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(560), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35913] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(666), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35961] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(646), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(644), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36009] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(728), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(726), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36057] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(712), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(710), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36105] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(656), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(654), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36173] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(664), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(662), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36221] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(708), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(706), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36269] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(572), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(570), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36317] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(736), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(734), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36365] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(572), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(570), 11,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36431] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(572), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(570), 12,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36495] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(572), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(570), 14,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36557] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(570), 18,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36615] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(570), 19,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36671] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(686), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36719] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(694), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36767] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1238), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1240), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1248), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1232), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1236), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1242), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1250), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(680), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1234), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1244), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1246), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(678), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36835] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(716), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(714), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36883] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(692), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(690), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36931] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1264), 1,
      anon_sym_SLASH,
    STATE(422), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1260), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1262), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36981] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1267), 1,
      anon_sym_LPAREN,
    STATE(448), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(272), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(270), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37031] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1273), 1,
      anon_sym_SLASH,
    STATE(425), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1269), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1271), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37081] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1273), 1,
      anon_sym_SLASH,
    STATE(422), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1275), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1277), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37131] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(490), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(488), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37176] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(366), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37221] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(322), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(320), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37266] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1283), 1,
      anon_sym_LPAREN,
    STATE(470), 1,
      sym_type_parameters,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1279), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1281), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37315] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(484), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(482), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37360] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(496), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37405] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(336), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(334), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37450] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(332), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(330), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37495] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(508), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37540] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1285), 1,
      anon_sym_LPAREN,
    ACTIONS(1287), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(346), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(344), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37589] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(464), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(462), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37634] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(1289), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(453), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37683] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1260), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1262), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37728] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(342), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(340), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37773] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(388), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(386), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37818] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(1292), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(453), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37867] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(554), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(552), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37911] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1296), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(453), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37957] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1302), 1,
      anon_sym_LPAREN,
    STATE(578), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1298), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1300), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38005] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1308), 1,
      anon_sym_LPAREN,
    STATE(581), 1,
      sym_type_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1304), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1306), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38053] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1310), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(453), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38099] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(526), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38143] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(540), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(538), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38187] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1312), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(544), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(542), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38233] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(524), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(522), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38277] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(550), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(548), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38321] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(457), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(455), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(453), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38367] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(520), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(518), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38411] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1314), 15,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1316), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38455] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1318), 1,
      anon_sym_RBRACE,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1326), 1,
      anon_sym_DASH,
    ACTIONS(1328), 1,
      anon_sym_DQUOTE,
    ACTIONS(1330), 1,
      sym_float,
    ACTIONS(1334), 1,
      sym__decimal,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1338), 1,
      sym__name,
    ACTIONS(1340), 1,
      sym__upname,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(980), 1,
      sym_identifier,
    STATE(1013), 1,
      sym_string,
    STATE(1073), 1,
      sym__pattern,
    STATE(1132), 1,
      sym_case_clause_pattern,
    STATE(1174), 1,
      sym_case_clause_patterns,
    STATE(1456), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(515), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1332), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [38539] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1326), 1,
      anon_sym_DASH,
    ACTIONS(1328), 1,
      anon_sym_DQUOTE,
    ACTIONS(1330), 1,
      sym_float,
    ACTIONS(1334), 1,
      sym__decimal,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1338), 1,
      sym__name,
    ACTIONS(1340), 1,
      sym__upname,
    ACTIONS(1342), 1,
      anon_sym_RBRACE,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(980), 1,
      sym_identifier,
    STATE(1013), 1,
      sym_string,
    STATE(1073), 1,
      sym__pattern,
    STATE(1132), 1,
      sym_case_clause_pattern,
    STATE(1174), 1,
      sym_case_clause_patterns,
    STATE(1526), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(515), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1332), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [38623] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1344), 15,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1346), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38667] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1326), 1,
      anon_sym_DASH,
    ACTIONS(1328), 1,
      anon_sym_DQUOTE,
    ACTIONS(1330), 1,
      sym_float,
    ACTIONS(1334), 1,
      sym__decimal,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1338), 1,
      sym__name,
    ACTIONS(1340), 1,
      sym__upname,
    ACTIONS(1348), 1,
      anon_sym_RBRACE,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(980), 1,
      sym_identifier,
    STATE(1013), 1,
      sym_string,
    STATE(1073), 1,
      sym__pattern,
    STATE(1132), 1,
      sym_case_clause_pattern,
    STATE(1174), 1,
      sym_case_clause_patterns,
    STATE(1471), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(515), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1332), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [38751] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1326), 1,
      anon_sym_DASH,
    ACTIONS(1328), 1,
      anon_sym_DQUOTE,
    ACTIONS(1330), 1,
      sym_float,
    ACTIONS(1334), 1,
      sym__decimal,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1338), 1,
      sym__name,
    ACTIONS(1340), 1,
      sym__upname,
    ACTIONS(1350), 1,
      anon_sym_RBRACE,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(980), 1,
      sym_identifier,
    STATE(1013), 1,
      sym_string,
    STATE(1073), 1,
      sym__pattern,
    STATE(1132), 1,
      sym_case_clause_pattern,
    STATE(1174), 1,
      sym_case_clause_patterns,
    STATE(1442), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(515), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1332), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [38835] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(530), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38879] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(558), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(556), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38923] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1326), 1,
      anon_sym_DASH,
    ACTIONS(1328), 1,
      anon_sym_DQUOTE,
    ACTIONS(1330), 1,
      sym_float,
    ACTIONS(1334), 1,
      sym__decimal,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1338), 1,
      sym__name,
    ACTIONS(1340), 1,
      sym__upname,
    ACTIONS(1352), 1,
      anon_sym_RBRACE,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(980), 1,
      sym_identifier,
    STATE(1013), 1,
      sym_string,
    STATE(1073), 1,
      sym__pattern,
    STATE(1132), 1,
      sym_case_clause_pattern,
    STATE(1174), 1,
      sym_case_clause_patterns,
    STATE(1529), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(515), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1332), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [39007] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1358), 1,
      anon_sym_DOT,
    ACTIONS(1360), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1354), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1356), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39055] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1362), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DASH_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1364), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39098] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1366), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DASH_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1368), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39141] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1374), 1,
      anon_sym_size,
    ACTIONS(1380), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1370), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1291), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [39198] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1382), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1384), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39241] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1374), 1,
      anon_sym_size,
    ACTIONS(1380), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1386), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1291), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [39298] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1388), 1,
      anon_sym_RPAREN,
    ACTIONS(1390), 1,
      anon_sym_DASH,
    ACTIONS(1392), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1394), 1,
      sym_float,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(966), 1,
      sym_identifier,
    STATE(1003), 1,
      sym_string,
    STATE(1137), 1,
      sym__pattern,
    STATE(1173), 1,
      sym_record_pattern_argument,
    STATE(1436), 1,
      sym_label,
    STATE(1452), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(981), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [39381] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1396), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1398), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39424] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1380), 1,
      anon_sym_unit,
    ACTIONS(1402), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1400), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1238), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [39481] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1404), 1,
      anon_sym_RBRACE,
    ACTIONS(1406), 1,
      anon_sym_POUND,
    ACTIONS(1409), 1,
      anon_sym_LBRACK,
    ACTIONS(1412), 1,
      anon_sym_LT_LT,
    ACTIONS(1415), 1,
      anon_sym_DASH,
    ACTIONS(1418), 1,
      anon_sym_DQUOTE,
    ACTIONS(1421), 1,
      sym_float,
    ACTIONS(1427), 1,
      sym__decimal,
    ACTIONS(1430), 1,
      sym__discard_name,
    ACTIONS(1433), 1,
      sym__name,
    ACTIONS(1436), 1,
      sym__upname,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(980), 1,
      sym_identifier,
    STATE(1013), 1,
      sym_string,
    STATE(1073), 1,
      sym__pattern,
    STATE(1132), 1,
      sym_case_clause_pattern,
    STATE(1174), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(472), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1424), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [39562] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1439), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DASH_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1441), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39605] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1447), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1443), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1445), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39650] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1380), 1,
      anon_sym_unit,
    ACTIONS(1451), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1449), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1167), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [39707] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1453), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1455), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39750] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1457), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1459), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39793] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1461), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1463), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39836] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1465), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1467), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39879] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1469), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1471), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39922] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(676), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(674), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39965] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(670), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40008] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(563), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(560), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40051] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1477), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1473), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1475), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40096] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(666), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40139] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(646), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(644), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40182] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(590), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(588), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40225] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(736), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(734), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40268] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(572), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
    ACTIONS(570), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DOT_DOT,
  [40315] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(686), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40358] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(572), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(570), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40401] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1485), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1489), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1491), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1493), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(678), 8,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [40462] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(716), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(714), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40505] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(376), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1499), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1501), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40550] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(732), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(730), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40593] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(664), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(662), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40636] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1507), 1,
      anon_sym_LBRACE,
    ACTIONS(1509), 1,
      anon_sym_EQ,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1503), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1505), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40683] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1511), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1513), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40726] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1519), 1,
      anon_sym_LBRACE,
    ACTIONS(1521), 1,
      anon_sym_DASH_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1515), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1517), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40773] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1523), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1525), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40816] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1390), 1,
      anon_sym_DASH,
    ACTIONS(1392), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1394), 1,
      sym_float,
    ACTIONS(1527), 1,
      anon_sym_RPAREN,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(966), 1,
      sym_identifier,
    STATE(1003), 1,
      sym_string,
    STATE(1137), 1,
      sym__pattern,
    STATE(1173), 1,
      sym_record_pattern_argument,
    STATE(1436), 1,
      sym_label,
    STATE(1517), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(981), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [40899] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1485), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1489), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1491), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1493), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(718), 8,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [40960] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1533), 1,
      anon_sym_LBRACE,
    ACTIONS(1535), 1,
      anon_sym_EQ,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1529), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1531), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41007] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(708), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(706), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41050] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(694), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41093] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(692), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(690), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41136] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1380), 1,
      anon_sym_unit,
    ACTIONS(1402), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1537), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1238), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41193] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1485), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1489), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1491), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1493), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(648), 8,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [41254] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1485), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1489), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1491), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1493), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(654), 8,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [41315] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(628), 1,
      sym__name,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1390), 1,
      anon_sym_DASH,
    ACTIONS(1392), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1394), 1,
      sym_float,
    ACTIONS(1539), 1,
      anon_sym_RPAREN,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(966), 1,
      sym_identifier,
    STATE(1003), 1,
      sym_string,
    STATE(1072), 1,
      sym_record_pattern_argument,
    STATE(1137), 1,
      sym__pattern,
    STATE(1436), 1,
      sym_label,
    STATE(1444), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(981), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [41398] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(572), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(570), 17,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DOT_DOT,
  [41449] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(712), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(710), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41492] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1541), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DASH_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1543), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41535] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1495), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(572), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(570), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DOT_DOT,
  [41588] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1320), 1,
      anon_sym_POUND,
    ACTIONS(1322), 1,
      anon_sym_LBRACK,
    ACTIONS(1324), 1,
      anon_sym_LT_LT,
    ACTIONS(1326), 1,
      anon_sym_DASH,
    ACTIONS(1328), 1,
      anon_sym_DQUOTE,
    ACTIONS(1330), 1,
      sym_float,
    ACTIONS(1334), 1,
      sym__decimal,
    ACTIONS(1336), 1,
      sym__discard_name,
    ACTIONS(1338), 1,
      sym__name,
    ACTIONS(1340), 1,
      sym__upname,
    ACTIONS(1545), 1,
      anon_sym_RBRACE,
    STATE(911), 1,
      sym__pattern_binary_expression,
    STATE(980), 1,
      sym_identifier,
    STATE(1013), 1,
      sym_string,
    STATE(1073), 1,
      sym__pattern,
    STATE(1132), 1,
      sym_case_clause_pattern,
    STATE(1174), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(472), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(828), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1332), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1032), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [41669] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1551), 1,
      anon_sym_LBRACE,
    ACTIONS(1553), 1,
      anon_sym_DASH_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1547), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1549), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41716] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1380), 1,
      anon_sym_unit,
    ACTIONS(1451), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1555), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1167), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41773] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(728), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(726), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41816] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1495), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1491), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1493), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(570), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DOT_DOT,
  [41871] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1495), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1489), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1491), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1493), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(570), 10,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DOT_DOT,
  [41928] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1479), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1483), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1489), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1497), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1481), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1491), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1493), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(570), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_DOT,
  [41987] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1557), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1559), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42029] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1561), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1563), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42071] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1565), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1567), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42113] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1569), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1571), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42155] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1573), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1575), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42197] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1577), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1579), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42239] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1581), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1583), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42281] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1585), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1587), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42323] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1589), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1591), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42365] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1593), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1595), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42407] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1597), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1599), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42449] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1601), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1603), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42491] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1605), 1,
      anon_sym_LBRACE,
    ACTIONS(1607), 1,
      anon_sym_POUND,
    ACTIONS(1609), 1,
      anon_sym_LBRACK,
    ACTIONS(1611), 1,
      anon_sym_LT_LT,
    ACTIONS(1613), 1,
      anon_sym_DASH,
    ACTIONS(1615), 1,
      sym_float,
    STATE(844), 1,
      sym_identifier,
    STATE(857), 1,
      sym__case_clause_tuple_access,
    STATE(879), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(613), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(858), 11,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_boolean_negation,
      sym_string,
      sym_integer,
  [42563] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1617), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1619), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42605] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1621), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1623), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42647] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1380), 1,
      anon_sym_unit,
    ACTIONS(1451), 1,
      anon_sym_size,
    STATE(1384), 1,
      sym_expression_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1124), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [42703] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1605), 1,
      anon_sym_LBRACE,
    ACTIONS(1607), 1,
      anon_sym_POUND,
    ACTIONS(1609), 1,
      anon_sym_LBRACK,
    ACTIONS(1611), 1,
      anon_sym_LT_LT,
    ACTIONS(1613), 1,
      anon_sym_DASH,
    ACTIONS(1625), 1,
      sym_float,
    STATE(844), 1,
      sym_identifier,
    STATE(857), 1,
      sym__case_clause_tuple_access,
    STATE(879), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(613), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(898), 11,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_boolean_negation,
      sym_string,
      sym_integer,
  [42775] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1627), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1629), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42817] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1605), 1,
      anon_sym_LBRACE,
    ACTIONS(1607), 1,
      anon_sym_POUND,
    ACTIONS(1609), 1,
      anon_sym_LBRACK,
    ACTIONS(1611), 1,
      anon_sym_LT_LT,
    ACTIONS(1613), 1,
      anon_sym_DASH,
    ACTIONS(1631), 1,
      sym_float,
    STATE(844), 1,
      sym_identifier,
    STATE(857), 1,
      sym__case_clause_tuple_access,
    STATE(879), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(613), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(899), 11,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_boolean_negation,
      sym_string,
      sym_integer,
  [42889] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1633), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1635), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42931] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1605), 1,
      anon_sym_LBRACE,
    ACTIONS(1607), 1,
      anon_sym_POUND,
    ACTIONS(1609), 1,
      anon_sym_LBRACK,
    ACTIONS(1611), 1,
      anon_sym_LT_LT,
    ACTIONS(1613), 1,
      anon_sym_DASH,
    ACTIONS(1637), 1,
      sym_float,
    STATE(844), 1,
      sym_identifier,
    STATE(857), 1,
      sym__case_clause_tuple_access,
    STATE(879), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(613), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(901), 11,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_boolean_negation,
      sym_string,
      sym_integer,
  [43003] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1639), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1641), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43045] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1643), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1645), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43087] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1647), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1649), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43129] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1380), 1,
      anon_sym_unit,
    ACTIONS(1402), 1,
      anon_sym_size,
    STATE(1313), 1,
      sym_pattern_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1095), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [43185] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1651), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1653), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43227] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1655), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1657), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43269] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 9,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_PIPE,
    ACTIONS(366), 21,
      anon_sym_if,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_as,
      anon_sym_DASH_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
  [43311] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1659), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1661), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43353] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(1372), 1,
      anon_sym_DASH,
    ACTIONS(1374), 1,
      anon_sym_size,
    ACTIONS(1380), 1,
      anon_sym_unit,
    STATE(1430), 1,
      sym_constant_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1378), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1128), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1376), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [43409] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(616), 1,
      anon_sym_BANG,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
    ACTIONS(624), 1,
      sym__decimal,
    ACTIONS(630), 1,
      sym__upname,
    ACTIONS(770), 1,
      sym__name,
    ACTIONS(1605), 1,
      anon_sym_LBRACE,
    ACTIONS(1607), 1,
      anon_sym_POUND,
    ACTIONS(1609), 1,
      anon_sym_LBRACK,
    ACTIONS(1611), 1,
      anon_sym_LT_LT,
    ACTIONS(1613), 1,
      anon_sym_DASH,
    ACTIONS(1663), 1,
      sym_float,
    STATE(844), 1,
      sym_identifier,
    STATE(857), 1,
      sym__case_clause_tuple_access,
    STATE(879), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(613), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(622), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(938), 11,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_boolean_negation,
      sym_string,
      sym_integer,
  [43481] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1665), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1667), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43523] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1669), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1671), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43565] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1503), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1505), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43607] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1673), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1675), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43649] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1679), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43691] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1681), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1683), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43733] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(900), 1,
      anon_sym_BANG,
    ACTIONS(902), 1,
      anon_sym_DQUOTE,
    ACTIONS(908), 1,
      sym__decimal,
    ACTIONS(910), 1,
      sym__name,
    ACTIONS(912), 1,
      sym__upname,
    ACTIONS(1326), 1,
      anon_sym_DASH,
    ACTIONS(1605), 1,
      anon_sym_LBRACE,
    ACTIONS(1607), 1,
      anon_sym_POUND,
    ACTIONS(1609), 1,
      anon_sym_LBRACK,
    ACTIONS(1611), 1,
      anon_sym_LT_LT,
    ACTIONS(1615), 1,
      sym_float,
    STATE(857), 1,
      sym__case_clause_tuple_access,
    STATE(879), 1,
      sym__case_clause_guard_binary_expression,
    STATE(894), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(613), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(906), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(858), 11,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_gu