// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// REQUIRES: amdgpu-registered-target

// RUN: %clang_cc1 -fopenmp -fopenmp-target-fast -fno-openmp-target-big-jump-loop -fopenmp-target-ignore-env-vars -x c++ -std=c++11 -fopenmp-version=50 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -fopenmp-target-fast -fno-openmp-target-big-jump-loop -fopenmp-target-ignore-env-vars -x c++ -std=c++11 -fopenmp-version=50 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s
// expected-no-diagnostics

int main()
{
  const int N = 10;

  double arr[N*N];

#pragma omp target teams distribute parallel for collapse(2)
  for (int j = 0; j < N; j++) {
    for (int i = j; i < N; i++) {
      arr[j * N + i]++;
    }
  }

  return 0;
}
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l14
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(800) [[ARR:%.*]], i64 noundef [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[ARR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[J:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTLB_MIN:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTLB_MAX:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTMIN_LESS_MAX:%.*]] = alloca i8, align 1, addrspace(5)
// CHECK-NEXT:    [[DOTLOWER:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[ARR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[ARR_ADDR]] to ptr
// CHECK-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// CHECK-NEXT:    [[J_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTLB_MIN_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTLB_MIN]] to ptr
// CHECK-NEXT:    [[DOTLB_MAX_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTLB_MAX]] to ptr
// CHECK-NEXT:    [[DOTMIN_LESS_MAX_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTMIN_LESS_MAX]] to ptr
// CHECK-NEXT:    [[DOTLOWER_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTLOWER]] to ptr
// CHECK-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[ARR]], ptr [[ARR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP1]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP2]], ptr [[DOTLB_MIN_ASCAST]], align 4
// CHECK-NEXT:    store i32 9, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP3]], ptr [[DOTLB_MAX_ASCAST]], align 4
// CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTLB_MIN_ASCAST]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTLB_MAX_ASCAST]], align 4
// CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP4]], [[TMP5]]
// CHECK-NEXT:    [[STOREDV:%.*]] = zext i1 [[CMP]] to i8
// CHECK-NEXT:    store i8 [[STOREDV]], ptr [[DOTMIN_LESS_MAX_ASCAST]], align 1
// CHECK-NEXT:    [[TMP6:%.*]] = load i8, ptr [[DOTMIN_LESS_MAX_ASCAST]], align 1
// CHECK-NEXT:    [[LOADEDV:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK-NEXT:    br i1 [[LOADEDV]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK:       cond.true:
// CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTLB_MIN_ASCAST]], align 4
// CHECK-NEXT:    br label [[COND_END:%.*]]
// CHECK:       cond.false:
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTLB_MAX_ASCAST]], align 4
// CHECK-NEXT:    br label [[COND_END]]
// CHECK:       cond.end:
// CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP7]], [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK-NEXT:    store i32 [[COND]], ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[COND]], ptr [[DOTLOWER_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTLOWER_ASCAST]], align 4
// CHECK-NEXT:    [[SUB:%.*]] = sub i32 10, [[TMP9]]
// CHECK-NEXT:    [[SUB1:%.*]] = sub i32 [[SUB]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add i32 [[SUB1]], 1
// CHECK-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK-NEXT:    [[CONV:%.*]] = zext i32 [[DIV]] to i64
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i64 10, [[CONV]]
// CHECK-NEXT:    [[SUB2:%.*]] = sub nsw i64 [[MUL]], 1
// CHECK-NEXT:    store i64 [[SUB2]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 8
// CHECK-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[TMP10:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP10]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i64 0, ptr [[DOTOMP_LB_ASCAST]], align 8
// CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 8
// CHECK-NEXT:    store i64 [[TMP11]], ptr [[DOTOMP_UB_ASCAST]], align 8
// CHECK-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTOMP_LB_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 8
// CHECK-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP14:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP15:%.*]] = add i32 [[TMP14]], [[TMP13]]
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP15]] to i64
// CHECK-NEXT:    [[TMP17:%.*]] = mul i64 [[TMP16]], 1
// CHECK-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// CHECK-NEXT:    [[TMP19:%.*]] = add i64 [[TMP17]], [[TMP18]]
// CHECK-NEXT:    store i64 [[TMP19]], ptr [[DOTOMP_IV_ASCAST]], align 8
// CHECK-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// CHECK-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTLOWER_ASCAST]], align 4
// CHECK-NEXT:    [[SUB3:%.*]] = sub i32 10, [[TMP21]]
// CHECK-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB3]], 1
// CHECK-NEXT:    [[ADD5:%.*]] = add i32 [[SUB4]], 1
// CHECK-NEXT:    [[DIV6:%.*]] = udiv i32 [[ADD5]], 1
// CHECK-NEXT:    [[MUL7:%.*]] = mul i32 1, [[DIV6]]
// CHECK-NEXT:    [[CONV8:%.*]] = zext i32 [[MUL7]] to i64
// CHECK-NEXT:    [[DIV9:%.*]] = sdiv i64 [[TMP20]], [[CONV8]]
// CHECK-NEXT:    [[MUL10:%.*]] = mul nsw i64 [[DIV9]], 1
// CHECK-NEXT:    [[ADD11:%.*]] = add nsw i64 0, [[MUL10]]
// CHECK-NEXT:    [[CONV12:%.*]] = trunc i64 [[ADD11]] to i32
// CHECK-NEXT:    store i32 [[CONV12]], ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[CONV13:%.*]] = sext i32 [[TMP22]] to i64
// CHECK-NEXT:    [[TMP23:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// CHECK-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTLOWER_ASCAST]], align 4
// CHECK-NEXT:    [[SUB14:%.*]] = sub i32 10, [[TMP25]]
// CHECK-NEXT:    [[SUB15:%.*]] = sub i32 [[SUB14]], 1
// CHECK-NEXT:    [[ADD16:%.*]] = add i32 [[SUB15]], 1
// CHECK-NEXT:    [[DIV17:%.*]] = udiv i32 [[ADD16]], 1
// CHECK-NEXT:    [[MUL18:%.*]] = mul i32 1, [[DIV17]]
// CHECK-NEXT:    [[CONV19:%.*]] = zext i32 [[MUL18]] to i64
// CHECK-NEXT:    [[DIV20:%.*]] = sdiv i64 [[TMP24]], [[CONV19]]
// CHECK-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTLOWER_ASCAST]], align 4
// CHECK-NEXT:    [[SUB21:%.*]] = sub i32 10, [[TMP26]]
// CHECK-NEXT:    [[SUB22:%.*]] = sub i32 [[SUB21]], 1
// CHECK-NEXT:    [[ADD23:%.*]] = add i32 [[SUB22]], 1
// CHECK-NEXT:    [[DIV24:%.*]] = udiv i32 [[ADD23]], 1
// CHECK-NEXT:    [[MUL25:%.*]] = mul i32 1, [[DIV24]]
// CHECK-NEXT:    [[CONV26:%.*]] = zext i32 [[MUL25]] to i64
// CHECK-NEXT:    [[MUL27:%.*]] = mul nsw i64 [[DIV20]], [[CONV26]]
// CHECK-NEXT:    [[SUB28:%.*]] = sub nsw i64 [[TMP23]], [[MUL27]]
// CHECK-NEXT:    [[MUL29:%.*]] = mul nsw i64 [[SUB28]], 1
// CHECK-NEXT:    [[ADD30:%.*]] = add nsw i64 [[CONV13]], [[MUL29]]
// CHECK-NEXT:    [[CONV31:%.*]] = trunc i64 [[ADD30]] to i32
// CHECK-NEXT:    store i32 [[CONV31]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP27:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// CHECK-NEXT:    [[TMP28:%.*]] = load i64, ptr [[DOTOMP_UB_ASCAST]], align 8
// CHECK-NEXT:    [[CMP32:%.*]] = icmp sle i64 [[TMP27]], [[TMP28]]
// CHECK-NEXT:    br i1 [[CMP32]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP29:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[CMP33:%.*]] = icmp slt i32 [[TMP29]], 10
// CHECK-NEXT:    br i1 [[CMP33]], label [[OMP_BODY_NEXT:%.*]], label [[OMP_KERNEL_DONE]]
// CHECK:       omp.body.next:
// CHECK-NEXT:    [[TMP30:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[MUL34:%.*]] = mul nsw i32 [[TMP30]], 10
// CHECK-NEXT:    [[TMP31:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[ADD35:%.*]] = add nsw i32 [[MUL34]], [[TMP31]]
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[ADD35]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x double], ptr [[TMP0]], i64 0, i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP32:%.*]] = load double, ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    [[INC:%.*]] = fadd double [[TMP32]], 1.000000e+00
// CHECK-NEXT:    store double [[INC]], ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
