---
myst:
  html_meta:
    keywords: LaTeX,documentations pour débutants
---
# Comment distinguer TeX, LaTeX, pdfTeX et pdfLaTeX ?

LaTeX n'est pas un programme indépendant. Ce n'est qu'un (énorme) jeu de macros pour TeX. Pour utiliser LaTeX, on pourrait en fait utiliser TeX, et commencer par lui faire lire avant notre document (avant le `\documentclass`) les définitions de centaines de macros. Pour des raisons d'efficacité, on utilise en fait un « format », c'est-à-dire que quand on tape `latex`, c'est le programme TeX qui est appelé, mais avec toutes les définitions de LaTeX préchargées.

Sur les installations modernes, ce premier point n'est pas exact : ce n'est pas le programme TeX mais [pdfTeX](/1_generalites/glossaire/pdftex) qui est appelé. Ce dernier est une version moderne de TeX, qui possède de nombreuses fonctionnalités supplémentaires :

- la possibilité d'écrire de droite à gauche ;
- des [fonctionnalités micro-typographiques](/3_composition/texte/paragraphes/latex_fait_des_lignes_trop_longues) ;
- la capacité de créer des liens hypertextes ;
- quelques nouvelles primitives utiles (dont `\middle` pour les [délimiteurs en mathématique](/4_domaines_specialises/mathematiques/structures/delimiteurs/ajuster_la_taille_des_delimiteurs)) ;
- et enfin la possibilité de produire un DVI ou un PDF.

Ce dernier point justifie le nom, mais le nom prête à confusion : `pdftex` sait en effet très bien produire des DVI. Ce qui va déterminer le mode de compilation, c'est le fait que vous l'appeliez :

- avec `latex`, commande équivalente à `pdftex -fmt latex (...).tex` ;
- avec `pdflatex`, commande équivalente à `pdftex -fmt latex -output-format pdf (...).tex`.

En fait, la seule commande qui lancera effectivement TeX (avec le format Plain TeX) est la commande... `tex` ! [^1] Vous pouvez vous amuser à taper `latex --version` pour vous convaincre du fait que c'est bien `pdftex` qui travaille, même en mode DVI.

```none
$ latex --version
pdfTeX 3.141592653-2.6-1.40.26 (TeX Live 2024)
kpathsea version 6.4.0
[...]
```

Quelques explications :

- 3.141592653 est le [numéro de version actuel](/1_generalites/histoire/quel_futur_pour_tex) de TeX, sur lequel est basé `pdfTeX` ;
- `pdftex` intègre les fonctionnalités d'une autre extension de TeX, eTeX (version 2.6), et son numéro de version actuel est le 1.40.26 restant ;
- `kpathsea` est une bibliothèque de recherche qui aide TeX à trouver rapidement ses fichiers dans [vos arborescences](/5_fichiers/emplacements/la_tds) `texmf`.

[^1]: la commande `etex` utilisera aussi le format Plain TeX, mais l'exécutable utilisé sera `pdftex` (avec les extensions eTeX activées), en mode de sortie DVI.

:::{sources}
<https://www.elzevir.fr/imj/latex/tips.html#moteur>
:::
