---
myst:
  html_meta:
    keywords: composition, illustrations, inclure une image, centrage, image trop grande
---

# Comment inclure une image en pleine largeur ?

Cette commande, écrite par Le TeXnicien de surface, permet d'inclure 
une image qui puisse déborder la largeur du texte. Elle tient compte 
d'une largeur et d'une hauteur maximale, à fixer, pour réduite l'image 
si nécessaire.


```{noedit}
% —————————— image pleine largeur —————————— %
% Dans le préambule
\usepackage{etoolbox}
\dimdef{\LargeurDisponible}{19cm}% à modifier en fonction des besoins
\dimdef{\HauteurDisponible}{10cm}% idem
\newbox{\limage}% nom de la boite avec laquelle on mesure les
                % dimensions de l'image

\newcommand{\CentrerImage}[1]{%
  \begingroup
  % tout se passe dans un groupe qui finit avec le \endgroup
  % essentiellement pour limiter l'effet du \centering
  % qui remplace les \hspace{} de la précédente solution
  \sbox{\limage}{\includegraphics{#1}}%
  % on a placé l'image dans la boite
  \dimdef{\LargeurImage}{\wd\limage}%
  \dimdef{\HauteurImage}{\ht\limage + \dp\limage}%
  % on calcule les dimensions grace aux macros fournies par etoolbox
  \par\noindent\centering
  % le paragraphe est centré sans retrait
  % on place une boite de largeur 0pt contenant l'image
  \makebox[0pt]{%
    \ifdimcomp{\LargeurImage}{>}{\HauteurImage}%
    {% plus large que haut, on limite à la largeur disponible
      \ifdimcomp{\LargeurImage}{>}{\LargeurDisponible}%
      % uniquement si l'image est trop large
      {\includegraphics[width=\LargeurDisponible]{#1}}%
      % sinon on garde les dimensions naturelles
      {\includegraphics{#1}}}%
    {% plus haut que large, on limite à la hauteur disponible
      \ifdimcomp{\HauteurImage}{>}{\HauteurDisponible}%
      % uniquement si l'image est trop haute
      {\includegraphics[height=\HauteurDisponible]{#1}}%
      % sinon on garde les dimensions naturelles
      {\includegraphics{#1}}}}\par
  % il faut un saut de paragraphe pour que \centering soit utile
  \endgroup}
% fin du groupe et de la macro


% Dans le texte saisi
\CentrerImage{example-image}
```

:::{todo}
Ajouter un exemple.
:::