---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symboles,  
              caractères, opérateurs mathématiques, symboles mathématiques,
              symboles spéciaux, opérateurs logiques
---

# Comment obtenir d'autres symboles mathématiques ?

LaTeX propose un grand nombre de commandes de symboles mathématiques. 
Si beaucoup d'entre elles sont données 
dans un [document très complet](texdoc:symbols-a4), cette page présente
pour sa part les plus courantes.

Bien entendu, de nombreuses extensions proposent des symboles mathématiques
supplémentaires (en plus de ceux offerts par <ctanpkg:mathtools> 
ou <ctanpkg:amsmath>) : par exemple, les extensions <ctanpkg:stmaryrd> 
et <ctanpkg:yhmath>.


Notez ici l'existence de [Detexify](https://detexify.kirelabs.org/classify.html),
outil en ligne très pratique permettant de retrouver la commande d'un symbole 
en le dessinant.


## Les opérateurs binaires

| <!-- -->               | <!-- -->                 | <!-- -->                               |
|------------------------|--------------------------|----------------------------------------|
| $\pm$       `\pm`      | $\cap$       `\cap`      | $\diamond$          `\diamond`         |
| $\mp$       `\mp`      | $\cup$       `\cup`      | $\bigtriangleup$    `\bigtriangleup`   |
| $\times$    `\times`   | $\uplus$     `\uplus`    | $\bigtriangledown$  `\bigtriangledown` |
| $\div$      `\div`     | $\sqcap$     `\sqcap`    | $\triangleleft$     `\triangleleft`    |
| $\ast$      `\ast`     | $\sqcup$     `\sqcup`    | $\triangleright$    `\triangleright`   |
| $\star$     `\star`    | $\lor$       `\lor`      | $\land$             `\land`            |
| $\dagger$   `\dagger`  | $\setminus$  `\setminus` | $\amalg$            `\amalg`           |
| $\ddagger$  `\ddagger` | $\cdot$      `\cdot`     | $\wr$               `\wr`              |
| $\lhd$      `\lhd`     | $\rhd$       `\rhd`      | $\unlhd$            `\unlhd`           |
| $\oplus$    `\oplus`   | $\ominus$    `\ominus`   | $\otimes$           `\otimes`          |
| $\oslash$   `\oslash`  | $\odot$      `\odot`     | $\bigcirc$          `\bigcirc`         |
| $\circ$     `\circ`    | $\bullet$    `\bullet`   | $\unrhd$            `\unrhd`           |


## Les opérateurs de relation

| <!-- -->                     | <!-- -->                     | <!-- -->             | <!-- -->                 |
|------------------------------|------------------------------|----------------------|--------------------------|
| $\leq$         `\leq`        | $\geq$         `\geq`        | $\equiv$   `\equiv`  | $\models$    `\models`   |
| $\prec$        `\prec`       | $\succ$        `\succ`       | $\sim$     `\sim`    | $\perp$      `\perp`     |
| $\preceq$      `\preceq`     | $\succeq$      `\succeq`     | $\simeq$   `\simeq`  | $\mid$       `\mid`      |
| $\ll$          `\ll`         | $\gg$          `\gg`         | $\asymp$   `\asymp`  | $\parallel$  `\parallel` |
| $\subset$      `\subset`     | $\supset$      `\supset`     | $\approx$  `\approx` | $\bowtie$    `\bowtie`   |
| $\subseteq$    `\subseteq`   | $\supseteq$    `\supseteq`   | $\cong$    `\cong`   | $\Join$      `\Join`     |
| $\sqsubset$    `\sqsubset`   | $\sqsupset$    `\sqsupset`   | $\neq$     `\neq`    | $\smile$     `\smile`    |
| $\sqsubseteq$  `\sqsubseteq` | $\sqsupseteq$  `\sqsupseteq` | $\doteq$   `\doteq`  | $\frown$     `\frown`    |
| $\in$          `\in`         | $\ni$          `\ni`         | $\propto$  `\propto` |                          |
| $\vdash$       `\vdash`      | $\dashv$       `\dashv`      |                      |                          |


## Autres opérateurs

| <!-- -->            | <!-- -->                | <!-- -->                  |
|---------------------|-------------------------|---------------------------|
| $\sum$ `\sum`       | $\bigcap$ `\bigcap`     | $\bigodot$ `\bigodot`     |
| $\prod$ `\prod`     | $\bigcup$ `\bigcup`     | $\bigotimes$ `\bigotimes` |
| $\coprod$ `\coprod` | $\bigsqcup$ `\bigsqcup` | $\bigoplus$ `\bigoplus`   |
| $\int$ `\int`       | $\bigvee$ `\bigvee`     | $\biguplus$ `\biguplus`   |
| $\oint$ `\oint`     | $\bigwedge$ `\bigwedge` |                           |


## Autres symboles

| <!-- -->          | <!-- -->                | <!-- -->                  | <!-- -->                      |
|-------------------|-------------------------|---------------------------|-------------------------------|
| $\aleph$ `\aleph` | $\prime$ `\prime`       | $\forall$ `\forall`       | $\infty$ `\infty`             |
| $\hbar$ `\hbar`   | $\emptyset$ `\emptyset` | $\exists$ `\exists`       | $\Box$ `\Box`                 |
| $\imath$ `\imath` | $\nabla$ `\nabla`       | $\neg$ `\neg`             | $\Diamond$ `\Diamond`         |
| $\jmath$ `\jmath` | $\surd$ `\surd`         | $\flat$ `\flat`           | $\triangle$ `\triangle`       |
| $\ell$ `\ell`     | $\top$ `\top`           | $\natural$ `\natural`     | $\clubsuit$ `\clubsuit`       |
| $\wp$ `\wp`       | $\bot$ `\bot`           | $\sharp$ `\sharp`         | $\diamondsuit$ `\diamondsuit` |
| $\Re$ `\Re`       | $\Vert$ `\Vert`         | $\backslash$ `\backslash` | $\heartsuit$ `\heartsuit`     |
| $\Im$ `\Im`       | $\angle$ `\angle`       | $\partial$ `\partial`     | $\spadesuit$ `\spadesuit`     |
| $\mho$ `\mho`     |                         |                           |                               |