---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symboles
              blackboard bold, gras de tableau, ensembles, symbole des réels
              symbole des entiers, lettres avec barres doubles
---

# Comment écrire les symboles d'ensembles ?

Jadis, dans les livres, les symboles d'ensemble étaient imprimés en gras
pour qu'on les voie bien :

> $\mathbf{R}$ est l'ensemble des réels,        $\mathbf{N}$ celui des entiers.

**Problème :** comment obtenir ce type de distinction lorsque l'on écrit 
sur un tableau noir ? En fait, au lieu d'écraser la craie avec force 
sur le tableau pour élargir le trait, on a pris l'habitude de doubler 
certaines parties des caractères : $\mathbb{R}$, $\mathbb{N}$. En retour, 
les livres se sont mis à copier l'usage des enseignants, et ont distingué 
le "gras standard" (*bold*), du "gras de tableau" (*blackboard bold*) qui est
une police de caractères à part (dessin normal à barres redoublées).


## Avec l'extension <ctanpkg:amssymb>

Les symboles mathématiques d'ensemble et bien d'autres sont disponibles 
par défaut dans les polices de 
l'[AMS](/1_generalites/glossaire/ams-tex_et_ams-latex) avec les familles 
`msam` (par exemple `msam10` pour 10pt) et `msbm` (disponibles en Type 1
dans les distributions actuelles). Pour y avoir accès, il faut utiliser 
l'extension <ctanpkg:amssymb>. 

Voici un exemple d'utilisation, avec un cas de définition de commande 
pour simplifier ce type de saisie :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amssymb}

  \newcommand{\R}{\mathbb{R}}

\begin{document}
$\mathbb{N}, \mathbb{Z}, \R, \mathbb{C}$
\end{document}
```

La commande `\mathbb` ne fonctionne que pour les lettres majuscules. 
Par ailleurs, la forme de ces caractères est considérée comme plutôt austère
(bien qu'elle ressemble à ce qu'on obtiendrait avec une craie) et rend 
ces lettres parfois peu appréciées.


## Avec les extensions <ctanpkg:mathbbol> ou <ctanpkg:bbold>

Les extensions <ctanpkg:mathbbol> et <ctanpkg:bbold> permettent d'obtenir
des lettres minuscules, et même d'autres symboles. La police est cependant
visuellement différente des polices mathématiques usuelles : elle ressemble
à une *Futura* vraiment doublée par endroit, pas détourée. L'exemple ci-dessous
illustre ce point et montre également qu'il faut utiliser la commande `\mathbb`
(comme pour les fontes AMS). C'est d'ailleurs le cas pour <ctanpkg:mathbbol>
comme pour <ctanpkg:mathbbol>.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathbbol}

\begin{document}
\[  \mathbb{N, Z, R, C, a, b, c, 1, 2, 3}  \]
\end{document}
```

Cette police, créée avec MetaFont, n'est pas disponible en format T1.


## Avec l'extension <ctanpkg:bbm> 

L'extension <ctanpkg:bbm> propose certaines variantes pour les polices
*Computer Modern*. Ces symboles correspondent davantage à ceux utilisés
au tableau en France. Les caractères s'obtiennent 
avec la commande `\mathbbm` :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{bbm}

\begin{document}
\[  \mathbbm{N, Z, R, C, a, b, c}  \]
\end{document}
```

Cette police, créée avec MetaFont, n'est pas disponible en format T1.


## Avec l'extension <ctanpkg:doublestroke>

L'extension <ctanpkg:doublestroke> propose des symboles 
correspondant à ceux utilisés en France au format T1 et est donc bien adapté
pour la création de fichier PDF de qualité. Toutes les majuscules 
sont présentes ainsi que le `1`, le `h` et le `k`.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{dsfont}

\begin{document}
\[  \mathds{N, Z, R, C}  \]
\end{document}
```

Un document permet de comparer l'apparence des différentes polices citées 
ci-dessus : <ctanpkg:blackboard>.


## Avec l'extension <ctanpkg:boondox>

L'ensemble de polices <ctanpkg:boondox> consiste en des formats T1 
des [polices STIX mathématiques](wp:STIX_Fonts_project). Cet ensemble contient
une fonte *BOONDOXDoubleStruck-Regular* et sa version grasse (cette dernière 
s'obtenant avec `\mathbbb`).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{BOONDOX-ds}

\begin{document}
\[  \mathbb{N, Z, R, C, a, b, c, 1, 2, 3}  \]
\[  \mathbbb{N, Z, R, C, a, b, c, 1, 2, 3}  \]
\end{document}
```


## Avec des polices gratuites

Certaines des polices évoquées dans la question
"[](/5_fichiers/formats/fontes/fontes_t1_pour_les_mathematiques)" répondent 
à la demande :

- les familles `txfonts` et `pxfonts` sont fournies avec des répliques 
  de `msam` et `msbm` mais, comme indiqué par ailleurs, il y a 
  plusieurs raisons pour ne pas utiliser ces fontes. Les versions révisées
  de ces fontes, `newtx` et `newpx` sont toutefois mieux ajustées ;
- la famille `mathpazo` propose des caractères "gras de tableau" ;
- les fontes `fourier` proposent des caractères "gras de tableau" 
  pour les majuscules, le chiffre `1` et le `k`.


## Avec des polices commerciales

Les polices *Dextor outline* et *Mathematical Pi* (une sorte d’*Helvetica*
doublée par endroit) donnent accès à des caractères "doublés".


:::{sources}
- [Écrire les ensembles classiques en Latex : `\mathbb`, amsfonts et `\mathbf`](https://www.math-linux.com/latex-4/faq/latex-faq/article/ecrire-les-ensembles-classiques-en-latex-mathbb-amsfonts-et-mathbf)
- [Symbols for the number sets](faquk:FAQ-numbersets)
- [STIX font project](https://www.stixfonts.org/)
:::