# Éditeur en ligne GitLab et Markdown

::::{danger}
La présente page est un travail en cours !
::::

L'éditeur en ligne intégré à GitLab est donc une version Web et _light_ de
l’éditeur [`Visual Studio Code`](https://code.visualstudio.com). Ce dernier
fournit de puissantes fonctionnalités :

- d'édition en général ;
- d'édition de fichiers Markdown en particulier.

Nous les présentons ici car elles vous feront gagner du temps si vous contribuez
au contenu de la présente FAQ.

::::{note}
Pour vous aider à commencer à éditer des fichiers Markdown, vous pouvez utiliser
le [modèle de profil Doc
Writer](https://code.visualstudio.com/docs/editor/profiles#_doc-writer-profile-template)
pour installer des extensions utiles (vérificateur d'orthographe, linter
Markdown) et configurer paramètres appropriés.
:::{danger}
Ceci ne semble pas possible avec l'éditeur en ligne GitLab.
:::
::::

## Édition Markdown

### Structure du document

La vue "*Outline*" ("Structure") est une section distincte dans la partie
inférieure de l'explorateur de fichiers. Lorsqu'elle est développée, elle
affiche la structure (la table des matières) créée à partir des rubriques du
fichier Markdown en cours.

<!-- ![Aperçu Markdown](/_static/images/markdown/markdown-outline-view.png) -->
```{image} /_static/images/markdown/outline-dark.png
:class: only-dark
:width: 100%
:alt: Aperçu Markdown
:name: outline_dark
:align: center
```
```{image} /_static/images/markdown/outline-light.png
:class: only-light
:width: 100%
:alt: Aperçu Markdown
:name: outline_light
:align: center
```

La vue "*Outline*" est un excellent moyen d'examiner le plan de votre document.

### Fragments de code pour Markdown

L'éditeur en ligne comprend des extraits utiles qui peuvent accélérer l'écriture
de textes en Markdown. Cela inclut des fragments pour les blocs de code, les
images, et plus encore. Appuyez sur <kbd>Ctrl</kbd>+<kbd>Espace</kbd> (Trigger
Suggest) pendant l'édition pour voir une liste de fragments Markdown
suggérés. Vous pouvez également utiliser le sélecteur de fragments dédié en
sélectionnant **Insert Snippet** dans la palette de commandes.

<!-- >**Vous pouvez ajouter vos propres snippets définis par l'utilisateur pour
Markdown. Jetez un coup d'œil à [User Defined
Snippets](/docs/editor/userdefinedsnippets.md) pour découvrir comment. -->

### Atteindre une rubrique du fichier

Utilisez <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>O</kbd> ou  ou <kbd>Ctrl</kbd>+<kbd>P</kbd>
<kbd>@</kbd> pour atteindre rapidement une rubrique du fichier en cours.

![Atteindre une rubrique dans un fichier
Markdown](/_static/images/markdown/go-to-symbol.png)

Vous pouvez parcourir toutes les rubriques du fichier ou commencer à taper un titre
de rubrique pour trouver celui que vous cherchez. Une fois que vous avez trouvé
la rubrique que vous voulez, appuyez sur <kbd>Entrée</kbd> pour déplacer votre
curseur jusqu'à lui. Appuyez sur <kbd>Échap</kbd> pour annuler le saut vers
la rubrique.

### Atteindre une rubrique de l'espace de travail

Utilisez <kbd>Ctrl</kbd>+<kbd>T</kbd> ou <kbd>Ctrl</kbd>+<kbd>P</kbd>
<kbd>#</kbd> pour rechercher les rubriques dans tous les fichiers Markdown de
l'espace de travail en cours.

![Atteindre une rubrique dans tous les fichiers Markdown d'un espace de travail](/_static/images/markdown/go-to-symbol-in-workspace.png)

Commencez à taper un titre de rubrique pour filtrer la liste et trouver la
rubrique que vous recherchez.

### Complétions de chemins

Les complétions de chemins permettent de créer des liens vers des fichiers et
des images. Ces chemins sont affichés automatiquement lorsque vous tapez le
chemin d'une image ou d'un lien, et peuvent également être demandés manuellement
en utilisant <kbd>Ctrl</kbd>+<kbd>Espace</kbd>.

![Complétions de chemin dans un lien
Markdown](/_static/images/markdown/path-completions.png)

Les chemins commençant par `/` sont résolus par rapport à la racine de l'espace
de travail actuel, tandis que les chemins commençant par `./` ou sans préfixe
sont résolus par rapport au fichier actuel. Il est aussi possible de visiter les
réperoires parents au moyen de `../`. Les suggestions de chemin sont
automatiquement affichées lorsque vous tapez `/` ou peuvent être invoquées
manuellement en utilisant <kbd>Ctrl</kbd>+<kbd>Espace</kbd>.

Les complétions de chemins peuvent aussi vous aider à relier des rubriques au
sein du fichier courant ou dans un autre fichier Markdown. Commencez le chemin
par `#` pour voir les complétions pour tous les rubriques dans le fichier (selon
le paramétrage, vous devrez peut-être utiliser <kbd>Ctrl</kbd>+<kbd>Espace</kbd>
pour les voir) :

![Suggestions de sections de rubrique dans un lien
Markdown](/_static/images/markdown/path-completions-header.png)

<!-- Vous pouvez désactiver l'IntelliSense des chemins avec `"markdown.suggest.paths.enabled" : false`. -->

### Créer des liens vers une rubrique dans un autre fichier

:::{danger}
Ceci semble ne pas fonctionner dans l'éditeur en ligne GitLab.
:::

Vous avez besoin de créer un lien vers une rubrique dans un autre document
Markdown, mais vous ne vous souvenez pas ou ne voulez pas taper le chemin
complet du fichier ? Essayez d'utiliser les complétions de rubrique de l'espace
de travail ! Pour commencer, il suffit de taper `##` dans un lien Markdown pour
obtenir une liste de tous les rubriques Markdown de l'espace de travail actuel :

![Suggestions pour tous les rubriques Markdown de l'espace de travail
actuel](/_static/images/markdown/md-workspace-header-suggestion.png)

Acceptez l'une de ces complétions pour insérer le lien complet vers cette
rubrique, même s'il se trouve dans un autre fichier :

![Ajouter un lien vers la rubrique sélectionné dans un autre
fichier](/_static/images/markdown/md-workspace-header-suggestion-insert.png)

Vous pouvez configurer si/quand les complétions de la rubrique de l'espace de
travail s'affichent avec le paramètre
`markdown.suggest.paths.includeWorkspaceHeaderCompletions`. Les valeurs valides
sont :

* `onDoubleHash` (par défaut) - Affiche les complétions de la rubrique de
  l'espace de travail seulement après que vous ayez tapé `##`.
* `onSingleOrDoubleHash` - Affiche les complétions de la rubrique de l'espace de
  travail après que vous ayez tapé `#` ou `##`.
* `never` - Ne jamais afficher les complétions de rubrique de l'espace de
  travail.

Gardez à l'esprit que la recherche de tous les rubriques dans l'espace de
travail actuel peut être coûteuse, il peut donc y avoir un léger retard la
première fois qu'ils sont demandés, en particulier pour les espaces de travail
avec beaucoup de fichiers Markdown.

### Insérer des images et des liens vers des fichiers

En plus de la [complétion de chemin](#complétions-de-chemins), l'éditeur en ligne
supporte également quelques autres façons d'insérer des images et des liens vers
des fichiers dans vos documents Markdown.

:::{only} latex
[Vous pouvez
**glisser-déposer**](https://code.visualstudio.com/assets/docs/languages/Markdown/drop-link.gif)
un fichier depuis l'explorateur de l'éditeur en ligne ou depuis votre système d'exploitation dans l'éditeur.
:::

:::{only} not latex
Vous pouvez **glisser-déposer** un fichier depuis l'explorateur de l'éditeur en
ligne ou depuis votre système d'exploitation dans l'éditeur.
:::

Commencez par faire glisser un fichier depuis l'explorateur de l'éditeur en
ligne sur votre code Markdown, puis maintenez enfoncé <kbd>Shift</kbd> pour
commencer à le déposer dans le fichier. Le curseur de prévisualisation montre
l'endroit où il sera inséré lorsque vous le déposez.

:::{only} not latex
![Insertion d'un lien Markdown par glisser-déposer depuis
l'explorateur](/_static/images/markdown/drop-link.gif)
:::

Si vous préférez utiliser le clavier, vous pouvez également **copier et coller**
un fichier ou une image dans un éditeur Markdown.

:::{danger}
Le copier-coller d'images semble ne pas fonctionner dans l'éditeur en ligne GitLab.
:::

Vous pouvez également utiliser la commande **Markdown : Insérer une image
à partir de l'espace de travail** pour insérer des images et **Markdown :
Insérer un lien vers un fichier dans l'espace de travail** pour insérer des
liens vers des fichiers.

:::{danger}
Ces commandes semblent introuvables dans l'éditeur en ligne GitLab.
:::

Les images insérées utilisent la syntaxe d'image Markdown
` ![](path/to/image.png)`. Les liens insèrent un lien Markdown normal
`[](path/to/file.md)`.

<!-- Par défaut, l'éditeur en ligne copie automatiquement les images déposées ou -->
<!-- collées en dehors de l'espace de travail dans votre espace de travail. Le -->
<!-- paramètre `markdown.copyFiles.destination` contrôle l'endroit où le nouveau -->
<!-- fichier image doit être créé. Ce paramètre associe les -->
<!-- [globs](/docs/editor/glob-patterns.md) qui correspondent au document Markdown -->
<!-- actuel aux destinations des images. Les destinations des images peuvent -->
<!-- également utiliser des variables simples. Voir la description du paramètre -->
<!-- `markdown.copyFiles.destination` pour plus d'informations sur les variables -->
<!-- disponibles. -->
<!--  -->
<!-- Par exemple, si nous voulons que chaque fichier Markdown sous `/docs` dans notre -->
<!-- espace de travail place les nouveaux fichiers média dans un répertoire `images` -->
<!-- spécifique au fichier courant, nous pouvons écrire : -->
<!--  -->
<!-- ``jsonc -->
<!-- "markdown.copyFiles.destination" : { -->
<!--   "/docs/**/*" : "images/${documentBaseName}/" -->
<!-- } -->
<!-- ``` -->
<!--  -->
<!-- Maintenant, lorsqu'un nouveau fichier est collé dans `/docs/api/readme.md`, le -->
<!-- fichier image est créé dans `/docs/api/images/readme/image.png`.  -->
<!--  -->
<!-- Vous pouvez même utiliser de simples expressions régulières pour transformer des -->
<!-- variables d'une manière [similaire aux snippets] -->
<!-- (/docs/editor/userdefinedsnippets.md#variable-transforms). Par exemple, cette -->
<!-- transformation n'utilise que la première lettre du nom du fichier du document -->
<!-- lors de la création du fichier média :  -->
<!--  -->
<!-- ``jsonc -->
<!-- "markdown.copyFiles.destination" : { -->
<!--   "/docs/**/*" : "images/${documentBaseName/(.).*/$1/}/" -->
<!-- } -->
<!-- ``` -->
<!--  -->
<!-- Lorsqu'un nouveau fichier est collé dans `/docs/api/readme.md`, l'image est -->
<!-- maintenant créée dans `/docs/api/images/r/image.png`. -->

### Sélection intelligente

La sélection intelligente vous permet d'étendre et de réduire rapidement la
sélection dans les documents Markdown. Cela peut être utilisé pour sélectionner
rapidement des éléments de bloc entiers (tels que des codes ou des tableaux) et
pour sélectionner tout le contenu d'une section de rubrique dans le fichier
Markdown.

La sélection intelligente utilise les commandes suivantes :

:Développer: <kbd>Shift</kbd>+<kbd>Alt</kbd>+<kbd>Right</kbd>
:Réduire: <kbd>Shift</kbd>+<kbd>Alt</kbd>+<kbd>Left</kbd>

La sélection s'applique aux éléments suivants et suit un modèle hiérarchique
traditionnel :

* rubriques ;
* listes ;
* blocs de guillemets ;
* blocs de code clôturés ;
* blocs de code html ;
* paragraphes.

:::{only} not latex
![La sélection intelligente dans un document Markdown s'étend d'un élément de
bloc à l'élément de bloc qui le contient, au reste du contenu sous une rubrique,
à la rubrique lui-même](/_static/images/markdown/smart-select.gif)
:::

:::{only} latex
[La sélection intelligente dans un document Markdown s'étend d'un élément de
bloc à l'élément de bloc qui le contient, au reste du contenu sous une rubrique,
à la rubrique lui-même](https://code.visualstudio.com/assets/docs/languages/Markdown/smart-select.gif)
:::

### Validation des liens

:::{danger}
La validation des liens semble ne pas fonctionner dans l'éditeur en ligne GitLab.
:::

La validation des liens vérifie les liens locaux dans votre code Markdown pour
s'assurer qu'ils sont valides. Cela permet de détecter des erreurs courantes,
telles que l'établissement d'un lien vers une rubrique qui a été renommé ou vers
un fichier qui n'existe plus sur le disque.

![Avertissement affiché dans l'éditeur en cas de lien vers un fichier qui
n'existe pas](/_static/images/markdown/link-validation.png)

La validation des liens est désactivée par défaut. Pour l'activer, il suffit de
définir `"markdown.validate.enabled": true` : l'éditeur en ligne analysera alors
les liens Markdown vers les rubriques, les images et les autres fichiers
locaux. Les liens invalides seront signalés comme des avertissements ou des
erreurs. Toute la validation des liens se fait localement et il n'y a pas de
vérification des liens http(s) externes.

Il y a quelques paramètres que vous pouvez utiliser pour personnaliser la validation des liens :

* `markdown.validate.fileLinks.enabled` - Active/désactive la validation des
  liens vers les fichiers locaux : `[link](/path/to/file.md)`
* `markdown.validate.fragmentLinks.enabled` - Active/désactive la validation des
  liens vers les rubriques du fichier courant : `[link](#some-header)`
* `markdown.validate.fileLinks.markdownFragmentLinks` - Active/désactive la
  validation des liens vers les rubriques de l'autre fichier markdown :
  `[link](other-file.md#some-header)`
* `markdown.validate.referenceLinks.enabled` - Active/désactive la validation
  des liens de référence : `[link][ref]`.
* `markdown.validate.ignoredLinks` - Une liste de globs de liens qui ne sont pas
  validés. Ceci est utile si vous créez des liens vers des fichiers qui
  n'existent pas sur le disque mais qui existent une fois que le texte Markdown
  a été publié.

### Trouver toutes les références aux rubriques et aux liens

Utilisez la commande **Find All References**
(<kbd>Shift</kbd>+<kbd>Alt</kbd>+<kbd>F12</kbd>) pour trouver tous les emplacements dans
l'espace de travail actuel où une rubrique ou un lien Markdown est référencé :

![Sauter à une rubrique dans un fichier Markdown](/_static/images/markdown/find-all-references.png)

La commande **Find All References** est supportée pour :

* rubriques : `# Ma rubrique`. Affiche tous les liens vers `#ma-rubrique` ;
* liens externes : `[texte](https://example.com)`. Affiche tous les liens vers
  `https://example.com` ;
* liens internes : `[text](./path/to/file.md)`. Affiche tous les liens vers
  `./path/to/file.md` ;
* fragments dans les liens : `[text](./path/to/file.md#my-header)`. Affiche tous
  les liens vers `#ma-rubrique` dans `./chemin/vers/fichier.md`.

### Renommer les rubriques et les liens

Vous en avez assez de briser accidentellement des liens lorsque vous changez une
rubrique Markdown ? Essayez d'utiliser **Renommer le symbole** (<kbd>F2</kbd>)
à la place. Après avoir tapé le nouveau nom de la rubrique et appuyé sur
<kbd>Entrée</kbd>, l'éditeur en ligne mettra à jour la rubrique ainsi que tous
les liens vers cette rubrique :

:::{only} not latex
![Renommer une rubrique Markdown pour mettre à jour tous les liens vers
lui](/_static/images/markdown/rename-header.gif)
:::

:::{only} latex
[Renommer une rubrique Markdown pour mettre à jour tous les liens vers
lui](https://code.visualstudio.com/assets/docs/languages/Markdown/rename-header.gif)
:::

Vous pouvez aussi utiliser <kbd>F2</kbd> sur :

* rubriques : `# Ma rubrique`. Cela mettra à jour tous les liens vers `#ma-rubrique`.
* Les liens externes : `[texte](http://example.com/page)`. Ceci mettra à jour
  tous les endroits qui ont un lien vers `http://example.com/page`
* Liens internes : `[text](./path/to/file.md)`. Cela renommera le fichier
  `./path/to/file.md` et mettra à jour tous les liens vers ce fichier.
* Fragments dans les liens : `[text](./path/to/file.md#my-header)`. Cela
  renommera la rubrique dans `./path/to/file.md` et mettra également à jour tous
  les liens vers lui.

### Mise à jour automatique des liens lors d'un déplacement ou d'un renommage de fichier

Avec la mise à jour automatique des liens Markdown, l'éditeur en ligne mettra
automatiquement à jour les liens Markdown chaque fois qu'un fichier lié est
déplacé ou renommé. Vous pouvez activer cette fonctionnalité avec le paramètre
`markdown.updateLinksOnFileMove.enabled`. Les valeurs valides sont :

* `never` (par défaut) - Ne pas essayer de mettre à jour les liens
  automatiquement.
* `prompt` - Confirmer avant de mettre à jour les liens.
* `always` - Mettre à jour les liens automatiquement sans confirmation.

La mise à jour automatique des liens détecte les renommages des fichiers
Markdown, des images et des répertoires. Vous pouvez l'activer pour d'autres
types de fichiers avec `markdown.updateLinksOnFileMove.include`.

## Aperçu Markdown

L'éditeur en ligne supporte les fichiers Markdown dès le départ. Il suffit de
commencer à écrire du texte Markdown, de sauvegarder le fichier avec l'extension
.md et de basculer la visualisation de l'éditeur entre le code et la
prévisualisation du fichier Markdown ; évidemment, vous pouvez aussi ouvrir un
fichier Markdown existant et commencer à travailler avec lui. Pour passer d'une
vue à l'autre, appuyez sur <kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>V</kbd> dans l'éditeur. Vous
pouvez voir l'aperçu côte à côte (<kbd>Ctrl</kbd>+<kbd>K</kbd> <kbd>V</kbd>) avec le
fichier que vous éditez et voir les changements reflétés en temps réel au fur et
à mesure que vous éditez.

Voici un exemple avec un fichier simple.

![Aperçu Markdown](/_static/images/markdown/preview.png)

>**Vous pouvez également faire un clic droit sur l'onglet de l'éditeur et
>sélectionner **Ouvrir un aperçu**
>(<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>V</kbd>) ou utiliser la **Palette de
>commandes** (<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>P</kbd>) pour exécuter la
>commande **Markdown : Ouvrir l'aperçu sur le côté**
>(<kbd>Ctrl</kbd>+<kbd>K</kbd> <kbd>V</kbd>).

### Prévisualisations dynamiques et verrouillage des prévisualisations

Par défaut, les aperçus Markdown sont automatiquement mis à jour pour afficher
l'aperçu du fichier Markdown actuellement actif :

:::{only} not latex
![L'aperçu bascule automatiquement pour afficher le document Markdown en
cours](/_static/images/markdown/md-dynamic-preview.gif)
:::

:::{only} latex
[L'aperçu bascule automatiquement pour afficher le document Markdown en
cours](https://code.visualstudio.com/assets/docs/languages/Markdown/md-dynamic-preview.gif)
:::

Vous pouvez verrouiller un aperçu Markdown en utilisant la commande **Markdown :
Toggle Preview Locking** pour la verrouiller sur le document Markdown en
cours. Les aperçus verrouillés sont indiqués par **[Aperçu]** dans le titre :

![Un aperçu Markdown
verrouillé](/_static/images/markdown/locked-preview-title.png)

>**Note:** La commande **Markdown : Toggle Preview Locking** n'est disponible
>que si la prévisualisation Markdown est l'onglet actif.

### Synchronisation de l'éditeur et de l'aperçu

L'éditeur en ligne synchronise automatiquement l'éditeur Markdown et les
panneaux de prévisualisation. Si vous faites défiler l'aperçu Markdown,
l'éditeur défile pour s'adapter à l'affichage de l'aperçu. Faites défiler
l'éditeur Markdown et la prévisualisation s'adapte à sa fenêtre :

:::{only} not latex
![Synchronisation du défilement de la sélection de l'éditeur de l'aperçu
Markdown](/_static/images/markdown/preview-scroll-sync.gif)
:::

:::{only} latex
[Synchronisation du défilement de la sélection de l'éditeur de l'aperçu
Markdown](/_static/images/markdown/preview-scroll-sync.gif)
:::

Vous pouvez désactiver la synchronisation du défilement en utilisant les
paramètres `markdown.preview.scrollPreviewWithEditor` et
`markdown.preview.scrollEditorWithPreview` (/docs/getstarted/settings.md).

La ligne actuellement sélectionnée dans l'éditeur est indiquée dans l'aperçu
Markdown par une barre gris clair dans la marge gauche :

![Marqueur de ligne de l'éditeur dans l'aperçu
Markdown](/_static/images/markdown/preview-selection-marker.png)

En outre, un double clic sur un élément dans l'aperçu Markdown ouvrira
automatiquement l'éditeur pour le fichier et fera défiler jusqu'à la ligne la
plus proche de l'élément cliqué.

:::{only} not latex
![Un double clic sur l'aperçu Markdown bascule vers
l'éditeur](/_static/images/markdown/double-click-preview-switch.gif)
:::

:::{only} latex
[Un double clic sur l'aperçu Markdown bascule vers
l'éditeur](/_static/images/markdown/double-click-preview-switch.gif)
:::

## Extension de l'aperçu Markdown

[Les
extensions](https://open-vsx.org/?search=markdown&category=&sortBy=relevance&sortOrder=desc)
peuvent ajouter des styles et des scripts personnalisés à l'aperçu Markdown pour
changer son apparence et ajouter de nouvelles fonctionnalités.

:::{danger} Les extensions `VSCode` ne peuvent actuellement pas être installées
dans l'éditeur en ligne GitLab.
:::

### Utiliser votre propre CSS

Vous pouvez également utiliser votre propre CSS dans l'aperçu Markdown avec le
[paramètre](https://code.visualstudio.com/docs/getstarted/settings)
`"markdown.styles": []`. Ceci répertorie les URL pour que les feuilles de style
soient chargées dans l'aperçu Markdown. Ces feuilles de style peuvent soit être
des URL « https » ou des chemins relatifs vers des fichiers locaux dans l'espace
de travail actuel.

Par exemple, pour charger une feuille de style appelée « Style.css » à la racine de votre fichier actuel
espace de travail, utilisez **Fichier** → **Préférences** → **Paramètres** pour afficher le
fichier `settings.json` de l'espace de travail et effectuez cette mise à jour :

```json
// Placez vos paramètres dans ce fichier pour écraser les paramètres par défaut et utilisateur.
{
     "markdown.styles": [
         "Style.css"
     ]
}
```

### Gardez les espaces à la fin afin de créer des sauts de ligne
Pour créer des [sauts de
ligne](https://spec.commonmark.org/0.29/#hard-line-breaks), Markdown nécessite
deux
espaces ou plus à la fin d'une ligne. Selon les paramètres de votre utilisateur
ou de votre espace de travail, l'éditeur en ligne peut être configuré pour
supprimer les espaces de fin de ligne. Afin de conserver les espaces de fin de
ligne uniquement dans les fichiers Markdown, vous pouvez ajouter ces lignes
à votre `settings.json` :

```json
{
  "[markdown]": {
    "files.trimTrailingWhitespace": false
  }
}
```

## Sécurité de l'aperçu Markdown

Pour des raisons de sécurité, l'éditeur en ligne restreint le contenu affiché
dans l'aperçu Markdown. Cela inclut la désactivation de l'exécution des scripts
et l'autorisation de charger des ressources uniquement via `https`.

Lorsque l'aperçu Markdown bloque le contenu d'une page, une fenêtre d'alerte
s'affiche dans le coin supérieur droit de la fenêtre d'aperçu :

![Alerte de sécurité Markdown](/_static/images/markdown/security-alert.png)

Vous pouvez modifier le contenu autorisé dans l'aperçu Markdown en cliquant sur
cette fenêtre contextuelle ou en exécutant la commande **Markdown : Modifier les
paramètres de sécurité de l'aperçu** dans n'importe quel fichier Markdown :

![Sélecteur de sécurité Markdown](/_static/images/markdown/security-selector.png)

Les paramètres de sécurité de l'aperçu Markdown s'appliquent à tous les fichiers
de l'espace de travail.

Voici les détails de chacun de ces niveaux de sécurité :

### Strict

Il s'agit du paramètre par défaut. Ne charge que du contenu fiable et désactive
l'exécution des scripts. Bloque les images `http`.

Il est fortement recommandé de garder la sécurité `Strict` activée à moins que
vous n'ayez une très bonne raison de la changer ET que vous fassiez confiance
à tous les fichiers Markdown dans l'espace de travail.

### Autoriser le contenu non sécurisé

Maintient les scripts désactivés mais permet au contenu d'être chargé via `http`.

### Désactiver

Désactive la sécurité supplémentaire dans la fenêtre de prévisualisation. Cela
permet l'exécution de scripts et autorise également le chargement de contenu via
`http`.

## Doc Writer profile template

Les [Profils](https://code.visualstudio.com/docs/editor/profiles) vous
permettent de changer rapidement vos extensions, vos paramètres et la
présentation de l'interface utilisateur en fonction de votre projet ou de votre
tâche en cours. Pour vous aider à démarrer avec l'édition de Markdown, vous
pouvez utiliser le [modèle de profil Doc
Writer](https://code.visualstudio.com/docs/editor/profiles#doc-writer-profile-template), qui est un profil
curaté avec des extensions et des paramètres utiles. Vous pouvez utiliser un
modèle de profil tel quel ou l'utiliser comme point de départ pour le
personnaliser davantage en fonction de vos propres flux de travail.

You select a profile template through the **Profiles** > **Create Profile...**
dropdown:

![Create Profile dropdown with profile
templates](/_static/images/markdown/profile-template-dropdown.png)

Once you select a profile template, you can review the settings and extensions,
and remove individual items if you don't want to include them in your new
Profile. After creating the new profile based on a template, changes made to
settings, extensions, or UI are persisted in your profile.

## Markdown extensions

In addition to the functionality l'éditeur en ligne provides out of the box, you
can install an extension for greater functionality.

<div class="marketplace-extensions-markdown-curated"></div>

> Tip: Select an extension tile above to read the description and reviews to
> decide which extension is best for you. See more in the
> [Marketplace](https://marketplace.visualstudio.com).

## Next steps

Read on to find out about:

* [CSS, SCSS, et Less](https://code.visualstudio.com/docs/languages/css) - Vous
  voulez éditer votre CSS ?  l'éditeur en ligne offre une excellente prise en
  charge de l'édition CSS, SCSS et Less.

## Questions courantes

### Y a-t-il un correcteur orthographique ?

Il n'est pas installé avec l'éditeur en ligne mais il existe des extensions de
correction orthographique. Consultez le [l'éditeur en ligne Marketplace]
(https://marketplace.visualstudio.com/vscode) pour trouver des extensions utiles
qui vous aideront dans votre travail.

### L'éditeur en ligne supporte-t-il le GitHub Flavored Markdown ?

Non, l'éditeur en ligne cible la spécification Markdown
[CommonMark](https://commonmark.org) en utilisant la bibliothèque
[markdown-it](https://github.com/markdown-it/markdown-it). GitHub s'oriente vers
la spécification CommonMark, ce que vous pouvez lire dans cette [mise
à jour](https://github.blog/2017-03-14-a-formal-spec-for-github-markdown/).

:::{sources}
https://code.visualstudio.com/docs/languages/markdown
:::
