/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramWriter;

public class SecretIvParameterSpec
implements AlgorithmParameterSpec,
Destroyable {
    private final byte[] iv;
    private boolean destroyed;

    public SecretIvParameterSpec(byte[] iv) {
        this(iv, 0, iv.length);
    }

    public SecretIvParameterSpec(SecretIvParameterSpec iv) {
        if (iv == null) {
            throw new NullPointerException("IV missing");
        }
        this.iv = Arrays.copyOf(iv.iv, iv.iv.length);
    }

    public SecretIvParameterSpec(byte[] iv, int offset, int length) {
        if (iv == null) {
            throw new NullPointerException("IV missing");
        }
        if (iv.length == 0) {
            throw new IllegalArgumentException("IV is empty");
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("len is negative");
        }
        if (iv.length - offset < length) {
            throw new IllegalArgumentException("Invalid offset/length combination");
        }
        this.iv = Arrays.copyOfRange(iv, offset, offset + length);
    }

    public int size() {
        return this.iv.length;
    }

    public void writeTo(DatagramWriter writer) {
        writer.writeBytes(this.iv);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        Bytes.clear((byte[])this.iv);
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

