// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package clouddirectory_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/clouddirectory"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleCloudDirectory_AddFacetToObject() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.AddFacetToObjectInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		SchemaFacet: &clouddirectory.SchemaFacet{ // Required
			FacetName: aws.String("FacetName"),
			SchemaArn: aws.String("Arn"),
		},
		ObjectAttributeList: []*clouddirectory.AttributeKeyAndValue{
			{ // Required
				Key: &clouddirectory.AttributeKey{ // Required
					FacetName: aws.String("FacetName"),     // Required
					Name:      aws.String("AttributeName"), // Required
					SchemaArn: aws.String("Arn"),           // Required
				},
				Value: &clouddirectory.TypedAttributeValue{ // Required
					BinaryValue:   []byte("PAYLOAD"),
					BooleanValue:  aws.Bool(true),
					DatetimeValue: aws.Time(time.Now()),
					NumberValue:   aws.String("NumberAttributeValue"),
					StringValue:   aws.String("StringAttributeValue"),
				},
			},
			// More values...
		},
	}
	resp, err := svc.AddFacetToObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ApplySchema() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ApplySchemaInput{
		DirectoryArn:       aws.String("Arn"), // Required
		PublishedSchemaArn: aws.String("Arn"), // Required
	}
	resp, err := svc.ApplySchema(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_AttachObject() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.AttachObjectInput{
		ChildReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		DirectoryArn: aws.String("Arn"),      // Required
		LinkName:     aws.String("LinkName"), // Required
		ParentReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.AttachObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_AttachPolicy() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.AttachPolicyInput{
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		PolicyReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		DirectoryArn: aws.String("Arn"),
	}
	resp, err := svc.AttachPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_AttachToIndex() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.AttachToIndexInput{
		DirectoryArn: aws.String("Arn"), // Required
		IndexReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		TargetReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.AttachToIndex(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_BatchRead() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.BatchReadInput{
		DirectoryArn: aws.String("Arn"), // Required
		Operations: []*clouddirectory.BatchReadOperation{ // Required
			{ // Required
				ListObjectAttributes: &clouddirectory.BatchListObjectAttributes{
					ObjectReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
					MaxResults: aws.Int64(1),
					NextToken:  aws.String("NextToken"),
				},
				ListObjectChildren: &clouddirectory.BatchListObjectChildren{
					ObjectReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
					MaxResults: aws.Int64(1),
					NextToken:  aws.String("NextToken"),
				},
			},
			// More values...
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
	}
	resp, err := svc.BatchRead(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_BatchWrite() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.BatchWriteInput{
		DirectoryArn: aws.String("Arn"), // Required
		Operations: []*clouddirectory.BatchWriteOperation{ // Required
			{ // Required
				AddFacetToObject: &clouddirectory.BatchAddFacetToObject{
					ObjectAttributeList: []*clouddirectory.AttributeKeyAndValue{ // Required
						{ // Required
							Key: &clouddirectory.AttributeKey{ // Required
								FacetName: aws.String("FacetName"),     // Required
								Name:      aws.String("AttributeName"), // Required
								SchemaArn: aws.String("Arn"),           // Required
							},
							Value: &clouddirectory.TypedAttributeValue{ // Required
								BinaryValue:   []byte("PAYLOAD"),
								BooleanValue:  aws.Bool(true),
								DatetimeValue: aws.Time(time.Now()),
								NumberValue:   aws.String("NumberAttributeValue"),
								StringValue:   aws.String("StringAttributeValue"),
							},
						},
						// More values...
					},
					ObjectReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
					SchemaFacet: &clouddirectory.SchemaFacet{ // Required
						FacetName: aws.String("FacetName"),
						SchemaArn: aws.String("Arn"),
					},
				},
				AttachObject: &clouddirectory.BatchAttachObject{
					ChildReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
					LinkName: aws.String("LinkName"), // Required
					ParentReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
				},
				CreateObject: &clouddirectory.BatchCreateObject{
					BatchReferenceName: aws.String("BatchReferenceName"), // Required
					LinkName:           aws.String("LinkName"),           // Required
					ObjectAttributeList: []*clouddirectory.AttributeKeyAndValue{ // Required
						{ // Required
							Key: &clouddirectory.AttributeKey{ // Required
								FacetName: aws.String("FacetName"),     // Required
								Name:      aws.String("AttributeName"), // Required
								SchemaArn: aws.String("Arn"),           // Required
							},
							Value: &clouddirectory.TypedAttributeValue{ // Required
								BinaryValue:   []byte("PAYLOAD"),
								BooleanValue:  aws.Bool(true),
								DatetimeValue: aws.Time(time.Now()),
								NumberValue:   aws.String("NumberAttributeValue"),
								StringValue:   aws.String("StringAttributeValue"),
							},
						},
						// More values...
					},
					ParentReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
					SchemaFacet: []*clouddirectory.SchemaFacet{ // Required
						{ // Required
							FacetName: aws.String("FacetName"),
							SchemaArn: aws.String("Arn"),
						},
						// More values...
					},
				},
				DeleteObject: &clouddirectory.BatchDeleteObject{
					ObjectReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
				},
				DetachObject: &clouddirectory.BatchDetachObject{
					BatchReferenceName: aws.String("BatchReferenceName"), // Required
					LinkName:           aws.String("LinkName"),           // Required
					ParentReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
				},
				RemoveFacetFromObject: &clouddirectory.BatchRemoveFacetFromObject{
					ObjectReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
					SchemaFacet: &clouddirectory.SchemaFacet{ // Required
						FacetName: aws.String("FacetName"),
						SchemaArn: aws.String("Arn"),
					},
				},
				UpdateObjectAttributes: &clouddirectory.BatchUpdateObjectAttributes{
					AttributeUpdates: []*clouddirectory.ObjectAttributeUpdate{ // Required
						{ // Required
							ObjectAttributeAction: &clouddirectory.ObjectAttributeAction{
								ObjectAttributeActionType: aws.String("UpdateActionType"),
								ObjectAttributeUpdateValue: &clouddirectory.TypedAttributeValue{
									BinaryValue:   []byte("PAYLOAD"),
									BooleanValue:  aws.Bool(true),
									DatetimeValue: aws.Time(time.Now()),
									NumberValue:   aws.String("NumberAttributeValue"),
									StringValue:   aws.String("StringAttributeValue"),
								},
							},
							ObjectAttributeKey: &clouddirectory.AttributeKey{
								FacetName: aws.String("FacetName"),     // Required
								Name:      aws.String("AttributeName"), // Required
								SchemaArn: aws.String("Arn"),           // Required
							},
						},
						// More values...
					},
					ObjectReference: &clouddirectory.ObjectReference{ // Required
						Selector: aws.String("SelectorObjectReference"),
					},
				},
			},
			// More values...
		},
	}
	resp, err := svc.BatchWrite(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_CreateDirectory() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.CreateDirectoryInput{
		Name:      aws.String("DirectoryName"), // Required
		SchemaArn: aws.String("Arn"),           // Required
	}
	resp, err := svc.CreateDirectory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_CreateFacet() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.CreateFacetInput{
		Name:       aws.String("FacetName"),  // Required
		ObjectType: aws.String("ObjectType"), // Required
		SchemaArn:  aws.String("Arn"),        // Required
		Attributes: []*clouddirectory.FacetAttribute{
			{ // Required
				Name: aws.String("AttributeName"), // Required
				AttributeDefinition: &clouddirectory.FacetAttributeDefinition{
					Type: aws.String("FacetAttributeType"), // Required
					DefaultValue: &clouddirectory.TypedAttributeValue{
						BinaryValue:   []byte("PAYLOAD"),
						BooleanValue:  aws.Bool(true),
						DatetimeValue: aws.Time(time.Now()),
						NumberValue:   aws.String("NumberAttributeValue"),
						StringValue:   aws.String("StringAttributeValue"),
					},
					IsImmutable: aws.Bool(true),
					Rules: map[string]*clouddirectory.Rule{
						"Key": { // Required
							Parameters: map[string]*string{
								"Key": aws.String("RuleParameterValue"), // Required
								// More values...
							},
							Type: aws.String("RuleType"),
						},
						// More values...
					},
				},
				AttributeReference: &clouddirectory.FacetAttributeReference{
					TargetAttributeName: aws.String("AttributeName"), // Required
					TargetFacetName:     aws.String("FacetName"),     // Required
				},
				RequiredBehavior: aws.String("RequiredAttributeBehavior"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateFacet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_CreateIndex() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.CreateIndexInput{
		DirectoryArn: aws.String("Arn"), // Required
		IsUnique:     aws.Bool(true),    // Required
		OrderedIndexedAttributeList: []*clouddirectory.AttributeKey{ // Required
			{ // Required
				FacetName: aws.String("FacetName"),     // Required
				Name:      aws.String("AttributeName"), // Required
				SchemaArn: aws.String("Arn"),           // Required
			},
			// More values...
		},
		LinkName: aws.String("LinkName"),
		ParentReference: &clouddirectory.ObjectReference{
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.CreateIndex(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_CreateObject() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.CreateObjectInput{
		DirectoryArn: aws.String("Arn"), // Required
		SchemaFacets: []*clouddirectory.SchemaFacet{ // Required
			{ // Required
				FacetName: aws.String("FacetName"),
				SchemaArn: aws.String("Arn"),
			},
			// More values...
		},
		LinkName: aws.String("LinkName"),
		ObjectAttributeList: []*clouddirectory.AttributeKeyAndValue{
			{ // Required
				Key: &clouddirectory.AttributeKey{ // Required
					FacetName: aws.String("FacetName"),     // Required
					Name:      aws.String("AttributeName"), // Required
					SchemaArn: aws.String("Arn"),           // Required
				},
				Value: &clouddirectory.TypedAttributeValue{ // Required
					BinaryValue:   []byte("PAYLOAD"),
					BooleanValue:  aws.Bool(true),
					DatetimeValue: aws.Time(time.Now()),
					NumberValue:   aws.String("NumberAttributeValue"),
					StringValue:   aws.String("StringAttributeValue"),
				},
			},
			// More values...
		},
		ParentReference: &clouddirectory.ObjectReference{
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.CreateObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_CreateSchema() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.CreateSchemaInput{
		Name: aws.String("SchemaName"), // Required
	}
	resp, err := svc.CreateSchema(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_DeleteDirectory() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.DeleteDirectoryInput{
		DirectoryArn: aws.String("Arn"), // Required
	}
	resp, err := svc.DeleteDirectory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_DeleteFacet() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.DeleteFacetInput{
		Name:      aws.String("FacetName"), // Required
		SchemaArn: aws.String("Arn"),       // Required
	}
	resp, err := svc.DeleteFacet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_DeleteObject() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.DeleteObjectInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.DeleteObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_DeleteSchema() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.DeleteSchemaInput{
		SchemaArn: aws.String("Arn"), // Required
	}
	resp, err := svc.DeleteSchema(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_DetachFromIndex() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.DetachFromIndexInput{
		DirectoryArn: aws.String("Arn"), // Required
		IndexReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		TargetReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.DetachFromIndex(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_DetachObject() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.DetachObjectInput{
		DirectoryArn: aws.String("Arn"),      // Required
		LinkName:     aws.String("LinkName"), // Required
		ParentReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.DetachObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_DetachPolicy() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.DetachPolicyInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		PolicyReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.DetachPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_DisableDirectory() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.DisableDirectoryInput{
		DirectoryArn: aws.String("Arn"), // Required
	}
	resp, err := svc.DisableDirectory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_EnableDirectory() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.EnableDirectoryInput{
		DirectoryArn: aws.String("Arn"), // Required
	}
	resp, err := svc.EnableDirectory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_GetDirectory() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.GetDirectoryInput{
		DirectoryArn: aws.String("DirectoryArn"), // Required
	}
	resp, err := svc.GetDirectory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_GetFacet() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.GetFacetInput{
		Name:      aws.String("FacetName"), // Required
		SchemaArn: aws.String("Arn"),       // Required
	}
	resp, err := svc.GetFacet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_GetObjectInformation() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.GetObjectInformationInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
	}
	resp, err := svc.GetObjectInformation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_GetSchemaAsJson() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.GetSchemaAsJsonInput{
		SchemaArn: aws.String("Arn"), // Required
	}
	resp, err := svc.GetSchemaAsJson(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListAppliedSchemaArns() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListAppliedSchemaArnsInput{
		DirectoryArn: aws.String("Arn"), // Required
		MaxResults:   aws.Int64(1),
		NextToken:    aws.String("NextToken"),
	}
	resp, err := svc.ListAppliedSchemaArns(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListAttachedIndices() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListAttachedIndicesInput{
		DirectoryArn: aws.String("Arn"), // Required
		TargetReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
		MaxResults:       aws.Int64(1),
		NextToken:        aws.String("NextToken"),
	}
	resp, err := svc.ListAttachedIndices(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListDevelopmentSchemaArns() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListDevelopmentSchemaArnsInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListDevelopmentSchemaArns(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListDirectories() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListDirectoriesInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
		State:      aws.String("DirectoryState"),
	}
	resp, err := svc.ListDirectories(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListFacetAttributes() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListFacetAttributesInput{
		Name:       aws.String("FacetName"), // Required
		SchemaArn:  aws.String("Arn"),       // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListFacetAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListFacetNames() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListFacetNamesInput{
		SchemaArn:  aws.String("Arn"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListFacetNames(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListIndex() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListIndexInput{
		DirectoryArn: aws.String("Arn"), // Required
		IndexReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
		MaxResults:       aws.Int64(1),
		NextToken:        aws.String("NextToken"),
		RangesOnIndexedValues: []*clouddirectory.ObjectAttributeRange{
			{ // Required
				AttributeKey: &clouddirectory.AttributeKey{
					FacetName: aws.String("FacetName"),     // Required
					Name:      aws.String("AttributeName"), // Required
					SchemaArn: aws.String("Arn"),           // Required
				},
				Range: &clouddirectory.TypedAttributeValueRange{
					EndMode:   aws.String("RangeMode"), // Required
					StartMode: aws.String("RangeMode"), // Required
					EndValue: &clouddirectory.TypedAttributeValue{
						BinaryValue:   []byte("PAYLOAD"),
						BooleanValue:  aws.Bool(true),
						DatetimeValue: aws.Time(time.Now()),
						NumberValue:   aws.String("NumberAttributeValue"),
						StringValue:   aws.String("StringAttributeValue"),
					},
					StartValue: &clouddirectory.TypedAttributeValue{
						BinaryValue:   []byte("PAYLOAD"),
						BooleanValue:  aws.Bool(true),
						DatetimeValue: aws.Time(time.Now()),
						NumberValue:   aws.String("NumberAttributeValue"),
						StringValue:   aws.String("StringAttributeValue"),
					},
				},
			},
			// More values...
		},
	}
	resp, err := svc.ListIndex(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListObjectAttributes() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListObjectAttributesInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
		MaxResults:       aws.Int64(1),
		NextToken:        aws.String("NextToken"),
	}
	resp, err := svc.ListObjectAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListObjectChildren() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListObjectChildrenInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
		MaxResults:       aws.Int64(1),
		NextToken:        aws.String("NextToken"),
	}
	resp, err := svc.ListObjectChildren(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListObjectParentPaths() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListObjectParentPathsInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListObjectParentPaths(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListObjectParents() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListObjectParentsInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
		MaxResults:       aws.Int64(1),
		NextToken:        aws.String("NextToken"),
	}
	resp, err := svc.ListObjectParents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListObjectPolicies() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListObjectPoliciesInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
		MaxResults:       aws.Int64(1),
		NextToken:        aws.String("NextToken"),
	}
	resp, err := svc.ListObjectPolicies(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListPolicyAttachments() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListPolicyAttachmentsInput{
		DirectoryArn: aws.String("Arn"), // Required
		PolicyReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		ConsistencyLevel: aws.String("ConsistencyLevel"),
		MaxResults:       aws.Int64(1),
		NextToken:        aws.String("NextToken"),
	}
	resp, err := svc.ListPolicyAttachments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListPublishedSchemaArns() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListPublishedSchemaArnsInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListPublishedSchemaArns(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_ListTagsForResource() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.ListTagsForResourceInput{
		ResourceArn: aws.String("Arn"), // Required
		MaxResults:  aws.Int64(1),
		NextToken:   aws.String("NextToken"),
	}
	resp, err := svc.ListTagsForResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_LookupPolicy() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.LookupPolicyInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.LookupPolicy(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_PublishSchema() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.PublishSchemaInput{
		DevelopmentSchemaArn: aws.String("Arn"),     // Required
		Version:              aws.String("Version"), // Required
		Name:                 aws.String("SchemaName"),
	}
	resp, err := svc.PublishSchema(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_PutSchemaFromJson() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.PutSchemaFromJsonInput{
		Document:  aws.String("SchemaJsonDocument"), // Required
		SchemaArn: aws.String("Arn"),                // Required
	}
	resp, err := svc.PutSchemaFromJson(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_RemoveFacetFromObject() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.RemoveFacetFromObjectInput{
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
		SchemaFacet: &clouddirectory.SchemaFacet{ // Required
			FacetName: aws.String("FacetName"),
			SchemaArn: aws.String("Arn"),
		},
	}
	resp, err := svc.RemoveFacetFromObject(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_TagResource() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.TagResourceInput{
		ResourceArn: aws.String("Arn"), // Required
		Tags: []*clouddirectory.Tag{ // Required
			{ // Required
				Key:   aws.String("TagKey"),
				Value: aws.String("TagValue"),
			},
			// More values...
		},
	}
	resp, err := svc.TagResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_UntagResource() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.UntagResourceInput{
		ResourceArn: aws.String("Arn"), // Required
		TagKeys: []*string{ // Required
			aws.String("TagKey"), // Required
			// More values...
		},
	}
	resp, err := svc.UntagResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_UpdateFacet() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.UpdateFacetInput{
		Name:      aws.String("FacetName"), // Required
		SchemaArn: aws.String("Arn"),       // Required
		AttributeUpdates: []*clouddirectory.FacetAttributeUpdate{
			{ // Required
				Action: aws.String("UpdateActionType"),
				Attribute: &clouddirectory.FacetAttribute{
					Name: aws.String("AttributeName"), // Required
					AttributeDefinition: &clouddirectory.FacetAttributeDefinition{
						Type: aws.String("FacetAttributeType"), // Required
						DefaultValue: &clouddirectory.TypedAttributeValue{
							BinaryValue:   []byte("PAYLOAD"),
							BooleanValue:  aws.Bool(true),
							DatetimeValue: aws.Time(time.Now()),
							NumberValue:   aws.String("NumberAttributeValue"),
							StringValue:   aws.String("StringAttributeValue"),
						},
						IsImmutable: aws.Bool(true),
						Rules: map[string]*clouddirectory.Rule{
							"Key": { // Required
								Parameters: map[string]*string{
									"Key": aws.String("RuleParameterValue"), // Required
									// More values...
								},
								Type: aws.String("RuleType"),
							},
							// More values...
						},
					},
					AttributeReference: &clouddirectory.FacetAttributeReference{
						TargetAttributeName: aws.String("AttributeName"), // Required
						TargetFacetName:     aws.String("FacetName"),     // Required
					},
					RequiredBehavior: aws.String("RequiredAttributeBehavior"),
				},
			},
			// More values...
		},
		ObjectType: aws.String("ObjectType"),
	}
	resp, err := svc.UpdateFacet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_UpdateObjectAttributes() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.UpdateObjectAttributesInput{
		AttributeUpdates: []*clouddirectory.ObjectAttributeUpdate{ // Required
			{ // Required
				ObjectAttributeAction: &clouddirectory.ObjectAttributeAction{
					ObjectAttributeActionType: aws.String("UpdateActionType"),
					ObjectAttributeUpdateValue: &clouddirectory.TypedAttributeValue{
						BinaryValue:   []byte("PAYLOAD"),
						BooleanValue:  aws.Bool(true),
						DatetimeValue: aws.Time(time.Now()),
						NumberValue:   aws.String("NumberAttributeValue"),
						StringValue:   aws.String("StringAttributeValue"),
					},
				},
				ObjectAttributeKey: &clouddirectory.AttributeKey{
					FacetName: aws.String("FacetName"),     // Required
					Name:      aws.String("AttributeName"), // Required
					SchemaArn: aws.String("Arn"),           // Required
				},
			},
			// More values...
		},
		DirectoryArn: aws.String("Arn"), // Required
		ObjectReference: &clouddirectory.ObjectReference{ // Required
			Selector: aws.String("SelectorObjectReference"),
		},
	}
	resp, err := svc.UpdateObjectAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCloudDirectory_UpdateSchema() {
	sess := session.Must(session.NewSession())

	svc := clouddirectory.New(sess)

	params := &clouddirectory.UpdateSchemaInput{
		Name:      aws.String("SchemaName"), // Required
		SchemaArn: aws.String("Arn"),        // Required
	}
	resp, err := svc.UpdateSchema(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
