# Cantera 2.0.2

Published on March 12, 2013 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v2.0.2)

Maintenance release fixing issues identified since Cantera 2.0.1.

## Fixes for regressions introduced in Cantera 2.0.x
* Fixed an indexing error in Jacobian evaluation in the 1D solver ([`3baa0eae9`](https://github.com/Cantera/cantera/commit/3baa0eae9))
* [Matlab] Fixed error reporting when importing Kinetics ([`6b569fcb2`](https://github.com/Cantera/cantera/commit/6b569fcb2))
* Fixed update logic for multicomponent diffusion coefficients ([`dd89ab12b`](https://github.com/Cantera/cantera/commit/dd89ab12b))
* [Python] Fixed an error when using a reactor heat flux function ([`83cca43a3`](https://github.com/Cantera/cantera/commit/83cca43a3))

## Fixes related to new features introduced in Cantera 2.0
* Updated libraries referenced by pkg-config ([`53891d0b2`](https://github.com/Cantera/cantera/commit/53891d0b2))([`180d5c481`](https://github.com/Cantera/cantera/commit/180d5c481))
* Fixed an incorrect bounds check in clib ([`544b638eb`](https://github.com/Cantera/cantera/commit/544b638eb))
* Fixed a bug when building without numpy ([`d75b394f6`](https://github.com/Cantera/cantera/commit/d75b394f6))
* Fixed parsing duplicate reactions with explicit reverse rate constants ([`0b4af9ac0`](https://github.com/Cantera/cantera/commit/0b4af9ac0))

## Fixes for bugs existing prior to Cantera 2.0
* [Matlab] Corrected error message in `setState_SP` ([`54e4b17aa`](https://github.com/Cantera/cantera/commit/54e4b17aa))
* [1D] Resize `StFlow::m_dthermal` after grid refinement ([`c4e62b72e`](https://github.com/Cantera/cantera/commit/c4e62b72e))
* [1D] Fixed calculation of diffusion flux due to Soret effect ([`5b423847f`](https://github.com/Cantera/cantera/commit/5b423847f))
* [1D] Fixed an uninitialized variable in `Domain1D` ([`b6a362209`](https://github.com/Cantera/cantera/commit/b6a362209))
* [1D] Fixed a case where the Newton solver could get stuck ([`80f3c9d24`](https://github.com/Cantera/cantera/commit/80f3c9d24))
* Use qualified names in `RxnRates.h` ([`7a4be4dcf`](https://github.com/Cantera/cantera/commit/7a4be4dcf))
* Fixed crashes when reaction mechanism contains no reactions ([`a25c1a43b`](https://github.com/Cantera/cantera/commit/a25c1a43b))
* Ensure that equilibrium constants are not zero ([`8847b5aba`](https://github.com/Cantera/cantera/commit/8847b5aba))
* Allow `GasKinetics` to more easily support derived classes ([`2dfc55192`](https://github.com/Cantera/cantera/commit/2dfc55192))

# Cantera 2.0.1

Published on November 18, 2012 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v2.0.1)

Maintenance release fixing issues identified since Cantera 2.0.0.

## Fixes for regressions introduced in Cantera 2.0
- Coverage dependencies were being ignored ([`f27aac85`](https://github.com/Cantera/cantera/commit/f27aac85997e397bd2ae4a9d37d19cfa39876725))
- Correctly handle rate coefficient units when converting Chemkin input files ([`b26f9f4e`](https://github.com/Cantera/cantera/commit/b26f9f4ee24fe2a8d823a2fde79aae3b33782253), [`7ef2bb13`](https://github.com/Cantera/cantera/commit/7ef2bb13e596691cbd1104d7e26c9fcee053c865))

## Fixes related to new features introduced in Cantera 2.0
- Validate p-log rate expressions ([`67395c84`](https://github.com/Cantera/cantera/commit/67395c84383c1b96b6d1743fadf3d4ab129e1598), [`16462628`](https://github.com/Cantera/cantera/commit/16462628a79ce229801d4991f35cf7d5be9b36c5))
- [SCons] Fix order of include / library directories passed to compiler ([`c092bbae`](https://github.com/Cantera/cantera/commit/c092bbaede6b93b03bd281d86a7cb972992665ed))
- [Scons] OS X does not need `blas_lapack_libs` ([`ead04df7`](https://github.com/Cantera/cantera/commit/ead04df7412034f2b5dffd9b9806b4fa31eca229))
- [SCons] fixed handling of the `FRAMEWORKS` variable ([`71156434`](https://github.com/Cantera/cantera/commit/71156434f87cf5af35bb34d11e8ea7e378b6830f))

## Fixes for bugs existing prior to Cantera 2.0
- [Python] Fixed an error when setting `FlowReactor` mass flow rate ([`1c5f7c3e`](https://github.com/Cantera/cantera/commit/1c5f7c3ed76d31412782aafb9f7d672dcc96677e))
- Fixed handling of falloff reactions with specific third bodies ([`1de94e0e`](https://github.com/Cantera/cantera/commit/1de94e0ee12dc5d95e3a904638e2abad239bb921))
- Fixed a sign error in `isothermalCompressibility` for ideal phases ([`86e7723c`](https://github.com/Cantera/cantera/commit/86e7723c264104a27e2334ab6de170227180803c))
- Ignore third body efficiencies for missing species in `ohn.cti` ([`3116653f`](https://github.com/Cantera/cantera/commit/3116653f2f0b7f41a319a688f736f63f121003aa))
- Fixed handling of explicit reaction orders for certain reactions ([`01a9bdcf`](https://github.com/Cantera/cantera/commit/01a9bdcf58438bbfb04330b48a2d2528a21c5372))
- Fixed correspondence of reactor types to integer constants used in `newReactor` ([`353fb38b`](https://github.com/Cantera/cantera/commit/353fb38b110f8c31d3ed5c2c1a9cda2beb1609dc), [`dec9c269`](https://github.com/Cantera/cantera/commit/dec9c269a1cbddef08f2024889cc7d2375bc7e75))
- Fixed a convergence failure in the VCS equilibrium solver ([`a6dc9944`](https://github.com/Cantera/cantera/commit/a6dc994439d00c038e1d5d511f67285c46606deb), [`ba7725fb`](https://github.com/Cantera/cantera/commit/ba7725fb5bc2bef69cd1927ec0c1bbc763cb103f))
