# Migration from Rivet v2 to Rivet v3

Rivet 3.x is a major new release series, in which we've made some big changes
that affect the programming interface (or "API") exposed to analysis authors.
Fear not: the changes are simple, and all beneficial to routine writers... it's
just the need for transition that's a bit unfortunate. Here is a *very* quick
guide for updating your analysis code from v2 to v3:

- The `addProjection(...)` function no longer exists: replace uses of this with `declare(...)`.
- Similarly, `applyProjection()` should now be `apply()`. Fewer characters to type: yay!
- There is also a change in the histogram-booking syntax from e.g. `_h_xxx = bookHisto1D(...)` to `book(_h_xxx, ...)`
- You should no longer attempt to access "the" event weight, since that's now done automatically and for all weights in the systematics vector: `_h_xxx->fill(x, event.weight())` becomes `_h_xxx->fill(x)`.

We recommend that anyone writing a new analysis should start by running the
`rivet-mkanalysis` script rather than directly copying an old analysis code: we
update the templates generated by the script as new API features and ideas
occur, and it always represents best-practice. You can still copy-paste chunks
from your old analysis as you need them, modulo the unavoidable API changes above.
