// Generated by tmpl
// https://github.com/benbjohnson/tmpl
//
// DO NOT EDIT!
// Source: aggregate_window.gen.go.tmpl

package universe

import (
	"github.com/apache/arrow/go/v7/arrow/memory"
	"github.com/influxdata/flux"
	"github.com/influxdata/flux/array"
)

type aggregateWindowSumInt struct {
	aggregateWindowBase
	vs *array.Int
}

func (a *aggregateWindowSumInt) Aggregate(ts *array.Int, vs array.Array, start, stop *array.Int, mem memory.Allocator) {
	b := array.NewIntBuilder(mem)
	b.Resize(stop.Len())

	// Check once if we should look for nulls in the input.
	hasNulls := vs.NullN() > 0

	values := vs.(*array.Int)
	aggregateWindows(ts, start, stop, func(i, j int) {
		var (
			sum    int64
			isNull = hasNulls
		)
		if hasNulls {
			for ; i < j; i++ {
				// If there are nulls, check if this is null.
				if values.IsNull(i) {
					continue
				}
				sum += values.Value(i)
				isNull = false
			}
		} else {
			// Skip the extra checks if we know there are no nulls.
			for ; i < j; i++ {
				sum += values.Value(i)
			}
		}

		// Append a null value if there were no valid points.
		if isNull {
			b.AppendNull()
		} else {
			b.Append(sum)
		}
	})
	result := b.NewIntArray()
	a.merge(start, stop, result, mem)
}

func (a *aggregateWindowSumInt) Merge(from aggregateWindow, mem memory.Allocator) {
	other := from.(*aggregateWindowSumInt)
	other.vs.Retain()
	a.merge(other.ts, other.ts, other.vs, mem)
}

func (a *aggregateWindowSumInt) merge(start, stop *array.Int, result *array.Int, mem memory.Allocator) {
	a.mergeWindows(start, stop, mem, func(ts, prev, next *array.Int) {
		if a.vs == nil {
			a.vs = result
			return
		}
		defer result.Release()

		merged := array.NewIntBuilder(mem)
		merged.Resize(ts.Len())
		mergeWindowValues(ts, prev, next, func(i, j int) {
			iValid := i >= 0 && a.vs.IsValid(i)
			jValid := j >= 0 && result.IsValid(j)
			if iValid && jValid {
				merged.Append(a.vs.Value(i) + result.Value(j))
			} else if iValid {
				merged.Append(a.vs.Value(i))
			} else if jValid {
				merged.Append(result.Value(j))
			} else {
				merged.AppendNull()
			}
		})
		a.vs.Release()
		a.vs = merged.NewIntArray()
	})
}

func (a *aggregateWindowSumInt) Compute(mem memory.Allocator) (*array.Int, flux.ColType, array.Array) {
	a.createEmptyWindows(mem, func(n int) (append func(i int), done func()) {
		b := array.NewIntBuilder(mem)
		b.Resize(n)

		append = func(i int) {
			if i < 0 || a.vs.IsNull(i) {
				b.AppendNull()
			} else {
				b.Append(a.vs.Value(i))
			}
		}

		done = func() {
			a.vs.Release()
			a.vs = b.NewIntArray()
		}
		return append, done
	})
	a.ts.Retain()
	a.vs.Retain()
	return a.ts, flux.TInt, a.vs
}

func (a *aggregateWindowSumInt) Close() error {
	a.release()
	if a.vs != nil {
		a.vs.Release()
		a.vs = nil
	}
	return nil
}

type aggregateWindowMeanInt struct {
	aggregateWindowBase
	counts *array.Int
	means  *array.Float
}

func (a *aggregateWindowMeanInt) Aggregate(ts *array.Int, vs array.Array, start, stop *array.Int, mem memory.Allocator) {
	countsB := array.NewIntBuilder(mem)
	countsB.Resize(stop.Len())

	meansB := array.NewFloatBuilder(mem)
	meansB.Resize(stop.Len())

	// Check once if we should look for nulls in the input.
	hasNulls := vs.NullN() > 0

	values := vs.(*array.Int)
	aggregateWindows(ts, start, stop, func(i, j int) {
		var (
			sum   int64
			count = int64(j - i)
		)
		if hasNulls {
			for ; i < j; i++ {
				if values.IsNull(i) {
					count--
					continue
				}
				sum += values.Value(i)
			}
		} else {
			for ; i < j; i++ {
				sum += values.Value(i)
			}
		}
		countsB.Append(count)
		if count > 0 {
			meansB.Append(float64(sum) / float64(count))
		} else {
			meansB.AppendNull()
		}
	})

	counts, means := countsB.NewIntArray(), meansB.NewFloatArray()
	a.merge(start, stop, counts, means, mem)
}

func (a *aggregateWindowMeanInt) Merge(from aggregateWindow, mem memory.Allocator) {
	other := from.(*aggregateWindowMeanInt)
	other.counts.Retain()
	other.means.Retain()
	a.merge(other.ts, other.ts, other.counts, other.means, mem)
}

func (a *aggregateWindowMeanInt) merge(start, stop, counts *array.Int, means *array.Float, mem memory.Allocator) {
	a.mergeWindows(start, stop, mem, func(ts, prev, next *array.Int) {
		if a.means == nil {
			a.counts, a.means = counts, means
			return
		}
		defer counts.Release()
		defer means.Release()

		mergedCounts := array.NewIntBuilder(mem)
		mergedCounts.Resize(ts.Len())
		mergedMeans := array.NewFloatBuilder(mem)
		mergedMeans.Resize(ts.Len())
		mergeWindowValues(ts, prev, next, func(i, j int) {
			iValid := i >= 0 && a.means.IsValid(i)
			jValid := j >= 0 && means.IsValid(j)
			if iValid && jValid {
				m, n := a.counts.Value(i), counts.Value(j)
				mergedCounts.Append(m + n)
				mergedMeans.Append((a.means.Value(i)*float64(m) + means.Value(j)*float64(n)) / float64(m+n))
			} else if iValid {
				mergedCounts.Append(a.counts.Value(i))
				mergedMeans.Append(a.means.Value(i))
			} else if jValid {
				mergedCounts.Append(counts.Value(j))
				mergedMeans.Append(means.Value(j))
			} else {
				mergedCounts.Append(0)
				mergedMeans.AppendNull()
			}
		})
		a.counts.Release()
		a.means.Release()
		a.counts, a.means = mergedCounts.NewIntArray(), mergedMeans.NewFloatArray()
	})
}

func (a *aggregateWindowMeanInt) Compute(mem memory.Allocator) (*array.Int, flux.ColType, array.Array) {
	a.createEmptyWindows(mem, func(n int) (append func(i int), done func()) {
		b := array.NewFloatBuilder(mem)
		b.Resize(n)

		append = func(i int) {
			if i < 0 || a.means.IsNull(i) {
				b.AppendNull()
			} else {
				b.Append(a.means.Value(i))
			}
		}

		done = func() {
			a.means.Release()
			a.means = b.NewFloatArray()
		}
		return append, done
	})
	a.ts.Retain()
	a.means.Retain()
	return a.ts, flux.TFloat, a.means
}

func (a *aggregateWindowMeanInt) Close() error {
	a.release()
	if a.counts != nil {
		a.counts.Release()
		a.counts = nil
	}
	if a.means != nil {
		a.means.Release()
		a.means = nil
	}
	return nil
}

type aggregateWindowSumUint struct {
	aggregateWindowBase
	vs *array.Uint
}

func (a *aggregateWindowSumUint) Aggregate(ts *array.Int, vs array.Array, start, stop *array.Int, mem memory.Allocator) {
	b := array.NewUintBuilder(mem)
	b.Resize(stop.Len())

	// Check once if we should look for nulls in the input.
	hasNulls := vs.NullN() > 0

	values := vs.(*array.Uint)
	aggregateWindows(ts, start, stop, func(i, j int) {
		var (
			sum    uint64
			isNull = hasNulls
		)
		if hasNulls {
			for ; i < j; i++ {
				// If there are nulls, check if this is null.
				if values.IsNull(i) {
					continue
				}
				sum += values.Value(i)
				isNull = false
			}
		} else {
			// Skip the extra checks if we know there are no nulls.
			for ; i < j; i++ {
				sum += values.Value(i)
			}
		}

		// Append a null value if there were no valid points.
		if isNull {
			b.AppendNull()
		} else {
			b.Append(sum)
		}
	})
	result := b.NewUintArray()
	a.merge(start, stop, result, mem)
}

func (a *aggregateWindowSumUint) Merge(from aggregateWindow, mem memory.Allocator) {
	other := from.(*aggregateWindowSumUint)
	other.vs.Retain()
	a.merge(other.ts, other.ts, other.vs, mem)
}

func (a *aggregateWindowSumUint) merge(start, stop *array.Int, result *array.Uint, mem memory.Allocator) {
	a.mergeWindows(start, stop, mem, func(ts, prev, next *array.Int) {
		if a.vs == nil {
			a.vs = result
			return
		}
		defer result.Release()

		merged := array.NewUintBuilder(mem)
		merged.Resize(ts.Len())
		mergeWindowValues(ts, prev, next, func(i, j int) {
			iValid := i >= 0 && a.vs.IsValid(i)
			jValid := j >= 0 && result.IsValid(j)
			if iValid && jValid {
				merged.Append(a.vs.Value(i) + result.Value(j))
			} else if iValid {
				merged.Append(a.vs.Value(i))
			} else if jValid {
				merged.Append(result.Value(j))
			} else {
				merged.AppendNull()
			}
		})
		a.vs.Release()
		a.vs = merged.NewUintArray()
	})
}

func (a *aggregateWindowSumUint) Compute(mem memory.Allocator) (*array.Int, flux.ColType, array.Array) {
	a.createEmptyWindows(mem, func(n int) (append func(i int), done func()) {
		b := array.NewUintBuilder(mem)
		b.Resize(n)

		append = func(i int) {
			if i < 0 || a.vs.IsNull(i) {
				b.AppendNull()
			} else {
				b.Append(a.vs.Value(i))
			}
		}

		done = func() {
			a.vs.Release()
			a.vs = b.NewUintArray()
		}
		return append, done
	})
	a.ts.Retain()
	a.vs.Retain()
	return a.ts, flux.TUInt, a.vs
}

func (a *aggregateWindowSumUint) Close() error {
	a.release()
	if a.vs != nil {
		a.vs.Release()
		a.vs = nil
	}
	return nil
}

type aggregateWindowMeanUint struct {
	aggregateWindowBase
	counts *array.Int
	means  *array.Float
}

func (a *aggregateWindowMeanUint) Aggregate(ts *array.Int, vs array.Array, start, stop *array.Int, mem memory.Allocator) {
	countsB := array.NewIntBuilder(mem)
	countsB.Resize(stop.Len())

	meansB := array.NewFloatBuilder(mem)
	meansB.Resize(stop.Len())

	// Check once if we should look for nulls in the input.
	hasNulls := vs.NullN() > 0

	values := vs.(*array.Uint)
	aggregateWindows(ts, start, stop, func(i, j int) {
		var (
			sum   uint64
			count = int64(j - i)
		)
		if hasNulls {
			for ; i < j; i++ {
				if values.IsNull(i) {
					count--
					continue
				}
				sum += values.Value(i)
			}
		} else {
			for ; i < j; i++ {
				sum += values.Value(i)
			}
		}
		countsB.Append(count)
		if count > 0 {
			meansB.Append(float64(sum) / float64(count))
		} else {
			meansB.AppendNull()
		}
	})

	counts, means := countsB.NewIntArray(), meansB.NewFloatArray()
	a.merge(start, stop, counts, means, mem)
}

func (a *aggregateWindowMeanUint) Merge(from aggregateWindow, mem memory.Allocator) {
	other := from.(*aggregateWindowMeanUint)
	other.counts.Retain()
	other.means.Retain()
	a.merge(other.ts, other.ts, other.counts, other.means, mem)
}

func (a *aggregateWindowMeanUint) merge(start, stop, counts *array.Int, means *array.Float, mem memory.Allocator) {
	a.mergeWindows(start, stop, mem, func(ts, prev, next *array.Int) {
		if a.means == nil {
			a.counts, a.means = counts, means
			return
		}
		defer counts.Release()
		defer means.Release()

		mergedCounts := array.NewIntBuilder(mem)
		mergedCounts.Resize(ts.Len())
		mergedMeans := array.NewFloatBuilder(mem)
		mergedMeans.Resize(ts.Len())
		mergeWindowValues(ts, prev, next, func(i, j int) {
			iValid := i >= 0 && a.means.IsValid(i)
			jValid := j >= 0 && means.IsValid(j)
			if iValid && jValid {
				m, n := a.counts.Value(i), counts.Value(j)
				mergedCounts.Append(m + n)
				mergedMeans.Append((a.means.Value(i)*float64(m) + means.Value(j)*float64(n)) / float64(m+n))
			} else if iValid {
				mergedCounts.Append(a.counts.Value(i))
				mergedMeans.Append(a.means.Value(i))
			} else if jValid {
				mergedCounts.Append(counts.Value(j))
				mergedMeans.Append(means.Value(j))
			} else {
				mergedCounts.Append(0)
				mergedMeans.AppendNull()
			}
		})
		a.counts.Release()
		a.means.Release()
		a.counts, a.means = mergedCounts.NewIntArray(), mergedMeans.NewFloatArray()
	})
}

func (a *aggregateWindowMeanUint) Compute(mem memory.Allocator) (*array.Int, flux.ColType, array.Array) {
	a.createEmptyWindows(mem, func(n int) (append func(i int), done func()) {
		b := array.NewFloatBuilder(mem)
		b.Resize(n)

		append = func(i int) {
			if i < 0 || a.means.IsNull(i) {
				b.AppendNull()
			} else {
				b.Append(a.means.Value(i))
			}
		}

		done = func() {
			a.means.Release()
			a.means = b.NewFloatArray()
		}
		return append, done
	})
	a.ts.Retain()
	a.means.Retain()
	return a.ts, flux.TFloat, a.means
}

func (a *aggregateWindowMeanUint) Close() error {
	a.release()
	if a.counts != nil {
		a.counts.Release()
		a.counts = nil
	}
	if a.means != nil {
		a.means.Release()
		a.means = nil
	}
	return nil
}

type aggregateWindowSumFloat struct {
	aggregateWindowBase
	vs *array.Float
}

func (a *aggregateWindowSumFloat) Aggregate(ts *array.Int, vs array.Array, start, stop *array.Int, mem memory.Allocator) {
	b := array.NewFloatBuilder(mem)
	b.Resize(stop.Len())

	// Check once if we should look for nulls in the input.
	hasNulls := vs.NullN() > 0

	values := vs.(*array.Float)
	aggregateWindows(ts, start, stop, func(i, j int) {
		var (
			sum    float64
			isNull = hasNulls
		)
		if hasNulls {
			for ; i < j; i++ {
				// If there are nulls, check if this is null.
				if values.IsNull(i) {
					continue
				}
				sum += values.Value(i)
				isNull = false
			}
		} else {
			// Skip the extra checks if we know there are no nulls.
			for ; i < j; i++ {
				sum += values.Value(i)
			}
		}

		// Append a null value if there were no valid points.
		if isNull {
			b.AppendNull()
		} else {
			b.Append(sum)
		}
	})
	result := b.NewFloatArray()
	a.merge(start, stop, result, mem)
}

func (a *aggregateWindowSumFloat) Merge(from aggregateWindow, mem memory.Allocator) {
	other := from.(*aggregateWindowSumFloat)
	other.vs.Retain()
	a.merge(other.ts, other.ts, other.vs, mem)
}

func (a *aggregateWindowSumFloat) merge(start, stop *array.Int, result *array.Float, mem memory.Allocator) {
	a.mergeWindows(start, stop, mem, func(ts, prev, next *array.Int) {
		if a.vs == nil {
			a.vs = result
			return
		}
		defer result.Release()

		merged := array.NewFloatBuilder(mem)
		merged.Resize(ts.Len())
		mergeWindowValues(ts, prev, next, func(i, j int) {
			iValid := i >= 0 && a.vs.IsValid(i)
			jValid := j >= 0 && result.IsValid(j)
			if iValid && jValid {
				merged.Append(a.vs.Value(i) + result.Value(j))
			} else if iValid {
				merged.Append(a.vs.Value(i))
			} else if jValid {
				merged.Append(result.Value(j))
			} else {
				merged.AppendNull()
			}
		})
		a.vs.Release()
		a.vs = merged.NewFloatArray()
	})
}

func (a *aggregateWindowSumFloat) Compute(mem memory.Allocator) (*array.Int, flux.ColType, array.Array) {
	a.createEmptyWindows(mem, func(n int) (append func(i int), done func()) {
		b := array.NewFloatBuilder(mem)
		b.Resize(n)

		append = func(i int) {
			if i < 0 || a.vs.IsNull(i) {
				b.AppendNull()
			} else {
				b.Append(a.vs.Value(i))
			}
		}

		done = func() {
			a.vs.Release()
			a.vs = b.NewFloatArray()
		}
		return append, done
	})
	a.ts.Retain()
	a.vs.Retain()
	return a.ts, flux.TFloat, a.vs
}

func (a *aggregateWindowSumFloat) Close() error {
	a.release()
	if a.vs != nil {
		a.vs.Release()
		a.vs = nil
	}
	return nil
}

type aggregateWindowMeanFloat struct {
	aggregateWindowBase
	counts *array.Int
	means  *array.Float
}

func (a *aggregateWindowMeanFloat) Aggregate(ts *array.Int, vs array.Array, start, stop *array.Int, mem memory.Allocator) {
	countsB := array.NewIntBuilder(mem)
	countsB.Resize(stop.Len())

	meansB := array.NewFloatBuilder(mem)
	meansB.Resize(stop.Len())

	// Check once if we should look for nulls in the input.
	hasNulls := vs.NullN() > 0

	values := vs.(*array.Float)
	aggregateWindows(ts, start, stop, func(i, j int) {
		var (
			sum   float64
			count = int64(j - i)
		)
		if hasNulls {
			for ; i < j; i++ {
				if values.IsNull(i) {
					count--
					continue
				}
				sum += values.Value(i)
			}
		} else {
			for ; i < j; i++ {
				sum += values.Value(i)
			}
		}
		countsB.Append(count)
		if count > 0 {
			meansB.Append(float64(sum) / float64(count))
		} else {
			meansB.AppendNull()
		}
	})

	counts, means := countsB.NewIntArray(), meansB.NewFloatArray()
	a.merge(start, stop, counts, means, mem)
}

func (a *aggregateWindowMeanFloat) Merge(from aggregateWindow, mem memory.Allocator) {
	other := from.(*aggregateWindowMeanFloat)
	other.counts.Retain()
	other.means.Retain()
	a.merge(other.ts, other.ts, other.counts, other.means, mem)
}

func (a *aggregateWindowMeanFloat) merge(start, stop, counts *array.Int, means *array.Float, mem memory.Allocator) {
	a.mergeWindows(start, stop, mem, func(ts, prev, next *array.Int) {
		if a.means == nil {
			a.counts, a.means = counts, means
			return
		}
		defer counts.Release()
		defer means.Release()

		mergedCounts := array.NewIntBuilder(mem)
		mergedCounts.Resize(ts.Len())
		mergedMeans := array.NewFloatBuilder(mem)
		mergedMeans.Resize(ts.Len())
		mergeWindowValues(ts, prev, next, func(i, j int) {
			iValid := i >= 0 && a.means.IsValid(i)
			jValid := j >= 0 && means.IsValid(j)
			if iValid && jValid {
				m, n := a.counts.Value(i), counts.Value(j)
				mergedCounts.Append(m + n)
				mergedMeans.Append((a.means.Value(i)*float64(m) + means.Value(j)*float64(n)) / float64(m+n))
			} else if iValid {
				mergedCounts.Append(a.counts.Value(i))
				mergedMeans.Append(a.means.Value(i))
			} else if jValid {
				mergedCounts.Append(counts.Value(j))
				mergedMeans.Append(means.Value(j))
			} else {
				mergedCounts.Append(0)
				mergedMeans.AppendNull()
			}
		})
		a.counts.Release()
		a.means.Release()
		a.counts, a.means = mergedCounts.NewIntArray(), mergedMeans.NewFloatArray()
	})
}

func (a *aggregateWindowMeanFloat) Compute(mem memory.Allocator) (*array.Int, flux.ColType, array.Array) {
	a.createEmptyWindows(mem, func(n int) (append func(i int), done func()) {
		b := array.NewFloatBuilder(mem)
		b.Resize(n)

		append = func(i int) {
			if i < 0 || a.means.IsNull(i) {
				b.AppendNull()
			} else {
				b.Append(a.means.Value(i))
			}
		}

		done = func() {
			a.means.Release()
			a.means = b.NewFloatArray()
		}
		return append, done
	})
	a.ts.Retain()
	a.means.Retain()
	return a.ts, flux.TFloat, a.means
}

func (a *aggregateWindowMeanFloat) Close() error {
	a.release()
	if a.counts != nil {
		a.counts.Release()
		a.counts = nil
	}
	if a.means != nil {
		a.means.Release()
		a.means = nil
	}
	return nil
}
