
//line parse.rl:1
/*
    cron is a fast, zero-allocation cron parsing library.  We aim to be Quartz cron compatible eventually.
    Currently we support:
    - standard five-position cron
    - six-position cron with seconds
    - seven-position cron with seconds and years
    - case-insensitive names of the days of the week
    - case-insensitive month names
*/

package cron

import (
    "fmt"
     "errors"
    "math/bits"
    "time"
)

// the following comment is there so it will end up, in the generated code.
// the blank line below this needs to be here.

// Code generated by ragel DO NOT EDIT.

//lint:file-ignore SA4006 Ignore unused, its generated
//lint:file-ignore U1000 Ignore all unused code, its generated



//line parse.rl:30

//line parse.rl:31

//line parse.go:37
const parse_start int = 464
const parse_first_final int = 464
const parse_error int = 0

const parse_en_sixPos int = 14
const parse_en_sevenPos int = 145
const parse_en_fivePos int = 286
const parse_en_durationMacro int = 492
const parse_en_atMacro int = 507
const parse_en_main int = 464


//line parse.rl:32


var skips = [...]uint64{
                    ^uint64(0),
                    1|1<<2|1<<4|1<<6|1<<8|1<<10|1<<12|1<<14|1<<16|1<<18|1<<20|1<<22|1<<24|1<<26|1<<28|1<<30|1<<32|1<<34|1<<36|1<<38|1<<40|1<<42|1<<44|1<<46|1<<48|1<<50|1<<52|1<<54|1<<56|1<<58|1<<60|1<<62,
                    1|1<<3|1<<6|1<<9|1<<12|1<<15|1<<18|1<<21|1<<24|1<<27|1<<30|1<<33|1<<36|1<<39|1<<42|1<<45|1<<48|1<<51|1<<54|1<<57|1<<60|1<<63,
                    1|1<<4|1<<8|1<<12|1<<16|1<<20|1<<24|1<<28|1<<32|1<<36|1<<40|1<<44|1<<48|1<<52|1<<56|1<<60,
                    1|1<<5|1<<10|1<<15|1<<20|1<<25|1<<30|1<<35|1<<40|1<<45|1<<50|1<<55|1<<60,
                    1|1<<6|1<<12|1<<18|1<<24|1<<30|1<<36|1<<42|1<<48|1<<54|1<<60,
                    1|1<<7|1<<14|1<<21|1<<28|1<<35|1<<42|1<<49|1<<56|1<<63,
                    1|1<<8|1<<16|1<<24|1<<32|1<<40|1<<48|1<<56,
                    1|1<<9|1<<18|1<<27|1<<36|1<<45|1<<54|1<<63,
                    1|1<<10|1<<20|1<<30|1<<40|1<<50|1<<60,
                    1|1<<11|1<<22|1<<33|1<<44|1<<55,
                    1|1<<12|1<<24|1<<36|1<<48,
                    1|1<<13|1<<26|1<<39|1<<52,
                    1|1<<14|1<<28|1<<42|1<<56,
                    1|1<<15|1<<30|1<<45,
                    1|1<<16|1<<32|1<<48,
                    1|1<<17|1<<34|1<<51,
                    1|1<<18|1<<36|1<<54,
                    1|1<<19|1<<38|1<<57,
                    1|1<<20|1<<40,
                    1|1<<21|1<<42,
                    1|1<<22|1<<44,
                    1|1<<23|1<<46,
                    1|1<<24|1<<48,
                    1|1<<25|1<<50,
                    1|1<<26|1<<52,
                    1|1<<27|1<<54,
                    1|1<<28|1<<56,
                    1|1<<29|1<<58,
                    1|1<<30|1<<59,
                    1|1<<31|1<<61,
                    1|1<<32|1<<63,
                    1|1<<33,
                    1|1<<34,
                    1|1<<35,
                    1|1<<36,
                    1|1<<37,
                    1|1<<38,
                    1|1<<39,
                    1|1<<40,
                    1|1<<41,
                    1|1<<42,
                    1|1<<43,
                    1|1<<44,
                    1|1<<45,
                    1|1<<46,
                    1|1<<47,
                    1|1<<48,
                    1|1<<49,
                    1|1<<50,
                    1|1<<51,
                    1|1<<52,
                    1|1<<53,
                    1|1<<54,
                    1|1<<55,
                    1|1<<56,
                    1|1<<57,
                    1|1<<58,
                    1|1<<59,
                    1|1<<60,
                    1|1<<61,
                    1|1<<62,
                    1|1<<63,
                }

const (
    mask60 = (^uint64(0))>>(64-60)
    mask31 = (^uint64(0))>>(64-31)
    mask7  = (^uint64(0))>>(64-7)
    mask24 = (^uint64(0))>>(64-24)
    mask12 = (^uint64(0))>>(64-12)
)

func parse(s string)(Parsed, error){
    nt:=Parsed{}
    cs, p, pe, eof:= 0, 0,len(s), len(s)
    
    // init scanner vars
    act, ts, te := 0, 0, 0
    _, _, _ = act, ts, te // we have to do this.

    // for fcall
    top := 0
    _ = top
    stack := [8]int{}
    mark, backtrack := 0,0
    _ = mark
    _ = backtrack
    m, d,  start, end, dec, befDec, sign:=uint64(0), uint64(0), uint64(0), uint64(0), int64(0), int64(0), int64(0)
    _ = d
    var dur time.Duration
    _, _, _, _ = dec, sign, dur, befDec

    // TODO(docmerlin): handle ranges
    
//line parse.go:149
	{
	cs = parse_start
	top = 0
	ts = 0
	te = 0
	act = 0
	}

//line parse.rl:130
    //m,h := 1<<0,1<<0
    
//line parse.rl:543


    
//line parse.go:165
	{
	if p == pe {
		goto _test_eof
	}
	switch cs {
	case 464:
		goto st_case_464
	case 1:
		goto st_case_1
	case 0:
		goto st_case_0
	case 465:
		goto st_case_465
	case 466:
		goto st_case_466
	case 2:
		goto st_case_2
	case 3:
		goto st_case_3
	case 4:
		goto st_case_4
	case 5:
		goto st_case_5
	case 6:
		goto st_case_6
	case 7:
		goto st_case_7
	case 8:
		goto st_case_8
	case 9:
		goto st_case_9
	case 467:
		goto st_case_467
	case 10:
		goto st_case_10
	case 468:
		goto st_case_468
	case 11:
		goto st_case_11
	case 469:
		goto st_case_469
	case 12:
		goto st_case_12
	case 470:
		goto st_case_470
	case 471:
		goto st_case_471
	case 13:
		goto st_case_13
	case 472:
		goto st_case_472
	case 14:
		goto st_case_14
	case 15:
		goto st_case_15
	case 16:
		goto st_case_16
	case 17:
		goto st_case_17
	case 18:
		goto st_case_18
	case 19:
		goto st_case_19
	case 20:
		goto st_case_20
	case 21:
		goto st_case_21
	case 22:
		goto st_case_22
	case 23:
		goto st_case_23
	case 24:
		goto st_case_24
	case 473:
		goto st_case_473
	case 474:
		goto st_case_474
	case 25:
		goto st_case_25
	case 475:
		goto st_case_475
	case 26:
		goto st_case_26
	case 476:
		goto st_case_476
	case 27:
		goto st_case_27
	case 477:
		goto st_case_477
	case 28:
		goto st_case_28
	case 29:
		goto st_case_29
	case 478:
		goto st_case_478
	case 30:
		goto st_case_30
	case 31:
		goto st_case_31
	case 32:
		goto st_case_32
	case 33:
		goto st_case_33
	case 34:
		goto st_case_34
	case 35:
		goto st_case_35
	case 36:
		goto st_case_36
	case 37:
		goto st_case_37
	case 38:
		goto st_case_38
	case 39:
		goto st_case_39
	case 40:
		goto st_case_40
	case 41:
		goto st_case_41
	case 479:
		goto st_case_479
	case 42:
		goto st_case_42
	case 43:
		goto st_case_43
	case 44:
		goto st_case_44
	case 45:
		goto st_case_45
	case 46:
		goto st_case_46
	case 47:
		goto st_case_47
	case 48:
		goto st_case_48
	case 49:
		goto st_case_49
	case 50:
		goto st_case_50
	case 51:
		goto st_case_51
	case 52:
		goto st_case_52
	case 53:
		goto st_case_53
	case 54:
		goto st_case_54
	case 55:
		goto st_case_55
	case 56:
		goto st_case_56
	case 57:
		goto st_case_57
	case 58:
		goto st_case_58
	case 59:
		goto st_case_59
	case 60:
		goto st_case_60
	case 61:
		goto st_case_61
	case 62:
		goto st_case_62
	case 63:
		goto st_case_63
	case 64:
		goto st_case_64
	case 65:
		goto st_case_65
	case 66:
		goto st_case_66
	case 67:
		goto st_case_67
	case 68:
		goto st_case_68
	case 69:
		goto st_case_69
	case 70:
		goto st_case_70
	case 71:
		goto st_case_71
	case 72:
		goto st_case_72
	case 73:
		goto st_case_73
	case 74:
		goto st_case_74
	case 75:
		goto st_case_75
	case 76:
		goto st_case_76
	case 77:
		goto st_case_77
	case 78:
		goto st_case_78
	case 79:
		goto st_case_79
	case 80:
		goto st_case_80
	case 81:
		goto st_case_81
	case 82:
		goto st_case_82
	case 83:
		goto st_case_83
	case 84:
		goto st_case_84
	case 85:
		goto st_case_85
	case 86:
		goto st_case_86
	case 87:
		goto st_case_87
	case 88:
		goto st_case_88
	case 89:
		goto st_case_89
	case 90:
		goto st_case_90
	case 91:
		goto st_case_91
	case 92:
		goto st_case_92
	case 93:
		goto st_case_93
	case 94:
		goto st_case_94
	case 95:
		goto st_case_95
	case 96:
		goto st_case_96
	case 97:
		goto st_case_97
	case 98:
		goto st_case_98
	case 99:
		goto st_case_99
	case 100:
		goto st_case_100
	case 101:
		goto st_case_101
	case 102:
		goto st_case_102
	case 103:
		goto st_case_103
	case 104:
		goto st_case_104
	case 105:
		goto st_case_105
	case 106:
		goto st_case_106
	case 107:
		goto st_case_107
	case 108:
		goto st_case_108
	case 109:
		goto st_case_109
	case 110:
		goto st_case_110
	case 111:
		goto st_case_111
	case 112:
		goto st_case_112
	case 113:
		goto st_case_113
	case 114:
		goto st_case_114
	case 115:
		goto st_case_115
	case 116:
		goto st_case_116
	case 117:
		goto st_case_117
	case 118:
		goto st_case_118
	case 119:
		goto st_case_119
	case 120:
		goto st_case_120
	case 121:
		goto st_case_121
	case 122:
		goto st_case_122
	case 123:
		goto st_case_123
	case 124:
		goto st_case_124
	case 125:
		goto st_case_125
	case 126:
		goto st_case_126
	case 127:
		goto st_case_127
	case 128:
		goto st_case_128
	case 129:
		goto st_case_129
	case 130:
		goto st_case_130
	case 131:
		goto st_case_131
	case 132:
		goto st_case_132
	case 133:
		goto st_case_133
	case 134:
		goto st_case_134
	case 135:
		goto st_case_135
	case 136:
		goto st_case_136
	case 137:
		goto st_case_137
	case 138:
		goto st_case_138
	case 139:
		goto st_case_139
	case 140:
		goto st_case_140
	case 141:
		goto st_case_141
	case 142:
		goto st_case_142
	case 143:
		goto st_case_143
	case 144:
		goto st_case_144
	case 145:
		goto st_case_145
	case 146:
		goto st_case_146
	case 147:
		goto st_case_147
	case 148:
		goto st_case_148
	case 149:
		goto st_case_149
	case 150:
		goto st_case_150
	case 151:
		goto st_case_151
	case 152:
		goto st_case_152
	case 153:
		goto st_case_153
	case 154:
		goto st_case_154
	case 155:
		goto st_case_155
	case 156:
		goto st_case_156
	case 157:
		goto st_case_157
	case 480:
		goto st_case_480
	case 481:
		goto st_case_481
	case 158:
		goto st_case_158
	case 482:
		goto st_case_482
	case 159:
		goto st_case_159
	case 483:
		goto st_case_483
	case 160:
		goto st_case_160
	case 484:
		goto st_case_484
	case 161:
		goto st_case_161
	case 162:
		goto st_case_162
	case 163:
		goto st_case_163
	case 164:
		goto st_case_164
	case 165:
		goto st_case_165
	case 166:
		goto st_case_166
	case 167:
		goto st_case_167
	case 168:
		goto st_case_168
	case 169:
		goto st_case_169
	case 170:
		goto st_case_170
	case 171:
		goto st_case_171
	case 172:
		goto st_case_172
	case 173:
		goto st_case_173
	case 174:
		goto st_case_174
	case 175:
		goto st_case_175
	case 176:
		goto st_case_176
	case 177:
		goto st_case_177
	case 178:
		goto st_case_178
	case 179:
		goto st_case_179
	case 180:
		goto st_case_180
	case 181:
		goto st_case_181
	case 182:
		goto st_case_182
	case 183:
		goto st_case_183
	case 184:
		goto st_case_184
	case 185:
		goto st_case_185
	case 186:
		goto st_case_186
	case 187:
		goto st_case_187
	case 188:
		goto st_case_188
	case 189:
		goto st_case_189
	case 190:
		goto st_case_190
	case 191:
		goto st_case_191
	case 192:
		goto st_case_192
	case 193:
		goto st_case_193
	case 194:
		goto st_case_194
	case 195:
		goto st_case_195
	case 196:
		goto st_case_196
	case 197:
		goto st_case_197
	case 198:
		goto st_case_198
	case 199:
		goto st_case_199
	case 200:
		goto st_case_200
	case 201:
		goto st_case_201
	case 202:
		goto st_case_202
	case 203:
		goto st_case_203
	case 204:
		goto st_case_204
	case 205:
		goto st_case_205
	case 206:
		goto st_case_206
	case 207:
		goto st_case_207
	case 208:
		goto st_case_208
	case 209:
		goto st_case_209
	case 210:
		goto st_case_210
	case 211:
		goto st_case_211
	case 212:
		goto st_case_212
	case 213:
		goto st_case_213
	case 214:
		goto st_case_214
	case 215:
		goto st_case_215
	case 216:
		goto st_case_216
	case 217:
		goto st_case_217
	case 218:
		goto st_case_218
	case 219:
		goto st_case_219
	case 220:
		goto st_case_220
	case 221:
		goto st_case_221
	case 222:
		goto st_case_222
	case 223:
		goto st_case_223
	case 224:
		goto st_case_224
	case 225:
		goto st_case_225
	case 226:
		goto st_case_226
	case 227:
		goto st_case_227
	case 228:
		goto st_case_228
	case 229:
		goto st_case_229
	case 230:
		goto st_case_230
	case 231:
		goto st_case_231
	case 232:
		goto st_case_232
	case 233:
		goto st_case_233
	case 234:
		goto st_case_234
	case 235:
		goto st_case_235
	case 236:
		goto st_case_236
	case 237:
		goto st_case_237
	case 238:
		goto st_case_238
	case 239:
		goto st_case_239
	case 240:
		goto st_case_240
	case 241:
		goto st_case_241
	case 242:
		goto st_case_242
	case 243:
		goto st_case_243
	case 244:
		goto st_case_244
	case 245:
		goto st_case_245
	case 246:
		goto st_case_246
	case 247:
		goto st_case_247
	case 248:
		goto st_case_248
	case 249:
		goto st_case_249
	case 250:
		goto st_case_250
	case 251:
		goto st_case_251
	case 252:
		goto st_case_252
	case 253:
		goto st_case_253
	case 254:
		goto st_case_254
	case 255:
		goto st_case_255
	case 256:
		goto st_case_256
	case 257:
		goto st_case_257
	case 258:
		goto st_case_258
	case 259:
		goto st_case_259
	case 260:
		goto st_case_260
	case 261:
		goto st_case_261
	case 262:
		goto st_case_262
	case 263:
		goto st_case_263
	case 264:
		goto st_case_264
	case 265:
		goto st_case_265
	case 266:
		goto st_case_266
	case 267:
		goto st_case_267
	case 268:
		goto st_case_268
	case 269:
		goto st_case_269
	case 270:
		goto st_case_270
	case 271:
		goto st_case_271
	case 272:
		goto st_case_272
	case 273:
		goto st_case_273
	case 274:
		goto st_case_274
	case 275:
		goto st_case_275
	case 276:
		goto st_case_276
	case 277:
		goto st_case_277
	case 278:
		goto st_case_278
	case 279:
		goto st_case_279
	case 280:
		goto st_case_280
	case 281:
		goto st_case_281
	case 282:
		goto st_case_282
	case 283:
		goto st_case_283
	case 284:
		goto st_case_284
	case 285:
		goto st_case_285
	case 286:
		goto st_case_286
	case 287:
		goto st_case_287
	case 288:
		goto st_case_288
	case 289:
		goto st_case_289
	case 290:
		goto st_case_290
	case 291:
		goto st_case_291
	case 292:
		goto st_case_292
	case 293:
		goto st_case_293
	case 294:
		goto st_case_294
	case 485:
		goto st_case_485
	case 486:
		goto st_case_486
	case 295:
		goto st_case_295
	case 487:
		goto st_case_487
	case 296:
		goto st_case_296
	case 488:
		goto st_case_488
	case 297:
		goto st_case_297
	case 489:
		goto st_case_489
	case 298:
		goto st_case_298
	case 299:
		goto st_case_299
	case 490:
		goto st_case_490
	case 300:
		goto st_case_300
	case 301:
		goto st_case_301
	case 302:
		goto st_case_302
	case 303:
		goto st_case_303
	case 304:
		goto st_case_304
	case 305:
		goto st_case_305
	case 306:
		goto st_case_306
	case 307:
		goto st_case_307
	case 308:
		goto st_case_308
	case 309:
		goto st_case_309
	case 310:
		goto st_case_310
	case 311:
		goto st_case_311
	case 491:
		goto st_case_491
	case 312:
		goto st_case_312
	case 313:
		goto st_case_313
	case 314:
		goto st_case_314
	case 315:
		goto st_case_315
	case 316:
		goto st_case_316
	case 317:
		goto st_case_317
	case 318:
		goto st_case_318
	case 319:
		goto st_case_319
	case 320:
		goto st_case_320
	case 321:
		goto st_case_321
	case 322:
		goto st_case_322
	case 323:
		goto st_case_323
	case 324:
		goto st_case_324
	case 325:
		goto st_case_325
	case 326:
		goto st_case_326
	case 327:
		goto st_case_327
	case 328:
		goto st_case_328
	case 329:
		goto st_case_329
	case 330:
		goto st_case_330
	case 331:
		goto st_case_331
	case 332:
		goto st_case_332
	case 333:
		goto st_case_333
	case 334:
		goto st_case_334
	case 335:
		goto st_case_335
	case 336:
		goto st_case_336
	case 337:
		goto st_case_337
	case 338:
		goto st_case_338
	case 339:
		goto st_case_339
	case 340:
		goto st_case_340
	case 341:
		goto st_case_341
	case 342:
		goto st_case_342
	case 343:
		goto st_case_343
	case 344:
		goto st_case_344
	case 345:
		goto st_case_345
	case 346:
		goto st_case_346
	case 347:
		goto st_case_347
	case 348:
		goto st_case_348
	case 349:
		goto st_case_349
	case 350:
		goto st_case_350
	case 351:
		goto st_case_351
	case 352:
		goto st_case_352
	case 353:
		goto st_case_353
	case 354:
		goto st_case_354
	case 355:
		goto st_case_355
	case 356:
		goto st_case_356
	case 357:
		goto st_case_357
	case 358:
		goto st_case_358
	case 359:
		goto st_case_359
	case 360:
		goto st_case_360
	case 361:
		goto st_case_361
	case 362:
		goto st_case_362
	case 363:
		goto st_case_363
	case 364:
		goto st_case_364
	case 365:
		goto st_case_365
	case 366:
		goto st_case_366
	case 367:
		goto st_case_367
	case 368:
		goto st_case_368
	case 369:
		goto st_case_369
	case 370:
		goto st_case_370
	case 371:
		goto st_case_371
	case 372:
		goto st_case_372
	case 373:
		goto st_case_373
	case 374:
		goto st_case_374
	case 375:
		goto st_case_375
	case 376:
		goto st_case_376
	case 377:
		goto st_case_377
	case 378:
		goto st_case_378
	case 379:
		goto st_case_379
	case 380:
		goto st_case_380
	case 381:
		goto st_case_381
	case 382:
		goto st_case_382
	case 383:
		goto st_case_383
	case 384:
		goto st_case_384
	case 385:
		goto st_case_385
	case 386:
		goto st_case_386
	case 387:
		goto st_case_387
	case 388:
		goto st_case_388
	case 389:
		goto st_case_389
	case 390:
		goto st_case_390
	case 391:
		goto st_case_391
	case 392:
		goto st_case_392
	case 393:
		goto st_case_393
	case 394:
		goto st_case_394
	case 395:
		goto st_case_395
	case 396:
		goto st_case_396
	case 397:
		goto st_case_397
	case 398:
		goto st_case_398
	case 399:
		goto st_case_399
	case 400:
		goto st_case_400
	case 401:
		goto st_case_401
	case 402:
		goto st_case_402
	case 403:
		goto st_case_403
	case 404:
		goto st_case_404
	case 405:
		goto st_case_405
	case 406:
		goto st_case_406
	case 407:
		goto st_case_407
	case 408:
		goto st_case_408
	case 492:
		goto st_case_492
	case 493:
		goto st_case_493
	case 494:
		goto st_case_494
	case 409:
		goto st_case_409
	case 495:
		goto st_case_495
	case 496:
		goto st_case_496
	case 497:
		goto st_case_497
	case 498:
		goto st_case_498
	case 499:
		goto st_case_499
	case 500:
		goto st_case_500
	case 410:
		goto st_case_410
	case 501:
		goto st_case_501
	case 502:
		goto st_case_502
	case 503:
		goto st_case_503
	case 504:
		goto st_case_504
	case 505:
		goto st_case_505
	case 506:
		goto st_case_506
	case 507:
		goto st_case_507
	case 411:
		goto st_case_411
	case 412:
		goto st_case_412
	case 413:
		goto st_case_413
	case 414:
		goto st_case_414
	case 415:
		goto st_case_415
	case 416:
		goto st_case_416
	case 417:
		goto st_case_417
	case 418:
		goto st_case_418
	case 508:
		goto st_case_508
	case 419:
		goto st_case_419
	case 420:
		goto st_case_420
	case 421:
		goto st_case_421
	case 422:
		goto st_case_422
	case 509:
		goto st_case_509
	case 423:
		goto st_case_423
	case 424:
		goto st_case_424
	case 425:
		goto st_case_425
	case 426:
		goto st_case_426
	case 427:
		goto st_case_427
	case 510:
		goto st_case_510
	case 428:
		goto st_case_428
	case 429:
		goto st_case_429
	case 430:
		goto st_case_430
	case 431:
		goto st_case_431
	case 432:
		goto st_case_432
	case 433:
		goto st_case_433
	case 511:
		goto st_case_511
	case 434:
		goto st_case_434
	case 435:
		goto st_case_435
	case 436:
		goto st_case_436
	case 437:
		goto st_case_437
	case 438:
		goto st_case_438
	case 512:
		goto st_case_512
	case 439:
		goto st_case_439
	case 440:
		goto st_case_440
	case 441:
		goto st_case_441
	case 442:
		goto st_case_442
	case 443:
		goto st_case_443
	case 513:
		goto st_case_513
	case 444:
		goto st_case_444
	case 445:
		goto st_case_445
	case 446:
		goto st_case_446
	case 447:
		goto st_case_447
	case 448:
		goto st_case_448
	case 449:
		goto st_case_449
	case 450:
		goto st_case_450
	case 451:
		goto st_case_451
	case 452:
		goto st_case_452
	case 453:
		goto st_case_453
	case 454:
		goto st_case_454
	case 455:
		goto st_case_455
	case 514:
		goto st_case_514
	case 456:
		goto st_case_456
	case 457:
		goto st_case_457
	case 458:
		goto st_case_458
	case 459:
		goto st_case_459
	case 460:
		goto st_case_460
	case 515:
		goto st_case_515
	case 461:
		goto st_case_461
	case 462:
		goto st_case_462
	case 463:
		goto st_case_463
	}
	goto st_out
tr0:
//line parse.rl:351
te = p+1
{
            p--

            return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])
        }
	goto st464
tr11:
//line parse.rl:516
p = (te) - 1
{
                _ = p // this is to make staticcheck happy
                // set seconds to 0 second of minute
                nt.second=1
                // set year to be permissive
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                p = ( mark) - 1

                {stack[top] = 464; top++; goto st286 }
                }
	goto st464
tr14:
//line parse.rl:526
p = (te) - 1
{
                _ = p // this is to make staticcheck happy
                nt.high=^uint64(0) // set year to be permissive
                nt.low=^uint64(0)
                p = ( mark) - 1

                {goto st14 }
                }
	goto st464
tr17:
//line parse.rl:533
p = (te) - 1
{
                _ = p // this is to make staticcheck happy
                p = ( mark) - 1

                {stack[top] = 464; top++; goto st145 }
                }
	goto st464
tr858:
//line parse.rl:132
te = p
p--
{
            mark = p;
        }
	goto st464
tr860:
//line parse.rl:516
te = p
p--
{
                _ = p // this is to make staticcheck happy
                // set seconds to 0 second of minute
                nt.second=1
                // set year to be permissive
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                p = ( mark) - 1

                {stack[top] = 464; top++; goto st286 }
                }
	goto st464
tr861:
//line parse.rl:526
te = p
p--
{
                _ = p // this is to make staticcheck happy
                nt.high=^uint64(0) // set year to be permissive
                nt.low=^uint64(0)
                p = ( mark) - 1

                {goto st14 }
                }
	goto st464
tr862:
//line parse.rl:533
te = p
p--
{
                _ = p // this is to make staticcheck happy
                p = ( mark) - 1

                {stack[top] = 464; top++; goto st145 }
                }
	goto st464
tr863:
//line parse.rl:351
te = p
p--
{
            p--

            return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])
        }
	goto st464
tr865:
//line parse.rl:538
te = p
p--
{{stack[top] = 464; top++; goto st507 }}
	goto st464
	st464:
//line NONE:1
ts = 0

		if p++; p == pe {
			goto _test_eof464
		}
	st_case_464:
//line NONE:1
ts = p

//line parse.go:1326
		switch ( s)[p] {
		case 32:
			goto st465
		case 42:
			goto tr856
		case 64:
			goto st472
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto tr856
				}
			case ( s)[p] >= 9:
				goto st465
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto tr856
				}
			case ( s)[p] >= 65:
				goto tr856
			}
		default:
			goto tr856
		}
		goto st1
	st1:
		if p++; p == pe {
			goto _test_eof1
		}
	st_case_1:
		if ( s)[p] == 43 {
			goto tr0
		}
		goto st0
st_case_0:
	st0:
		cs = 0
		goto _out
	st465:
		if p++; p == pe {
			goto _test_eof465
		}
	st_case_465:
		switch ( s)[p] {
		case 32:
			goto st466
		case 43:
			goto tr0
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st466
		}
		goto tr858
	st466:
		if p++; p == pe {
			goto _test_eof466
		}
	st_case_466:
		if ( s)[p] == 32 {
			goto st466
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st466
		}
		goto tr858
tr856:
//line parse.rl:132

            mark = p;
        
	goto st2
	st2:
		if p++; p == pe {
			goto _test_eof2
		}
	st_case_2:
//line parse.go:1409
		switch ( s)[p] {
		case 32:
			goto st3
		case 43:
			goto tr0
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 42 <= ( s)[p] && ( s)[p] <= 45 {
					goto st13
				}
			case ( s)[p] >= 9:
				goto st3
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st13
				}
			case ( s)[p] >= 65:
				goto st13
			}
		default:
			goto st13
		}
		goto st0
	st3:
		if p++; p == pe {
			goto _test_eof3
		}
	st_case_3:
		switch ( s)[p] {
		case 32:
			goto st3
		case 42:
			goto st4
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st4
				}
			case ( s)[p] >= 9:
				goto st3
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st4
				}
			case ( s)[p] >= 65:
				goto st4
			}
		default:
			goto st4
		}
		goto st0
	st4:
		if p++; p == pe {
			goto _test_eof4
		}
	st_case_4:
		switch ( s)[p] {
		case 32:
			goto st5
		case 42:
			goto st4
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st4
				}
			case ( s)[p] >= 9:
				goto st5
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st4
				}
			case ( s)[p] >= 65:
				goto st4
			}
		default:
			goto st4
		}
		goto st0
	st5:
		if p++; p == pe {
			goto _test_eof5
		}
	st_case_5:
		switch ( s)[p] {
		case 32:
			goto st5
		case 42:
			goto st6
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st6
				}
			case ( s)[p] >= 9:
				goto st5
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st6
				}
			case ( s)[p] >= 65:
				goto st6
			}
		default:
			goto st6
		}
		goto st0
	st6:
		if p++; p == pe {
			goto _test_eof6
		}
	st_case_6:
		switch ( s)[p] {
		case 32:
			goto st7
		case 42:
			goto st6
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st6
				}
			case ( s)[p] >= 9:
				goto st7
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st6
				}
			case ( s)[p] >= 65:
				goto st6
			}
		default:
			goto st6
		}
		goto st0
	st7:
		if p++; p == pe {
			goto _test_eof7
		}
	st_case_7:
		switch ( s)[p] {
		case 32:
			goto st7
		case 42:
			goto st8
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st8
				}
			case ( s)[p] >= 9:
				goto st7
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st8
				}
			case ( s)[p] >= 65:
				goto st8
			}
		default:
			goto st8
		}
		goto st0
	st8:
		if p++; p == pe {
			goto _test_eof8
		}
	st_case_8:
		switch ( s)[p] {
		case 32:
			goto st9
		case 42:
			goto st8
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st8
				}
			case ( s)[p] >= 9:
				goto st9
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st8
				}
			case ( s)[p] >= 65:
				goto st8
			}
		default:
			goto st8
		}
		goto st0
	st9:
		if p++; p == pe {
			goto _test_eof9
		}
	st_case_9:
		switch ( s)[p] {
		case 32:
			goto st9
		case 42:
			goto tr10
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto tr10
				}
			case ( s)[p] >= 9:
				goto st9
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto tr10
				}
			case ( s)[p] >= 65:
				goto tr10
			}
		default:
			goto tr10
		}
		goto st0
tr10:
//line NONE:1
te = p+1

	goto st467
	st467:
		if p++; p == pe {
			goto _test_eof467
		}
	st_case_467:
//line parse.go:1687
		switch ( s)[p] {
		case 32:
			goto st10
		case 42:
			goto tr10
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto tr10
				}
			case ( s)[p] >= 9:
				goto st10
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto tr10
				}
			case ( s)[p] >= 65:
				goto tr10
			}
		default:
			goto tr10
		}
		goto tr860
	st10:
		if p++; p == pe {
			goto _test_eof10
		}
	st_case_10:
		switch ( s)[p] {
		case 32:
			goto st10
		case 42:
			goto tr13
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto tr13
				}
			case ( s)[p] >= 9:
				goto st10
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto tr13
				}
			case ( s)[p] >= 65:
				goto tr13
			}
		default:
			goto tr13
		}
		goto tr11
tr13:
//line NONE:1
te = p+1

	goto st468
	st468:
		if p++; p == pe {
			goto _test_eof468
		}
	st_case_468:
//line parse.go:1761
		switch ( s)[p] {
		case 32:
			goto st11
		case 42:
			goto tr13
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto tr13
				}
			case ( s)[p] >= 9:
				goto st11
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto tr13
				}
			case ( s)[p] >= 65:
				goto tr13
			}
		default:
			goto tr13
		}
		goto tr861
	st11:
		if p++; p == pe {
			goto _test_eof11
		}
	st_case_11:
		switch ( s)[p] {
		case 32:
			goto st11
		case 42:
			goto tr16
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto tr16
				}
			case ( s)[p] >= 9:
				goto st11
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto tr16
				}
			case ( s)[p] >= 65:
				goto tr16
			}
		default:
			goto tr16
		}
		goto tr14
tr16:
//line NONE:1
te = p+1

	goto st469
	st469:
		if p++; p == pe {
			goto _test_eof469
		}
	st_case_469:
//line parse.go:1835
		switch ( s)[p] {
		case 32:
			goto st12
		case 42:
			goto tr16
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto tr16
				}
			case ( s)[p] >= 9:
				goto st12
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto tr16
				}
			case ( s)[p] >= 65:
				goto tr16
			}
		default:
			goto tr16
		}
		goto tr862
	st12:
		if p++; p == pe {
			goto _test_eof12
		}
	st_case_12:
		switch ( s)[p] {
		case 32:
			goto st12
		case 42:
			goto st470
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st470
				}
			case ( s)[p] >= 9:
				goto st12
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st470
				}
			case ( s)[p] >= 65:
				goto st470
			}
		default:
			goto st470
		}
		goto tr17
	st470:
		if p++; p == pe {
			goto _test_eof470
		}
	st_case_470:
		switch ( s)[p] {
		case 32:
			goto st471
		case 42:
			goto st470
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st470
				}
			case ( s)[p] >= 9:
				goto st471
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st470
				}
			case ( s)[p] >= 65:
				goto st470
			}
		default:
			goto st470
		}
		goto tr863
	st471:
		if p++; p == pe {
			goto _test_eof471
		}
	st_case_471:
		if ( s)[p] == 42 {
			goto st470
		}
		switch {
		case ( s)[p] < 47:
			if 44 <= ( s)[p] && ( s)[p] <= 45 {
				goto st470
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st470
				}
			case ( s)[p] >= 65:
				goto st470
			}
		default:
			goto st470
		}
		goto tr863
	st13:
		if p++; p == pe {
			goto _test_eof13
		}
	st_case_13:
		switch ( s)[p] {
		case 32:
			goto st3
		case 42:
			goto st13
		}
		switch {
		case ( s)[p] < 47:
			switch {
			case ( s)[p] > 13:
				if 44 <= ( s)[p] && ( s)[p] <= 45 {
					goto st13
				}
			case ( s)[p] >= 9:
				goto st3
			}
		case ( s)[p] > 57:
			switch {
			case ( s)[p] > 90:
				if 97 <= ( s)[p] && ( s)[p] <= 122 {
					goto st13
				}
			case ( s)[p] >= 65:
				goto st13
			}
		default:
			goto st13
		}
		goto st0
	st472:
		if p++; p == pe {
			goto _test_eof472
		}
	st_case_472:
		if ( s)[p] == 43 {
			goto tr0
		}
		goto tr865
tr23:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st14
tr262:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:376
d=m
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st14
tr265:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st14
tr271:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st14
	st14:
//line NONE:1
ts = 0

		if p++; p == pe {
			goto _test_eof14
		}
	st_case_14:
//line parse.go:2150
		if ( s)[p] == 42 {
			goto tr20
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr21
		}
		goto st0
tr20:
//line parse.rl:375
d=0;
	goto st15
	st15:
		if p++; p == pe {
			goto _test_eof15
		}
	st_case_15:
//line parse.go:2167
		switch ( s)[p] {
		case 32:
			goto tr22
		case 44:
			goto tr23
		case 47:
			goto tr24
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr22
		}
		goto st0
tr22:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st16
tr261:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:376
d=m
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st16
tr264:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st16
tr270:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st16
	st16:
		if p++; p == pe {
			goto _test_eof16
		}
	st_case_16:
//line parse.go:2325
		switch ( s)[p] {
		case 32:
			goto st16
		case 42:
			goto tr26
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr27
			}
		case ( s)[p] >= 9:
			goto st16
		}
		goto st0
tr26:
//line parse.rl:375
d=0;
	goto st17
	st17:
		if p++; p == pe {
			goto _test_eof17
		}
	st_case_17:
//line parse.go:2350
		switch ( s)[p] {
		case 32:
			goto tr28
		case 44:
			goto tr29
		case 47:
			goto tr30
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr28
		}
		goto st0
tr28:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st18
tr246:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st18
tr252:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st18
tr257:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:379
d=m
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st18
	st18:
		if p++; p == pe {
			goto _test_eof18
		}
	st_case_18:
//line parse.go:2508
		switch ( s)[p] {
		case 32:
			goto st18
		case 42:
			goto tr32
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr33
			}
		case ( s)[p] >= 9:
			goto st18
		}
		goto st0
tr32:
//line parse.rl:382
d=0;
	goto st19
	st19:
		if p++; p == pe {
			goto _test_eof19
		}
	st_case_19:
//line parse.go:2533
		switch ( s)[p] {
		case 32:
			goto tr34
		case 44:
			goto tr35
		case 47:
			goto tr36
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr34
		}
		goto st0
tr34:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st20
tr232:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st20
tr238:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st20
tr243:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:383
d=m
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st20
	st20:
		if p++; p == pe {
			goto _test_eof20
		}
	st_case_20:
//line parse.go:2691
		switch ( s)[p] {
		case 32:
			goto st20
		case 42:
			goto tr38
		case 70:
			goto tr40
		case 77:
			goto tr41
		case 83:
			goto tr42
		case 84:
			goto tr43
		case 87:
			goto tr44
		case 102:
			goto tr40
		case 109:
			goto tr41
		case 115:
			goto tr42
		case 116:
			goto tr43
		case 119:
			goto tr44
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr39
			}
		case ( s)[p] >= 9:
			goto st20
		}
		goto st0
tr38:
//line parse.rl:386
d=0;
	goto st21
	st21:
		if p++; p == pe {
			goto _test_eof21
		}
	st_case_21:
//line parse.go:2736
		switch ( s)[p] {
		case 32:
			goto tr45
		case 44:
			goto tr46
		case 47:
			goto tr47
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr45
		}
		goto st0
tr45:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st22
tr178:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st22
tr189:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st22
tr194:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:387
d=m
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st22
tr199:
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st22
tr216:
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st22
	st22:
		if p++; p == pe {
			goto _test_eof22
		}
	st_case_22:
//line parse.go:2952
		switch ( s)[p] {
		case 32:
			goto st22
		case 42:
			goto tr49
		case 65:
			goto tr51
		case 68:
			goto tr52
		case 70:
			goto tr53
		case 74:
			goto tr54
		case 77:
			goto tr55
		case 78:
			goto tr56
		case 79:
			goto tr57
		case 83:
			goto tr58
		case 97:
			goto tr51
		case 100:
			goto tr52
		case 102:
			goto tr53
		case 106:
			goto tr54
		case 109:
			goto tr55
		case 110:
			goto tr56
		case 111:
			goto tr57
		case 115:
			goto tr58
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr50
			}
		case ( s)[p] >= 9:
			goto st22
		}
		goto st0
tr49:
//line parse.rl:390
d=0;
	goto st23
	st23:
		if p++; p == pe {
			goto _test_eof23
		}
	st_case_23:
//line parse.go:3009
		switch ( s)[p] {
		case 32:
			goto tr59
		case 44:
			goto tr60
		case 47:
			goto tr61
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr59
		}
		goto st0
tr59:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st24
tr105:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st24
tr119:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st24
tr124:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:391
d=m
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st24
tr130:
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st24
tr155:
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st24
	st24:
		if p++; p == pe {
			goto _test_eof24
		}
	st_case_24:
//line parse.go:3225
		switch ( s)[p] {
		case 32:
			goto st24
		case 42:
			goto tr63
		case 70:
			goto tr65
		case 77:
			goto tr66
		case 83:
			goto tr67
		case 84:
			goto tr68
		case 87:
			goto tr69
		case 102:
			goto tr65
		case 109:
			goto tr66
		case 115:
			goto tr67
		case 116:
			goto tr68
		case 119:
			goto tr69
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr64
			}
		case ( s)[p] >= 9:
			goto st24
		}
		goto st0
tr63:
//line parse.rl:394
d=0;
	goto st473
	st473:
		if p++; p == pe {
			goto _test_eof473
		}
	st_case_473:
//line parse.go:3270
		switch ( s)[p] {
		case 32:
			goto tr866
		case 44:
			goto tr867
		case 47:
			goto tr868
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr866
		}
		goto st0
tr866:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st474
tr870:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st474
tr875:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st474
tr879:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:395
d=m
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st474
tr882:
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st474
tr885:
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st474
	st474:
		if p++; p == pe {
			goto _test_eof474
		}
	st_case_474:
//line parse.go:3522
		if ( s)[p] == 32 {
			goto st474
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st474
		}
		goto st0
tr867:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st25
tr871:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st25
tr876:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st25
tr880:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:395
d=m
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st25
tr883:
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st25
tr886:
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st25
	st25:
		if p++; p == pe {
			goto _test_eof25
		}
	st_case_25:
//line parse.go:3769
		switch ( s)[p] {
		case 42:
			goto tr63
		case 70:
			goto tr65
		case 77:
			goto tr66
		case 83:
			goto tr67
		case 84:
			goto tr68
		case 87:
			goto tr69
		case 102:
			goto tr65
		case 109:
			goto tr66
		case 115:
			goto tr67
		case 116:
			goto tr68
		case 119:
			goto tr69
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr64
		}
		goto st0
tr64:
//line parse.rl:394
d=0;
//line parse.rl:132

            mark = p;
        
	goto st475
	st475:
		if p++; p == pe {
			goto _test_eof475
		}
	st_case_475:
//line parse.go:3811
		switch ( s)[p] {
		case 32:
			goto tr870
		case 44:
			goto tr871
		case 45:
			goto tr872
		case 47:
			goto tr873
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st475
			}
		case ( s)[p] >= 9:
			goto tr870
		}
		goto st0
tr872:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
	goto st26
tr887:
//line parse.rl:394
 start=m; end=6;d=0;
	goto st26
	st26:
		if p++; p == pe {
			goto _test_eof26
		}
	st_case_26:
//line parse.go:3852
		switch ( s)[p] {
		case 70:
			goto st28
		case 77:
			goto st30
		case 83:
			goto st32
		case 84:
			goto st35
		case 87:
			goto st38
		case 102:
			goto st28
		case 109:
			goto st30
		case 115:
			goto st32
		case 116:
			goto st35
		case 119:
			goto st38
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr70
		}
		goto st0
tr70:
//line parse.rl:132

            mark = p;
        
	goto st476
	st476:
		if p++; p == pe {
			goto _test_eof476
		}
	st_case_476:
//line parse.go:3890
		switch ( s)[p] {
		case 32:
			goto tr875
		case 44:
			goto tr876
		case 47:
			goto tr877
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st476
			}
		case ( s)[p] >= 9:
			goto tr875
		}
		goto st0
tr868:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
	goto st27
tr873:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
	goto st27
tr877:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
	goto st27
tr884:
//line parse.rl:394
 end=m; d=1;
	goto st27
tr888:
//line parse.rl:394
 start=m; end=6;d=0;
	goto st27
	st27:
		if p++; p == pe {
			goto _test_eof27
		}
	st_case_27:
//line parse.go:3949
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr76
		}
		goto st0
tr76:
//line parse.rl:132

            mark = p;
        
	goto st477
	st477:
		if p++; p == pe {
			goto _test_eof477
		}
	st_case_477:
//line parse.go:3965
		switch ( s)[p] {
		case 32:
			goto tr879
		case 44:
			goto tr880
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st477
			}
		case ( s)[p] >= 9:
			goto tr879
		}
		goto st0
	st28:
		if p++; p == pe {
			goto _test_eof28
		}
	st_case_28:
		switch ( s)[p] {
		case 82:
			goto st29
		case 114:
			goto st29
		}
		goto st0
	st29:
		if p++; p == pe {
			goto _test_eof29
		}
	st_case_29:
		switch ( s)[p] {
		case 73:
			goto tr78
		case 105:
			goto tr78
		}
		goto st0
tr78:
//line parse.rl:369
m=5
	goto st478
tr80:
//line parse.rl:369
m=1
	goto st478
tr83:
//line parse.rl:369
m=6
	goto st478
tr84:
//line parse.rl:369
m=0
	goto st478
tr87:
//line parse.rl:369
m=4
	goto st478
tr88:
//line parse.rl:369
m=2
	goto st478
tr90:
//line parse.rl:369
m=3
	goto st478
	st478:
		if p++; p == pe {
			goto _test_eof478
		}
	st_case_478:
//line parse.go:4038
		switch ( s)[p] {
		case 32:
			goto tr882
		case 44:
			goto tr883
		case 47:
			goto tr884
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr882
		}
		goto st0
	st30:
		if p++; p == pe {
			goto _test_eof30
		}
	st_case_30:
		switch ( s)[p] {
		case 79:
			goto st31
		case 111:
			goto st31
		}
		goto st0
	st31:
		if p++; p == pe {
			goto _test_eof31
		}
	st_case_31:
		switch ( s)[p] {
		case 78:
			goto tr80
		case 110:
			goto tr80
		}
		goto st0
	st32:
		if p++; p == pe {
			goto _test_eof32
		}
	st_case_32:
		switch ( s)[p] {
		case 65:
			goto st33
		case 85:
			goto st34
		case 97:
			goto st33
		case 117:
			goto st34
		}
		goto st0
	st33:
		if p++; p == pe {
			goto _test_eof33
		}
	st_case_33:
		switch ( s)[p] {
		case 84:
			goto tr83
		case 116:
			goto tr83
		}
		goto st0
	st34:
		if p++; p == pe {
			goto _test_eof34
		}
	st_case_34:
		switch ( s)[p] {
		case 78:
			goto tr84
		case 110:
			goto tr84
		}
		goto st0
	st35:
		if p++; p == pe {
			goto _test_eof35
		}
	st_case_35:
		switch ( s)[p] {
		case 72:
			goto st36
		case 85:
			goto st37
		case 104:
			goto st36
		case 117:
			goto st37
		}
		goto st0
	st36:
		if p++; p == pe {
			goto _test_eof36
		}
	st_case_36:
		switch ( s)[p] {
		case 85:
			goto tr87
		case 117:
			goto tr87
		}
		goto st0
	st37:
		if p++; p == pe {
			goto _test_eof37
		}
	st_case_37:
		switch ( s)[p] {
		case 69:
			goto tr88
		case 101:
			goto tr88
		}
		goto st0
	st38:
		if p++; p == pe {
			goto _test_eof38
		}
	st_case_38:
		switch ( s)[p] {
		case 69:
			goto st39
		case 101:
			goto st39
		}
		goto st0
	st39:
		if p++; p == pe {
			goto _test_eof39
		}
	st_case_39:
		switch ( s)[p] {
		case 68:
			goto tr90
		case 100:
			goto tr90
		}
		goto st0
tr65:
//line parse.rl:394
d=0;
	goto st40
	st40:
		if p++; p == pe {
			goto _test_eof40
		}
	st_case_40:
//line parse.go:4188
		switch ( s)[p] {
		case 82:
			goto st41
		case 114:
			goto st41
		}
		goto st0
	st41:
		if p++; p == pe {
			goto _test_eof41
		}
	st_case_41:
		switch ( s)[p] {
		case 73:
			goto tr92
		case 105:
			goto tr92
		}
		goto st0
tr92:
//line parse.rl:369
m=5
	goto st479
tr94:
//line parse.rl:369
m=1
	goto st479
tr97:
//line parse.rl:369
m=6
	goto st479
tr98:
//line parse.rl:369
m=0
	goto st479
tr101:
//line parse.rl:369
m=4
	goto st479
tr102:
//line parse.rl:369
m=2
	goto st479
tr104:
//line parse.rl:369
m=3
	goto st479
	st479:
		if p++; p == pe {
			goto _test_eof479
		}
	st_case_479:
//line parse.go:4241
		switch ( s)[p] {
		case 32:
			goto tr885
		case 44:
			goto tr886
		case 45:
			goto tr887
		case 47:
			goto tr888
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr885
		}
		goto st0
tr66:
//line parse.rl:394
d=0;
	goto st42
	st42:
		if p++; p == pe {
			goto _test_eof42
		}
	st_case_42:
//line parse.go:4265
		switch ( s)[p] {
		case 79:
			goto st43
		case 111:
			goto st43
		}
		goto st0
	st43:
		if p++; p == pe {
			goto _test_eof43
		}
	st_case_43:
		switch ( s)[p] {
		case 78:
			goto tr94
		case 110:
			goto tr94
		}
		goto st0
tr67:
//line parse.rl:394
d=0;
	goto st44
	st44:
		if p++; p == pe {
			goto _test_eof44
		}
	st_case_44:
//line parse.go:4294
		switch ( s)[p] {
		case 65:
			goto st45
		case 85:
			goto st46
		case 97:
			goto st45
		case 117:
			goto st46
		}
		goto st0
	st45:
		if p++; p == pe {
			goto _test_eof45
		}
	st_case_45:
		switch ( s)[p] {
		case 84:
			goto tr97
		case 116:
			goto tr97
		}
		goto st0
	st46:
		if p++; p == pe {
			goto _test_eof46
		}
	st_case_46:
		switch ( s)[p] {
		case 78:
			goto tr98
		case 110:
			goto tr98
		}
		goto st0
tr68:
//line parse.rl:394
d=0;
	goto st47
	st47:
		if p++; p == pe {
			goto _test_eof47
		}
	st_case_47:
//line parse.go:4339
		switch ( s)[p] {
		case 72:
			goto st48
		case 85:
			goto st49
		case 104:
			goto st48
		case 117:
			goto st49
		}
		goto st0
	st48:
		if p++; p == pe {
			goto _test_eof48
		}
	st_case_48:
		switch ( s)[p] {
		case 85:
			goto tr101
		case 117:
			goto tr101
		}
		goto st0
	st49:
		if p++; p == pe {
			goto _test_eof49
		}
	st_case_49:
		switch ( s)[p] {
		case 69:
			goto tr102
		case 101:
			goto tr102
		}
		goto st0
tr69:
//line parse.rl:394
d=0;
	goto st50
	st50:
		if p++; p == pe {
			goto _test_eof50
		}
	st_case_50:
//line parse.go:4384
		switch ( s)[p] {
		case 69:
			goto st51
		case 101:
			goto st51
		}
		goto st0
	st51:
		if p++; p == pe {
			goto _test_eof51
		}
	st_case_51:
		switch ( s)[p] {
		case 68:
			goto tr104
		case 100:
			goto tr104
		}
		goto st0
tr60:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st52
tr106:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st52
tr120:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st52
tr125:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:391
d=m
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st52
tr131:
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st52
tr156:
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st52
	st52:
		if p++; p == pe {
			goto _test_eof52
		}
	st_case_52:
//line parse.go:4607
		switch ( s)[p] {
		case 42:
			goto tr49
		case 65:
			goto tr51
		case 68:
			goto tr52
		case 70:
			goto tr53
		case 74:
			goto tr54
		case 77:
			goto tr55
		case 78:
			goto tr56
		case 79:
			goto tr57
		case 83:
			goto tr58
		case 97:
			goto tr51
		case 100:
			goto tr52
		case 102:
			goto tr53
		case 106:
			goto tr54
		case 109:
			goto tr55
		case 110:
			goto tr56
		case 111:
			goto tr57
		case 115:
			goto tr58
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr50
		}
		goto st0
tr50:
//line parse.rl:390
d=0;
//line parse.rl:132

            mark = p;
        
	goto st53
	st53:
		if p++; p == pe {
			goto _test_eof53
		}
	st_case_53:
//line parse.go:4661
		switch ( s)[p] {
		case 32:
			goto tr105
		case 44:
			goto tr106
		case 45:
			goto tr107
		case 47:
			goto tr108
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st53
			}
		case ( s)[p] >= 9:
			goto tr105
		}
		goto st0
tr107:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
	goto st54
tr157:
//line parse.rl:390
 start=m; end=0;d=0;
	goto st54
	st54:
		if p++; p == pe {
			goto _test_eof54
		}
	st_case_54:
//line parse.go:4702
		switch ( s)[p] {
		case 65:
			goto st58
		case 68:
			goto st62
		case 70:
			goto st64
		case 74:
			goto st66
		case 77:
			goto st69
		case 78:
			goto st71
		case 79:
			goto st73
		case 83:
			goto st75
		case 97:
			goto st58
		case 100:
			goto st62
		case 102:
			goto st64
		case 106:
			goto st66
		case 109:
			goto st69
		case 110:
			goto st71
		case 111:
			goto st73
		case 115:
			goto st75
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr110
		}
		goto st0
tr110:
//line parse.rl:132

            mark = p;
        
	goto st55
	st55:
		if p++; p == pe {
			goto _test_eof55
		}
	st_case_55:
//line parse.go:4752
		switch ( s)[p] {
		case 32:
			goto tr119
		case 44:
			goto tr120
		case 47:
			goto tr121
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st55
			}
		case ( s)[p] >= 9:
			goto tr119
		}
		goto st0
tr61:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
	goto st56
tr108:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
	goto st56
tr121:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
	goto st56
tr132:
//line parse.rl:390
 end=m; d=1;
	goto st56
tr158:
//line parse.rl:390
 start=m; end=0;d=0;
	goto st56
	st56:
		if p++; p == pe {
			goto _test_eof56
		}
	st_case_56:
//line parse.go:4811
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr123
		}
		goto st0
tr123:
//line parse.rl:132

            mark = p;
        
	goto st57
	st57:
		if p++; p == pe {
			goto _test_eof57
		}
	st_case_57:
//line parse.go:4827
		switch ( s)[p] {
		case 32:
			goto tr124
		case 44:
			goto tr125
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st57
			}
		case ( s)[p] >= 9:
			goto tr124
		}
		goto st0
	st58:
		if p++; p == pe {
			goto _test_eof58
		}
	st_case_58:
		switch ( s)[p] {
		case 80:
			goto st59
		case 85:
			goto st61
		case 112:
			goto st59
		case 117:
			goto st61
		}
		goto st0
	st59:
		if p++; p == pe {
			goto _test_eof59
		}
	st_case_59:
		switch ( s)[p] {
		case 82:
			goto tr129
		case 114:
			goto tr129
		}
		goto st0
tr129:
//line parse.rl:370
m=4
	goto st60
tr133:
//line parse.rl:370
m=8
	goto st60
tr135:
//line parse.rl:370
m=12
	goto st60
tr137:
//line parse.rl:370
m=2
	goto st60
tr140:
//line parse.rl:370
m=1
	goto st60
tr141:
//line parse.rl:370
m=7
	goto st60
tr142:
//line parse.rl:370
m=6
	goto st60
tr144:
//line parse.rl:370
m=3
	goto st60
tr145:
//line parse.rl:370
m=5
	goto st60
tr147:
//line parse.rl:370
m=11
	goto st60
tr149:
//line parse.rl:370
m=10
	goto st60
tr151:
//line parse.rl:370
m=9
	goto st60
	st60:
		if p++; p == pe {
			goto _test_eof60
		}
	st_case_60:
//line parse.go:4924
		switch ( s)[p] {
		case 32:
			goto tr130
		case 44:
			goto tr131
		case 47:
			goto tr132
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr130
		}
		goto st0
	st61:
		if p++; p == pe {
			goto _test_eof61
		}
	st_case_61:
		switch ( s)[p] {
		case 71:
			goto tr133
		case 103:
			goto tr133
		}
		goto st0
	st62:
		if p++; p == pe {
			goto _test_eof62
		}
	st_case_62:
		switch ( s)[p] {
		case 69:
			goto st63
		case 101:
			goto st63
		}
		goto st0
	st63:
		if p++; p == pe {
			goto _test_eof63
		}
	st_case_63:
		switch ( s)[p] {
		case 67:
			goto tr135
		case 99:
			goto tr135
		}
		goto st0
	st64:
		if p++; p == pe {
			goto _test_eof64
		}
	st_case_64:
		switch ( s)[p] {
		case 69:
			goto st65
		case 101:
			goto st65
		}
		goto st0
	st65:
		if p++; p == pe {
			goto _test_eof65
		}
	st_case_65:
		switch ( s)[p] {
		case 66:
			goto tr137
		case 98:
			goto tr137
		}
		goto st0
	st66:
		if p++; p == pe {
			goto _test_eof66
		}
	st_case_66:
		switch ( s)[p] {
		case 65:
			goto st67
		case 85:
			goto st68
		case 97:
			goto st67
		case 117:
			goto st68
		}
		goto st0
	st67:
		if p++; p == pe {
			goto _test_eof67
		}
	st_case_67:
		switch ( s)[p] {
		case 78:
			goto tr140
		case 110:
			goto tr140
		}
		goto st0
	st68:
		if p++; p == pe {
			goto _test_eof68
		}
	st_case_68:
		switch ( s)[p] {
		case 76:
			goto tr141
		case 78:
			goto tr142
		case 108:
			goto tr141
		case 110:
			goto tr142
		}
		goto st0
	st69:
		if p++; p == pe {
			goto _test_eof69
		}
	st_case_69:
		switch ( s)[p] {
		case 65:
			goto st70
		case 97:
			goto st70
		}
		goto st0
	st70:
		if p++; p == pe {
			goto _test_eof70
		}
	st_case_70:
		switch ( s)[p] {
		case 82:
			goto tr144
		case 89:
			goto tr145
		case 114:
			goto tr144
		case 121:
			goto tr145
		}
		goto st0
	st71:
		if p++; p == pe {
			goto _test_eof71
		}
	st_case_71:
		switch ( s)[p] {
		case 79:
			goto st72
		case 111:
			goto st72
		}
		goto st0
	st72:
		if p++; p == pe {
			goto _test_eof72
		}
	st_case_72:
		switch ( s)[p] {
		case 86:
			goto tr147
		case 118:
			goto tr147
		}
		goto st0
	st73:
		if p++; p == pe {
			goto _test_eof73
		}
	st_case_73:
		switch ( s)[p] {
		case 67:
			goto st74
		case 99:
			goto st74
		}
		goto st0
	st74:
		if p++; p == pe {
			goto _test_eof74
		}
	st_case_74:
		switch ( s)[p] {
		case 84:
			goto tr149
		case 116:
			goto tr149
		}
		goto st0
	st75:
		if p++; p == pe {
			goto _test_eof75
		}
	st_case_75:
		switch ( s)[p] {
		case 69:
			goto st76
		case 101:
			goto st76
		}
		goto st0
	st76:
		if p++; p == pe {
			goto _test_eof76
		}
	st_case_76:
		switch ( s)[p] {
		case 80:
			goto tr151
		case 112:
			goto tr151
		}
		goto st0
tr51:
//line parse.rl:390
d=0;
	goto st77
	st77:
		if p++; p == pe {
			goto _test_eof77
		}
	st_case_77:
//line parse.go:5150
		switch ( s)[p] {
		case 80:
			goto st78
		case 85:
			goto st80
		case 112:
			goto st78
		case 117:
			goto st80
		}
		goto st0
	st78:
		if p++; p == pe {
			goto _test_eof78
		}
	st_case_78:
		switch ( s)[p] {
		case 82:
			goto tr154
		case 114:
			goto tr154
		}
		goto st0
tr154:
//line parse.rl:370
m=4
	goto st79
tr159:
//line parse.rl:370
m=8
	goto st79
tr161:
//line parse.rl:370
m=12
	goto st79
tr163:
//line parse.rl:370
m=2
	goto st79
tr166:
//line parse.rl:370
m=1
	goto st79
tr167:
//line parse.rl:370
m=7
	goto st79
tr168:
//line parse.rl:370
m=6
	goto st79
tr170:
//line parse.rl:370
m=3
	goto st79
tr171:
//line parse.rl:370
m=5
	goto st79
tr173:
//line parse.rl:370
m=11
	goto st79
tr175:
//line parse.rl:370
m=10
	goto st79
tr177:
//line parse.rl:370
m=9
	goto st79
	st79:
		if p++; p == pe {
			goto _test_eof79
		}
	st_case_79:
//line parse.go:5227
		switch ( s)[p] {
		case 32:
			goto tr155
		case 44:
			goto tr156
		case 45:
			goto tr157
		case 47:
			goto tr158
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr155
		}
		goto st0
	st80:
		if p++; p == pe {
			goto _test_eof80
		}
	st_case_80:
		switch ( s)[p] {
		case 71:
			goto tr159
		case 103:
			goto tr159
		}
		goto st0
tr52:
//line parse.rl:390
d=0;
	goto st81
	st81:
		if p++; p == pe {
			goto _test_eof81
		}
	st_case_81:
//line parse.go:5263
		switch ( s)[p] {
		case 69:
			goto st82
		case 101:
			goto st82
		}
		goto st0
	st82:
		if p++; p == pe {
			goto _test_eof82
		}
	st_case_82:
		switch ( s)[p] {
		case 67:
			goto tr161
		case 99:
			goto tr161
		}
		goto st0
tr53:
//line parse.rl:390
d=0;
	goto st83
	st83:
		if p++; p == pe {
			goto _test_eof83
		}
	st_case_83:
//line parse.go:5292
		switch ( s)[p] {
		case 69:
			goto st84
		case 101:
			goto st84
		}
		goto st0
	st84:
		if p++; p == pe {
			goto _test_eof84
		}
	st_case_84:
		switch ( s)[p] {
		case 66:
			goto tr163
		case 98:
			goto tr163
		}
		goto st0
tr54:
//line parse.rl:390
d=0;
	goto st85
	st85:
		if p++; p == pe {
			goto _test_eof85
		}
	st_case_85:
//line parse.go:5321
		switch ( s)[p] {
		case 65:
			goto st86
		case 85:
			goto st87
		case 97:
			goto st86
		case 117:
			goto st87
		}
		goto st0
	st86:
		if p++; p == pe {
			goto _test_eof86
		}
	st_case_86:
		switch ( s)[p] {
		case 78:
			goto tr166
		case 110:
			goto tr166
		}
		goto st0
	st87:
		if p++; p == pe {
			goto _test_eof87
		}
	st_case_87:
		switch ( s)[p] {
		case 76:
			goto tr167
		case 78:
			goto tr168
		case 108:
			goto tr167
		case 110:
			goto tr168
		}
		goto st0
tr55:
//line parse.rl:390
d=0;
	goto st88
	st88:
		if p++; p == pe {
			goto _test_eof88
		}
	st_case_88:
//line parse.go:5370
		switch ( s)[p] {
		case 65:
			goto st89
		case 97:
			goto st89
		}
		goto st0
	st89:
		if p++; p == pe {
			goto _test_eof89
		}
	st_case_89:
		switch ( s)[p] {
		case 82:
			goto tr170
		case 89:
			goto tr171
		case 114:
			goto tr170
		case 121:
			goto tr171
		}
		goto st0
tr56:
//line parse.rl:390
d=0;
	goto st90
	st90:
		if p++; p == pe {
			goto _test_eof90
		}
	st_case_90:
//line parse.go:5403
		switch ( s)[p] {
		case 79:
			goto st91
		case 111:
			goto st91
		}
		goto st0
	st91:
		if p++; p == pe {
			goto _test_eof91
		}
	st_case_91:
		switch ( s)[p] {
		case 86:
			goto tr173
		case 118:
			goto tr173
		}
		goto st0
tr57:
//line parse.rl:390
d=0;
	goto st92
	st92:
		if p++; p == pe {
			goto _test_eof92
		}
	st_case_92:
//line parse.go:5432
		switch ( s)[p] {
		case 67:
			goto st93
		case 99:
			goto st93
		}
		goto st0
	st93:
		if p++; p == pe {
			goto _test_eof93
		}
	st_case_93:
		switch ( s)[p] {
		case 84:
			goto tr175
		case 116:
			goto tr175
		}
		goto st0
tr58:
//line parse.rl:390
d=0;
	goto st94
	st94:
		if p++; p == pe {
			goto _test_eof94
		}
	st_case_94:
//line parse.go:5461
		switch ( s)[p] {
		case 69:
			goto st95
		case 101:
			goto st95
		}
		goto st0
	st95:
		if p++; p == pe {
			goto _test_eof95
		}
	st_case_95:
		switch ( s)[p] {
		case 80:
			goto tr177
		case 112:
			goto tr177
		}
		goto st0
tr46:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st96
tr179:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st96
tr190:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st96
tr195:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:387
d=m
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st96
tr200:
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st96
tr217:
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st96
	st96:
		if p++; p == pe {
			goto _test_eof96
		}
	st_case_96:
//line parse.go:5684
		switch ( s)[p] {
		case 42:
			goto tr38
		case 70:
			goto tr40
		case 77:
			goto tr41
		case 83:
			goto tr42
		case 84:
			goto tr43
		case 87:
			goto tr44
		case 102:
			goto tr40
		case 109:
			goto tr41
		case 115:
			goto tr42
		case 116:
			goto tr43
		case 119:
			goto tr44
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr39
		}
		goto st0
tr39:
//line parse.rl:386
d=0;
//line parse.rl:132

            mark = p;
        
	goto st97
	st97:
		if p++; p == pe {
			goto _test_eof97
		}
	st_case_97:
//line parse.go:5726
		switch ( s)[p] {
		case 32:
			goto tr178
		case 44:
			goto tr179
		case 45:
			goto tr180
		case 47:
			goto tr181
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st97
			}
		case ( s)[p] >= 9:
			goto tr178
		}
		goto st0
tr180:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st98
tr218:
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st98
	st98:
		if p++; p == pe {
			goto _test_eof98
		}
	st_case_98:
//line parse.go:5767
		switch ( s)[p] {
		case 70:
			goto st102
		case 77:
			goto st105
		case 83:
			goto st107
		case 84:
			goto st110
		case 87:
			goto st113
		case 102:
			goto st102
		case 109:
			goto st105
		case 115:
			goto st107
		case 116:
			goto st110
		case 119:
			goto st113
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr183
		}
		goto st0
tr183:
//line parse.rl:132

            mark = p;
        
	goto st99
	st99:
		if p++; p == pe {
			goto _test_eof99
		}
	st_case_99:
//line parse.go:5805
		switch ( s)[p] {
		case 32:
			goto tr189
		case 44:
			goto tr190
		case 47:
			goto tr191
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st99
			}
		case ( s)[p] >= 9:
			goto tr189
		}
		goto st0
tr47:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
	goto st100
tr181:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st100
tr191:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
	goto st100
tr201:
//line parse.rl:386
 end=m-1; d=1;
	goto st100
tr219:
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st100
	st100:
		if p++; p == pe {
			goto _test_eof100
		}
	st_case_100:
//line parse.go:5864
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr193
		}
		goto st0
tr193:
//line parse.rl:132

            mark = p;
        
	goto st101
	st101:
		if p++; p == pe {
			goto _test_eof101
		}
	st_case_101:
//line parse.go:5880
		switch ( s)[p] {
		case 32:
			goto tr194
		case 44:
			goto tr195
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st101
			}
		case ( s)[p] >= 9:
			goto tr194
		}
		goto st0
	st102:
		if p++; p == pe {
			goto _test_eof102
		}
	st_case_102:
		switch ( s)[p] {
		case 82:
			goto st103
		case 114:
			goto st103
		}
		goto st0
	st103:
		if p++; p == pe {
			goto _test_eof103
		}
	st_case_103:
		switch ( s)[p] {
		case 73:
			goto tr198
		case 105:
			goto tr198
		}
		goto st0
tr198:
//line parse.rl:369
m=5
	goto st104
tr203:
//line parse.rl:369
m=1
	goto st104
tr206:
//line parse.rl:369
m=6
	goto st104
tr207:
//line parse.rl:369
m=0
	goto st104
tr210:
//line parse.rl:369
m=4
	goto st104
tr211:
//line parse.rl:369
m=2
	goto st104
tr213:
//line parse.rl:369
m=3
	goto st104
	st104:
		if p++; p == pe {
			goto _test_eof104
		}
	st_case_104:
//line parse.go:5953
		switch ( s)[p] {
		case 32:
			goto tr199
		case 44:
			goto tr200
		case 47:
			goto tr201
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr199
		}
		goto st0
	st105:
		if p++; p == pe {
			goto _test_eof105
		}
	st_case_105:
		switch ( s)[p] {
		case 79:
			goto st106
		case 111:
			goto st106
		}
		goto st0
	st106:
		if p++; p == pe {
			goto _test_eof106
		}
	st_case_106:
		switch ( s)[p] {
		case 78:
			goto tr203
		case 110:
			goto tr203
		}
		goto st0
	st107:
		if p++; p == pe {
			goto _test_eof107
		}
	st_case_107:
		switch ( s)[p] {
		case 65:
			goto st108
		case 85:
			goto st109
		case 97:
			goto st108
		case 117:
			goto st109
		}
		goto st0
	st108:
		if p++; p == pe {
			goto _test_eof108
		}
	st_case_108:
		switch ( s)[p] {
		case 84:
			goto tr206
		case 116:
			goto tr206
		}
		goto st0
	st109:
		if p++; p == pe {
			goto _test_eof109
		}
	st_case_109:
		switch ( s)[p] {
		case 78:
			goto tr207
		case 110:
			goto tr207
		}
		goto st0
	st110:
		if p++; p == pe {
			goto _test_eof110
		}
	st_case_110:
		switch ( s)[p] {
		case 72:
			goto st111
		case 85:
			goto st112
		case 104:
			goto st111
		case 117:
			goto st112
		}
		goto st0
	st111:
		if p++; p == pe {
			goto _test_eof111
		}
	st_case_111:
		switch ( s)[p] {
		case 85:
			goto tr210
		case 117:
			goto tr210
		}
		goto st0
	st112:
		if p++; p == pe {
			goto _test_eof112
		}
	st_case_112:
		switch ( s)[p] {
		case 69:
			goto tr211
		case 101:
			goto tr211
		}
		goto st0
	st113:
		if p++; p == pe {
			goto _test_eof113
		}
	st_case_113:
		switch ( s)[p] {
		case 69:
			goto st114
		case 101:
			goto st114
		}
		goto st0
	st114:
		if p++; p == pe {
			goto _test_eof114
		}
	st_case_114:
		switch ( s)[p] {
		case 68:
			goto tr213
		case 100:
			goto tr213
		}
		goto st0
tr40:
//line parse.rl:386
d=0;
	goto st115
	st115:
		if p++; p == pe {
			goto _test_eof115
		}
	st_case_115:
//line parse.go:6103
		switch ( s)[p] {
		case 82:
			goto st116
		case 114:
			goto st116
		}
		goto st0
	st116:
		if p++; p == pe {
			goto _test_eof116
		}
	st_case_116:
		switch ( s)[p] {
		case 73:
			goto tr215
		case 105:
			goto tr215
		}
		goto st0
tr215:
//line parse.rl:369
m=5
	goto st117
tr221:
//line parse.rl:369
m=1
	goto st117
tr224:
//line parse.rl:369
m=6
	goto st117
tr225:
//line parse.rl:369
m=0
	goto st117
tr228:
//line parse.rl:369
m=4
	goto st117
tr229:
//line parse.rl:369
m=2
	goto st117
tr231:
//line parse.rl:369
m=3
	goto st117
	st117:
		if p++; p == pe {
			goto _test_eof117
		}
	st_case_117:
//line parse.go:6156
		switch ( s)[p] {
		case 32:
			goto tr216
		case 44:
			goto tr217
		case 45:
			goto tr218
		case 47:
			goto tr219
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr216
		}
		goto st0
tr41:
//line parse.rl:386
d=0;
	goto st118
	st118:
		if p++; p == pe {
			goto _test_eof118
		}
	st_case_118:
//line parse.go:6180
		switch ( s)[p] {
		case 79:
			goto st119
		case 111:
			goto st119
		}
		goto st0
	st119:
		if p++; p == pe {
			goto _test_eof119
		}
	st_case_119:
		switch ( s)[p] {
		case 78:
			goto tr221
		case 110:
			goto tr221
		}
		goto st0
tr42:
//line parse.rl:386
d=0;
	goto st120
	st120:
		if p++; p == pe {
			goto _test_eof120
		}
	st_case_120:
//line parse.go:6209
		switch ( s)[p] {
		case 65:
			goto st121
		case 85:
			goto st122
		case 97:
			goto st121
		case 117:
			goto st122
		}
		goto st0
	st121:
		if p++; p == pe {
			goto _test_eof121
		}
	st_case_121:
		switch ( s)[p] {
		case 84:
			goto tr224
		case 116:
			goto tr224
		}
		goto st0
	st122:
		if p++; p == pe {
			goto _test_eof122
		}
	st_case_122:
		switch ( s)[p] {
		case 78:
			goto tr225
		case 110:
			goto tr225
		}
		goto st0
tr43:
//line parse.rl:386
d=0;
	goto st123
	st123:
		if p++; p == pe {
			goto _test_eof123
		}
	st_case_123:
//line parse.go:6254
		switch ( s)[p] {
		case 72:
			goto st124
		case 85:
			goto st125
		case 104:
			goto st124
		case 117:
			goto st125
		}
		goto st0
	st124:
		if p++; p == pe {
			goto _test_eof124
		}
	st_case_124:
		switch ( s)[p] {
		case 85:
			goto tr228
		case 117:
			goto tr228
		}
		goto st0
	st125:
		if p++; p == pe {
			goto _test_eof125
		}
	st_case_125:
		switch ( s)[p] {
		case 69:
			goto tr229
		case 101:
			goto tr229
		}
		goto st0
tr44:
//line parse.rl:386
d=0;
	goto st126
	st126:
		if p++; p == pe {
			goto _test_eof126
		}
	st_case_126:
//line parse.go:6299
		switch ( s)[p] {
		case 69:
			goto st127
		case 101:
			goto st127
		}
		goto st0
	st127:
		if p++; p == pe {
			goto _test_eof127
		}
	st_case_127:
		switch ( s)[p] {
		case 68:
			goto tr231
		case 100:
			goto tr231
		}
		goto st0
tr35:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st128
tr233:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st128
tr239:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st128
tr244:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:383
d=m
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st128
	st128:
		if p++; p == pe {
			goto _test_eof128
		}
	st_case_128:
//line parse.go:6464
		if ( s)[p] == 42 {
			goto tr32
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr33
		}
		goto st0
tr33:
//line parse.rl:382
d=0;
//line parse.rl:132

            mark = p;
        
	goto st129
	st129:
		if p++; p == pe {
			goto _test_eof129
		}
	st_case_129:
//line parse.go:6485
		switch ( s)[p] {
		case 32:
			goto tr232
		case 44:
			goto tr233
		case 45:
			goto tr234
		case 47:
			goto tr235
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st129
			}
		case ( s)[p] >= 9:
			goto tr232
		}
		goto st0
tr234:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
	goto st130
	st130:
		if p++; p == pe {
			goto _test_eof130
		}
	st_case_130:
//line parse.go:6522
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr237
		}
		goto st0
tr237:
//line parse.rl:132

            mark = p;
        
	goto st131
	st131:
		if p++; p == pe {
			goto _test_eof131
		}
	st_case_131:
//line parse.go:6538
		switch ( s)[p] {
		case 32:
			goto tr238
		case 44:
			goto tr239
		case 47:
			goto tr240
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st131
			}
		case ( s)[p] >= 9:
			goto tr238
		}
		goto st0
tr36:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
	goto st132
tr235:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
	goto st132
tr240:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
	goto st132
	st132:
		if p++; p == pe {
			goto _test_eof132
		}
	st_case_132:
//line parse.go:6589
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr242
		}
		goto st0
tr242:
//line parse.rl:132

            mark = p;
        
	goto st133
	st133:
		if p++; p == pe {
			goto _test_eof133
		}
	st_case_133:
//line parse.go:6605
		switch ( s)[p] {
		case 32:
			goto tr243
		case 44:
			goto tr244
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st133
			}
		case ( s)[p] >= 9:
			goto tr243
		}
		goto st0
tr29:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st134
tr247:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st134
tr253:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st134
tr258:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:379
d=m
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st134
	st134:
		if p++; p == pe {
			goto _test_eof134
		}
	st_case_134:
//line parse.go:6766
		if ( s)[p] == 42 {
			goto tr26
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr27
		}
		goto st0
tr27:
//line parse.rl:375
d=0;
//line parse.rl:132

            mark = p;
        
	goto st135
	st135:
		if p++; p == pe {
			goto _test_eof135
		}
	st_case_135:
//line parse.go:6787
		switch ( s)[p] {
		case 32:
			goto tr246
		case 44:
			goto tr247
		case 45:
			goto tr248
		case 47:
			goto tr249
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st135
			}
		case ( s)[p] >= 9:
			goto tr246
		}
		goto st0
tr248:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st136
	st136:
		if p++; p == pe {
			goto _test_eof136
		}
	st_case_136:
//line parse.go:6824
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr251
		}
		goto st0
tr251:
//line parse.rl:132

            mark = p;
        
	goto st137
	st137:
		if p++; p == pe {
			goto _test_eof137
		}
	st_case_137:
//line parse.go:6840
		switch ( s)[p] {
		case 32:
			goto tr252
		case 44:
			goto tr253
		case 47:
			goto tr254
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st137
			}
		case ( s)[p] >= 9:
			goto tr252
		}
		goto st0
tr30:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
	goto st138
tr249:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st138
tr254:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
	goto st138
	st138:
		if p++; p == pe {
			goto _test_eof138
		}
	st_case_138:
//line parse.go:6891
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr256
		}
		goto st0
tr256:
//line parse.rl:132

            mark = p;
        
	goto st139
	st139:
		if p++; p == pe {
			goto _test_eof139
		}
	st_case_139:
//line parse.go:6907
		switch ( s)[p] {
		case 32:
			goto tr257
		case 44:
			goto tr258
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st139
			}
		case ( s)[p] >= 9:
			goto tr257
		}
		goto st0
tr24:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
	goto st140
tr267:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st140
tr272:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
	goto st140
	st140:
		if p++; p == pe {
			goto _test_eof140
		}
	st_case_140:
//line parse.go:6956
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr260
		}
		goto st0
tr260:
//line parse.rl:132

            mark = p;
        
	goto st141
	st141:
		if p++; p == pe {
			goto _test_eof141
		}
	st_case_141:
//line parse.go:6972
		switch ( s)[p] {
		case 32:
			goto tr261
		case 44:
			goto tr262
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st141
			}
		case ( s)[p] >= 9:
			goto tr261
		}
		goto st0
tr21:
//line parse.rl:375
d=0;
//line parse.rl:132

            mark = p;
        
	goto st142
	st142:
		if p++; p == pe {
			goto _test_eof142
		}
	st_case_142:
//line parse.go:7001
		switch ( s)[p] {
		case 32:
			goto tr264
		case 44:
			goto tr265
		case 45:
			goto tr266
		case 47:
			goto tr267
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st142
			}
		case ( s)[p] >= 9:
			goto tr264
		}
		goto st0
tr266:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st143
	st143:
		if p++; p == pe {
			goto _test_eof143
		}
	st_case_143:
//line parse.go:7038
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr269
		}
		goto st0
tr269:
//line parse.rl:132

            mark = p;
        
	goto st144
	st144:
		if p++; p == pe {
			goto _test_eof144
		}
	st_case_144:
//line parse.go:7054
		switch ( s)[p] {
		case 32:
			goto tr270
		case 44:
			goto tr271
		case 47:
			goto tr272
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st144
			}
		case ( s)[p] >= 9:
			goto tr270
		}
		goto st0
tr277:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st145
tr543:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:376
d=m
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st145
tr546:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st145
tr552:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st145
	st145:
//line NONE:1
ts = 0

		if p++; p == pe {
			goto _test_eof145
		}
	st_case_145:
//line parse.go:7220
		if ( s)[p] == 42 {
			goto tr274
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr275
		}
		goto st0
tr274:
//line parse.rl:375
d=0;
	goto st146
	st146:
		if p++; p == pe {
			goto _test_eof146
		}
	st_case_146:
//line parse.go:7237
		switch ( s)[p] {
		case 32:
			goto tr276
		case 44:
			goto tr277
		case 47:
			goto tr278
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr276
		}
		goto st0
tr276:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st147
tr542:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:376
d=m
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st147
tr545:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st147
tr551:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:136

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid second */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start second %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end second %d", end)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.second |= 1<<m
                }else{
                    nt.second |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st147
	st147:
		if p++; p == pe {
			goto _test_eof147
		}
	st_case_147:
//line parse.go:7395
		switch ( s)[p] {
		case 32:
			goto st147
		case 42:
			goto tr280
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr281
			}
		case ( s)[p] >= 9:
			goto st147
		}
		goto st0
tr280:
//line parse.rl:375
d=0;
	goto st148
	st148:
		if p++; p == pe {
			goto _test_eof148
		}
	st_case_148:
//line parse.go:7420
		switch ( s)[p] {
		case 32:
			goto tr282
		case 44:
			goto tr283
		case 47:
			goto tr284
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr282
		}
		goto st0
tr282:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st149
tr527:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st149
tr533:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st149
tr538:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:379
d=m
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st149
	st149:
		if p++; p == pe {
			goto _test_eof149
		}
	st_case_149:
//line parse.go:7578
		switch ( s)[p] {
		case 32:
			goto st149
		case 42:
			goto tr286
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr287
			}
		case ( s)[p] >= 9:
			goto st149
		}
		goto st0
tr286:
//line parse.rl:382
d=0;
	goto st150
	st150:
		if p++; p == pe {
			goto _test_eof150
		}
	st_case_150:
//line parse.go:7603
		switch ( s)[p] {
		case 32:
			goto tr288
		case 44:
			goto tr289
		case 47:
			goto tr290
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr288
		}
		goto st0
tr288:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st151
tr513:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st151
tr519:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st151
tr524:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:383
d=m
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st151
	st151:
		if p++; p == pe {
			goto _test_eof151
		}
	st_case_151:
//line parse.go:7761
		switch ( s)[p] {
		case 32:
			goto st151
		case 42:
			goto tr292
		case 70:
			goto tr294
		case 77:
			goto tr295
		case 83:
			goto tr296
		case 84:
			goto tr297
		case 87:
			goto tr298
		case 102:
			goto tr294
		case 109:
			goto tr295
		case 115:
			goto tr296
		case 116:
			goto tr297
		case 119:
			goto tr298
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr293
			}
		case ( s)[p] >= 9:
			goto st151
		}
		goto st0
tr292:
//line parse.rl:386
d=0;
	goto st152
	st152:
		if p++; p == pe {
			goto _test_eof152
		}
	st_case_152:
//line parse.go:7806
		switch ( s)[p] {
		case 32:
			goto tr299
		case 44:
			goto tr300
		case 47:
			goto tr301
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr299
		}
		goto st0
tr299:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st153
tr459:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st153
tr470:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st153
tr475:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:387
d=m
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st153
tr480:
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st153
tr497:
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st153
	st153:
		if p++; p == pe {
			goto _test_eof153
		}
	st_case_153:
//line parse.go:8022
		switch ( s)[p] {
		case 32:
			goto st153
		case 42:
			goto tr303
		case 65:
			goto tr305
		case 68:
			goto tr306
		case 70:
			goto tr307
		case 74:
			goto tr308
		case 77:
			goto tr309
		case 78:
			goto tr310
		case 79:
			goto tr311
		case 83:
			goto tr312
		case 97:
			goto tr305
		case 100:
			goto tr306
		case 102:
			goto tr307
		case 106:
			goto tr308
		case 109:
			goto tr309
		case 110:
			goto tr310
		case 111:
			goto tr311
		case 115:
			goto tr312
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr304
			}
		case ( s)[p] >= 9:
			goto st153
		}
		goto st0
tr303:
//line parse.rl:390
d=0;
	goto st154
	st154:
		if p++; p == pe {
			goto _test_eof154
		}
	st_case_154:
//line parse.go:8079
		switch ( s)[p] {
		case 32:
			goto tr313
		case 44:
			goto tr314
		case 47:
			goto tr315
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr313
		}
		goto st0
tr313:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st155
tr386:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st155
tr400:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st155
tr405:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:391
d=m
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st155
tr411:
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st155
tr436:
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st155
	st155:
		if p++; p == pe {
			goto _test_eof155
		}
	st_case_155:
//line parse.go:8295
		switch ( s)[p] {
		case 32:
			goto st155
		case 42:
			goto tr317
		case 70:
			goto tr319
		case 77:
			goto tr320
		case 83:
			goto tr321
		case 84:
			goto tr322
		case 87:
			goto tr323
		case 102:
			goto tr319
		case 109:
			goto tr320
		case 115:
			goto tr321
		case 116:
			goto tr322
		case 119:
			goto tr323
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr318
			}
		case ( s)[p] >= 9:
			goto st155
		}
		goto st0
tr317:
//line parse.rl:394
d=0;
	goto st156
	st156:
		if p++; p == pe {
			goto _test_eof156
		}
	st_case_156:
//line parse.go:8340
		switch ( s)[p] {
		case 32:
			goto tr324
		case 44:
			goto tr325
		case 47:
			goto tr326
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr324
		}
		goto st0
tr324:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st157
tr332:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st157
tr343:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st157
tr348:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:395
d=m
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st157
tr353:
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st157
tr370:
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st157
	st157:
		if p++; p == pe {
			goto _test_eof157
		}
	st_case_157:
//line parse.go:8592
		switch ( s)[p] {
		case 32:
			goto st157
		case 42:
			goto tr328
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr329
			}
		case ( s)[p] >= 9:
			goto st157
		}
		goto st0
tr328:
//line parse.rl:398
d=0;
	goto st480
	st480:
		if p++; p == pe {
			goto _test_eof480
		}
	st_case_480:
//line parse.go:8617
		switch ( s)[p] {
		case 32:
			goto tr889
		case 44:
			goto tr890
		case 47:
			goto tr891
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr889
		}
		goto st0
tr889:
//line parse.rl:398
 start=1970;end=2099;m=0;d=1; 
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
	goto st481
tr893:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 start=m; end=m; d=0;
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
	goto st481
tr898:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 end=m; d=1;
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
	goto st481
tr902:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:399
d=m
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
	goto st481
	st481:
		if p++; p == pe {
			goto _test_eof481
		}
	st_case_481:
//line parse.go:8895
		if ( s)[p] == 32 {
			goto st481
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st481
		}
		goto st0
tr890:
//line parse.rl:398
 start=1970;end=2099;m=0;d=1; 
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
	goto st158
tr894:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 start=m; end=m; d=0;
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
	goto st158
tr899:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 end=m; d=1;
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
	goto st158
tr903:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:399
d=m
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
	goto st158
	st158:
		if p++; p == pe {
			goto _test_eof158
		}
	st_case_158:
//line parse.go:9168
		if ( s)[p] == 42 {
			goto tr328
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr329
		}
		goto st0
tr329:
//line parse.rl:398
d=0;
//line parse.rl:132

            mark = p;
        
	goto st482
	st482:
		if p++; p == pe {
			goto _test_eof482
		}
	st_case_482:
//line parse.go:9189
		switch ( s)[p] {
		case 32:
			goto tr893
		case 44:
			goto tr894
		case 45:
			goto tr895
		case 47:
			goto tr896
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st482
			}
		case ( s)[p] >= 9:
			goto tr893
		}
		goto st0
tr895:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 start=m; end=m; d=0;
	goto st159
	st159:
		if p++; p == pe {
			goto _test_eof159
		}
	st_case_159:
//line parse.go:9226
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr330
		}
		goto st0
tr330:
//line parse.rl:132

            mark = p;
        
	goto st483
	st483:
		if p++; p == pe {
			goto _test_eof483
		}
	st_case_483:
//line parse.go:9242
		switch ( s)[p] {
		case 32:
			goto tr898
		case 44:
			goto tr899
		case 47:
			goto tr900
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st483
			}
		case ( s)[p] >= 9:
			goto tr898
		}
		goto st0
tr891:
//line parse.rl:398
 start=1970;end=2099;m=0;d=1; 
	goto st160
tr896:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 start=m; end=m; d=0;
	goto st160
tr900:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 end=m; d=1;
	goto st160
	st160:
		if p++; p == pe {
			goto _test_eof160
		}
	st_case_160:
//line parse.go:9293
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr331
		}
		goto st0
tr331:
//line parse.rl:132

            mark = p;
        
	goto st484
	st484:
		if p++; p == pe {
			goto _test_eof484
		}
	st_case_484:
//line parse.go:9309
		switch ( s)[p] {
		case 32:
			goto tr902
		case 44:
			goto tr903
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st484
			}
		case ( s)[p] >= 9:
			goto tr902
		}
		goto st0
tr325:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st161
tr333:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st161
tr344:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st161
tr349:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:395
d=m
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st161
tr354:
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st161
tr371:
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st161
	st161:
		if p++; p == pe {
			goto _test_eof161
		}
	st_case_161:
//line parse.go:9564
		switch ( s)[p] {
		case 42:
			goto tr317
		case 70:
			goto tr319
		case 77:
			goto tr320
		case 83:
			goto tr321
		case 84:
			goto tr322
		case 87:
			goto tr323
		case 102:
			goto tr319
		case 109:
			goto tr320
		case 115:
			goto tr321
		case 116:
			goto tr322
		case 119:
			goto tr323
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr318
		}
		goto st0
tr318:
//line parse.rl:394
d=0;
//line parse.rl:132

            mark = p;
        
	goto st162
	st162:
		if p++; p == pe {
			goto _test_eof162
		}
	st_case_162:
//line parse.go:9606
		switch ( s)[p] {
		case 32:
			goto tr332
		case 44:
			goto tr333
		case 45:
			goto tr334
		case 47:
			goto tr335
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st162
			}
		case ( s)[p] >= 9:
			goto tr332
		}
		goto st0
tr334:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
	goto st163
tr372:
//line parse.rl:394
 start=m; end=6;d=0;
	goto st163
	st163:
		if p++; p == pe {
			goto _test_eof163
		}
	st_case_163:
//line parse.go:9647
		switch ( s)[p] {
		case 70:
			goto st167
		case 77:
			goto st170
		case 83:
			goto st172
		case 84:
			goto st175
		case 87:
			goto st178
		case 102:
			goto st167
		case 109:
			goto st170
		case 115:
			goto st172
		case 116:
			goto st175
		case 119:
			goto st178
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr337
		}
		goto st0
tr337:
//line parse.rl:132

            mark = p;
        
	goto st164
	st164:
		if p++; p == pe {
			goto _test_eof164
		}
	st_case_164:
//line parse.go:9685
		switch ( s)[p] {
		case 32:
			goto tr343
		case 44:
			goto tr344
		case 47:
			goto tr345
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st164
			}
		case ( s)[p] >= 9:
			goto tr343
		}
		goto st0
tr326:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
	goto st165
tr335:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
	goto st165
tr345:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
	goto st165
tr355:
//line parse.rl:394
 end=m; d=1;
	goto st165
tr373:
//line parse.rl:394
 start=m; end=6;d=0;
	goto st165
	st165:
		if p++; p == pe {
			goto _test_eof165
		}
	st_case_165:
//line parse.go:9744
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr347
		}
		goto st0
tr347:
//line parse.rl:132

            mark = p;
        
	goto st166
	st166:
		if p++; p == pe {
			goto _test_eof166
		}
	st_case_166:
//line parse.go:9760
		switch ( s)[p] {
		case 32:
			goto tr348
		case 44:
			goto tr349
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st166
			}
		case ( s)[p] >= 9:
			goto tr348
		}
		goto st0
	st167:
		if p++; p == pe {
			goto _test_eof167
		}
	st_case_167:
		switch ( s)[p] {
		case 82:
			goto st168
		case 114:
			goto st168
		}
		goto st0
	st168:
		if p++; p == pe {
			goto _test_eof168
		}
	st_case_168:
		switch ( s)[p] {
		case 73:
			goto tr352
		case 105:
			goto tr352
		}
		goto st0
tr352:
//line parse.rl:369
m=5
	goto st169
tr357:
//line parse.rl:369
m=1
	goto st169
tr360:
//line parse.rl:369
m=6
	goto st169
tr361:
//line parse.rl:369
m=0
	goto st169
tr364:
//line parse.rl:369
m=4
	goto st169
tr365:
//line parse.rl:369
m=2
	goto st169
tr367:
//line parse.rl:369
m=3
	goto st169
	st169:
		if p++; p == pe {
			goto _test_eof169
		}
	st_case_169:
//line parse.go:9833
		switch ( s)[p] {
		case 32:
			goto tr353
		case 44:
			goto tr354
		case 47:
			goto tr355
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr353
		}
		goto st0
	st170:
		if p++; p == pe {
			goto _test_eof170
		}
	st_case_170:
		switch ( s)[p] {
		case 79:
			goto st171
		case 111:
			goto st171
		}
		goto st0
	st171:
		if p++; p == pe {
			goto _test_eof171
		}
	st_case_171:
		switch ( s)[p] {
		case 78:
			goto tr357
		case 110:
			goto tr357
		}
		goto st0
	st172:
		if p++; p == pe {
			goto _test_eof172
		}
	st_case_172:
		switch ( s)[p] {
		case 65:
			goto st173
		case 85:
			goto st174
		case 97:
			goto st173
		case 117:
			goto st174
		}
		goto st0
	st173:
		if p++; p == pe {
			goto _test_eof173
		}
	st_case_173:
		switch ( s)[p] {
		case 84:
			goto tr360
		case 116:
			goto tr360
		}
		goto st0
	st174:
		if p++; p == pe {
			goto _test_eof174
		}
	st_case_174:
		switch ( s)[p] {
		case 78:
			goto tr361
		case 110:
			goto tr361
		}
		goto st0
	st175:
		if p++; p == pe {
			goto _test_eof175
		}
	st_case_175:
		switch ( s)[p] {
		case 72:
			goto st176
		case 85:
			goto st177
		case 104:
			goto st176
		case 117:
			goto st177
		}
		goto st0
	st176:
		if p++; p == pe {
			goto _test_eof176
		}
	st_case_176:
		switch ( s)[p] {
		case 85:
			goto tr364
		case 117:
			goto tr364
		}
		goto st0
	st177:
		if p++; p == pe {
			goto _test_eof177
		}
	st_case_177:
		switch ( s)[p] {
		case 69:
			goto tr365
		case 101:
			goto tr365
		}
		goto st0
	st178:
		if p++; p == pe {
			goto _test_eof178
		}
	st_case_178:
		switch ( s)[p] {
		case 69:
			goto st179
		case 101:
			goto st179
		}
		goto st0
	st179:
		if p++; p == pe {
			goto _test_eof179
		}
	st_case_179:
		switch ( s)[p] {
		case 68:
			goto tr367
		case 100:
			goto tr367
		}
		goto st0
tr319:
//line parse.rl:394
d=0;
	goto st180
	st180:
		if p++; p == pe {
			goto _test_eof180
		}
	st_case_180:
//line parse.go:9983
		switch ( s)[p] {
		case 82:
			goto st181
		case 114:
			goto st181
		}
		goto st0
	st181:
		if p++; p == pe {
			goto _test_eof181
		}
	st_case_181:
		switch ( s)[p] {
		case 73:
			goto tr369
		case 105:
			goto tr369
		}
		goto st0
tr369:
//line parse.rl:369
m=5
	goto st182
tr375:
//line parse.rl:369
m=1
	goto st182
tr378:
//line parse.rl:369
m=6
	goto st182
tr379:
//line parse.rl:369
m=0
	goto st182
tr382:
//line parse.rl:369
m=4
	goto st182
tr383:
//line parse.rl:369
m=2
	goto st182
tr385:
//line parse.rl:369
m=3
	goto st182
	st182:
		if p++; p == pe {
			goto _test_eof182
		}
	st_case_182:
//line parse.go:10036
		switch ( s)[p] {
		case 32:
			goto tr370
		case 44:
			goto tr371
		case 45:
			goto tr372
		case 47:
			goto tr373
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr370
		}
		goto st0
tr320:
//line parse.rl:394
d=0;
	goto st183
	st183:
		if p++; p == pe {
			goto _test_eof183
		}
	st_case_183:
//line parse.go:10060
		switch ( s)[p] {
		case 79:
			goto st184
		case 111:
			goto st184
		}
		goto st0
	st184:
		if p++; p == pe {
			goto _test_eof184
		}
	st_case_184:
		switch ( s)[p] {
		case 78:
			goto tr375
		case 110:
			goto tr375
		}
		goto st0
tr321:
//line parse.rl:394
d=0;
	goto st185
	st185:
		if p++; p == pe {
			goto _test_eof185
		}
	st_case_185:
//line parse.go:10089
		switch ( s)[p] {
		case 65:
			goto st186
		case 85:
			goto st187
		case 97:
			goto st186
		case 117:
			goto st187
		}
		goto st0
	st186:
		if p++; p == pe {
			goto _test_eof186
		}
	st_case_186:
		switch ( s)[p] {
		case 84:
			goto tr378
		case 116:
			goto tr378
		}
		goto st0
	st187:
		if p++; p == pe {
			goto _test_eof187
		}
	st_case_187:
		switch ( s)[p] {
		case 78:
			goto tr379
		case 110:
			goto tr379
		}
		goto st0
tr322:
//line parse.rl:394
d=0;
	goto st188
	st188:
		if p++; p == pe {
			goto _test_eof188
		}
	st_case_188:
//line parse.go:10134
		switch ( s)[p] {
		case 72:
			goto st189
		case 85:
			goto st190
		case 104:
			goto st189
		case 117:
			goto st190
		}
		goto st0
	st189:
		if p++; p == pe {
			goto _test_eof189
		}
	st_case_189:
		switch ( s)[p] {
		case 85:
			goto tr382
		case 117:
			goto tr382
		}
		goto st0
	st190:
		if p++; p == pe {
			goto _test_eof190
		}
	st_case_190:
		switch ( s)[p] {
		case 69:
			goto tr383
		case 101:
			goto tr383
		}
		goto st0
tr323:
//line parse.rl:394
d=0;
	goto st191
	st191:
		if p++; p == pe {
			goto _test_eof191
		}
	st_case_191:
//line parse.go:10179
		switch ( s)[p] {
		case 69:
			goto st192
		case 101:
			goto st192
		}
		goto st0
	st192:
		if p++; p == pe {
			goto _test_eof192
		}
	st_case_192:
		switch ( s)[p] {
		case 68:
			goto tr385
		case 100:
			goto tr385
		}
		goto st0
tr314:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st193
tr387:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st193
tr401:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st193
tr406:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:391
d=m
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st193
tr412:
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st193
tr437:
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st193
	st193:
		if p++; p == pe {
			goto _test_eof193
		}
	st_case_193:
//line parse.go:10402
		switch ( s)[p] {
		case 42:
			goto tr303
		case 65:
			goto tr305
		case 68:
			goto tr306
		case 70:
			goto tr307
		case 74:
			goto tr308
		case 77:
			goto tr309
		case 78:
			goto tr310
		case 79:
			goto tr311
		case 83:
			goto tr312
		case 97:
			goto tr305
		case 100:
			goto tr306
		case 102:
			goto tr307
		case 106:
			goto tr308
		case 109:
			goto tr309
		case 110:
			goto tr310
		case 111:
			goto tr311
		case 115:
			goto tr312
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr304
		}
		goto st0
tr304:
//line parse.rl:390
d=0;
//line parse.rl:132

            mark = p;
        
	goto st194
	st194:
		if p++; p == pe {
			goto _test_eof194
		}
	st_case_194:
//line parse.go:10456
		switch ( s)[p] {
		case 32:
			goto tr386
		case 44:
			goto tr387
		case 45:
			goto tr388
		case 47:
			goto tr389
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st194
			}
		case ( s)[p] >= 9:
			goto tr386
		}
		goto st0
tr388:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
	goto st195
tr438:
//line parse.rl:390
 start=m; end=0;d=0;
	goto st195
	st195:
		if p++; p == pe {
			goto _test_eof195
		}
	st_case_195:
//line parse.go:10497
		switch ( s)[p] {
		case 65:
			goto st199
		case 68:
			goto st203
		case 70:
			goto st205
		case 74:
			goto st207
		case 77:
			goto st210
		case 78:
			goto st212
		case 79:
			goto st214
		case 83:
			goto st216
		case 97:
			goto st199
		case 100:
			goto st203
		case 102:
			goto st205
		case 106:
			goto st207
		case 109:
			goto st210
		case 110:
			goto st212
		case 111:
			goto st214
		case 115:
			goto st216
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr391
		}
		goto st0
tr391:
//line parse.rl:132

            mark = p;
        
	goto st196
	st196:
		if p++; p == pe {
			goto _test_eof196
		}
	st_case_196:
//line parse.go:10547
		switch ( s)[p] {
		case 32:
			goto tr400
		case 44:
			goto tr401
		case 47:
			goto tr402
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st196
			}
		case ( s)[p] >= 9:
			goto tr400
		}
		goto st0
tr315:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
	goto st197
tr389:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
	goto st197
tr402:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
	goto st197
tr413:
//line parse.rl:390
 end=m; d=1;
	goto st197
tr439:
//line parse.rl:390
 start=m; end=0;d=0;
	goto st197
	st197:
		if p++; p == pe {
			goto _test_eof197
		}
	st_case_197:
//line parse.go:10606
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr404
		}
		goto st0
tr404:
//line parse.rl:132

            mark = p;
        
	goto st198
	st198:
		if p++; p == pe {
			goto _test_eof198
		}
	st_case_198:
//line parse.go:10622
		switch ( s)[p] {
		case 32:
			goto tr405
		case 44:
			goto tr406
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st198
			}
		case ( s)[p] >= 9:
			goto tr405
		}
		goto st0
	st199:
		if p++; p == pe {
			goto _test_eof199
		}
	st_case_199:
		switch ( s)[p] {
		case 80:
			goto st200
		case 85:
			goto st202
		case 112:
			goto st200
		case 117:
			goto st202
		}
		goto st0
	st200:
		if p++; p == pe {
			goto _test_eof200
		}
	st_case_200:
		switch ( s)[p] {
		case 82:
			goto tr410
		case 114:
			goto tr410
		}
		goto st0
tr410:
//line parse.rl:370
m=4
	goto st201
tr414:
//line parse.rl:370
m=8
	goto st201
tr416:
//line parse.rl:370
m=12
	goto st201
tr418:
//line parse.rl:370
m=2
	goto st201
tr421:
//line parse.rl:370
m=1
	goto st201
tr422:
//line parse.rl:370
m=7
	goto st201
tr423:
//line parse.rl:370
m=6
	goto st201
tr425:
//line parse.rl:370
m=3
	goto st201
tr426:
//line parse.rl:370
m=5
	goto st201
tr428:
//line parse.rl:370
m=11
	goto st201
tr430:
//line parse.rl:370
m=10
	goto st201
tr432:
//line parse.rl:370
m=9
	goto st201
	st201:
		if p++; p == pe {
			goto _test_eof201
		}
	st_case_201:
//line parse.go:10719
		switch ( s)[p] {
		case 32:
			goto tr411
		case 44:
			goto tr412
		case 47:
			goto tr413
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr411
		}
		goto st0
	st202:
		if p++; p == pe {
			goto _test_eof202
		}
	st_case_202:
		switch ( s)[p] {
		case 71:
			goto tr414
		case 103:
			goto tr414
		}
		goto st0
	st203:
		if p++; p == pe {
			goto _test_eof203
		}
	st_case_203:
		switch ( s)[p] {
		case 69:
			goto st204
		case 101:
			goto st204
		}
		goto st0
	st204:
		if p++; p == pe {
			goto _test_eof204
		}
	st_case_204:
		switch ( s)[p] {
		case 67:
			goto tr416
		case 99:
			goto tr416
		}
		goto st0
	st205:
		if p++; p == pe {
			goto _test_eof205
		}
	st_case_205:
		switch ( s)[p] {
		case 69:
			goto st206
		case 101:
			goto st206
		}
		goto st0
	st206:
		if p++; p == pe {
			goto _test_eof206
		}
	st_case_206:
		switch ( s)[p] {
		case 66:
			goto tr418
		case 98:
			goto tr418
		}
		goto st0
	st207:
		if p++; p == pe {
			goto _test_eof207
		}
	st_case_207:
		switch ( s)[p] {
		case 65:
			goto st208
		case 85:
			goto st209
		case 97:
			goto st208
		case 117:
			goto st209
		}
		goto st0
	st208:
		if p++; p == pe {
			goto _test_eof208
		}
	st_case_208:
		switch ( s)[p] {
		case 78:
			goto tr421
		case 110:
			goto tr421
		}
		goto st0
	st209:
		if p++; p == pe {
			goto _test_eof209
		}
	st_case_209:
		switch ( s)[p] {
		case 76:
			goto tr422
		case 78:
			goto tr423
		case 108:
			goto tr422
		case 110:
			goto tr423
		}
		goto st0
	st210:
		if p++; p == pe {
			goto _test_eof210
		}
	st_case_210:
		switch ( s)[p] {
		case 65:
			goto st211
		case 97:
			goto st211
		}
		goto st0
	st211:
		if p++; p == pe {
			goto _test_eof211
		}
	st_case_211:
		switch ( s)[p] {
		case 82:
			goto tr425
		case 89:
			goto tr426
		case 114:
			goto tr425
		case 121:
			goto tr426
		}
		goto st0
	st212:
		if p++; p == pe {
			goto _test_eof212
		}
	st_case_212:
		switch ( s)[p] {
		case 79:
			goto st213
		case 111:
			goto st213
		}
		goto st0
	st213:
		if p++; p == pe {
			goto _test_eof213
		}
	st_case_213:
		switch ( s)[p] {
		case 86:
			goto tr428
		case 118:
			goto tr428
		}
		goto st0
	st214:
		if p++; p == pe {
			goto _test_eof214
		}
	st_case_214:
		switch ( s)[p] {
		case 67:
			goto st215
		case 99:
			goto st215
		}
		goto st0
	st215:
		if p++; p == pe {
			goto _test_eof215
		}
	st_case_215:
		switch ( s)[p] {
		case 84:
			goto tr430
		case 116:
			goto tr430
		}
		goto st0
	st216:
		if p++; p == pe {
			goto _test_eof216
		}
	st_case_216:
		switch ( s)[p] {
		case 69:
			goto st217
		case 101:
			goto st217
		}
		goto st0
	st217:
		if p++; p == pe {
			goto _test_eof217
		}
	st_case_217:
		switch ( s)[p] {
		case 80:
			goto tr432
		case 112:
			goto tr432
		}
		goto st0
tr305:
//line parse.rl:390
d=0;
	goto st218
	st218:
		if p++; p == pe {
			goto _test_eof218
		}
	st_case_218:
//line parse.go:10945
		switch ( s)[p] {
		case 80:
			goto st219
		case 85:
			goto st221
		case 112:
			goto st219
		case 117:
			goto st221
		}
		goto st0
	st219:
		if p++; p == pe {
			goto _test_eof219
		}
	st_case_219:
		switch ( s)[p] {
		case 82:
			goto tr435
		case 114:
			goto tr435
		}
		goto st0
tr435:
//line parse.rl:370
m=4
	goto st220
tr440:
//line parse.rl:370
m=8
	goto st220
tr442:
//line parse.rl:370
m=12
	goto st220
tr444:
//line parse.rl:370
m=2
	goto st220
tr447:
//line parse.rl:370
m=1
	goto st220
tr448:
//line parse.rl:370
m=7
	goto st220
tr449:
//line parse.rl:370
m=6
	goto st220
tr451:
//line parse.rl:370
m=3
	goto st220
tr452:
//line parse.rl:370
m=5
	goto st220
tr454:
//line parse.rl:370
m=11
	goto st220
tr456:
//line parse.rl:370
m=10
	goto st220
tr458:
//line parse.rl:370
m=9
	goto st220
	st220:
		if p++; p == pe {
			goto _test_eof220
		}
	st_case_220:
//line parse.go:11022
		switch ( s)[p] {
		case 32:
			goto tr436
		case 44:
			goto tr437
		case 45:
			goto tr438
		case 47:
			goto tr439
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr436
		}
		goto st0
	st221:
		if p++; p == pe {
			goto _test_eof221
		}
	st_case_221:
		switch ( s)[p] {
		case 71:
			goto tr440
		case 103:
			goto tr440
		}
		goto st0
tr306:
//line parse.rl:390
d=0;
	goto st222
	st222:
		if p++; p == pe {
			goto _test_eof222
		}
	st_case_222:
//line parse.go:11058
		switch ( s)[p] {
		case 69:
			goto st223
		case 101:
			goto st223
		}
		goto st0
	st223:
		if p++; p == pe {
			goto _test_eof223
		}
	st_case_223:
		switch ( s)[p] {
		case 67:
			goto tr442
		case 99:
			goto tr442
		}
		goto st0
tr307:
//line parse.rl:390
d=0;
	goto st224
	st224:
		if p++; p == pe {
			goto _test_eof224
		}
	st_case_224:
//line parse.go:11087
		switch ( s)[p] {
		case 69:
			goto st225
		case 101:
			goto st225
		}
		goto st0
	st225:
		if p++; p == pe {
			goto _test_eof225
		}
	st_case_225:
		switch ( s)[p] {
		case 66:
			goto tr444
		case 98:
			goto tr444
		}
		goto st0
tr308:
//line parse.rl:390
d=0;
	goto st226
	st226:
		if p++; p == pe {
			goto _test_eof226
		}
	st_case_226:
//line parse.go:11116
		switch ( s)[p] {
		case 65:
			goto st227
		case 85:
			goto st228
		case 97:
			goto st227
		case 117:
			goto st228
		}
		goto st0
	st227:
		if p++; p == pe {
			goto _test_eof227
		}
	st_case_227:
		switch ( s)[p] {
		case 78:
			goto tr447
		case 110:
			goto tr447
		}
		goto st0
	st228:
		if p++; p == pe {
			goto _test_eof228
		}
	st_case_228:
		switch ( s)[p] {
		case 76:
			goto tr448
		case 78:
			goto tr449
		case 108:
			goto tr448
		case 110:
			goto tr449
		}
		goto st0
tr309:
//line parse.rl:390
d=0;
	goto st229
	st229:
		if p++; p == pe {
			goto _test_eof229
		}
	st_case_229:
//line parse.go:11165
		switch ( s)[p] {
		case 65:
			goto st230
		case 97:
			goto st230
		}
		goto st0
	st230:
		if p++; p == pe {
			goto _test_eof230
		}
	st_case_230:
		switch ( s)[p] {
		case 82:
			goto tr451
		case 89:
			goto tr452
		case 114:
			goto tr451
		case 121:
			goto tr452
		}
		goto st0
tr310:
//line parse.rl:390
d=0;
	goto st231
	st231:
		if p++; p == pe {
			goto _test_eof231
		}
	st_case_231:
//line parse.go:11198
		switch ( s)[p] {
		case 79:
			goto st232
		case 111:
			goto st232
		}
		goto st0
	st232:
		if p++; p == pe {
			goto _test_eof232
		}
	st_case_232:
		switch ( s)[p] {
		case 86:
			goto tr454
		case 118:
			goto tr454
		}
		goto st0
tr311:
//line parse.rl:390
d=0;
	goto st233
	st233:
		if p++; p == pe {
			goto _test_eof233
		}
	st_case_233:
//line parse.go:11227
		switch ( s)[p] {
		case 67:
			goto st234
		case 99:
			goto st234
		}
		goto st0
	st234:
		if p++; p == pe {
			goto _test_eof234
		}
	st_case_234:
		switch ( s)[p] {
		case 84:
			goto tr456
		case 116:
			goto tr456
		}
		goto st0
tr312:
//line parse.rl:390
d=0;
	goto st235
	st235:
		if p++; p == pe {
			goto _test_eof235
		}
	st_case_235:
//line parse.go:11256
		switch ( s)[p] {
		case 69:
			goto st236
		case 101:
			goto st236
		}
		goto st0
	st236:
		if p++; p == pe {
			goto _test_eof236
		}
	st_case_236:
		switch ( s)[p] {
		case 80:
			goto tr458
		case 112:
			goto tr458
		}
		goto st0
tr300:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st237
tr460:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st237
tr471:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st237
tr476:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:387
d=m
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st237
tr481:
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st237
tr498:
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st237
	st237:
		if p++; p == pe {
			goto _test_eof237
		}
	st_case_237:
//line parse.go:11479
		switch ( s)[p] {
		case 42:
			goto tr292
		case 70:
			goto tr294
		case 77:
			goto tr295
		case 83:
			goto tr296
		case 84:
			goto tr297
		case 87:
			goto tr298
		case 102:
			goto tr294
		case 109:
			goto tr295
		case 115:
			goto tr296
		case 116:
			goto tr297
		case 119:
			goto tr298
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr293
		}
		goto st0
tr293:
//line parse.rl:386
d=0;
//line parse.rl:132

            mark = p;
        
	goto st238
	st238:
		if p++; p == pe {
			goto _test_eof238
		}
	st_case_238:
//line parse.go:11521
		switch ( s)[p] {
		case 32:
			goto tr459
		case 44:
			goto tr460
		case 45:
			goto tr461
		case 47:
			goto tr462
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st238
			}
		case ( s)[p] >= 9:
			goto tr459
		}
		goto st0
tr461:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st239
tr499:
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st239
	st239:
		if p++; p == pe {
			goto _test_eof239
		}
	st_case_239:
//line parse.go:11562
		switch ( s)[p] {
		case 70:
			goto st243
		case 77:
			goto st246
		case 83:
			goto st248
		case 84:
			goto st251
		case 87:
			goto st254
		case 102:
			goto st243
		case 109:
			goto st246
		case 115:
			goto st248
		case 116:
			goto st251
		case 119:
			goto st254
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr464
		}
		goto st0
tr464:
//line parse.rl:132

            mark = p;
        
	goto st240
	st240:
		if p++; p == pe {
			goto _test_eof240
		}
	st_case_240:
//line parse.go:11600
		switch ( s)[p] {
		case 32:
			goto tr470
		case 44:
			goto tr471
		case 47:
			goto tr472
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st240
			}
		case ( s)[p] >= 9:
			goto tr470
		}
		goto st0
tr301:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
	goto st241
tr462:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st241
tr472:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
	goto st241
tr482:
//line parse.rl:386
 end=m-1; d=1;
	goto st241
tr500:
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st241
	st241:
		if p++; p == pe {
			goto _test_eof241
		}
	st_case_241:
//line parse.go:11659
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr474
		}
		goto st0
tr474:
//line parse.rl:132

            mark = p;
        
	goto st242
	st242:
		if p++; p == pe {
			goto _test_eof242
		}
	st_case_242:
//line parse.go:11675
		switch ( s)[p] {
		case 32:
			goto tr475
		case 44:
			goto tr476
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st242
			}
		case ( s)[p] >= 9:
			goto tr475
		}
		goto st0
	st243:
		if p++; p == pe {
			goto _test_eof243
		}
	st_case_243:
		switch ( s)[p] {
		case 82:
			goto st244
		case 114:
			goto st244
		}
		goto st0
	st244:
		if p++; p == pe {
			goto _test_eof244
		}
	st_case_244:
		switch ( s)[p] {
		case 73:
			goto tr479
		case 105:
			goto tr479
		}
		goto st0
tr479:
//line parse.rl:369
m=5
	goto st245
tr484:
//line parse.rl:369
m=1
	goto st245
tr487:
//line parse.rl:369
m=6
	goto st245
tr488:
//line parse.rl:369
m=0
	goto st245
tr491:
//line parse.rl:369
m=4
	goto st245
tr492:
//line parse.rl:369
m=2
	goto st245
tr494:
//line parse.rl:369
m=3
	goto st245
	st245:
		if p++; p == pe {
			goto _test_eof245
		}
	st_case_245:
//line parse.go:11748
		switch ( s)[p] {
		case 32:
			goto tr480
		case 44:
			goto tr481
		case 47:
			goto tr482
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr480
		}
		goto st0
	st246:
		if p++; p == pe {
			goto _test_eof246
		}
	st_case_246:
		switch ( s)[p] {
		case 79:
			goto st247
		case 111:
			goto st247
		}
		goto st0
	st247:
		if p++; p == pe {
			goto _test_eof247
		}
	st_case_247:
		switch ( s)[p] {
		case 78:
			goto tr484
		case 110:
			goto tr484
		}
		goto st0
	st248:
		if p++; p == pe {
			goto _test_eof248
		}
	st_case_248:
		switch ( s)[p] {
		case 65:
			goto st249
		case 85:
			goto st250
		case 97:
			goto st249
		case 117:
			goto st250
		}
		goto st0
	st249:
		if p++; p == pe {
			goto _test_eof249
		}
	st_case_249:
		switch ( s)[p] {
		case 84:
			goto tr487
		case 116:
			goto tr487
		}
		goto st0
	st250:
		if p++; p == pe {
			goto _test_eof250
		}
	st_case_250:
		switch ( s)[p] {
		case 78:
			goto tr488
		case 110:
			goto tr488
		}
		goto st0
	st251:
		if p++; p == pe {
			goto _test_eof251
		}
	st_case_251:
		switch ( s)[p] {
		case 72:
			goto st252
		case 85:
			goto st253
		case 104:
			goto st252
		case 117:
			goto st253
		}
		goto st0
	st252:
		if p++; p == pe {
			goto _test_eof252
		}
	st_case_252:
		switch ( s)[p] {
		case 85:
			goto tr491
		case 117:
			goto tr491
		}
		goto st0
	st253:
		if p++; p == pe {
			goto _test_eof253
		}
	st_case_253:
		switch ( s)[p] {
		case 69:
			goto tr492
		case 101:
			goto tr492
		}
		goto st0
	st254:
		if p++; p == pe {
			goto _test_eof254
		}
	st_case_254:
		switch ( s)[p] {
		case 69:
			goto st255
		case 101:
			goto st255
		}
		goto st0
	st255:
		if p++; p == pe {
			goto _test_eof255
		}
	st_case_255:
		switch ( s)[p] {
		case 68:
			goto tr494
		case 100:
			goto tr494
		}
		goto st0
tr294:
//line parse.rl:386
d=0;
	goto st256
	st256:
		if p++; p == pe {
			goto _test_eof256
		}
	st_case_256:
//line parse.go:11898
		switch ( s)[p] {
		case 82:
			goto st257
		case 114:
			goto st257
		}
		goto st0
	st257:
		if p++; p == pe {
			goto _test_eof257
		}
	st_case_257:
		switch ( s)[p] {
		case 73:
			goto tr496
		case 105:
			goto tr496
		}
		goto st0
tr496:
//line parse.rl:369
m=5
	goto st258
tr502:
//line parse.rl:369
m=1
	goto st258
tr505:
//line parse.rl:369
m=6
	goto st258
tr506:
//line parse.rl:369
m=0
	goto st258
tr509:
//line parse.rl:369
m=4
	goto st258
tr510:
//line parse.rl:369
m=2
	goto st258
tr512:
//line parse.rl:369
m=3
	goto st258
	st258:
		if p++; p == pe {
			goto _test_eof258
		}
	st_case_258:
//line parse.go:11951
		switch ( s)[p] {
		case 32:
			goto tr497
		case 44:
			goto tr498
		case 45:
			goto tr499
		case 47:
			goto tr500
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr497
		}
		goto st0
tr295:
//line parse.rl:386
d=0;
	goto st259
	st259:
		if p++; p == pe {
			goto _test_eof259
		}
	st_case_259:
//line parse.go:11975
		switch ( s)[p] {
		case 79:
			goto st260
		case 111:
			goto st260
		}
		goto st0
	st260:
		if p++; p == pe {
			goto _test_eof260
		}
	st_case_260:
		switch ( s)[p] {
		case 78:
			goto tr502
		case 110:
			goto tr502
		}
		goto st0
tr296:
//line parse.rl:386
d=0;
	goto st261
	st261:
		if p++; p == pe {
			goto _test_eof261
		}
	st_case_261:
//line parse.go:12004
		switch ( s)[p] {
		case 65:
			goto st262
		case 85:
			goto st263
		case 97:
			goto st262
		case 117:
			goto st263
		}
		goto st0
	st262:
		if p++; p == pe {
			goto _test_eof262
		}
	st_case_262:
		switch ( s)[p] {
		case 84:
			goto tr505
		case 116:
			goto tr505
		}
		goto st0
	st263:
		if p++; p == pe {
			goto _test_eof263
		}
	st_case_263:
		switch ( s)[p] {
		case 78:
			goto tr506
		case 110:
			goto tr506
		}
		goto st0
tr297:
//line parse.rl:386
d=0;
	goto st264
	st264:
		if p++; p == pe {
			goto _test_eof264
		}
	st_case_264:
//line parse.go:12049
		switch ( s)[p] {
		case 72:
			goto st265
		case 85:
			goto st266
		case 104:
			goto st265
		case 117:
			goto st266
		}
		goto st0
	st265:
		if p++; p == pe {
			goto _test_eof265
		}
	st_case_265:
		switch ( s)[p] {
		case 85:
			goto tr509
		case 117:
			goto tr509
		}
		goto st0
	st266:
		if p++; p == pe {
			goto _test_eof266
		}
	st_case_266:
		switch ( s)[p] {
		case 69:
			goto tr510
		case 101:
			goto tr510
		}
		goto st0
tr298:
//line parse.rl:386
d=0;
	goto st267
	st267:
		if p++; p == pe {
			goto _test_eof267
		}
	st_case_267:
//line parse.go:12094
		switch ( s)[p] {
		case 69:
			goto st268
		case 101:
			goto st268
		}
		goto st0
	st268:
		if p++; p == pe {
			goto _test_eof268
		}
	st_case_268:
		switch ( s)[p] {
		case 68:
			goto tr512
		case 100:
			goto tr512
		}
		goto st0
tr289:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st269
tr514:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st269
tr520:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st269
tr525:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:383
d=m
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st269
	st269:
		if p++; p == pe {
			goto _test_eof269
		}
	st_case_269:
//line parse.go:12259
		if ( s)[p] == 42 {
			goto tr286
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr287
		}
		goto st0
tr287:
//line parse.rl:382
d=0;
//line parse.rl:132

            mark = p;
        
	goto st270
	st270:
		if p++; p == pe {
			goto _test_eof270
		}
	st_case_270:
//line parse.go:12280
		switch ( s)[p] {
		case 32:
			goto tr513
		case 44:
			goto tr514
		case 45:
			goto tr515
		case 47:
			goto tr516
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st270
			}
		case ( s)[p] >= 9:
			goto tr513
		}
		goto st0
tr515:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
	goto st271
	st271:
		if p++; p == pe {
			goto _test_eof271
		}
	st_case_271:
//line parse.go:12317
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr518
		}
		goto st0
tr518:
//line parse.rl:132

            mark = p;
        
	goto st272
	st272:
		if p++; p == pe {
			goto _test_eof272
		}
	st_case_272:
//line parse.go:12333
		switch ( s)[p] {
		case 32:
			goto tr519
		case 44:
			goto tr520
		case 47:
			goto tr521
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st272
			}
		case ( s)[p] >= 9:
			goto tr519
		}
		goto st0
tr290:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
	goto st273
tr516:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
	goto st273
tr521:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
	goto st273
	st273:
		if p++; p == pe {
			goto _test_eof273
		}
	st_case_273:
//line parse.go:12384
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr523
		}
		goto st0
tr523:
//line parse.rl:132

            mark = p;
        
	goto st274
	st274:
		if p++; p == pe {
			goto _test_eof274
		}
	st_case_274:
//line parse.go:12400
		switch ( s)[p] {
		case 32:
			goto tr524
		case 44:
			goto tr525
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st274
			}
		case ( s)[p] >= 9:
			goto tr524
		}
		goto st0
tr283:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st275
tr528:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st275
tr534:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st275
tr539:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:379
d=m
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st275
	st275:
		if p++; p == pe {
			goto _test_eof275
		}
	st_case_275:
//line parse.go:12561
		if ( s)[p] == 42 {
			goto tr280
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr281
		}
		goto st0
tr281:
//line parse.rl:375
d=0;
//line parse.rl:132

            mark = p;
        
	goto st276
	st276:
		if p++; p == pe {
			goto _test_eof276
		}
	st_case_276:
//line parse.go:12582
		switch ( s)[p] {
		case 32:
			goto tr527
		case 44:
			goto tr528
		case 45:
			goto tr529
		case 47:
			goto tr530
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st276
			}
		case ( s)[p] >= 9:
			goto tr527
		}
		goto st0
tr529:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st277
	st277:
		if p++; p == pe {
			goto _test_eof277
		}
	st_case_277:
//line parse.go:12619
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr532
		}
		goto st0
tr532:
//line parse.rl:132

            mark = p;
        
	goto st278
	st278:
		if p++; p == pe {
			goto _test_eof278
		}
	st_case_278:
//line parse.go:12635
		switch ( s)[p] {
		case 32:
			goto tr533
		case 44:
			goto tr534
		case 47:
			goto tr535
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st278
			}
		case ( s)[p] >= 9:
			goto tr533
		}
		goto st0
tr284:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
	goto st279
tr530:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st279
tr535:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
	goto st279
	st279:
		if p++; p == pe {
			goto _test_eof279
		}
	st_case_279:
//line parse.go:12686
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr537
		}
		goto st0
tr537:
//line parse.rl:132

            mark = p;
        
	goto st280
	st280:
		if p++; p == pe {
			goto _test_eof280
		}
	st_case_280:
//line parse.go:12702
		switch ( s)[p] {
		case 32:
			goto tr538
		case 44:
			goto tr539
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st280
			}
		case ( s)[p] >= 9:
			goto tr538
		}
		goto st0
tr278:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
	goto st281
tr548:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st281
tr553:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
	goto st281
	st281:
		if p++; p == pe {
			goto _test_eof281
		}
	st_case_281:
//line parse.go:12751
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr541
		}
		goto st0
tr541:
//line parse.rl:132

            mark = p;
        
	goto st282
	st282:
		if p++; p == pe {
			goto _test_eof282
		}
	st_case_282:
//line parse.go:12767
		switch ( s)[p] {
		case 32:
			goto tr542
		case 44:
			goto tr543
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st282
			}
		case ( s)[p] >= 9:
			goto tr542
		}
		goto st0
tr275:
//line parse.rl:375
d=0;
//line parse.rl:132

            mark = p;
        
	goto st283
	st283:
		if p++; p == pe {
			goto _test_eof283
		}
	st_case_283:
//line parse.go:12796
		switch ( s)[p] {
		case 32:
			goto tr545
		case 44:
			goto tr546
		case 45:
			goto tr547
		case 47:
			goto tr548
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st283
			}
		case ( s)[p] >= 9:
			goto tr545
		}
		goto st0
tr547:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st284
	st284:
		if p++; p == pe {
			goto _test_eof284
		}
	st_case_284:
//line parse.go:12833
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr550
		}
		goto st0
tr550:
//line parse.rl:132

            mark = p;
        
	goto st285
	st285:
		if p++; p == pe {
			goto _test_eof285
		}
	st_case_285:
//line parse.go:12849
		switch ( s)[p] {
		case 32:
			goto tr551
		case 44:
			goto tr552
		case 47:
			goto tr553
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st285
			}
		case ( s)[p] >= 9:
			goto tr551
		}
		goto st0
tr558:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st286
tr780:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st286
tr786:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st286
tr777:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:379
d=m
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st286
	st286:
//line NONE:1
ts = 0

		if p++; p == pe {
			goto _test_eof286
		}
	st_case_286:
//line parse.go:13015
		if ( s)[p] == 42 {
			goto tr555
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr556
		}
		goto st0
tr555:
//line parse.rl:375
d=0;
	goto st287
	st287:
		if p++; p == pe {
			goto _test_eof287
		}
	st_case_287:
//line parse.go:13032
		switch ( s)[p] {
		case 32:
			goto tr557
		case 44:
			goto tr558
		case 47:
			goto tr559
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr557
		}
		goto st0
tr557:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st288
tr779:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st288
tr785:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st288
tr776:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:379
d=m
//line parse.rl:161

            {
                if d>=60 {
                    return nt, fmt.Errorf("invalid minute */%d", d)
                }
                if start>=60 {
                    return nt, fmt.Errorf("invalid start minute %d", start)
                }
                if end>=60 {
                    return nt, fmt.Errorf("invalid end minute %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.minute |= 1<<m
                }else{
                    nt.minute |= ((skips[d-1]&mask60)<<start)&endMask
                }
            }
        
	goto st288
	st288:
		if p++; p == pe {
			goto _test_eof288
		}
	st_case_288:
//line parse.go:13190
		switch ( s)[p] {
		case 32:
			goto st288
		case 42:
			goto tr561
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr562
			}
		case ( s)[p] >= 9:
			goto st288
		}
		goto st0
tr561:
//line parse.rl:382
d=0;
	goto st289
	st289:
		if p++; p == pe {
			goto _test_eof289
		}
	st_case_289:
//line parse.go:13215
		switch ( s)[p] {
		case 32:
			goto tr563
		case 44:
			goto tr564
		case 47:
			goto tr565
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr563
		}
		goto st0
tr563:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st290
tr761:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st290
tr767:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st290
tr772:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:383
d=m
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st290
	st290:
		if p++; p == pe {
			goto _test_eof290
		}
	st_case_290:
//line parse.go:13373
		switch ( s)[p] {
		case 32:
			goto st290
		case 42:
			goto tr567
		case 70:
			goto tr569
		case 77:
			goto tr570
		case 83:
			goto tr571
		case 84:
			goto tr572
		case 87:
			goto tr573
		case 102:
			goto tr569
		case 109:
			goto tr570
		case 115:
			goto tr571
		case 116:
			goto tr572
		case 119:
			goto tr573
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr568
			}
		case ( s)[p] >= 9:
			goto st290
		}
		goto st0
tr567:
//line parse.rl:386
d=0;
	goto st291
	st291:
		if p++; p == pe {
			goto _test_eof291
		}
	st_case_291:
//line parse.go:13418
		switch ( s)[p] {
		case 32:
			goto tr574
		case 44:
			goto tr575
		case 47:
			goto tr576
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr574
		}
		goto st0
tr574:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st292
tr707:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st292
tr718:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st292
tr723:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:387
d=m
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st292
tr728:
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st292
tr745:
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st292
	st292:
		if p++; p == pe {
			goto _test_eof292
		}
	st_case_292:
//line parse.go:13634
		switch ( s)[p] {
		case 32:
			goto st292
		case 42:
			goto tr578
		case 65:
			goto tr580
		case 68:
			goto tr581
		case 70:
			goto tr582
		case 74:
			goto tr583
		case 77:
			goto tr584
		case 78:
			goto tr585
		case 79:
			goto tr586
		case 83:
			goto tr587
		case 97:
			goto tr580
		case 100:
			goto tr581
		case 102:
			goto tr582
		case 106:
			goto tr583
		case 109:
			goto tr584
		case 110:
			goto tr585
		case 111:
			goto tr586
		case 115:
			goto tr587
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr579
			}
		case ( s)[p] >= 9:
			goto st292
		}
		goto st0
tr578:
//line parse.rl:390
d=0;
	goto st293
	st293:
		if p++; p == pe {
			goto _test_eof293
		}
	st_case_293:
//line parse.go:13691
		switch ( s)[p] {
		case 32:
			goto tr588
		case 44:
			goto tr589
		case 47:
			goto tr590
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr588
		}
		goto st0
tr588:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st294
tr634:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st294
tr648:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st294
tr653:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:391
d=m
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st294
tr659:
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st294
tr684:
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st294
	st294:
		if p++; p == pe {
			goto _test_eof294
		}
	st_case_294:
//line parse.go:13907
		switch ( s)[p] {
		case 32:
			goto st294
		case 42:
			goto tr592
		case 70:
			goto tr594
		case 77:
			goto tr595
		case 83:
			goto tr596
		case 84:
			goto tr597
		case 87:
			goto tr598
		case 102:
			goto tr594
		case 109:
			goto tr595
		case 115:
			goto tr596
		case 116:
			goto tr597
		case 119:
			goto tr598
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto tr593
			}
		case ( s)[p] >= 9:
			goto st294
		}
		goto st0
tr592:
//line parse.rl:394
d=0;
	goto st485
	st485:
		if p++; p == pe {
			goto _test_eof485
		}
	st_case_485:
//line parse.go:13952
		switch ( s)[p] {
		case 32:
			goto tr905
		case 44:
			goto tr906
		case 47:
			goto tr907
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr905
		}
		goto st0
tr905:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st486
tr909:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st486
tr914:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st486
tr918:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:395
d=m
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st486
tr921:
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st486
tr924:
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st486
	st486:
		if p++; p == pe {
			goto _test_eof486
		}
	st_case_486:
//line parse.go:14204
		if ( s)[p] == 32 {
			goto st486
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st486
		}
		goto st0
tr906:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st295
tr910:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st295
tr915:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st295
tr919:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:395
d=m
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st295
tr922:
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st295
tr925:
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
	goto st295
	st295:
		if p++; p == pe {
			goto _test_eof295
		}
	st_case_295:
//line parse.go:14451
		switch ( s)[p] {
		case 42:
			goto tr592
		case 70:
			goto tr594
		case 77:
			goto tr595
		case 83:
			goto tr596
		case 84:
			goto tr597
		case 87:
			goto tr598
		case 102:
			goto tr594
		case 109:
			goto tr595
		case 115:
			goto tr596
		case 116:
			goto tr597
		case 119:
			goto tr598
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr593
		}
		goto st0
tr593:
//line parse.rl:394
d=0;
//line parse.rl:132

            mark = p;
        
	goto st487
	st487:
		if p++; p == pe {
			goto _test_eof487
		}
	st_case_487:
//line parse.go:14493
		switch ( s)[p] {
		case 32:
			goto tr909
		case 44:
			goto tr910
		case 45:
			goto tr911
		case 47:
			goto tr912
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st487
			}
		case ( s)[p] >= 9:
			goto tr909
		}
		goto st0
tr911:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
	goto st296
tr926:
//line parse.rl:394
 start=m; end=6;d=0;
	goto st296
	st296:
		if p++; p == pe {
			goto _test_eof296
		}
	st_case_296:
//line parse.go:14534
		switch ( s)[p] {
		case 70:
			goto st298
		case 77:
			goto st300
		case 83:
			goto st302
		case 84:
			goto st305
		case 87:
			goto st308
		case 102:
			goto st298
		case 109:
			goto st300
		case 115:
			goto st302
		case 116:
			goto st305
		case 119:
			goto st308
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr599
		}
		goto st0
tr599:
//line parse.rl:132

            mark = p;
        
	goto st488
	st488:
		if p++; p == pe {
			goto _test_eof488
		}
	st_case_488:
//line parse.go:14572
		switch ( s)[p] {
		case 32:
			goto tr914
		case 44:
			goto tr915
		case 47:
			goto tr916
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st488
			}
		case ( s)[p] >= 9:
			goto tr914
		}
		goto st0
tr907:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
	goto st297
tr912:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
	goto st297
tr916:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
	goto st297
tr923:
//line parse.rl:394
 end=m; d=1;
	goto st297
tr927:
//line parse.rl:394
 start=m; end=6;d=0;
	goto st297
	st297:
		if p++; p == pe {
			goto _test_eof297
		}
	st_case_297:
//line parse.go:14631
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr605
		}
		goto st0
tr605:
//line parse.rl:132

            mark = p;
        
	goto st489
	st489:
		if p++; p == pe {
			goto _test_eof489
		}
	st_case_489:
//line parse.go:14647
		switch ( s)[p] {
		case 32:
			goto tr918
		case 44:
			goto tr919
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st489
			}
		case ( s)[p] >= 9:
			goto tr918
		}
		goto st0
	st298:
		if p++; p == pe {
			goto _test_eof298
		}
	st_case_298:
		switch ( s)[p] {
		case 82:
			goto st299
		case 114:
			goto st299
		}
		goto st0
	st299:
		if p++; p == pe {
			goto _test_eof299
		}
	st_case_299:
		switch ( s)[p] {
		case 73:
			goto tr607
		case 105:
			goto tr607
		}
		goto st0
tr607:
//line parse.rl:369
m=5
	goto st490
tr609:
//line parse.rl:369
m=1
	goto st490
tr612:
//line parse.rl:369
m=6
	goto st490
tr613:
//line parse.rl:369
m=0
	goto st490
tr616:
//line parse.rl:369
m=4
	goto st490
tr617:
//line parse.rl:369
m=2
	goto st490
tr619:
//line parse.rl:369
m=3
	goto st490
	st490:
		if p++; p == pe {
			goto _test_eof490
		}
	st_case_490:
//line parse.go:14720
		switch ( s)[p] {
		case 32:
			goto tr921
		case 44:
			goto tr922
		case 47:
			goto tr923
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr921
		}
		goto st0
	st300:
		if p++; p == pe {
			goto _test_eof300
		}
	st_case_300:
		switch ( s)[p] {
		case 79:
			goto st301
		case 111:
			goto st301
		}
		goto st0
	st301:
		if p++; p == pe {
			goto _test_eof301
		}
	st_case_301:
		switch ( s)[p] {
		case 78:
			goto tr609
		case 110:
			goto tr609
		}
		goto st0
	st302:
		if p++; p == pe {
			goto _test_eof302
		}
	st_case_302:
		switch ( s)[p] {
		case 65:
			goto st303
		case 85:
			goto st304
		case 97:
			goto st303
		case 117:
			goto st304
		}
		goto st0
	st303:
		if p++; p == pe {
			goto _test_eof303
		}
	st_case_303:
		switch ( s)[p] {
		case 84:
			goto tr612
		case 116:
			goto tr612
		}
		goto st0
	st304:
		if p++; p == pe {
			goto _test_eof304
		}
	st_case_304:
		switch ( s)[p] {
		case 78:
			goto tr613
		case 110:
			goto tr613
		}
		goto st0
	st305:
		if p++; p == pe {
			goto _test_eof305
		}
	st_case_305:
		switch ( s)[p] {
		case 72:
			goto st306
		case 85:
			goto st307
		case 104:
			goto st306
		case 117:
			goto st307
		}
		goto st0
	st306:
		if p++; p == pe {
			goto _test_eof306
		}
	st_case_306:
		switch ( s)[p] {
		case 85:
			goto tr616
		case 117:
			goto tr616
		}
		goto st0
	st307:
		if p++; p == pe {
			goto _test_eof307
		}
	st_case_307:
		switch ( s)[p] {
		case 69:
			goto tr617
		case 101:
			goto tr617
		}
		goto st0
	st308:
		if p++; p == pe {
			goto _test_eof308
		}
	st_case_308:
		switch ( s)[p] {
		case 69:
			goto st309
		case 101:
			goto st309
		}
		goto st0
	st309:
		if p++; p == pe {
			goto _test_eof309
		}
	st_case_309:
		switch ( s)[p] {
		case 68:
			goto tr619
		case 100:
			goto tr619
		}
		goto st0
tr594:
//line parse.rl:394
d=0;
	goto st310
	st310:
		if p++; p == pe {
			goto _test_eof310
		}
	st_case_310:
//line parse.go:14870
		switch ( s)[p] {
		case 82:
			goto st311
		case 114:
			goto st311
		}
		goto st0
	st311:
		if p++; p == pe {
			goto _test_eof311
		}
	st_case_311:
		switch ( s)[p] {
		case 73:
			goto tr621
		case 105:
			goto tr621
		}
		goto st0
tr621:
//line parse.rl:369
m=5
	goto st491
tr623:
//line parse.rl:369
m=1
	goto st491
tr626:
//line parse.rl:369
m=6
	goto st491
tr627:
//line parse.rl:369
m=0
	goto st491
tr630:
//line parse.rl:369
m=4
	goto st491
tr631:
//line parse.rl:369
m=2
	goto st491
tr633:
//line parse.rl:369
m=3
	goto st491
	st491:
		if p++; p == pe {
			goto _test_eof491
		}
	st_case_491:
//line parse.go:14923
		switch ( s)[p] {
		case 32:
			goto tr924
		case 44:
			goto tr925
		case 45:
			goto tr926
		case 47:
			goto tr927
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr924
		}
		goto st0
tr595:
//line parse.rl:394
d=0;
	goto st312
	st312:
		if p++; p == pe {
			goto _test_eof312
		}
	st_case_312:
//line parse.go:14947
		switch ( s)[p] {
		case 79:
			goto st313
		case 111:
			goto st313
		}
		goto st0
	st313:
		if p++; p == pe {
			goto _test_eof313
		}
	st_case_313:
		switch ( s)[p] {
		case 78:
			goto tr623
		case 110:
			goto tr623
		}
		goto st0
tr596:
//line parse.rl:394
d=0;
	goto st314
	st314:
		if p++; p == pe {
			goto _test_eof314
		}
	st_case_314:
//line parse.go:14976
		switch ( s)[p] {
		case 65:
			goto st315
		case 85:
			goto st316
		case 97:
			goto st315
		case 117:
			goto st316
		}
		goto st0
	st315:
		if p++; p == pe {
			goto _test_eof315
		}
	st_case_315:
		switch ( s)[p] {
		case 84:
			goto tr626
		case 116:
			goto tr626
		}
		goto st0
	st316:
		if p++; p == pe {
			goto _test_eof316
		}
	st_case_316:
		switch ( s)[p] {
		case 78:
			goto tr627
		case 110:
			goto tr627
		}
		goto st0
tr597:
//line parse.rl:394
d=0;
	goto st317
	st317:
		if p++; p == pe {
			goto _test_eof317
		}
	st_case_317:
//line parse.go:15021
		switch ( s)[p] {
		case 72:
			goto st318
		case 85:
			goto st319
		case 104:
			goto st318
		case 117:
			goto st319
		}
		goto st0
	st318:
		if p++; p == pe {
			goto _test_eof318
		}
	st_case_318:
		switch ( s)[p] {
		case 85:
			goto tr630
		case 117:
			goto tr630
		}
		goto st0
	st319:
		if p++; p == pe {
			goto _test_eof319
		}
	st_case_319:
		switch ( s)[p] {
		case 69:
			goto tr631
		case 101:
			goto tr631
		}
		goto st0
tr598:
//line parse.rl:394
d=0;
	goto st320
	st320:
		if p++; p == pe {
			goto _test_eof320
		}
	st_case_320:
//line parse.go:15066
		switch ( s)[p] {
		case 69:
			goto st321
		case 101:
			goto st321
		}
		goto st0
	st321:
		if p++; p == pe {
			goto _test_eof321
		}
	st_case_321:
		switch ( s)[p] {
		case 68:
			goto tr633
		case 100:
			goto tr633
		}
		goto st0
tr589:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st322
tr635:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st322
tr649:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st322
tr654:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:391
d=m
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st322
tr660:
//line parse.rl:390
 end=m; d=1;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st322
tr685:
//line parse.rl:390
 start=m; end=0;d=0;
//line parse.rl:211

            {
                if d>12{
                    return nt, fmt.Errorf("invalid month */%d", d)
                }
                if start>12 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if  end>12 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't an error
                endOp := 16-end
                if end==0{
                    endOp = 0
                }
                endMask := (^uint16(0))<<endOp>>endOp
                if d==0{
                    nt.month |= 1<<(start-1)
                }else{
                    nt.month |= (uint16(skips[d-1]&mask12)<<uint16(start-1))&endMask
                }
            }
        
	goto st322
	st322:
		if p++; p == pe {
			goto _test_eof322
		}
	st_case_322:
//line parse.go:15289
		switch ( s)[p] {
		case 42:
			goto tr578
		case 65:
			goto tr580
		case 68:
			goto tr581
		case 70:
			goto tr582
		case 74:
			goto tr583
		case 77:
			goto tr584
		case 78:
			goto tr585
		case 79:
			goto tr586
		case 83:
			goto tr587
		case 97:
			goto tr580
		case 100:
			goto tr581
		case 102:
			goto tr582
		case 106:
			goto tr583
		case 109:
			goto tr584
		case 110:
			goto tr585
		case 111:
			goto tr586
		case 115:
			goto tr587
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr579
		}
		goto st0
tr579:
//line parse.rl:390
d=0;
//line parse.rl:132

            mark = p;
        
	goto st323
	st323:
		if p++; p == pe {
			goto _test_eof323
		}
	st_case_323:
//line parse.go:15343
		switch ( s)[p] {
		case 32:
			goto tr634
		case 44:
			goto tr635
		case 45:
			goto tr636
		case 47:
			goto tr637
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st323
			}
		case ( s)[p] >= 9:
			goto tr634
		}
		goto st0
tr636:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
	goto st324
tr686:
//line parse.rl:390
 start=m; end=0;d=0;
	goto st324
	st324:
		if p++; p == pe {
			goto _test_eof324
		}
	st_case_324:
//line parse.go:15384
		switch ( s)[p] {
		case 65:
			goto st328
		case 68:
			goto st332
		case 70:
			goto st334
		case 74:
			goto st336
		case 77:
			goto st339
		case 78:
			goto st341
		case 79:
			goto st343
		case 83:
			goto st345
		case 97:
			goto st328
		case 100:
			goto st332
		case 102:
			goto st334
		case 106:
			goto st336
		case 109:
			goto st339
		case 110:
			goto st341
		case 111:
			goto st343
		case 115:
			goto st345
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr639
		}
		goto st0
tr639:
//line parse.rl:132

            mark = p;
        
	goto st325
	st325:
		if p++; p == pe {
			goto _test_eof325
		}
	st_case_325:
//line parse.go:15434
		switch ( s)[p] {
		case 32:
			goto tr648
		case 44:
			goto tr649
		case 47:
			goto tr650
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st325
			}
		case ( s)[p] >= 9:
			goto tr648
		}
		goto st0
tr590:
//line parse.rl:390
 start=1;end=12;m=0;d=1; 
	goto st326
tr637:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 start=m; end=0;d=0;
	goto st326
tr650:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:390
 end=m; d=1;
	goto st326
tr661:
//line parse.rl:390
 end=m; d=1;
	goto st326
tr687:
//line parse.rl:390
 start=m; end=0;d=0;
	goto st326
	st326:
		if p++; p == pe {
			goto _test_eof326
		}
	st_case_326:
//line parse.go:15493
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr652
		}
		goto st0
tr652:
//line parse.rl:132

            mark = p;
        
	goto st327
	st327:
		if p++; p == pe {
			goto _test_eof327
		}
	st_case_327:
//line parse.go:15509
		switch ( s)[p] {
		case 32:
			goto tr653
		case 44:
			goto tr654
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st327
			}
		case ( s)[p] >= 9:
			goto tr653
		}
		goto st0
	st328:
		if p++; p == pe {
			goto _test_eof328
		}
	st_case_328:
		switch ( s)[p] {
		case 80:
			goto st329
		case 85:
			goto st331
		case 112:
			goto st329
		case 117:
			goto st331
		}
		goto st0
	st329:
		if p++; p == pe {
			goto _test_eof329
		}
	st_case_329:
		switch ( s)[p] {
		case 82:
			goto tr658
		case 114:
			goto tr658
		}
		goto st0
tr658:
//line parse.rl:370
m=4
	goto st330
tr662:
//line parse.rl:370
m=8
	goto st330
tr664:
//line parse.rl:370
m=12
	goto st330
tr666:
//line parse.rl:370
m=2
	goto st330
tr669:
//line parse.rl:370
m=1
	goto st330
tr670:
//line parse.rl:370
m=7
	goto st330
tr671:
//line parse.rl:370
m=6
	goto st330
tr673:
//line parse.rl:370
m=3
	goto st330
tr674:
//line parse.rl:370
m=5
	goto st330
tr676:
//line parse.rl:370
m=11
	goto st330
tr678:
//line parse.rl:370
m=10
	goto st330
tr680:
//line parse.rl:370
m=9
	goto st330
	st330:
		if p++; p == pe {
			goto _test_eof330
		}
	st_case_330:
//line parse.go:15606
		switch ( s)[p] {
		case 32:
			goto tr659
		case 44:
			goto tr660
		case 47:
			goto tr661
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr659
		}
		goto st0
	st331:
		if p++; p == pe {
			goto _test_eof331
		}
	st_case_331:
		switch ( s)[p] {
		case 71:
			goto tr662
		case 103:
			goto tr662
		}
		goto st0
	st332:
		if p++; p == pe {
			goto _test_eof332
		}
	st_case_332:
		switch ( s)[p] {
		case 69:
			goto st333
		case 101:
			goto st333
		}
		goto st0
	st333:
		if p++; p == pe {
			goto _test_eof333
		}
	st_case_333:
		switch ( s)[p] {
		case 67:
			goto tr664
		case 99:
			goto tr664
		}
		goto st0
	st334:
		if p++; p == pe {
			goto _test_eof334
		}
	st_case_334:
		switch ( s)[p] {
		case 69:
			goto st335
		case 101:
			goto st335
		}
		goto st0
	st335:
		if p++; p == pe {
			goto _test_eof335
		}
	st_case_335:
		switch ( s)[p] {
		case 66:
			goto tr666
		case 98:
			goto tr666
		}
		goto st0
	st336:
		if p++; p == pe {
			goto _test_eof336
		}
	st_case_336:
		switch ( s)[p] {
		case 65:
			goto st337
		case 85:
			goto st338
		case 97:
			goto st337
		case 117:
			goto st338
		}
		goto st0
	st337:
		if p++; p == pe {
			goto _test_eof337
		}
	st_case_337:
		switch ( s)[p] {
		case 78:
			goto tr669
		case 110:
			goto tr669
		}
		goto st0
	st338:
		if p++; p == pe {
			goto _test_eof338
		}
	st_case_338:
		switch ( s)[p] {
		case 76:
			goto tr670
		case 78:
			goto tr671
		case 108:
			goto tr670
		case 110:
			goto tr671
		}
		goto st0
	st339:
		if p++; p == pe {
			goto _test_eof339
		}
	st_case_339:
		switch ( s)[p] {
		case 65:
			goto st340
		case 97:
			goto st340
		}
		goto st0
	st340:
		if p++; p == pe {
			goto _test_eof340
		}
	st_case_340:
		switch ( s)[p] {
		case 82:
			goto tr673
		case 89:
			goto tr674
		case 114:
			goto tr673
		case 121:
			goto tr674
		}
		goto st0
	st341:
		if p++; p == pe {
			goto _test_eof341
		}
	st_case_341:
		switch ( s)[p] {
		case 79:
			goto st342
		case 111:
			goto st342
		}
		goto st0
	st342:
		if p++; p == pe {
			goto _test_eof342
		}
	st_case_342:
		switch ( s)[p] {
		case 86:
			goto tr676
		case 118:
			goto tr676
		}
		goto st0
	st343:
		if p++; p == pe {
			goto _test_eof343
		}
	st_case_343:
		switch ( s)[p] {
		case 67:
			goto st344
		case 99:
			goto st344
		}
		goto st0
	st344:
		if p++; p == pe {
			goto _test_eof344
		}
	st_case_344:
		switch ( s)[p] {
		case 84:
			goto tr678
		case 116:
			goto tr678
		}
		goto st0
	st345:
		if p++; p == pe {
			goto _test_eof345
		}
	st_case_345:
		switch ( s)[p] {
		case 69:
			goto st346
		case 101:
			goto st346
		}
		goto st0
	st346:
		if p++; p == pe {
			goto _test_eof346
		}
	st_case_346:
		switch ( s)[p] {
		case 80:
			goto tr680
		case 112:
			goto tr680
		}
		goto st0
tr580:
//line parse.rl:390
d=0;
	goto st347
	st347:
		if p++; p == pe {
			goto _test_eof347
		}
	st_case_347:
//line parse.go:15832
		switch ( s)[p] {
		case 80:
			goto st348
		case 85:
			goto st350
		case 112:
			goto st348
		case 117:
			goto st350
		}
		goto st0
	st348:
		if p++; p == pe {
			goto _test_eof348
		}
	st_case_348:
		switch ( s)[p] {
		case 82:
			goto tr683
		case 114:
			goto tr683
		}
		goto st0
tr683:
//line parse.rl:370
m=4
	goto st349
tr688:
//line parse.rl:370
m=8
	goto st349
tr690:
//line parse.rl:370
m=12
	goto st349
tr692:
//line parse.rl:370
m=2
	goto st349
tr695:
//line parse.rl:370
m=1
	goto st349
tr696:
//line parse.rl:370
m=7
	goto st349
tr697:
//line parse.rl:370
m=6
	goto st349
tr699:
//line parse.rl:370
m=3
	goto st349
tr700:
//line parse.rl:370
m=5
	goto st349
tr702:
//line parse.rl:370
m=11
	goto st349
tr704:
//line parse.rl:370
m=10
	goto st349
tr706:
//line parse.rl:370
m=9
	goto st349
	st349:
		if p++; p == pe {
			goto _test_eof349
		}
	st_case_349:
//line parse.go:15909
		switch ( s)[p] {
		case 32:
			goto tr684
		case 44:
			goto tr685
		case 45:
			goto tr686
		case 47:
			goto tr687
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr684
		}
		goto st0
	st350:
		if p++; p == pe {
			goto _test_eof350
		}
	st_case_350:
		switch ( s)[p] {
		case 71:
			goto tr688
		case 103:
			goto tr688
		}
		goto st0
tr581:
//line parse.rl:390
d=0;
	goto st351
	st351:
		if p++; p == pe {
			goto _test_eof351
		}
	st_case_351:
//line parse.go:15945
		switch ( s)[p] {
		case 69:
			goto st352
		case 101:
			goto st352
		}
		goto st0
	st352:
		if p++; p == pe {
			goto _test_eof352
		}
	st_case_352:
		switch ( s)[p] {
		case 67:
			goto tr690
		case 99:
			goto tr690
		}
		goto st0
tr582:
//line parse.rl:390
d=0;
	goto st353
	st353:
		if p++; p == pe {
			goto _test_eof353
		}
	st_case_353:
//line parse.go:15974
		switch ( s)[p] {
		case 69:
			goto st354
		case 101:
			goto st354
		}
		goto st0
	st354:
		if p++; p == pe {
			goto _test_eof354
		}
	st_case_354:
		switch ( s)[p] {
		case 66:
			goto tr692
		case 98:
			goto tr692
		}
		goto st0
tr583:
//line parse.rl:390
d=0;
	goto st355
	st355:
		if p++; p == pe {
			goto _test_eof355
		}
	st_case_355:
//line parse.go:16003
		switch ( s)[p] {
		case 65:
			goto st356
		case 85:
			goto st357
		case 97:
			goto st356
		case 117:
			goto st357
		}
		goto st0
	st356:
		if p++; p == pe {
			goto _test_eof356
		}
	st_case_356:
		switch ( s)[p] {
		case 78:
			goto tr695
		case 110:
			goto tr695
		}
		goto st0
	st357:
		if p++; p == pe {
			goto _test_eof357
		}
	st_case_357:
		switch ( s)[p] {
		case 76:
			goto tr696
		case 78:
			goto tr697
		case 108:
			goto tr696
		case 110:
			goto tr697
		}
		goto st0
tr584:
//line parse.rl:390
d=0;
	goto st358
	st358:
		if p++; p == pe {
			goto _test_eof358
		}
	st_case_358:
//line parse.go:16052
		switch ( s)[p] {
		case 65:
			goto st359
		case 97:
			goto st359
		}
		goto st0
	st359:
		if p++; p == pe {
			goto _test_eof359
		}
	st_case_359:
		switch ( s)[p] {
		case 82:
			goto tr699
		case 89:
			goto tr700
		case 114:
			goto tr699
		case 121:
			goto tr700
		}
		goto st0
tr585:
//line parse.rl:390
d=0;
	goto st360
	st360:
		if p++; p == pe {
			goto _test_eof360
		}
	st_case_360:
//line parse.go:16085
		switch ( s)[p] {
		case 79:
			goto st361
		case 111:
			goto st361
		}
		goto st0
	st361:
		if p++; p == pe {
			goto _test_eof361
		}
	st_case_361:
		switch ( s)[p] {
		case 86:
			goto tr702
		case 118:
			goto tr702
		}
		goto st0
tr586:
//line parse.rl:390
d=0;
	goto st362
	st362:
		if p++; p == pe {
			goto _test_eof362
		}
	st_case_362:
//line parse.go:16114
		switch ( s)[p] {
		case 67:
			goto st363
		case 99:
			goto st363
		}
		goto st0
	st363:
		if p++; p == pe {
			goto _test_eof363
		}
	st_case_363:
		switch ( s)[p] {
		case 84:
			goto tr704
		case 116:
			goto tr704
		}
		goto st0
tr587:
//line parse.rl:390
d=0;
	goto st364
	st364:
		if p++; p == pe {
			goto _test_eof364
		}
	st_case_364:
//line parse.go:16143
		switch ( s)[p] {
		case 69:
			goto st365
		case 101:
			goto st365
		}
		goto st0
	st365:
		if p++; p == pe {
			goto _test_eof365
		}
	st_case_365:
		switch ( s)[p] {
		case 80:
			goto tr706
		case 112:
			goto tr706
		}
		goto st0
tr575:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st366
tr708:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st366
tr719:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st366
tr724:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:387
d=m
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st366
tr729:
//line parse.rl:386
 end=m-1; d=1;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st366
tr746:
//line parse.rl:386
 start=m-1; end=0;d=0;
//line parse.rl:322

            {
                if d>=31{
                    return nt, fmt.Errorf("invalid day month */%d", d)
                }
                if start>30 {
                    return nt, fmt.Errorf("invalid start month %d", start)
                }
                if end>31 {
                    return nt, fmt.Errorf("invalid end month %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.dom |= 1<<(m-1)
                }else{
                    nt.dom |= uint32(((skips[d-1]&mask31)<<start)&endMask)
                }
            }
        
	goto st366
	st366:
		if p++; p == pe {
			goto _test_eof366
		}
	st_case_366:
//line parse.go:16366
		switch ( s)[p] {
		case 42:
			goto tr567
		case 70:
			goto tr569
		case 77:
			goto tr570
		case 83:
			goto tr571
		case 84:
			goto tr572
		case 87:
			goto tr573
		case 102:
			goto tr569
		case 109:
			goto tr570
		case 115:
			goto tr571
		case 116:
			goto tr572
		case 119:
			goto tr573
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr568
		}
		goto st0
tr568:
//line parse.rl:386
d=0;
//line parse.rl:132

            mark = p;
        
	goto st367
	st367:
		if p++; p == pe {
			goto _test_eof367
		}
	st_case_367:
//line parse.go:16408
		switch ( s)[p] {
		case 32:
			goto tr707
		case 44:
			goto tr708
		case 45:
			goto tr709
		case 47:
			goto tr710
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st367
			}
		case ( s)[p] >= 9:
			goto tr707
		}
		goto st0
tr709:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st368
tr747:
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st368
	st368:
		if p++; p == pe {
			goto _test_eof368
		}
	st_case_368:
//line parse.go:16449
		switch ( s)[p] {
		case 70:
			goto st372
		case 77:
			goto st375
		case 83:
			goto st377
		case 84:
			goto st380
		case 87:
			goto st383
		case 102:
			goto st372
		case 109:
			goto st375
		case 115:
			goto st377
		case 116:
			goto st380
		case 119:
			goto st383
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr712
		}
		goto st0
tr712:
//line parse.rl:132

            mark = p;
        
	goto st369
	st369:
		if p++; p == pe {
			goto _test_eof369
		}
	st_case_369:
//line parse.go:16487
		switch ( s)[p] {
		case 32:
			goto tr718
		case 44:
			goto tr719
		case 47:
			goto tr720
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st369
			}
		case ( s)[p] >= 9:
			goto tr718
		}
		goto st0
tr576:
//line parse.rl:386
 start=0;end=30;m=0;d=1; 
	goto st370
tr710:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st370
tr720:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:386
 end=m-1; d=1;
	goto st370
tr730:
//line parse.rl:386
 end=m-1; d=1;
	goto st370
tr748:
//line parse.rl:386
 start=m-1; end=0;d=0;
	goto st370
	st370:
		if p++; p == pe {
			goto _test_eof370
		}
	st_case_370:
//line parse.go:16546
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr722
		}
		goto st0
tr722:
//line parse.rl:132

            mark = p;
        
	goto st371
	st371:
		if p++; p == pe {
			goto _test_eof371
		}
	st_case_371:
//line parse.go:16562
		switch ( s)[p] {
		case 32:
			goto tr723
		case 44:
			goto tr724
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st371
			}
		case ( s)[p] >= 9:
			goto tr723
		}
		goto st0
	st372:
		if p++; p == pe {
			goto _test_eof372
		}
	st_case_372:
		switch ( s)[p] {
		case 82:
			goto st373
		case 114:
			goto st373
		}
		goto st0
	st373:
		if p++; p == pe {
			goto _test_eof373
		}
	st_case_373:
		switch ( s)[p] {
		case 73:
			goto tr727
		case 105:
			goto tr727
		}
		goto st0
tr727:
//line parse.rl:369
m=5
	goto st374
tr732:
//line parse.rl:369
m=1
	goto st374
tr735:
//line parse.rl:369
m=6
	goto st374
tr736:
//line parse.rl:369
m=0
	goto st374
tr739:
//line parse.rl:369
m=4
	goto st374
tr740:
//line parse.rl:369
m=2
	goto st374
tr742:
//line parse.rl:369
m=3
	goto st374
	st374:
		if p++; p == pe {
			goto _test_eof374
		}
	st_case_374:
//line parse.go:16635
		switch ( s)[p] {
		case 32:
			goto tr728
		case 44:
			goto tr729
		case 47:
			goto tr730
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr728
		}
		goto st0
	st375:
		if p++; p == pe {
			goto _test_eof375
		}
	st_case_375:
		switch ( s)[p] {
		case 79:
			goto st376
		case 111:
			goto st376
		}
		goto st0
	st376:
		if p++; p == pe {
			goto _test_eof376
		}
	st_case_376:
		switch ( s)[p] {
		case 78:
			goto tr732
		case 110:
			goto tr732
		}
		goto st0
	st377:
		if p++; p == pe {
			goto _test_eof377
		}
	st_case_377:
		switch ( s)[p] {
		case 65:
			goto st378
		case 85:
			goto st379
		case 97:
			goto st378
		case 117:
			goto st379
		}
		goto st0
	st378:
		if p++; p == pe {
			goto _test_eof378
		}
	st_case_378:
		switch ( s)[p] {
		case 84:
			goto tr735
		case 116:
			goto tr735
		}
		goto st0
	st379:
		if p++; p == pe {
			goto _test_eof379
		}
	st_case_379:
		switch ( s)[p] {
		case 78:
			goto tr736
		case 110:
			goto tr736
		}
		goto st0
	st380:
		if p++; p == pe {
			goto _test_eof380
		}
	st_case_380:
		switch ( s)[p] {
		case 72:
			goto st381
		case 85:
			goto st382
		case 104:
			goto st381
		case 117:
			goto st382
		}
		goto st0
	st381:
		if p++; p == pe {
			goto _test_eof381
		}
	st_case_381:
		switch ( s)[p] {
		case 85:
			goto tr739
		case 117:
			goto tr739
		}
		goto st0
	st382:
		if p++; p == pe {
			goto _test_eof382
		}
	st_case_382:
		switch ( s)[p] {
		case 69:
			goto tr740
		case 101:
			goto tr740
		}
		goto st0
	st383:
		if p++; p == pe {
			goto _test_eof383
		}
	st_case_383:
		switch ( s)[p] {
		case 69:
			goto st384
		case 101:
			goto st384
		}
		goto st0
	st384:
		if p++; p == pe {
			goto _test_eof384
		}
	st_case_384:
		switch ( s)[p] {
		case 68:
			goto tr742
		case 100:
			goto tr742
		}
		goto st0
tr569:
//line parse.rl:386
d=0;
	goto st385
	st385:
		if p++; p == pe {
			goto _test_eof385
		}
	st_case_385:
//line parse.go:16785
		switch ( s)[p] {
		case 82:
			goto st386
		case 114:
			goto st386
		}
		goto st0
	st386:
		if p++; p == pe {
			goto _test_eof386
		}
	st_case_386:
		switch ( s)[p] {
		case 73:
			goto tr744
		case 105:
			goto tr744
		}
		goto st0
tr744:
//line parse.rl:369
m=5
	goto st387
tr750:
//line parse.rl:369
m=1
	goto st387
tr753:
//line parse.rl:369
m=6
	goto st387
tr754:
//line parse.rl:369
m=0
	goto st387
tr757:
//line parse.rl:369
m=4
	goto st387
tr758:
//line parse.rl:369
m=2
	goto st387
tr760:
//line parse.rl:369
m=3
	goto st387
	st387:
		if p++; p == pe {
			goto _test_eof387
		}
	st_case_387:
//line parse.go:16838
		switch ( s)[p] {
		case 32:
			goto tr745
		case 44:
			goto tr746
		case 45:
			goto tr747
		case 47:
			goto tr748
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr745
		}
		goto st0
tr570:
//line parse.rl:386
d=0;
	goto st388
	st388:
		if p++; p == pe {
			goto _test_eof388
		}
	st_case_388:
//line parse.go:16862
		switch ( s)[p] {
		case 79:
			goto st389
		case 111:
			goto st389
		}
		goto st0
	st389:
		if p++; p == pe {
			goto _test_eof389
		}
	st_case_389:
		switch ( s)[p] {
		case 78:
			goto tr750
		case 110:
			goto tr750
		}
		goto st0
tr571:
//line parse.rl:386
d=0;
	goto st390
	st390:
		if p++; p == pe {
			goto _test_eof390
		}
	st_case_390:
//line parse.go:16891
		switch ( s)[p] {
		case 65:
			goto st391
		case 85:
			goto st392
		case 97:
			goto st391
		case 117:
			goto st392
		}
		goto st0
	st391:
		if p++; p == pe {
			goto _test_eof391
		}
	st_case_391:
		switch ( s)[p] {
		case 84:
			goto tr753
		case 116:
			goto tr753
		}
		goto st0
	st392:
		if p++; p == pe {
			goto _test_eof392
		}
	st_case_392:
		switch ( s)[p] {
		case 78:
			goto tr754
		case 110:
			goto tr754
		}
		goto st0
tr572:
//line parse.rl:386
d=0;
	goto st393
	st393:
		if p++; p == pe {
			goto _test_eof393
		}
	st_case_393:
//line parse.go:16936
		switch ( s)[p] {
		case 72:
			goto st394
		case 85:
			goto st395
		case 104:
			goto st394
		case 117:
			goto st395
		}
		goto st0
	st394:
		if p++; p == pe {
			goto _test_eof394
		}
	st_case_394:
		switch ( s)[p] {
		case 85:
			goto tr757
		case 117:
			goto tr757
		}
		goto st0
	st395:
		if p++; p == pe {
			goto _test_eof395
		}
	st_case_395:
		switch ( s)[p] {
		case 69:
			goto tr758
		case 101:
			goto tr758
		}
		goto st0
tr573:
//line parse.rl:386
d=0;
	goto st396
	st396:
		if p++; p == pe {
			goto _test_eof396
		}
	st_case_396:
//line parse.go:16981
		switch ( s)[p] {
		case 69:
			goto st397
		case 101:
			goto st397
		}
		goto st0
	st397:
		if p++; p == pe {
			goto _test_eof397
		}
	st_case_397:
		switch ( s)[p] {
		case 68:
			goto tr760
		case 100:
			goto tr760
		}
		goto st0
tr564:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st398
tr762:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st398
tr768:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st398
tr773:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:383
d=m
//line parse.rl:186

            {
                if d>=24{
                    return nt, fmt.Errorf("invalid hour */%d", d)
                }
                if start>=24 {
                    return nt, fmt.Errorf("invalid start hour %d", start)
                }
                if end>=24 {
                    return nt, fmt.Errorf("invalid end hour %d", start)
                }
                // handle the case that isn't a 
                endOp := 64-end-1
                if end==0{
                    endOp = 0
                }
                endMask := (^uint64(0))<<endOp>>endOp
                if d==0{
                    nt.hour |= 1<<m
                }else{
                    nt.hour |= uint32(((skips[d-1]&mask24)<<start)&endMask)
                }
            }
        
	goto st398
	st398:
		if p++; p == pe {
			goto _test_eof398
		}
	st_case_398:
//line parse.go:17146
		if ( s)[p] == 42 {
			goto tr561
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr562
		}
		goto st0
tr562:
//line parse.rl:382
d=0;
//line parse.rl:132

            mark = p;
        
	goto st399
	st399:
		if p++; p == pe {
			goto _test_eof399
		}
	st_case_399:
//line parse.go:17167
		switch ( s)[p] {
		case 32:
			goto tr761
		case 44:
			goto tr762
		case 45:
			goto tr763
		case 47:
			goto tr764
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st399
			}
		case ( s)[p] >= 9:
			goto tr761
		}
		goto st0
tr763:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
	goto st400
	st400:
		if p++; p == pe {
			goto _test_eof400
		}
	st_case_400:
//line parse.go:17204
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr766
		}
		goto st0
tr766:
//line parse.rl:132

            mark = p;
        
	goto st401
	st401:
		if p++; p == pe {
			goto _test_eof401
		}
	st_case_401:
//line parse.go:17220
		switch ( s)[p] {
		case 32:
			goto tr767
		case 44:
			goto tr768
		case 47:
			goto tr769
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st401
			}
		case ( s)[p] >= 9:
			goto tr767
		}
		goto st0
tr565:
//line parse.rl:382
 start=0;end=23;m=1;d=1; 
	goto st402
tr764:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 start=m; end=0;d=0;
	goto st402
tr769:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:382
 end=m; d=1;
	goto st402
	st402:
		if p++; p == pe {
			goto _test_eof402
		}
	st_case_402:
//line parse.go:17271
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr771
		}
		goto st0
tr771:
//line parse.rl:132

            mark = p;
        
	goto st403
	st403:
		if p++; p == pe {
			goto _test_eof403
		}
	st_case_403:
//line parse.go:17287
		switch ( s)[p] {
		case 32:
			goto tr772
		case 44:
			goto tr773
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st403
			}
		case ( s)[p] >= 9:
			goto tr772
		}
		goto st0
tr559:
//line parse.rl:375
 start=0;end=59;m=1;d=1; 
	goto st404
tr782:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st404
tr787:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 end=m; d=1;
	goto st404
	st404:
		if p++; p == pe {
			goto _test_eof404
		}
	st_case_404:
//line parse.go:17336
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr775
		}
		goto st0
tr775:
//line parse.rl:132

            mark = p;
        
	goto st405
	st405:
		if p++; p == pe {
			goto _test_eof405
		}
	st_case_405:
//line parse.go:17352
		switch ( s)[p] {
		case 32:
			goto tr776
		case 44:
			goto tr777
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st405
			}
		case ( s)[p] >= 9:
			goto tr776
		}
		goto st0
tr556:
//line parse.rl:375
d=0;
//line parse.rl:132

            mark = p;
        
	goto st406
	st406:
		if p++; p == pe {
			goto _test_eof406
		}
	st_case_406:
//line parse.go:17381
		switch ( s)[p] {
		case 32:
			goto tr779
		case 44:
			goto tr780
		case 45:
			goto tr781
		case 47:
			goto tr782
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st406
			}
		case ( s)[p] >= 9:
			goto tr779
		}
		goto st0
tr781:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:375
 start=m; end=0;d=0;
	goto st407
	st407:
		if p++; p == pe {
			goto _test_eof407
		}
	st_case_407:
//line parse.go:17418
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto tr784
		}
		goto st0
tr784:
//line parse.rl:132

            mark = p;
        
	goto st408
	st408:
		if p++; p == pe {
			goto _test_eof408
		}
	st_case_408:
//line parse.go:17434
		switch ( s)[p] {
		case 32:
			goto tr785
		case 44:
			goto tr786
		case 47:
			goto tr787
		}
		switch {
		case ( s)[p] > 13:
			if 48 <= ( s)[p] && ( s)[p] <= 57 {
				goto st408
			}
		case ( s)[p] >= 9:
			goto tr785
		}
		goto st0
tr789:
//line parse.rl:351
p = (te) - 1
{
            p--

            return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])
        }
	goto st492
tr928:
//line parse.rl:351
te = p+1
{
            p--

            return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])
        }
	goto st492
tr931:
//line parse.rl:417
te = p
p--

	goto st492
tr932:
//line parse.rl:351
te = p
p--
{
            p--

            return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])
        }
	goto st492
tr933:
//line parse.rl:414
 nt.addEveryDay(int(m)); 
//line parse.rl:416
te = p
p--

	goto st492
tr934:
//line parse.rl:412
 nt.addEveryDur(time.Duration(m)*time.Hour); 
//line parse.rl:416
te = p
p--

	goto st492
tr936:
//line parse.rl:413
 nt.addEveryDur(time.Duration(m)*time.Minute); 
//line parse.rl:416
te = p
p--

	goto st492
tr939:
//line parse.rl:408
 nt.setEveryMonth(int(m)); 
//line parse.rl:416
te = p
p--

	goto st492
tr940:
//line parse.rl:407
 nt.addEveryDur(time.Duration(m)*time.Millisecond); 
//line parse.rl:416
te = p
p--

	goto st492
tr941:
//line parse.rl:410
 nt.addEveryDur( time.Duration(m)) ;
//line parse.rl:416
te = p
p--

	goto st492
tr942:
//line parse.rl:411
nt.addEveryDur(time.Duration(m)*time.Second); 
//line parse.rl:416
te = p
p--

	goto st492
tr943:
//line parse.rl:409
 nt.addEveryDur(time.Duration(m)*time.Microsecond); 
//line parse.rl:416
te = p
p--

	goto st492
tr945:
//line parse.rl:415
 nt.addEveryDay(int(m*7)); 
//line parse.rl:416
te = p
p--

	goto st492
tr946:
//line parse.rl:406
 nt.setEveryYear(int(m));
//line parse.rl:416
te = p
p--

	goto st492
	st492:
//line NONE:1
ts = 0

		if p++; p == pe {
			goto _test_eof492
		}
	st_case_492:
//line NONE:1
ts = p

//line parse.go:17577
		switch ( s)[p] {
		case 32:
			goto st493
		case 100:
			goto st0
		case 104:
			goto st0
		case 117:
			goto st0
		case 121:
			goto st0
		}
		switch {
		case ( s)[p] < 48:
			if 9 <= ( s)[p] && ( s)[p] <= 13 {
				goto st493
			}
		case ( s)[p] > 57:
			if 109 <= ( s)[p] && ( s)[p] <= 110 {
				goto st0
			}
		default:
			goto tr930
		}
		goto tr928
	st493:
		if p++; p == pe {
			goto _test_eof493
		}
	st_case_493:
		if ( s)[p] == 32 {
			goto st493
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st493
		}
		goto tr931
tr930:
//line NONE:1
te = p+1

//line parse.rl:132

            mark = p;
        
	goto st494
	st494:
		if p++; p == pe {
			goto _test_eof494
		}
	st_case_494:
//line parse.go:17629
		switch ( s)[p] {
		case 68:
			goto tr791
		case 72:
			goto tr792
		case 77:
			goto tr793
		case 78:
			goto tr794
		case 83:
			goto tr795
		case 85:
			goto tr796
		case 87:
			goto tr797
		case 89:
			goto tr798
		case 100:
			goto tr791
		case 104:
			goto tr792
		case 109:
			goto tr793
		case 110:
			goto tr794
		case 115:
			goto tr795
		case 117:
			goto tr796
		case 119:
			goto tr797
		case 121:
			goto tr798
		case 181:
			goto tr796
		case 194:
			goto tr796
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto st409
		}
		goto tr932
	st409:
		if p++; p == pe {
			goto _test_eof409
		}
	st_case_409:
		switch ( s)[p] {
		case 68:
			goto tr791
		case 72:
			goto tr792
		case 77:
			goto tr793
		case 78:
			goto tr794
		case 83:
			goto tr795
		case 85:
			goto tr796
		case 87:
			goto tr797
		case 89:
			goto tr798
		case 100:
			goto tr791
		case 104:
			goto tr792
		case 109:
			goto tr793
		case 110:
			goto tr794
		case 115:
			goto tr795
		case 117:
			goto tr796
		case 119:
			goto tr797
		case 121:
			goto tr798
		case 181:
			goto tr796
		case 194:
			goto tr796
		}
		if 48 <= ( s)[p] && ( s)[p] <= 57 {
			goto st409
		}
		goto tr789
tr791:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
	goto st495
	st495:
		if p++; p == pe {
			goto _test_eof495
		}
	st_case_495:
//line parse.go:17734
		goto tr933
tr792:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
	goto st496
	st496:
		if p++; p == pe {
			goto _test_eof496
		}
	st_case_496:
//line parse.go:17751
		switch ( s)[p] {
		case 82:
			goto st497
		case 114:
			goto st497
		}
		goto tr934
	st497:
		if p++; p == pe {
			goto _test_eof497
		}
	st_case_497:
		goto tr934
tr793:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
	goto st498
	st498:
		if p++; p == pe {
			goto _test_eof498
		}
	st_case_498:
//line parse.go:17780
		switch ( s)[p] {
		case 79:
			goto st499
		case 83:
			goto st500
		case 111:
			goto st499
		case 115:
			goto st500
		}
		goto tr936
	st499:
		if p++; p == pe {
			goto _test_eof499
		}
	st_case_499:
		goto tr939
	st500:
		if p++; p == pe {
			goto _test_eof500
		}
	st_case_500:
		goto tr940
tr794:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
	goto st410
	st410:
		if p++; p == pe {
			goto _test_eof410
		}
	st_case_410:
//line parse.go:17819
		switch ( s)[p] {
		case 83:
			goto st501
		case 115:
			goto st501
		}
		goto tr789
	st501:
		if p++; p == pe {
			goto _test_eof501
		}
	st_case_501:
		goto tr941
tr795:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
	goto st502
	st502:
		if p++; p == pe {
			goto _test_eof502
		}
	st_case_502:
//line parse.go:17848
		goto tr942
tr796:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
	goto st503
	st503:
		if p++; p == pe {
			goto _test_eof503
		}
	st_case_503:
//line parse.go:17865
		switch ( s)[p] {
		case 83:
			goto st504
		case 115:
			goto st504
		}
		goto tr943
	st504:
		if p++; p == pe {
			goto _test_eof504
		}
	st_case_504:
		goto tr943
tr797:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
	goto st505
	st505:
		if p++; p == pe {
			goto _test_eof505
		}
	st_case_505:
//line parse.go:17894
		goto tr945
tr798:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
	goto st506
	st506:
		if p++; p == pe {
			goto _test_eof506
		}
	st_case_506:
//line parse.go:17911
		goto tr946
tr800:
//line parse.rl:351
te = p+1
{
            p--

            return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])
        }
	goto st507
tr955:
//line parse.rl:421
te = p
p--
{
                nt.second=1
                nt.minute=1
                nt.hour=1
                nt.dom=1
                nt.month=1
                nt.dow=^uint8(0)
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                nt.end=^uint8(0)
                if p!=pe-1{return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])}
            }
	goto st507
tr956:
//line parse.rl:457
te = p
p--
{
                nt.second=1
                nt.minute=1
                nt.hour=1
                nt.dom=^uint32(0)
                nt.month=((1<<13) - 1) // every month
                nt.dow=^uint8(0)
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                nt.end =^uint8(0)
                if p!=pe-1{return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])}
            }
	goto st507
tr957:
//line parse.rl:506
te = p
p--
{
                nt.every = true;
                p = mark
                {stack[top] = 507; top++; goto st492 }
            }
	goto st507
tr959:
//line parse.rl:481
te = p
p--
{
                nt.second=1
                nt.minute=(1<<60)-1
                nt.hour=^uint32(0)
                nt.dom=^uint32(0)
                nt.month=((1<<13) - 1) // every month
                nt.dow=^uint8(0)
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                nt.end =^uint8(0)
                if p!=pe-1{return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])}
            }
	goto st507
tr960:
//line parse.rl:493
te = p
p--
{
                nt.second=(1<<60)-1
                nt.minute=(1<<60)-1
                nt.hour=^uint32(0)
                nt.dom=^uint32(0)
                nt.month=((1<<13) - 1) // every month
                nt.dow=^uint8(0)
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                nt.end =^uint8(0)
                if p!=pe-1{return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])}
            }
	goto st507
tr961:
//line parse.rl:469
te = p
p--
{
                nt.second=1
                nt.minute=1
                nt.hour=^uint32(0)
                nt.dom=^uint32(0)
                nt.month=((1<<13) - 1) // every month
                nt.dow=^uint8(0)
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                nt.end =^uint8(0)
                if p!=pe-1{return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])}
            }
	goto st507
tr962:
//line parse.rl:433
te = p
p--
{
                nt.second=1
                nt.minute=1
                nt.hour=1
                nt.dom=1
                nt.month=((1<<13) - 1) // every month
                nt.dow=^uint8(0)
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                nt.end =^uint8(0)
                if p!=pe-1{return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])}
            }
	goto st507
tr963:
//line parse.rl:445
te = p
p--
{
                nt.second=1
                nt.minute=1
                nt.hour=1
                nt.dom=^uint32(0)
                nt.month=((1<<13) - 1) // every month
                nt.dow=1
                nt.high=^uint64(0)
                nt.low=^uint64(0)
                nt.end =^uint8(0)
                if p!=pe-1{return nt, fmt.Errorf("error in parsing at char %d, '%s'", p, s[p:p+1])}
            }
	goto st507
	st507:
//line NONE:1
ts = 0

		if p++; p == pe {
			goto _test_eof507
		}
	st_case_507:
//line NONE:1
ts = p

//line parse.go:18062
		switch ( s)[p] {
		case 97:
			goto st412
		case 100:
			goto st419
		case 101:
			goto st423
		case 104:
			goto st439
		case 109:
			goto st444
		case 119:
			goto st456
		case 121:
			goto st461
		}
		goto st411
	st411:
		if p++; p == pe {
			goto _test_eof411
		}
	st_case_411:
		if ( s)[p] == 43 {
			goto tr800
		}
		goto st0
	st412:
		if p++; p == pe {
			goto _test_eof412
		}
	st_case_412:
		switch ( s)[p] {
		case 43:
			goto tr800
		case 110:
			goto st413
		}
		goto st0
	st413:
		if p++; p == pe {
			goto _test_eof413
		}
	st_case_413:
		if ( s)[p] == 110 {
			goto st414
		}
		goto st0
	st414:
		if p++; p == pe {
			goto _test_eof414
		}
	st_case_414:
		if ( s)[p] == 117 {
			goto st415
		}
		goto st0
	st415:
		if p++; p == pe {
			goto _test_eof415
		}
	st_case_415:
		if ( s)[p] == 97 {
			goto st416
		}
		goto st0
	st416:
		if p++; p == pe {
			goto _test_eof416
		}
	st_case_416:
		if ( s)[p] == 108 {
			goto st417
		}
		goto st0
	st417:
		if p++; p == pe {
			goto _test_eof417
		}
	st_case_417:
		if ( s)[p] == 108 {
			goto st418
		}
		goto st0
	st418:
		if p++; p == pe {
			goto _test_eof418
		}
	st_case_418:
		if ( s)[p] == 121 {
			goto st508
		}
		goto st0
	st508:
		if p++; p == pe {
			goto _test_eof508
		}
	st_case_508:
		if ( s)[p] == 32 {
			goto st508
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st508
		}
		goto tr955
	st419:
		if p++; p == pe {
			goto _test_eof419
		}
	st_case_419:
		switch ( s)[p] {
		case 43:
			goto tr800
		case 97:
			goto st420
		}
		goto st0
	st420:
		if p++; p == pe {
			goto _test_eof420
		}
	st_case_420:
		if ( s)[p] == 105 {
			goto st421
		}
		goto st0
	st421:
		if p++; p == pe {
			goto _test_eof421
		}
	st_case_421:
		if ( s)[p] == 108 {
			goto st422
		}
		goto st0
	st422:
		if p++; p == pe {
			goto _test_eof422
		}
	st_case_422:
		if ( s)[p] == 121 {
			goto st509
		}
		goto st0
	st509:
		if p++; p == pe {
			goto _test_eof509
		}
	st_case_509:
		if ( s)[p] == 32 {
			goto st509
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st509
		}
		goto tr956
	st423:
		if p++; p == pe {
			goto _test_eof423
		}
	st_case_423:
		switch ( s)[p] {
		case 43:
			goto tr800
		case 118:
			goto st424
		}
		goto st0
	st424:
		if p++; p == pe {
			goto _test_eof424
		}
	st_case_424:
		if ( s)[p] == 101 {
			goto st425
		}
		goto st0
	st425:
		if p++; p == pe {
			goto _test_eof425
		}
	st_case_425:
		if ( s)[p] == 114 {
			goto st426
		}
		goto st0
	st426:
		if p++; p == pe {
			goto _test_eof426
		}
	st_case_426:
		if ( s)[p] == 121 {
			goto st427
		}
		goto st0
	st427:
		if p++; p == pe {
			goto _test_eof427
		}
	st_case_427:
		switch ( s)[p] {
		case 32:
			goto tr816
		case 95:
			goto st428
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto tr816
		}
		goto st0
tr816:
//line parse.rl:132

            mark = p;
        
	goto st510
	st510:
		if p++; p == pe {
			goto _test_eof510
		}
	st_case_510:
//line parse.go:18283
		if ( s)[p] == 32 {
			goto st510
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st510
		}
		goto tr957
	st428:
		if p++; p == pe {
			goto _test_eof428
		}
	st_case_428:
		switch ( s)[p] {
		case 109:
			goto st429
		case 115:
			goto st434
		}
		goto st0
	st429:
		if p++; p == pe {
			goto _test_eof429
		}
	st_case_429:
		if ( s)[p] == 105 {
			goto st430
		}
		goto st0
	st430:
		if p++; p == pe {
			goto _test_eof430
		}
	st_case_430:
		if ( s)[p] == 110 {
			goto st431
		}
		goto st0
	st431:
		if p++; p == pe {
			goto _test_eof431
		}
	st_case_431:
		if ( s)[p] == 117 {
			goto st432
		}
		goto st0
	st432:
		if p++; p == pe {
			goto _test_eof432
		}
	st_case_432:
		if ( s)[p] == 116 {
			goto st433
		}
		goto st0
	st433:
		if p++; p == pe {
			goto _test_eof433
		}
	st_case_433:
		if ( s)[p] == 101 {
			goto st511
		}
		goto st0
	st511:
		if p++; p == pe {
			goto _test_eof511
		}
	st_case_511:
		if ( s)[p] == 32 {
			goto st511
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st511
		}
		goto tr959
	st434:
		if p++; p == pe {
			goto _test_eof434
		}
	st_case_434:
		if ( s)[p] == 101 {
			goto st435
		}
		goto st0
	st435:
		if p++; p == pe {
			goto _test_eof435
		}
	st_case_435:
		if ( s)[p] == 99 {
			goto st436
		}
		goto st0
	st436:
		if p++; p == pe {
			goto _test_eof436
		}
	st_case_436:
		if ( s)[p] == 111 {
			goto st437
		}
		goto st0
	st437:
		if p++; p == pe {
			goto _test_eof437
		}
	st_case_437:
		if ( s)[p] == 110 {
			goto st438
		}
		goto st0
	st438:
		if p++; p == pe {
			goto _test_eof438
		}
	st_case_438:
		if ( s)[p] == 100 {
			goto st512
		}
		goto st0
	st512:
		if p++; p == pe {
			goto _test_eof512
		}
	st_case_512:
		if ( s)[p] == 32 {
			goto st512
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st512
		}
		goto tr960
	st439:
		if p++; p == pe {
			goto _test_eof439
		}
	st_case_439:
		switch ( s)[p] {
		case 43:
			goto tr800
		case 111:
			goto st440
		}
		goto st0
	st440:
		if p++; p == pe {
			goto _test_eof440
		}
	st_case_440:
		if ( s)[p] == 117 {
			goto st441
		}
		goto st0
	st441:
		if p++; p == pe {
			goto _test_eof441
		}
	st_case_441:
		if ( s)[p] == 114 {
			goto st442
		}
		goto st0
	st442:
		if p++; p == pe {
			goto _test_eof442
		}
	st_case_442:
		if ( s)[p] == 108 {
			goto st443
		}
		goto st0
	st443:
		if p++; p == pe {
			goto _test_eof443
		}
	st_case_443:
		if ( s)[p] == 121 {
			goto st513
		}
		goto st0
	st513:
		if p++; p == pe {
			goto _test_eof513
		}
	st_case_513:
		if ( s)[p] == 32 {
			goto st513
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st513
		}
		goto tr961
	st444:
		if p++; p == pe {
			goto _test_eof444
		}
	st_case_444:
		switch ( s)[p] {
		case 43:
			goto tr800
		case 105:
			goto st445
		case 111:
			goto st451
		}
		goto st0
	st445:
		if p++; p == pe {
			goto _test_eof445
		}
	st_case_445:
		if ( s)[p] == 100 {
			goto st446
		}
		goto st0
	st446:
		if p++; p == pe {
			goto _test_eof446
		}
	st_case_446:
		if ( s)[p] == 110 {
			goto st447
		}
		goto st0
	st447:
		if p++; p == pe {
			goto _test_eof447
		}
	st_case_447:
		if ( s)[p] == 105 {
			goto st448
		}
		goto st0
	st448:
		if p++; p == pe {
			goto _test_eof448
		}
	st_case_448:
		if ( s)[p] == 103 {
			goto st449
		}
		goto st0
	st449:
		if p++; p == pe {
			goto _test_eof449
		}
	st_case_449:
		if ( s)[p] == 104 {
			goto st450
		}
		goto st0
	st450:
		if p++; p == pe {
			goto _test_eof450
		}
	st_case_450:
		if ( s)[p] == 116 {
			goto st509
		}
		goto st0
	st451:
		if p++; p == pe {
			goto _test_eof451
		}
	st_case_451:
		if ( s)[p] == 110 {
			goto st452
		}
		goto st0
	st452:
		if p++; p == pe {
			goto _test_eof452
		}
	st_case_452:
		if ( s)[p] == 116 {
			goto st453
		}
		goto st0
	st453:
		if p++; p == pe {
			goto _test_eof453
		}
	st_case_453:
		if ( s)[p] == 104 {
			goto st454
		}
		goto st0
	st454:
		if p++; p == pe {
			goto _test_eof454
		}
	st_case_454:
		if ( s)[p] == 108 {
			goto st455
		}
		goto st0
	st455:
		if p++; p == pe {
			goto _test_eof455
		}
	st_case_455:
		if ( s)[p] == 121 {
			goto st514
		}
		goto st0
	st514:
		if p++; p == pe {
			goto _test_eof514
		}
	st_case_514:
		if ( s)[p] == 32 {
			goto st514
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st514
		}
		goto tr962
	st456:
		if p++; p == pe {
			goto _test_eof456
		}
	st_case_456:
		switch ( s)[p] {
		case 43:
			goto tr800
		case 101:
			goto st457
		}
		goto st0
	st457:
		if p++; p == pe {
			goto _test_eof457
		}
	st_case_457:
		if ( s)[p] == 101 {
			goto st458
		}
		goto st0
	st458:
		if p++; p == pe {
			goto _test_eof458
		}
	st_case_458:
		if ( s)[p] == 107 {
			goto st459
		}
		goto st0
	st459:
		if p++; p == pe {
			goto _test_eof459
		}
	st_case_459:
		if ( s)[p] == 108 {
			goto st460
		}
		goto st0
	st460:
		if p++; p == pe {
			goto _test_eof460
		}
	st_case_460:
		if ( s)[p] == 121 {
			goto st515
		}
		goto st0
	st515:
		if p++; p == pe {
			goto _test_eof515
		}
	st_case_515:
		if ( s)[p] == 32 {
			goto st515
		}
		if 9 <= ( s)[p] && ( s)[p] <= 13 {
			goto st515
		}
		goto tr963
	st461:
		if p++; p == pe {
			goto _test_eof461
		}
	st_case_461:
		switch ( s)[p] {
		case 43:
			goto tr800
		case 101:
			goto st462
		}
		goto st0
	st462:
		if p++; p == pe {
			goto _test_eof462
		}
	st_case_462:
		if ( s)[p] == 97 {
			goto st463
		}
		goto st0
	st463:
		if p++; p == pe {
			goto _test_eof463
		}
	st_case_463:
		if ( s)[p] == 114 {
			goto st417
		}
		goto st0
	st_out:
	_test_eof464: cs = 464; goto _test_eof
	_test_eof1: cs = 1; goto _test_eof
	_test_eof465: cs = 465; goto _test_eof
	_test_eof466: cs = 466; goto _test_eof
	_test_eof2: cs = 2; goto _test_eof
	_test_eof3: cs = 3; goto _test_eof
	_test_eof4: cs = 4; goto _test_eof
	_test_eof5: cs = 5; goto _test_eof
	_test_eof6: cs = 6; goto _test_eof
	_test_eof7: cs = 7; goto _test_eof
	_test_eof8: cs = 8; goto _test_eof
	_test_eof9: cs = 9; goto _test_eof
	_test_eof467: cs = 467; goto _test_eof
	_test_eof10: cs = 10; goto _test_eof
	_test_eof468: cs = 468; goto _test_eof
	_test_eof11: cs = 11; goto _test_eof
	_test_eof469: cs = 469; goto _test_eof
	_test_eof12: cs = 12; goto _test_eof
	_test_eof470: cs = 470; goto _test_eof
	_test_eof471: cs = 471; goto _test_eof
	_test_eof13: cs = 13; goto _test_eof
	_test_eof472: cs = 472; goto _test_eof
	_test_eof14: cs = 14; goto _test_eof
	_test_eof15: cs = 15; goto _test_eof
	_test_eof16: cs = 16; goto _test_eof
	_test_eof17: cs = 17; goto _test_eof
	_test_eof18: cs = 18; goto _test_eof
	_test_eof19: cs = 19; goto _test_eof
	_test_eof20: cs = 20; goto _test_eof
	_test_eof21: cs = 21; goto _test_eof
	_test_eof22: cs = 22; goto _test_eof
	_test_eof23: cs = 23; goto _test_eof
	_test_eof24: cs = 24; goto _test_eof
	_test_eof473: cs = 473; goto _test_eof
	_test_eof474: cs = 474; goto _test_eof
	_test_eof25: cs = 25; goto _test_eof
	_test_eof475: cs = 475; goto _test_eof
	_test_eof26: cs = 26; goto _test_eof
	_test_eof476: cs = 476; goto _test_eof
	_test_eof27: cs = 27; goto _test_eof
	_test_eof477: cs = 477; goto _test_eof
	_test_eof28: cs = 28; goto _test_eof
	_test_eof29: cs = 29; goto _test_eof
	_test_eof478: cs = 478; goto _test_eof
	_test_eof30: cs = 30; goto _test_eof
	_test_eof31: cs = 31; goto _test_eof
	_test_eof32: cs = 32; goto _test_eof
	_test_eof33: cs = 33; goto _test_eof
	_test_eof34: cs = 34; goto _test_eof
	_test_eof35: cs = 35; goto _test_eof
	_test_eof36: cs = 36; goto _test_eof
	_test_eof37: cs = 37; goto _test_eof
	_test_eof38: cs = 38; goto _test_eof
	_test_eof39: cs = 39; goto _test_eof
	_test_eof40: cs = 40; goto _test_eof
	_test_eof41: cs = 41; goto _test_eof
	_test_eof479: cs = 479; goto _test_eof
	_test_eof42: cs = 42; goto _test_eof
	_test_eof43: cs = 43; goto _test_eof
	_test_eof44: cs = 44; goto _test_eof
	_test_eof45: cs = 45; goto _test_eof
	_test_eof46: cs = 46; goto _test_eof
	_test_eof47: cs = 47; goto _test_eof
	_test_eof48: cs = 48; goto _test_eof
	_test_eof49: cs = 49; goto _test_eof
	_test_eof50: cs = 50; goto _test_eof
	_test_eof51: cs = 51; goto _test_eof
	_test_eof52: cs = 52; goto _test_eof
	_test_eof53: cs = 53; goto _test_eof
	_test_eof54: cs = 54; goto _test_eof
	_test_eof55: cs = 55; goto _test_eof
	_test_eof56: cs = 56; goto _test_eof
	_test_eof57: cs = 57; goto _test_eof
	_test_eof58: cs = 58; goto _test_eof
	_test_eof59: cs = 59; goto _test_eof
	_test_eof60: cs = 60; goto _test_eof
	_test_eof61: cs = 61; goto _test_eof
	_test_eof62: cs = 62; goto _test_eof
	_test_eof63: cs = 63; goto _test_eof
	_test_eof64: cs = 64; goto _test_eof
	_test_eof65: cs = 65; goto _test_eof
	_test_eof66: cs = 66; goto _test_eof
	_test_eof67: cs = 67; goto _test_eof
	_test_eof68: cs = 68; goto _test_eof
	_test_eof69: cs = 69; goto _test_eof
	_test_eof70: cs = 70; goto _test_eof
	_test_eof71: cs = 71; goto _test_eof
	_test_eof72: cs = 72; goto _test_eof
	_test_eof73: cs = 73; goto _test_eof
	_test_eof74: cs = 74; goto _test_eof
	_test_eof75: cs = 75; goto _test_eof
	_test_eof76: cs = 76; goto _test_eof
	_test_eof77: cs = 77; goto _test_eof
	_test_eof78: cs = 78; goto _test_eof
	_test_eof79: cs = 79; goto _test_eof
	_test_eof80: cs = 80; goto _test_eof
	_test_eof81: cs = 81; goto _test_eof
	_test_eof82: cs = 82; goto _test_eof
	_test_eof83: cs = 83; goto _test_eof
	_test_eof84: cs = 84; goto _test_eof
	_test_eof85: cs = 85; goto _test_eof
	_test_eof86: cs = 86; goto _test_eof
	_test_eof87: cs = 87; goto _test_eof
	_test_eof88: cs = 88; goto _test_eof
	_test_eof89: cs = 89; goto _test_eof
	_test_eof90: cs = 90; goto _test_eof
	_test_eof91: cs = 91; goto _test_eof
	_test_eof92: cs = 92; goto _test_eof
	_test_eof93: cs = 93; goto _test_eof
	_test_eof94: cs = 94; goto _test_eof
	_test_eof95: cs = 95; goto _test_eof
	_test_eof96: cs = 96; goto _test_eof
	_test_eof97: cs = 97; goto _test_eof
	_test_eof98: cs = 98; goto _test_eof
	_test_eof99: cs = 99; goto _test_eof
	_test_eof100: cs = 100; goto _test_eof
	_test_eof101: cs = 101; goto _test_eof
	_test_eof102: cs = 102; goto _test_eof
	_test_eof103: cs = 103; goto _test_eof
	_test_eof104: cs = 104; goto _test_eof
	_test_eof105: cs = 105; goto _test_eof
	_test_eof106: cs = 106; goto _test_eof
	_test_eof107: cs = 107; goto _test_eof
	_test_eof108: cs = 108; goto _test_eof
	_test_eof109: cs = 109; goto _test_eof
	_test_eof110: cs = 110; goto _test_eof
	_test_eof111: cs = 111; goto _test_eof
	_test_eof112: cs = 112; goto _test_eof
	_test_eof113: cs = 113; goto _test_eof
	_test_eof114: cs = 114; goto _test_eof
	_test_eof115: cs = 115; goto _test_eof
	_test_eof116: cs = 116; goto _test_eof
	_test_eof117: cs = 117; goto _test_eof
	_test_eof118: cs = 118; goto _test_eof
	_test_eof119: cs = 119; goto _test_eof
	_test_eof120: cs = 120; goto _test_eof
	_test_eof121: cs = 121; goto _test_eof
	_test_eof122: cs = 122; goto _test_eof
	_test_eof123: cs = 123; goto _test_eof
	_test_eof124: cs = 124; goto _test_eof
	_test_eof125: cs = 125; goto _test_eof
	_test_eof126: cs = 126; goto _test_eof
	_test_eof127: cs = 127; goto _test_eof
	_test_eof128: cs = 128; goto _test_eof
	_test_eof129: cs = 129; goto _test_eof
	_test_eof130: cs = 130; goto _test_eof
	_test_eof131: cs = 131; goto _test_eof
	_test_eof132: cs = 132; goto _test_eof
	_test_eof133: cs = 133; goto _test_eof
	_test_eof134: cs = 134; goto _test_eof
	_test_eof135: cs = 135; goto _test_eof
	_test_eof136: cs = 136; goto _test_eof
	_test_eof137: cs = 137; goto _test_eof
	_test_eof138: cs = 138; goto _test_eof
	_test_eof139: cs = 139; goto _test_eof
	_test_eof140: cs = 140; goto _test_eof
	_test_eof141: cs = 141; goto _test_eof
	_test_eof142: cs = 142; goto _test_eof
	_test_eof143: cs = 143; goto _test_eof
	_test_eof144: cs = 144; goto _test_eof
	_test_eof145: cs = 145; goto _test_eof
	_test_eof146: cs = 146; goto _test_eof
	_test_eof147: cs = 147; goto _test_eof
	_test_eof148: cs = 148; goto _test_eof
	_test_eof149: cs = 149; goto _test_eof
	_test_eof150: cs = 150; goto _test_eof
	_test_eof151: cs = 151; goto _test_eof
	_test_eof152: cs = 152; goto _test_eof
	_test_eof153: cs = 153; goto _test_eof
	_test_eof154: cs = 154; goto _test_eof
	_test_eof155: cs = 155; goto _test_eof
	_test_eof156: cs = 156; goto _test_eof
	_test_eof157: cs = 157; goto _test_eof
	_test_eof480: cs = 480; goto _test_eof
	_test_eof481: cs = 481; goto _test_eof
	_test_eof158: cs = 158; goto _test_eof
	_test_eof482: cs = 482; goto _test_eof
	_test_eof159: cs = 159; goto _test_eof
	_test_eof483: cs = 483; goto _test_eof
	_test_eof160: cs = 160; goto _test_eof
	_test_eof484: cs = 484; goto _test_eof
	_test_eof161: cs = 161; goto _test_eof
	_test_eof162: cs = 162; goto _test_eof
	_test_eof163: cs = 163; goto _test_eof
	_test_eof164: cs = 164; goto _test_eof
	_test_eof165: cs = 165; goto _test_eof
	_test_eof166: cs = 166; goto _test_eof
	_test_eof167: cs = 167; goto _test_eof
	_test_eof168: cs = 168; goto _test_eof
	_test_eof169: cs = 169; goto _test_eof
	_test_eof170: cs = 170; goto _test_eof
	_test_eof171: cs = 171; goto _test_eof
	_test_eof172: cs = 172; goto _test_eof
	_test_eof173: cs = 173; goto _test_eof
	_test_eof174: cs = 174; goto _test_eof
	_test_eof175: cs = 175; goto _test_eof
	_test_eof176: cs = 176; goto _test_eof
	_test_eof177: cs = 177; goto _test_eof
	_test_eof178: cs = 178; goto _test_eof
	_test_eof179: cs = 179; goto _test_eof
	_test_eof180: cs = 180; goto _test_eof
	_test_eof181: cs = 181; goto _test_eof
	_test_eof182: cs = 182; goto _test_eof
	_test_eof183: cs = 183; goto _test_eof
	_test_eof184: cs = 184; goto _test_eof
	_test_eof185: cs = 185; goto _test_eof
	_test_eof186: cs = 186; goto _test_eof
	_test_eof187: cs = 187; goto _test_eof
	_test_eof188: cs = 188; goto _test_eof
	_test_eof189: cs = 189; goto _test_eof
	_test_eof190: cs = 190; goto _test_eof
	_test_eof191: cs = 191; goto _test_eof
	_test_eof192: cs = 192; goto _test_eof
	_test_eof193: cs = 193; goto _test_eof
	_test_eof194: cs = 194; goto _test_eof
	_test_eof195: cs = 195; goto _test_eof
	_test_eof196: cs = 196; goto _test_eof
	_test_eof197: cs = 197; goto _test_eof
	_test_eof198: cs = 198; goto _test_eof
	_test_eof199: cs = 199; goto _test_eof
	_test_eof200: cs = 200; goto _test_eof
	_test_eof201: cs = 201; goto _test_eof
	_test_eof202: cs = 202; goto _test_eof
	_test_eof203: cs = 203; goto _test_eof
	_test_eof204: cs = 204; goto _test_eof
	_test_eof205: cs = 205; goto _test_eof
	_test_eof206: cs = 206; goto _test_eof
	_test_eof207: cs = 207; goto _test_eof
	_test_eof208: cs = 208; goto _test_eof
	_test_eof209: cs = 209; goto _test_eof
	_test_eof210: cs = 210; goto _test_eof
	_test_eof211: cs = 211; goto _test_eof
	_test_eof212: cs = 212; goto _test_eof
	_test_eof213: cs = 213; goto _test_eof
	_test_eof214: cs = 214; goto _test_eof
	_test_eof215: cs = 215; goto _test_eof
	_test_eof216: cs = 216; goto _test_eof
	_test_eof217: cs = 217; goto _test_eof
	_test_eof218: cs = 218; goto _test_eof
	_test_eof219: cs = 219; goto _test_eof
	_test_eof220: cs = 220; goto _test_eof
	_test_eof221: cs = 221; goto _test_eof
	_test_eof222: cs = 222; goto _test_eof
	_test_eof223: cs = 223; goto _test_eof
	_test_eof224: cs = 224; goto _test_eof
	_test_eof225: cs = 225; goto _test_eof
	_test_eof226: cs = 226; goto _test_eof
	_test_eof227: cs = 227; goto _test_eof
	_test_eof228: cs = 228; goto _test_eof
	_test_eof229: cs = 229; goto _test_eof
	_test_eof230: cs = 230; goto _test_eof
	_test_eof231: cs = 231; goto _test_eof
	_test_eof232: cs = 232; goto _test_eof
	_test_eof233: cs = 233; goto _test_eof
	_test_eof234: cs = 234; goto _test_eof
	_test_eof235: cs = 235; goto _test_eof
	_test_eof236: cs = 236; goto _test_eof
	_test_eof237: cs = 237; goto _test_eof
	_test_eof238: cs = 238; goto _test_eof
	_test_eof239: cs = 239; goto _test_eof
	_test_eof240: cs = 240; goto _test_eof
	_test_eof241: cs = 241; goto _test_eof
	_test_eof242: cs = 242; goto _test_eof
	_test_eof243: cs = 243; goto _test_eof
	_test_eof244: cs = 244; goto _test_eof
	_test_eof245: cs = 245; goto _test_eof
	_test_eof246: cs = 246; goto _test_eof
	_test_eof247: cs = 247; goto _test_eof
	_test_eof248: cs = 248; goto _test_eof
	_test_eof249: cs = 249; goto _test_eof
	_test_eof250: cs = 250; goto _test_eof
	_test_eof251: cs = 251; goto _test_eof
	_test_eof252: cs = 252; goto _test_eof
	_test_eof253: cs = 253; goto _test_eof
	_test_eof254: cs = 254; goto _test_eof
	_test_eof255: cs = 255; goto _test_eof
	_test_eof256: cs = 256; goto _test_eof
	_test_eof257: cs = 257; goto _test_eof
	_test_eof258: cs = 258; goto _test_eof
	_test_eof259: cs = 259; goto _test_eof
	_test_eof260: cs = 260; goto _test_eof
	_test_eof261: cs = 261; goto _test_eof
	_test_eof262: cs = 262; goto _test_eof
	_test_eof263: cs = 263; goto _test_eof
	_test_eof264: cs = 264; goto _test_eof
	_test_eof265: cs = 265; goto _test_eof
	_test_eof266: cs = 266; goto _test_eof
	_test_eof267: cs = 267; goto _test_eof
	_test_eof268: cs = 268; goto _test_eof
	_test_eof269: cs = 269; goto _test_eof
	_test_eof270: cs = 270; goto _test_eof
	_test_eof271: cs = 271; goto _test_eof
	_test_eof272: cs = 272; goto _test_eof
	_test_eof273: cs = 273; goto _test_eof
	_test_eof274: cs = 274; goto _test_eof
	_test_eof275: cs = 275; goto _test_eof
	_test_eof276: cs = 276; goto _test_eof
	_test_eof277: cs = 277; goto _test_eof
	_test_eof278: cs = 278; goto _test_eof
	_test_eof279: cs = 279; goto _test_eof
	_test_eof280: cs = 280; goto _test_eof
	_test_eof281: cs = 281; goto _test_eof
	_test_eof282: cs = 282; goto _test_eof
	_test_eof283: cs = 283; goto _test_eof
	_test_eof284: cs = 284; goto _test_eof
	_test_eof285: cs = 285; goto _test_eof
	_test_eof286: cs = 286; goto _test_eof
	_test_eof287: cs = 287; goto _test_eof
	_test_eof288: cs = 288; goto _test_eof
	_test_eof289: cs = 289; goto _test_eof
	_test_eof290: cs = 290; goto _test_eof
	_test_eof291: cs = 291; goto _test_eof
	_test_eof292: cs = 292; goto _test_eof
	_test_eof293: cs = 293; goto _test_eof
	_test_eof294: cs = 294; goto _test_eof
	_test_eof485: cs = 485; goto _test_eof
	_test_eof486: cs = 486; goto _test_eof
	_test_eof295: cs = 295; goto _test_eof
	_test_eof487: cs = 487; goto _test_eof
	_test_eof296: cs = 296; goto _test_eof
	_test_eof488: cs = 488; goto _test_eof
	_test_eof297: cs = 297; goto _test_eof
	_test_eof489: cs = 489; goto _test_eof
	_test_eof298: cs = 298; goto _test_eof
	_test_eof299: cs = 299; goto _test_eof
	_test_eof490: cs = 490; goto _test_eof
	_test_eof300: cs = 300; goto _test_eof
	_test_eof301: cs = 301; goto _test_eof
	_test_eof302: cs = 302; goto _test_eof
	_test_eof303: cs = 303; goto _test_eof
	_test_eof304: cs = 304; goto _test_eof
	_test_eof305: cs = 305; goto _test_eof
	_test_eof306: cs = 306; goto _test_eof
	_test_eof307: cs = 307; goto _test_eof
	_test_eof308: cs = 308; goto _test_eof
	_test_eof309: cs = 309; goto _test_eof
	_test_eof310: cs = 310; goto _test_eof
	_test_eof311: cs = 311; goto _test_eof
	_test_eof491: cs = 491; goto _test_eof
	_test_eof312: cs = 312; goto _test_eof
	_test_eof313: cs = 313; goto _test_eof
	_test_eof314: cs = 314; goto _test_eof
	_test_eof315: cs = 315; goto _test_eof
	_test_eof316: cs = 316; goto _test_eof
	_test_eof317: cs = 317; goto _test_eof
	_test_eof318: cs = 318; goto _test_eof
	_test_eof319: cs = 319; goto _test_eof
	_test_eof320: cs = 320; goto _test_eof
	_test_eof321: cs = 321; goto _test_eof
	_test_eof322: cs = 322; goto _test_eof
	_test_eof323: cs = 323; goto _test_eof
	_test_eof324: cs = 324; goto _test_eof
	_test_eof325: cs = 325; goto _test_eof
	_test_eof326: cs = 326; goto _test_eof
	_test_eof327: cs = 327; goto _test_eof
	_test_eof328: cs = 328; goto _test_eof
	_test_eof329: cs = 329; goto _test_eof
	_test_eof330: cs = 330; goto _test_eof
	_test_eof331: cs = 331; goto _test_eof
	_test_eof332: cs = 332; goto _test_eof
	_test_eof333: cs = 333; goto _test_eof
	_test_eof334: cs = 334; goto _test_eof
	_test_eof335: cs = 335; goto _test_eof
	_test_eof336: cs = 336; goto _test_eof
	_test_eof337: cs = 337; goto _test_eof
	_test_eof338: cs = 338; goto _test_eof
	_test_eof339: cs = 339; goto _test_eof
	_test_eof340: cs = 340; goto _test_eof
	_test_eof341: cs = 341; goto _test_eof
	_test_eof342: cs = 342; goto _test_eof
	_test_eof343: cs = 343; goto _test_eof
	_test_eof344: cs = 344; goto _test_eof
	_test_eof345: cs = 345; goto _test_eof
	_test_eof346: cs = 346; goto _test_eof
	_test_eof347: cs = 347; goto _test_eof
	_test_eof348: cs = 348; goto _test_eof
	_test_eof349: cs = 349; goto _test_eof
	_test_eof350: cs = 350; goto _test_eof
	_test_eof351: cs = 351; goto _test_eof
	_test_eof352: cs = 352; goto _test_eof
	_test_eof353: cs = 353; goto _test_eof
	_test_eof354: cs = 354; goto _test_eof
	_test_eof355: cs = 355; goto _test_eof
	_test_eof356: cs = 356; goto _test_eof
	_test_eof357: cs = 357; goto _test_eof
	_test_eof358: cs = 358; goto _test_eof
	_test_eof359: cs = 359; goto _test_eof
	_test_eof360: cs = 360; goto _test_eof
	_test_eof361: cs = 361; goto _test_eof
	_test_eof362: cs = 362; goto _test_eof
	_test_eof363: cs = 363; goto _test_eof
	_test_eof364: cs = 364; goto _test_eof
	_test_eof365: cs = 365; goto _test_eof
	_test_eof366: cs = 366; goto _test_eof
	_test_eof367: cs = 367; goto _test_eof
	_test_eof368: cs = 368; goto _test_eof
	_test_eof369: cs = 369; goto _test_eof
	_test_eof370: cs = 370; goto _test_eof
	_test_eof371: cs = 371; goto _test_eof
	_test_eof372: cs = 372; goto _test_eof
	_test_eof373: cs = 373; goto _test_eof
	_test_eof374: cs = 374; goto _test_eof
	_test_eof375: cs = 375; goto _test_eof
	_test_eof376: cs = 376; goto _test_eof
	_test_eof377: cs = 377; goto _test_eof
	_test_eof378: cs = 378; goto _test_eof
	_test_eof379: cs = 379; goto _test_eof
	_test_eof380: cs = 380; goto _test_eof
	_test_eof381: cs = 381; goto _test_eof
	_test_eof382: cs = 382; goto _test_eof
	_test_eof383: cs = 383; goto _test_eof
	_test_eof384: cs = 384; goto _test_eof
	_test_eof385: cs = 385; goto _test_eof
	_test_eof386: cs = 386; goto _test_eof
	_test_eof387: cs = 387; goto _test_eof
	_test_eof388: cs = 388; goto _test_eof
	_test_eof389: cs = 389; goto _test_eof
	_test_eof390: cs = 390; goto _test_eof
	_test_eof391: cs = 391; goto _test_eof
	_test_eof392: cs = 392; goto _test_eof
	_test_eof393: cs = 393; goto _test_eof
	_test_eof394: cs = 394; goto _test_eof
	_test_eof395: cs = 395; goto _test_eof
	_test_eof396: cs = 396; goto _test_eof
	_test_eof397: cs = 397; goto _test_eof
	_test_eof398: cs = 398; goto _test_eof
	_test_eof399: cs = 399; goto _test_eof
	_test_eof400: cs = 400; goto _test_eof
	_test_eof401: cs = 401; goto _test_eof
	_test_eof402: cs = 402; goto _test_eof
	_test_eof403: cs = 403; goto _test_eof
	_test_eof404: cs = 404; goto _test_eof
	_test_eof405: cs = 405; goto _test_eof
	_test_eof406: cs = 406; goto _test_eof
	_test_eof407: cs = 407; goto _test_eof
	_test_eof408: cs = 408; goto _test_eof
	_test_eof492: cs = 492; goto _test_eof
	_test_eof493: cs = 493; goto _test_eof
	_test_eof494: cs = 494; goto _test_eof
	_test_eof409: cs = 409; goto _test_eof
	_test_eof495: cs = 495; goto _test_eof
	_test_eof496: cs = 496; goto _test_eof
	_test_eof497: cs = 497; goto _test_eof
	_test_eof498: cs = 498; goto _test_eof
	_test_eof499: cs = 499; goto _test_eof
	_test_eof500: cs = 500; goto _test_eof
	_test_eof410: cs = 410; goto _test_eof
	_test_eof501: cs = 501; goto _test_eof
	_test_eof502: cs = 502; goto _test_eof
	_test_eof503: cs = 503; goto _test_eof
	_test_eof504: cs = 504; goto _test_eof
	_test_eof505: cs = 505; goto _test_eof
	_test_eof506: cs = 506; goto _test_eof
	_test_eof507: cs = 507; goto _test_eof
	_test_eof411: cs = 411; goto _test_eof
	_test_eof412: cs = 412; goto _test_eof
	_test_eof413: cs = 413; goto _test_eof
	_test_eof414: cs = 414; goto _test_eof
	_test_eof415: cs = 415; goto _test_eof
	_test_eof416: cs = 416; goto _test_eof
	_test_eof417: cs = 417; goto _test_eof
	_test_eof418: cs = 418; goto _test_eof
	_test_eof508: cs = 508; goto _test_eof
	_test_eof419: cs = 419; goto _test_eof
	_test_eof420: cs = 420; goto _test_eof
	_test_eof421: cs = 421; goto _test_eof
	_test_eof422: cs = 422; goto _test_eof
	_test_eof509: cs = 509; goto _test_eof
	_test_eof423: cs = 423; goto _test_eof
	_test_eof424: cs = 424; goto _test_eof
	_test_eof425: cs = 425; goto _test_eof
	_test_eof426: cs = 426; goto _test_eof
	_test_eof427: cs = 427; goto _test_eof
	_test_eof510: cs = 510; goto _test_eof
	_test_eof428: cs = 428; goto _test_eof
	_test_eof429: cs = 429; goto _test_eof
	_test_eof430: cs = 430; goto _test_eof
	_test_eof431: cs = 431; goto _test_eof
	_test_eof432: cs = 432; goto _test_eof
	_test_eof433: cs = 433; goto _test_eof
	_test_eof511: cs = 511; goto _test_eof
	_test_eof434: cs = 434; goto _test_eof
	_test_eof435: cs = 435; goto _test_eof
	_test_eof436: cs = 436; goto _test_eof
	_test_eof437: cs = 437; goto _test_eof
	_test_eof438: cs = 438; goto _test_eof
	_test_eof512: cs = 512; goto _test_eof
	_test_eof439: cs = 439; goto _test_eof
	_test_eof440: cs = 440; goto _test_eof
	_test_eof441: cs = 441; goto _test_eof
	_test_eof442: cs = 442; goto _test_eof
	_test_eof443: cs = 443; goto _test_eof
	_test_eof513: cs = 513; goto _test_eof
	_test_eof444: cs = 444; goto _test_eof
	_test_eof445: cs = 445; goto _test_eof
	_test_eof446: cs = 446; goto _test_eof
	_test_eof447: cs = 447; goto _test_eof
	_test_eof448: cs = 448; goto _test_eof
	_test_eof449: cs = 449; goto _test_eof
	_test_eof450: cs = 450; goto _test_eof
	_test_eof451: cs = 451; goto _test_eof
	_test_eof452: cs = 452; goto _test_eof
	_test_eof453: cs = 453; goto _test_eof
	_test_eof454: cs = 454; goto _test_eof
	_test_eof455: cs = 455; goto _test_eof
	_test_eof514: cs = 514; goto _test_eof
	_test_eof456: cs = 456; goto _test_eof
	_test_eof457: cs = 457; goto _test_eof
	_test_eof458: cs = 458; goto _test_eof
	_test_eof459: cs = 459; goto _test_eof
	_test_eof460: cs = 460; goto _test_eof
	_test_eof515: cs = 515; goto _test_eof
	_test_eof461: cs = 461; goto _test_eof
	_test_eof462: cs = 462; goto _test_eof
	_test_eof463: cs = 463; goto _test_eof

	_test_eof: {}
	if p == eof {
		switch cs {
		case 465:
			goto tr858
		case 466:
			goto tr858
		case 467:
			goto tr860
		case 10:
			goto tr11
		case 468:
			goto tr861
		case 11:
			goto tr14
		case 469:
			goto tr862
		case 12:
			goto tr17
		case 470:
			goto tr863
		case 471:
			goto tr863
		case 472:
			goto tr865
		case 493:
			goto tr931
		case 494:
			goto tr932
		case 409:
			goto tr789
		case 495:
			goto tr933
		case 496:
			goto tr934
		case 497:
			goto tr934
		case 498:
			goto tr936
		case 499:
			goto tr939
		case 500:
			goto tr940
		case 410:
			goto tr789
		case 501:
			goto tr941
		case 502:
			goto tr942
		case 503:
			goto tr943
		case 504:
			goto tr943
		case 505:
			goto tr945
		case 506:
			goto tr946
		case 508:
			goto tr955
		case 509:
			goto tr956
		case 510:
			goto tr957
		case 511:
			goto tr959
		case 512:
			goto tr960
		case 513:
			goto tr961
		case 514:
			goto tr962
		case 515:
			goto tr963
		case 473, 485:
//line parse.rl:394
 start=0;end=6;m=0;d=1; 
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
		case 479, 491:
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
		case 478, 490:
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
		case 480:
//line parse.rl:398
 start=1970;end=2099;m=0;d=1; 
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
		case 475, 487:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 start=m; end=6;d=0;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
		case 476, 488:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:394
 end=m; d=1;
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
		case 477, 489:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:395
d=m
//line parse.rl:236

            {
                //const sundaysAtFirst = uint64(1 | 1<<7 | 1<<14 | 1<<21 | 1<<28 | 1<<35 | 1<<42)
                if d>7{
                    return nt, fmt.Errorf("invalid day of week */%d", d)
                }
                if start>7 {
                    return nt, fmt.Errorf("invalid start day of week %d", start)
                }
                if end==7{
                    end=6 // for compatibility with older crons
                }
                if end>6 {
                    return nt, fmt.Errorf("invalid end day of week %d", start)
                }
                if start>end {
                    return nt, errors.New("invalid day of week range start must be before end")
                }

                // handle the case that isn't a 
                dayRange := (^uint64(0))<<(64 - (end-start+1))>>(64 - end-1)
                if d==0{
                    //nt.dow |= uint32(sundaysAtFirst<<start)
                    nt.dow |= uint8(1<<start)
                }else{
                    dayRange&=skips[d-1]&mask7
                    nt.dow |= uint8(dayRange)
                }
            }
        
		case 482:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 start=m; end=m; d=0;
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
		case 483:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:398
 end=m; d=1;
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
		case 484:
//line parse.rl:356

            m=0
            for _, x := range s[mark:p] {
                m*=10
                m+=uint64(x-'0') // since we know that x is a numerical digit we can subtract the rune '0' to convert to a number from 0 to 9
            }
        
//line parse.rl:399
d=m
//line parse.rl:267

            // short circuit for the most common cases.
            if d>128 {
                return nt, fmt.Errorf("invalid year */%d", d)
            }
            if start<1970 || start>2099 {
                return nt, fmt.Errorf("invalid start year %d", start)
            }
            if end<1970 || end>2099 {
                return nt, fmt.Errorf("invalid end year %d", end)
            }
            if d==0{
                nt.setYear(int(start))
            }else if d==1&&start==end{
                nt.low=^uint64(0)
                nt.high=^uint64(0)
                nt.end=^uint8(0)
            }else if d >=64 {
                for i:=start;i<=end;i+=d{
                        nt.setYear(int(i))
                }
            } else {
                s := start - 1970
                e := end - 1970
                repeat:=d-1
                sk := skips[repeat]
                switch{
                case end<=start:
                    nt.setYear(int(start))
                case s < 64:
                    switch{
                    case e < 64:
                    nt.low |= sk<<s & ((^uint64(0)) >> (63-e))
                    case e < 128:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low)))) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                    nt.low |= sk<<s
                    nt.high |= (sk << (repeat - uint64(bits.LeadingZeros64(nt.low))))
                    nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 128:
                    switch{
                    case e < 128:
                        nt.high |= sk<<( s - 64 ) & ((^uint64(0)) >> ( 127 - e ))
                    default:
                        nt.high |= sk<<( s - 64)
                        nt.end |= uint8((sk << (repeat - uint64(bits.LeadingZeros64(nt.high)))) & ((^uint64(0)) >> ( 191 - e )))
                    }
                case s < 192:
                    nt.end |= uint8(sk<<( s - 128 ) & ((^uint64(0)) >> ( 191 - e )))
                }
            }
        
//line parse.go:19766
		}
	}

	_out: {}
	}

//line parse.rl:546
    if !nt.valid() {
        return nt, fmt.Errorf("failed to parse cron string '%s' %v %b", s, nt, mask12)
    }
    return nt,  nil
}


