/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.pantsbuild.jarjar.util.DuplicateJarEntryException;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.IoUtil;
import org.pantsbuild.jarjar.util.JarProcessor;

public class StandaloneJarProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(File file, File file2, JarProcessor jarProcessor) throws IOException {
        byte[] byArray = new byte[8192];
        JarFile jarFile = new JarFile(file);
        File file3 = File.createTempFile("jarjar", ".jar");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
        JarOutputStream jarOutputStream = new JarOutputStream(bufferedOutputStream);
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                EntryStruct entryStruct = new EntryStruct();
                JarEntry jarEntry = enumeration.nextElement();
                entryStruct.name = jarEntry.getName();
                entryStruct.time = jarEntry.getTime();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IoUtil.pipe(jarFile.getInputStream(jarEntry), byteArrayOutputStream, byArray);
                entryStruct.data = byteArrayOutputStream.toByteArray();
                if (!jarProcessor.process(entryStruct)) continue;
                if (hashSet.add(entryStruct.name)) {
                    jarEntry = new JarEntry(entryStruct.name);
                    jarEntry.setTime(entryStruct.time);
                    jarEntry.setCompressedSize(-1L);
                    jarOutputStream.putNextEntry(jarEntry);
                    jarOutputStream.write(entryStruct.data);
                    continue;
                }
                if (entryStruct.name.endsWith("/")) continue;
                throw new DuplicateJarEntryException(file.getAbsolutePath(), entryStruct.name);
            }
        }
        finally {
            jarFile.close();
            jarOutputStream.close();
        }
        IoUtil.copyZipWithoutEmptyDirectories(file3, file2);
        file3.delete();
    }
}

