/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.guava.collect;

import io.bazel.kotlin.builder.guava.annotations.GwtCompatible;
import io.bazel.kotlin.builder.guava.annotations.GwtIncompatible;
import io.bazel.kotlin.builder.guava.annotations.J2ktIncompatible;
import io.bazel.kotlin.builder.guava.base.Preconditions;
import io.bazel.kotlin.builder.guava.collect.ElementTypesAreNonnullByDefault;
import io.bazel.kotlin.builder.guava.collect.ImmutableList;
import io.bazel.kotlin.builder.guava.collect.ImmutableSet;
import io.bazel.kotlin.builder.guava.collect.Iterators;
import io.bazel.kotlin.builder.guava.collect.UnmodifiableIterator;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

