/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.tasks.jvm;

import com.google.protobuf.ProtocolStringList;
import io.bazel.kotlin.builder.utils.TaskUtilsKt;
import io.bazel.kotlin.builder.utils.jars.JarCreator;
import io.bazel.kotlin.model.CompilationTaskInfo;
import io.bazel.kotlin.model.JvmCompilationTask;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\bH\u0000\u00a8\u0006\t"}, d2={"instrumentRecursively", "", "instr", "Lorg/jacoco/core/instr/Instrumenter;", "metadataDir", "Ljava/nio/file/Path;", "root", "createCoverageInstrumentedJar", "Lio/bazel/kotlin/model/JvmCompilationTask;", "src_main_kotlin_io_bazel_kotlin_builder_tasks-tasks"})
public final class JacocoInstrumentationKt {
    public static final void createCoverageInstrumentedJar(@NotNull JvmCompilationTask $this$createCoverageInstrumentedJar) {
        JarCreator jarCreator;
        Intrinsics.checkNotNullParameter($this$createCoverageInstrumentedJar, "<this>");
        Path instrumentedClassesDirectory = Paths.get($this$createCoverageInstrumentedJar.getDirectories().getCoverageMetadataClasses(), new String[0]);
        Files.createDirectories(instrumentedClassesDirectory, new FileAttribute[0]);
        Instrumenter instr = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
        Intrinsics.checkNotNullExpressionValue(instrumentedClassesDirectory, "instrumentedClassesDirectory");
        Path path = Paths.get($this$createCoverageInstrumentedJar.getDirectories().getClasses(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(directories.classes)");
        JacocoInstrumentationKt.instrumentRecursively(instr, instrumentedClassesDirectory, path);
        Path path2 = Paths.get($this$createCoverageInstrumentedJar.getDirectories().getJavaClasses(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(directories.javaClasses)");
        JacocoInstrumentationKt.instrumentRecursively(instr, instrumentedClassesDirectory, path2);
        Path path3 = Paths.get($this$createCoverageInstrumentedJar.getDirectories().getGeneratedClasses(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path3, "get(directories.generatedClasses)");
        JacocoInstrumentationKt.instrumentRecursively(instr, instrumentedClassesDirectory, path3);
        Path pathsForCoverage = instrumentedClassesDirectory.resolve(Paths.get($this$createCoverageInstrumentedJar.getOutputs().getJar(), new String[0]).getFileName() + "-paths-for-coverage.txt");
        ProtocolStringList protocolStringList = $this$createCoverageInstrumentedJar.getInputs().getJavaSourcesList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList, "inputs.javaSourcesList");
        Collection collection = protocolStringList;
        ProtocolStringList protocolStringList2 = $this$createCoverageInstrumentedJar.getInputs().getKotlinSourcesList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList2, "inputs.kotlinSourcesList");
        Files.write(pathsForCoverage, (Iterable<? extends CharSequence>)CollectionsKt.plus(collection, (Iterable)protocolStringList2), new OpenOption[0]);
        Path path4 = Paths.get($this$createCoverageInstrumentedJar.getOutputs().getJar(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path4, "get(outputs.jar)");
        JarCreator it = jarCreator = new JarCreator(path4, true, false);
        boolean bl = false;
        Path path5 = Paths.get($this$createCoverageInstrumentedJar.getDirectories().getClasses(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path5, "get(directories.classes)");
        it.addDirectory(path5);
        Path path6 = Paths.get($this$createCoverageInstrumentedJar.getDirectories().getJavaClasses(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path6, "get(directories.javaClasses)");
        it.addDirectory(path6);
        Path path7 = Paths.get($this$createCoverageInstrumentedJar.getDirectories().getGeneratedClasses(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path7, "get(directories.generatedClasses)");
        it.addDirectory(path7);
        it.addDirectory(instrumentedClassesDirectory);
        String string = $this$createCoverageInstrumentedJar.getInfo().getLabel();
        Intrinsics.checkNotNullExpressionValue(string, "info.label");
        CompilationTaskInfo compilationTaskInfo = $this$createCoverageInstrumentedJar.getInfo();
        Intrinsics.checkNotNullExpressionValue(compilationTaskInfo, "info");
        it.setJarOwner(string, TaskUtilsKt.getBazelRuleKind(compilationTaskInfo));
        it.execute();
    }

    private static final void instrumentRecursively(Instrumenter instr, Path metadataDir, Path root) {
        SimpleFileVisitor<Path> visitor2 = new SimpleFileVisitor<Path>(metadataDir, root, instr){
            final /* synthetic */ Path $metadataDir;
            final /* synthetic */ Path $root;
            final /* synthetic */ Instrumenter $instr;
            {
                this.$metadataDir = $metadataDir;
                this.$root = $root;
                this.$instr = $instr;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter(file, "file");
                Intrinsics.checkNotNullParameter(attrs, "attrs");
                File file2 = file.toFile();
                Intrinsics.checkNotNullExpressionValue(file2, "file.toFile()");
                if (!Intrinsics.areEqual(FilesKt.getExtension(file2), "class")) {
                    return FileVisitResult.CONTINUE;
                }
                Path absoluteUninstrumentedCopy = Paths.get(file + ".uninstrumented", new String[0]);
                Path uninstrumentedCopy = this.$metadataDir.resolve(this.$root.relativize(absoluteUninstrumentedCopy));
                Files.createDirectories(uninstrumentedCopy.getParent(), new FileAttribute[0]);
                Files.move(file, uninstrumentedCopy, new CopyOption[0]);
                InputStream inputStream = Files.newInputStream(uninstrumentedCopy, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(uninstrumentedCopy)");
                Closeable closeable = inputStream;
                int n = 8192;
                closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                Instrumenter instrumenter = this.$instr;
                Throwable throwable = null;
                try {
                    BufferedInputStream input = (BufferedInputStream)closeable;
                    boolean bl = false;
                    OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
                    Intrinsics.checkNotNullExpressionValue(outputStream, "newOutputStream(file)");
                    Closeable closeable2 = outputStream;
                    int n2 = 8192;
                    closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2);
                    Throwable throwable2 = null;
                    try {
                        BufferedOutputStream output = (BufferedOutputStream)closeable2;
                        boolean bl2 = false;
                        instrumenter.instrument((InputStream)input, (OutputStream)output, ((Object)file).toString());
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable2, throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(root, (FileVisitor<? super Path>)visitor2);
    }
}

