// Autogenerated by Thrift for thrift/compiler/test/fixtures/basic-annotations/src/module.thrift
//
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
//  @generated

package module


import (
    "context"
    "fmt"
    "reflect"

    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift/types"
    metadata "github.com/facebook/fbthrift/thrift/lib/thrift/metadata"
)

// (needed to ensure safety because of naive import list construction)
var _ = context.Background
var _ = fmt.Printf
var _ = reflect.Ptr
var _ = thrift.ZERO
var _ = metadata.GoUnusedProtection__

type MyService interface {
    Ping(ctx context.Context) (error)
    GetRandomData(ctx context.Context) (string, error)
    HasDataById(ctx context.Context, id int64) (bool, error)
    GoGetDataById(ctx context.Context, id int64) (string, error)
    PutDataById(ctx context.Context, id int64, data string) (error)
    LobDataById(ctx context.Context, id int64, data string) (error)
    GoDoNothing(ctx context.Context) (error)
}

type MyServiceChannelClientInterface interface {
    thrift.ClientInterface
    MyService
}

type MyServiceClientInterface interface {
    thrift.ClientInterface
    Ping() (error)
    GetRandomData() (string, error)
    HasDataById(id int64) (bool, error)
    GoGetDataById(id int64) (string, error)
    PutDataById(id int64, data string) (error)
    LobDataById(id int64, data string) (error)
    GoDoNothing() (error)
}

type MyServiceContextClientInterface interface {
    MyServiceClientInterface
    PingContext(ctx context.Context) (error)
    GetRandomDataContext(ctx context.Context) (string, error)
    HasDataByIdContext(ctx context.Context, id int64) (bool, error)
    GoGetDataByIdContext(ctx context.Context, id int64) (string, error)
    PutDataByIdContext(ctx context.Context, id int64, data string) (error)
    LobDataByIdContext(ctx context.Context, id int64, data string) (error)
    GoDoNothingContext(ctx context.Context) (error)
}

type MyServiceChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServiceChannelClientInterface = (*MyServiceChannelClient)(nil)

func NewMyServiceChannelClient(channel thrift.RequestChannel) *MyServiceChannelClient {
    return &MyServiceChannelClient{
        ch: channel,
    }
}

func (c *MyServiceChannelClient) Close() error {
    return c.ch.Close()
}

type MyServiceClient struct {
    chClient *MyServiceChannelClient
}
// Compile time interface enforcer
var _ MyServiceClientInterface = (*MyServiceClient)(nil)
var _ MyServiceContextClientInterface = (*MyServiceClient)(nil)

func NewMyServiceClient(prot thrift.Protocol) *MyServiceClient {
    return &MyServiceClient{
        chClient: NewMyServiceChannelClient(
            thrift.NewSerialChannel(prot),
        ),
    }
}

func (c *MyServiceClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServiceChannelClient) Ping(ctx context.Context) (error) {
    in := &reqMyServicePing{
    }
    out := newRespMyServicePing()
    err := c.ch.Call(ctx, "ping", in, out)
    if err != nil {
        return err
    } else if out.MyExcept != nil {
        return out.MyExcept
    }
    return nil
}

func (c *MyServiceClient) Ping() (error) {
    return c.chClient.Ping(context.Background())
}

func (c *MyServiceClient) PingContext(ctx context.Context) (error) {
    return c.chClient.Ping(ctx)
}

func (c *MyServiceChannelClient) GetRandomData(ctx context.Context) (string, error) {
    in := &reqMyServiceGetRandomData{
    }
    out := newRespMyServiceGetRandomData()
    err := c.ch.Call(ctx, "getRandomData", in, out)
    if err != nil {
        return "", err
    }
    return out.GetSuccess(), nil
}

func (c *MyServiceClient) GetRandomData() (string, error) {
    return c.chClient.GetRandomData(context.Background())
}

func (c *MyServiceClient) GetRandomDataContext(ctx context.Context) (string, error) {
    return c.chClient.GetRandomData(ctx)
}

func (c *MyServiceChannelClient) HasDataById(ctx context.Context, id int64) (bool, error) {
    in := &reqMyServiceHasDataById{
        Id: id,
    }
    out := newRespMyServiceHasDataById()
    err := c.ch.Call(ctx, "hasDataById", in, out)
    if err != nil {
        return false, err
    }
    return out.GetSuccess(), nil
}

func (c *MyServiceClient) HasDataById(id int64) (bool, error) {
    return c.chClient.HasDataById(context.Background(), id)
}

func (c *MyServiceClient) HasDataByIdContext(ctx context.Context, id int64) (bool, error) {
    return c.chClient.HasDataById(ctx, id)
}

func (c *MyServiceChannelClient) GoGetDataById(ctx context.Context, id int64) (string, error) {
    in := &reqMyServiceGoGetDataById{
        Id: id,
    }
    out := newRespMyServiceGoGetDataById()
    err := c.ch.Call(ctx, "getDataById", in, out)
    if err != nil {
        return "", err
    }
    return out.GetSuccess(), nil
}

func (c *MyServiceClient) GoGetDataById(id int64) (string, error) {
    return c.chClient.GoGetDataById(context.Background(), id)
}

func (c *MyServiceClient) GoGetDataByIdContext(ctx context.Context, id int64) (string, error) {
    return c.chClient.GoGetDataById(ctx, id)
}

func (c *MyServiceChannelClient) PutDataById(ctx context.Context, id int64, data string) (error) {
    in := &reqMyServicePutDataById{
        Id: id,
        Data: data,
    }
    out := newRespMyServicePutDataById()
    err := c.ch.Call(ctx, "putDataById", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServiceClient) PutDataById(id int64, data string) (error) {
    return c.chClient.PutDataById(context.Background(), id, data)
}

func (c *MyServiceClient) PutDataByIdContext(ctx context.Context, id int64, data string) (error) {
    return c.chClient.PutDataById(ctx, id, data)
}

func (c *MyServiceChannelClient) LobDataById(ctx context.Context, id int64, data string) (error) {
    in := &reqMyServiceLobDataById{
        Id: id,
        Data: data,
    }
    return c.ch.Oneway(ctx, "lobDataById", in)
}

func (c *MyServiceClient) LobDataById(id int64, data string) (error) {
    return c.chClient.LobDataById(context.Background(), id, data)
}

func (c *MyServiceClient) LobDataByIdContext(ctx context.Context, id int64, data string) (error) {
    return c.chClient.LobDataById(ctx, id, data)
}

func (c *MyServiceChannelClient) GoDoNothing(ctx context.Context) (error) {
    in := &reqMyServiceGoDoNothing{
    }
    out := newRespMyServiceGoDoNothing()
    err := c.ch.Call(ctx, "doNothing", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServiceClient) GoDoNothing() (error) {
    return c.chClient.GoDoNothing(context.Background())
}

func (c *MyServiceClient) GoDoNothingContext(ctx context.Context) (error) {
    return c.chClient.GoDoNothing(ctx)
}


type MyServiceProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler            MyService
}

func NewMyServiceProcessor(handler MyService) *MyServiceProcessor {
    p := &MyServiceProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("ping", &procFuncMyServicePing{handler: handler})
    p.AddToProcessorFunctionMap("getRandomData", &procFuncMyServiceGetRandomData{handler: handler})
    p.AddToProcessorFunctionMap("hasDataById", &procFuncMyServiceHasDataById{handler: handler})
    p.AddToProcessorFunctionMap("getDataById", &procFuncMyServiceGoGetDataById{handler: handler})
    p.AddToProcessorFunctionMap("putDataById", &procFuncMyServicePutDataById{handler: handler})
    p.AddToProcessorFunctionMap("lobDataById", &procFuncMyServiceLobDataById{handler: handler})
    p.AddToProcessorFunctionMap("doNothing", &procFuncMyServiceGoDoNothing{handler: handler})
    p.AddToFunctionServiceMap("ping", "MyService")
    p.AddToFunctionServiceMap("getRandomData", "MyService")
    p.AddToFunctionServiceMap("hasDataById", "MyService")
    p.AddToFunctionServiceMap("getDataById", "MyService")
    p.AddToFunctionServiceMap("putDataById", "MyService")
    p.AddToFunctionServiceMap("lobDataById", "MyService")
    p.AddToFunctionServiceMap("doNothing", "MyService")

    return p
}

func (p *MyServiceProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *MyServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyServiceProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *MyServiceProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *MyServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *MyServiceProcessor) PackageName() string {
    return "module"
}

func (p *MyServiceProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyService")
}


type procFuncMyServicePing struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServicePing)(nil)

func (p *procFuncMyServicePing) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch v := result.(type) {
    case *MyException:
        result = &respMyServicePing{
            MyExcept: v,
        }
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("ping", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePing) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePing()
    err := p.handler.Ping(ctx)
    if err != nil {
        switch v := err.(type) {
        case *MyException:
            result.MyExcept = v
            return result, nil
        default:
            x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Ping: " + err.Error(), err)
            return x, x
        }
    }

    return result, nil
}


type procFuncMyServiceGetRandomData struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceGetRandomData)(nil)

func (p *procFuncMyServiceGetRandomData) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGetRandomData()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGetRandomData) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getRandomData", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGetRandomData) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServiceGetRandomData()
    retval, err := p.handler.GetRandomData(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetRandomData: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncMyServiceHasDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceHasDataById)(nil)

func (p *procFuncMyServiceHasDataById) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceHasDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceHasDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("hasDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceHasDataById) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceHasDataById)
    result := newRespMyServiceHasDataById()
    retval, err := p.handler.HasDataById(ctx, args.Id)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing HasDataById: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncMyServiceGoGetDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceGoGetDataById)(nil)

func (p *procFuncMyServiceGoGetDataById) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGoGetDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGoGetDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGoGetDataById) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceGoGetDataById)
    result := newRespMyServiceGoGetDataById()
    retval, err := p.handler.GoGetDataById(ctx, args.Id)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GoGetDataById: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncMyServicePutDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServicePutDataById)(nil)

func (p *procFuncMyServicePutDataById) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePutDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePutDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("putDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePutDataById) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServicePutDataById)
    result := newRespMyServicePutDataById()
    err := p.handler.PutDataById(ctx, args.Id, args.Data)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing PutDataById: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type procFuncMyServiceLobDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceLobDataById)(nil)

func (p *procFuncMyServiceLobDataById) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceLobDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceLobDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("lobDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceLobDataById) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceLobDataById)
    err := p.handler.LobDataById(ctx, args.Id, args.Data)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing LobDataById: " + err.Error(), err)
        return x, x
    }

    return nil, nil
}


type procFuncMyServiceGoDoNothing struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServiceGoDoNothing)(nil)

func (p *procFuncMyServiceGoDoNothing) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGoDoNothing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGoDoNothing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("doNothing", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGoDoNothing) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServiceGoDoNothing()
    err := p.handler.GoDoNothing(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GoDoNothing: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type MyServicePrioParent interface {
    Ping(ctx context.Context) (error)
    Pong(ctx context.Context) (error)
}

type MyServicePrioParentChannelClientInterface interface {
    thrift.ClientInterface
    MyServicePrioParent
}

type MyServicePrioParentClientInterface interface {
    thrift.ClientInterface
    Ping() (error)
    Pong() (error)
}

type MyServicePrioParentContextClientInterface interface {
    MyServicePrioParentClientInterface
    PingContext(ctx context.Context) (error)
    PongContext(ctx context.Context) (error)
}

type MyServicePrioParentChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServicePrioParentChannelClientInterface = (*MyServicePrioParentChannelClient)(nil)

func NewMyServicePrioParentChannelClient(channel thrift.RequestChannel) *MyServicePrioParentChannelClient {
    return &MyServicePrioParentChannelClient{
        ch: channel,
    }
}

func (c *MyServicePrioParentChannelClient) Close() error {
    return c.ch.Close()
}

type MyServicePrioParentClient struct {
    chClient *MyServicePrioParentChannelClient
}
// Compile time interface enforcer
var _ MyServicePrioParentClientInterface = (*MyServicePrioParentClient)(nil)
var _ MyServicePrioParentContextClientInterface = (*MyServicePrioParentClient)(nil)

func NewMyServicePrioParentClient(prot thrift.Protocol) *MyServicePrioParentClient {
    return &MyServicePrioParentClient{
        chClient: NewMyServicePrioParentChannelClient(
            thrift.NewSerialChannel(prot),
        ),
    }
}

func (c *MyServicePrioParentClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServicePrioParentChannelClient) Ping(ctx context.Context) (error) {
    in := &reqMyServicePrioParentPing{
    }
    out := newRespMyServicePrioParentPing()
    err := c.ch.Call(ctx, "ping", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServicePrioParentClient) Ping() (error) {
    return c.chClient.Ping(context.Background())
}

func (c *MyServicePrioParentClient) PingContext(ctx context.Context) (error) {
    return c.chClient.Ping(ctx)
}

func (c *MyServicePrioParentChannelClient) Pong(ctx context.Context) (error) {
    in := &reqMyServicePrioParentPong{
    }
    out := newRespMyServicePrioParentPong()
    err := c.ch.Call(ctx, "pong", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServicePrioParentClient) Pong() (error) {
    return c.chClient.Pong(context.Background())
}

func (c *MyServicePrioParentClient) PongContext(ctx context.Context) (error) {
    return c.chClient.Pong(ctx)
}


type MyServicePrioParentProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler            MyServicePrioParent
}

func NewMyServicePrioParentProcessor(handler MyServicePrioParent) *MyServicePrioParentProcessor {
    p := &MyServicePrioParentProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("ping", &procFuncMyServicePrioParentPing{handler: handler})
    p.AddToProcessorFunctionMap("pong", &procFuncMyServicePrioParentPong{handler: handler})
    p.AddToFunctionServiceMap("ping", "MyServicePrioParent")
    p.AddToFunctionServiceMap("pong", "MyServicePrioParent")

    return p
}

func (p *MyServicePrioParentProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *MyServicePrioParentProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyServicePrioParentProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *MyServicePrioParentProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *MyServicePrioParentProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *MyServicePrioParentProcessor) PackageName() string {
    return "module"
}

func (p *MyServicePrioParentProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyServicePrioParent")
}


type procFuncMyServicePrioParentPing struct {
    handler MyServicePrioParent
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServicePrioParentPing)(nil)

func (p *procFuncMyServicePrioParentPing) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioParentPing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioParentPing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("ping", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioParentPing) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioParentPing()
    err := p.handler.Ping(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Ping: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type procFuncMyServicePrioParentPong struct {
    handler MyServicePrioParent
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServicePrioParentPong)(nil)

func (p *procFuncMyServicePrioParentPong) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioParentPong()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioParentPong) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("pong", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioParentPong) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioParentPong()
    err := p.handler.Pong(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Pong: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type MyServicePrioChild interface {
    // Inherited/extended service
    MyServicePrioParent

    Pang(ctx context.Context) (error)
}

type MyServicePrioChildChannelClientInterface interface {
    thrift.ClientInterface
    MyServicePrioChild
}

type MyServicePrioChildClientInterface interface {
    thrift.ClientInterface
    Pang() (error)
}

type MyServicePrioChildContextClientInterface interface {
    MyServicePrioChildClientInterface
    // Inherited/extended service
    MyServicePrioParentContextClientInterface

    PangContext(ctx context.Context) (error)
}

type MyServicePrioChildChannelClient struct {
    // Inherited/extended service
    *MyServicePrioParentChannelClient
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServicePrioChildChannelClientInterface = (*MyServicePrioChildChannelClient)(nil)

func NewMyServicePrioChildChannelClient(channel thrift.RequestChannel) *MyServicePrioChildChannelClient {
    return &MyServicePrioChildChannelClient{
        MyServicePrioParentChannelClient: NewMyServicePrioParentChannelClient(channel),
        ch: channel,
    }
}

func (c *MyServicePrioChildChannelClient) Close() error {
    return c.ch.Close()
}

type MyServicePrioChildClient struct {
    // Inherited/extended service
    *MyServicePrioParentClient
    chClient *MyServicePrioChildChannelClient
}
// Compile time interface enforcer
var _ MyServicePrioChildClientInterface = (*MyServicePrioChildClient)(nil)
var _ MyServicePrioChildContextClientInterface = (*MyServicePrioChildClient)(nil)

func NewMyServicePrioChildClient(prot thrift.Protocol) *MyServicePrioChildClient {
    return &MyServicePrioChildClient{
        MyServicePrioParentClient: NewMyServicePrioParentClient(prot),
        chClient: NewMyServicePrioChildChannelClient(
            thrift.NewSerialChannel(prot),
        ),
    }
}

func (c *MyServicePrioChildClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServicePrioChildChannelClient) Pang(ctx context.Context) (error) {
    in := &reqMyServicePrioChildPang{
    }
    out := newRespMyServicePrioChildPang()
    err := c.ch.Call(ctx, "pang", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServicePrioChildClient) Pang() (error) {
    return c.chClient.Pang(context.Background())
}

func (c *MyServicePrioChildClient) PangContext(ctx context.Context) (error) {
    return c.chClient.Pang(ctx)
}


type MyServicePrioChildProcessor struct {
    // Inherited/extended processor
    *MyServicePrioParentProcessor
}

func NewMyServicePrioChildProcessor(handler MyServicePrioChild) *MyServicePrioChildProcessor {
    p := &MyServicePrioChildProcessor{
        NewMyServicePrioParentProcessor(handler),
    }
    p.AddToProcessorFunctionMap("pang", &procFuncMyServicePrioChildPang{handler: handler})
    p.AddToFunctionServiceMap("pang", "MyServicePrioChild")

    return p
}

func (p *MyServicePrioChildProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyServicePrioChild")
}


type procFuncMyServicePrioChildPang struct {
    handler MyServicePrioChild
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncMyServicePrioChildPang)(nil)

func (p *procFuncMyServicePrioChildPang) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioChildPang()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioChildPang) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("pang", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioChildPang) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioChildPang()
    err := p.handler.Pang(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Pang: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type BadService interface {
    Bar(ctx context.Context) (int32, error)
}

type BadServiceChannelClientInterface interface {
    thrift.ClientInterface
    BadService
}

type BadServiceClientInterface interface {
    thrift.ClientInterface
    Bar() (int32, error)
}

type BadServiceContextClientInterface interface {
    BadServiceClientInterface
    BarContext(ctx context.Context) (int32, error)
}

type BadServiceChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ BadServiceChannelClientInterface = (*BadServiceChannelClient)(nil)

func NewBadServiceChannelClient(channel thrift.RequestChannel) *BadServiceChannelClient {
    return &BadServiceChannelClient{
        ch: channel,
    }
}

func (c *BadServiceChannelClient) Close() error {
    return c.ch.Close()
}

type BadServiceClient struct {
    chClient *BadServiceChannelClient
}
// Compile time interface enforcer
var _ BadServiceClientInterface = (*BadServiceClient)(nil)
var _ BadServiceContextClientInterface = (*BadServiceClient)(nil)

func NewBadServiceClient(prot thrift.Protocol) *BadServiceClient {
    return &BadServiceClient{
        chClient: NewBadServiceChannelClient(
            thrift.NewSerialChannel(prot),
        ),
    }
}

func (c *BadServiceClient) Close() error {
    return c.chClient.Close()
}

func (c *BadServiceChannelClient) Bar(ctx context.Context) (int32, error) {
    in := &reqBadServiceBar{
    }
    out := newRespBadServiceBar()
    err := c.ch.Call(ctx, "bar", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *BadServiceClient) Bar() (int32, error) {
    return c.chClient.Bar(context.Background())
}

func (c *BadServiceClient) BarContext(ctx context.Context) (int32, error) {
    return c.chClient.Bar(ctx)
}


type BadServiceProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler            BadService
}

func NewBadServiceProcessor(handler BadService) *BadServiceProcessor {
    p := &BadServiceProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("bar", &procFuncBadServiceBar{handler: handler})
    p.AddToFunctionServiceMap("bar", "BadService")

    return p
}

func (p *BadServiceProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *BadServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *BadServiceProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *BadServiceProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *BadServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *BadServiceProcessor) PackageName() string {
    return "module"
}

func (p *BadServiceProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.BadService")
}


type procFuncBadServiceBar struct {
    handler BadService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncBadServiceBar)(nil)

func (p *procFuncBadServiceBar) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqBadServiceBar()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncBadServiceBar) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("bar", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncBadServiceBar) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespBadServiceBar()
    retval, err := p.handler.Bar(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Bar: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type FooBarBazService interface {
    FooStructured(ctx context.Context) (error)
    BarNonStructured(ctx context.Context) (error)
    Baz(ctx context.Context) (error)
}

type FooBarBazServiceChannelClientInterface interface {
    thrift.ClientInterface
    FooBarBazService
}

type FooBarBazServiceClientInterface interface {
    thrift.ClientInterface
    FooStructured() (error)
    BarNonStructured() (error)
    Baz() (error)
}

type FooBarBazServiceContextClientInterface interface {
    FooBarBazServiceClientInterface
    FooStructuredContext(ctx context.Context) (error)
    BarNonStructuredContext(ctx context.Context) (error)
    BazContext(ctx context.Context) (error)
}

type FooBarBazServiceChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ FooBarBazServiceChannelClientInterface = (*FooBarBazServiceChannelClient)(nil)

func NewFooBarBazServiceChannelClient(channel thrift.RequestChannel) *FooBarBazServiceChannelClient {
    return &FooBarBazServiceChannelClient{
        ch: channel,
    }
}

func (c *FooBarBazServiceChannelClient) Close() error {
    return c.ch.Close()
}

type FooBarBazServiceClient struct {
    chClient *FooBarBazServiceChannelClient
}
// Compile time interface enforcer
var _ FooBarBazServiceClientInterface = (*FooBarBazServiceClient)(nil)
var _ FooBarBazServiceContextClientInterface = (*FooBarBazServiceClient)(nil)

func NewFooBarBazServiceClient(prot thrift.Protocol) *FooBarBazServiceClient {
    return &FooBarBazServiceClient{
        chClient: NewFooBarBazServiceChannelClient(
            thrift.NewSerialChannel(prot),
        ),
    }
}

func (c *FooBarBazServiceClient) Close() error {
    return c.chClient.Close()
}

func (c *FooBarBazServiceChannelClient) FooStructured(ctx context.Context) (error) {
    in := &reqFooBarBazServiceFooStructured{
    }
    out := newRespFooBarBazServiceFooStructured()
    err := c.ch.Call(ctx, "foo", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *FooBarBazServiceClient) FooStructured() (error) {
    return c.chClient.FooStructured(context.Background())
}

func (c *FooBarBazServiceClient) FooStructuredContext(ctx context.Context) (error) {
    return c.chClient.FooStructured(ctx)
}

func (c *FooBarBazServiceChannelClient) BarNonStructured(ctx context.Context) (error) {
    in := &reqFooBarBazServiceBarNonStructured{
    }
    out := newRespFooBarBazServiceBarNonStructured()
    err := c.ch.Call(ctx, "bar", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *FooBarBazServiceClient) BarNonStructured() (error) {
    return c.chClient.BarNonStructured(context.Background())
}

func (c *FooBarBazServiceClient) BarNonStructuredContext(ctx context.Context) (error) {
    return c.chClient.BarNonStructured(ctx)
}

func (c *FooBarBazServiceChannelClient) Baz(ctx context.Context) (error) {
    in := &reqFooBarBazServiceBaz{
    }
    out := newRespFooBarBazServiceBaz()
    err := c.ch.Call(ctx, "baz", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *FooBarBazServiceClient) Baz() (error) {
    return c.chClient.Baz(context.Background())
}

func (c *FooBarBazServiceClient) BazContext(ctx context.Context) (error) {
    return c.chClient.Baz(ctx)
}


type FooBarBazServiceProcessor struct {
    processorFunctionMap map[string]thrift.ProcessorFunction
    functionServiceMap   map[string]string
    handler            FooBarBazService
}

func NewFooBarBazServiceProcessor(handler FooBarBazService) *FooBarBazServiceProcessor {
    p := &FooBarBazServiceProcessor{
        handler:              handler,
        processorFunctionMap: make(map[string]thrift.ProcessorFunction),
        functionServiceMap:   make(map[string]string),
    }
    p.AddToProcessorFunctionMap("foo", &procFuncFooBarBazServiceFooStructured{handler: handler})
    p.AddToProcessorFunctionMap("bar", &procFuncFooBarBazServiceBarNonStructured{handler: handler})
    p.AddToProcessorFunctionMap("baz", &procFuncFooBarBazServiceBaz{handler: handler})
    p.AddToFunctionServiceMap("foo", "FooBarBazService")
    p.AddToFunctionServiceMap("bar", "FooBarBazService")
    p.AddToFunctionServiceMap("baz", "FooBarBazService")

    return p
}

func (p *FooBarBazServiceProcessor) AddToProcessorFunctionMap(key string, processorFunction thrift.ProcessorFunction) {
    p.processorFunctionMap[key] = processorFunction
}

func (p *FooBarBazServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *FooBarBazServiceProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction) {
    return p.processorFunctionMap[key]
}

func (p *FooBarBazServiceProcessor) ProcessorFunctionMap() map[string]thrift.ProcessorFunction {
    return p.processorFunctionMap
}

func (p *FooBarBazServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *FooBarBazServiceProcessor) PackageName() string {
    return "module"
}

func (p *FooBarBazServiceProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.FooBarBazService")
}


type procFuncFooBarBazServiceFooStructured struct {
    handler FooBarBazService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncFooBarBazServiceFooStructured)(nil)

func (p *procFuncFooBarBazServiceFooStructured) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqFooBarBazServiceFooStructured()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncFooBarBazServiceFooStructured) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("foo", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncFooBarBazServiceFooStructured) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespFooBarBazServiceFooStructured()
    err := p.handler.FooStructured(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing FooStructured: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type procFuncFooBarBazServiceBarNonStructured struct {
    handler FooBarBazService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncFooBarBazServiceBarNonStructured)(nil)

func (p *procFuncFooBarBazServiceBarNonStructured) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqFooBarBazServiceBarNonStructured()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncFooBarBazServiceBarNonStructured) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("bar", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncFooBarBazServiceBarNonStructured) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespFooBarBazServiceBarNonStructured()
    err := p.handler.BarNonStructured(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing BarNonStructured: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type procFuncFooBarBazServiceBaz struct {
    handler FooBarBazService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = (*procFuncFooBarBazServiceBaz)(nil)

func (p *procFuncFooBarBazServiceBaz) Read(iprot thrift.Decoder) (thrift.Struct, thrift.Exception) {
    args := newReqFooBarBazServiceBaz()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncFooBarBazServiceBaz) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Encoder) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("baz", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncFooBarBazServiceBaz) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespFooBarBazServiceBaz()
    err := p.handler.Baz(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Baz: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


