/* Copyright © Charliecloud contributors.

   String-handling functions of various kinds. */

#define _GNU_SOURCE
#pragma once

#include <stdarg.h>

#include "misc.h"


/** Disallowed library functions **/

#define asprintf FN_BLOCKED
#define strdup FN_BLOCKED
#define strcmp FN_BLOCKED
#define vasprintf FN_BLOCKED


/** Function prototypes **/

char *argv_to_string(char **argv);
char *asprintf_ch(const char *fmt, ...);
const char *bool_to_string(bool b);
int buf_strings_count(char *str, size_t s);
char *cat(const char *a, const char *b);
char *cats(size_t argc, ...);
char *errno_nerd_str(int errno_);
char *replace_char(const char *str, char old, char new);
void split(char **a, char **b, const char *str, char del);
char *strdup_ch(const char *src);
bool streq(const char *a, const char *b);
size_t string_append(char *addr, char *str, size_t size, size_t offset);
char *vasprintf_ch(const char *fmt, va_list ap);

