/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.karaf.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.kar.KarService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.addon.AddonEvent;
import org.openhab.core.addon.AddonEventFactory;
import org.openhab.core.addon.AddonType;
import org.openhab.core.common.NamedThreadFactory;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.openhab.addons", service={FeatureInstaller.class, ConfigurationListener.class})
@ConfigurableService(category="system", label="Add-on Management", description_uri="system:addons")
@NonNullByDefault
public class FeatureInstaller
implements ConfigurationListener {
    protected static final String CONFIG_URI = "system:addons";
    public static final String PREFIX = "openhab-";
    private static final String CFG_REMOTE = "remote";
    private static final String PAX_URL_PID = "org.ops4j.pax.url.mvn";
    private static final String ADDONS_PID = "org.openhab.addons";
    private static final String PROPERTY_MVN_REPOS = "org.ops4j.pax.url.mvn.repositories";
    public static final String FINDER_ADDON_TYPE = "core-config-discovery-addon";
    public static final List<String> ADDON_TYPES = Stream.concat(AddonType.DEFAULT_TYPES.stream().map(AddonType::getId), Stream.of("core-config-discovery-addon")).toList();
    private final Logger logger = LoggerFactory.getLogger(FeatureInstaller.class);
    private final ConfigurationAdmin configurationAdmin;
    private final FeaturesService featuresService;
    private final KarService karService;
    private final EventPublisher eventPublisher;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean processingConfigQueue = new AtomicBoolean();
    private final LinkedBlockingQueue<Map<String, Object>> configQueue = new LinkedBlockingQueue();
    private @Nullable String onlineRepoUrl = null;
    private boolean paxCfgUpdated = true;
    private @Nullable Map<String, Object> configMapCache;

    @Activate
    public FeatureInstaller(@Reference ConfigurationAdmin configurationAdmin, @Reference FeaturesService featuresService, @Reference KarService karService, @Reference EventPublisher eventPublisher, Map<String, Object> config) {
        this.configurationAdmin = configurationAdmin;
        this.featuresService = featuresService;
        this.karService = karService;
        this.eventPublisher = eventPublisher;
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("karaf-addons"));
        this.setOnlineRepoUrl();
        this.modified(config);
        this.scheduler.scheduleWithFixedDelay(this::syncConfiguration, 1L, 1L, TimeUnit.MINUTES);
    }

    @Deactivate
    protected void deactivate() {
        this.scheduler.shutdown();
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.configQueue.add(config);
        if (this.processingConfigQueue.compareAndSet(false, true)) {
            this.scheduler.execute(this::processConfigQueue);
        }
    }

    private void syncConfiguration() {
        this.logger.debug("Running scheduled sync job");
        try {
            Dictionary cfg = this.configurationAdmin.getConfiguration(ADDONS_PID).getProperties();
            if (cfg == null) {
                this.logger.debug("Configuration has no properties yet. Skipping update.");
                return;
            }
            HashMap<String, Object> cfgMap = new HashMap<String, Object>();
            Enumeration enumeration = cfg.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                cfgMap.put(key, cfg.get(key));
            }
            if (!cfgMap.equals(this.configMapCache) && !this.processingConfigQueue.get()) {
                this.modified(cfgMap);
            }
        }
        catch (IOException e) {
            this.logger.debug("Failed to retrieve the addons configuration from configuration admin: {}", (Object)e.getMessage());
        }
    }

    private synchronized void processConfigQueue() {
        Map<String, Object> config;
        if (!this.allKarsInstalled()) {
            this.logger.info("Some .kar files are not installed yet. Delaying add-on installation by 15s.");
            this.scheduler.schedule(this::processConfigQueue, 15L, TimeUnit.SECONDS);
            return;
        }
        boolean changed = false;
        while ((config = this.configQueue.poll()) != null) {
            boolean repoConfigurationChanged;
            this.configMapCache = config;
            boolean onlineMode = (Boolean)ConfigParser.valueAsOrElse((Object)config.get(CFG_REMOTE), Boolean.class, (Object)this.getOnlineRepositoryMode());
            boolean bl = repoConfigurationChanged = this.getOnlineRepositoryMode() != onlineMode && this.setOnlineRepositoryMode(onlineMode);
            if (repoConfigurationChanged) {
                this.waitForConfigUpdateEvent();
            }
            if (!this.installAddons(config)) continue;
            changed = true;
        }
        try {
            if (changed) {
                this.featuresService.refreshFeatures(EnumSet.noneOf(FeaturesService.Option.class));
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to refresh bundles after processing config update", (Throwable)e);
        }
        this.processingConfigQueue.set(false);
    }

    public void addAddon(String type, String id) {
        try {
            this.changeAddonConfig(type, id, Collection::add);
        }
        catch (IOException e) {
            this.logger.warn("Adding add-on 'openhab-{}-{}' failed: {}", new Object[]{type, id, e.getMessage(), this.debugException(e)});
        }
    }

    public void removeAddon(String type, String id) {
        try {
            this.changeAddonConfig(type, id, Collection::remove);
        }
        catch (IOException e) {
            this.logger.warn("Removing add-on 'openhab-{}-{}' failed: {}", new Object[]{type, id, e.getMessage(), this.debugException(e)});
        }
    }

    public void configurationEvent(@Nullable ConfigurationEvent event) {
        if (event != null && PAX_URL_PID.equals(event.getPid()) && event.getType() == 1) {
            this.paxCfgUpdated = true;
        }
    }

    private @Nullable Exception debugException(Exception e) {
        return this.logger.isDebugEnabled() ? e : null;
    }

    private boolean allKarsInstalled() {
        try {
            Dictionary felixProperties;
            String addonsDirectory;
            List karRepos = this.karService.list();
            Configuration[] configurations = this.configurationAdmin.listConfigurations("(service.factoryPid=org.apache.felix.fileinstall)");
            if (configurations.length > 0 && (addonsDirectory = (String)(felixProperties = configurations[0].getProperties()).get("felix.fileinstall.dir")) != null) {
                Throwable throwable = null;
                Object var6_8 = null;
                try (Stream<Path> files = Files.list(Path.of(addonsDirectory, new String[0]));){
                    return files.map(Path::getFileName).map(Path::toString).filter(file -> file.endsWith(".kar")).map(karFileName -> karFileName.substring(0, karFileName.lastIndexOf("."))).allMatch(karRepos::contains);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.warn("Could not determine addons folder, its content or the list of installed repositories!");
        return false;
    }

    private void waitForConfigUpdateEvent() {
        int counter = 0;
        while (!this.paxCfgUpdated && counter++ < 50) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.logger.warn("Waited for 5s to receive config update, but configuration was not updated. Proceeding anyway.");
    }

    private void changeAddonConfig(String type, String id, BiFunction<Collection<String>, String, Boolean> method) throws IOException {
        Configuration cfg = this.configurationAdmin.getConfiguration(ADDONS_PID, null);
        Dictionary props = Objects.requireNonNullElse(cfg.getProperties(), new Hashtable());
        Object typeProp = props.get(type);
        String[] addonIds = typeProp != null ? typeProp.toString().split(",") : new String[]{};
        HashSet normalizedIds = new HashSet();
        Arrays.stream(addonIds).map(String::strip).forEach(normalizedIds::add);
        if (method.apply(normalizedIds, id).booleanValue()) {
            props.put(type, String.join((CharSequence)",", normalizedIds));
            cfg.update(props);
        }
    }

    private void setOnlineRepoUrl() {
        Path versionFilePath = Path.of(OpenHAB.getUserDataFolder(), "etc", "version.properties");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = Files.newBufferedReader(versionFilePath);){
                Properties prop = new Properties();
                prop.load(reader);
                String repo = prop.getProperty("online-repo", "").strip();
                if (!repo.isEmpty()) {
                    this.onlineRepoUrl = repo + "@id=openhab@snapshots";
                } else {
                    this.logger.warn("Cannot determine online repo url - online repo support will be disabled.");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.warn("Cannot determine online repo url - online repo support will be disabled. Error: {}", (Object)e.getMessage(), (Object)this.debugException(e));
        }
    }

    private boolean getOnlineRepositoryMode() {
        if (this.onlineRepoUrl != null) {
            Dictionary properties;
            block5: {
                Configuration paxCfg = this.configurationAdmin.getConfiguration(PAX_URL_PID, null);
                properties = paxCfg.getProperties();
                if (properties != null) break block5;
                return false;
            }
            try {
                Object repos = properties.get(PROPERTY_MVN_REPOS);
                if (repos instanceof String) {
                    String string = (String)repos;
                    return List.of(string.split(",")).contains(this.onlineRepoUrl);
                }
            }
            catch (IOException e) {
                this.logger.error("Failed getting the add-on management online/offline mode: {}", (Object)e.getMessage(), (Object)this.debugException(e));
            }
        }
        return false;
    }

    private boolean setOnlineRepositoryMode(boolean enabled) {
        boolean changed = false;
        String onlineRepoUrl = this.onlineRepoUrl;
        if (onlineRepoUrl != null) {
            try {
                Configuration paxCfg = this.configurationAdmin.getConfiguration(PAX_URL_PID, null);
                paxCfg.setBundleLocation("?");
                Dictionary properties = Objects.requireNonNullElse(paxCfg.getProperties(), new Hashtable());
                ArrayList<String> repoCfg = new ArrayList<String>();
                Object repos = properties.get(PROPERTY_MVN_REPOS);
                if (repos instanceof String) {
                    String string = (String)repos;
                    repoCfg.addAll(Arrays.asList(string.split(",")));
                    repoCfg.remove("");
                }
                if (enabled && !repoCfg.contains(onlineRepoUrl)) {
                    repoCfg.add(onlineRepoUrl);
                    changed = true;
                    this.logger.debug("Added repo '{}' to feature repo list.", (Object)onlineRepoUrl);
                } else if (!enabled && repoCfg.contains(onlineRepoUrl)) {
                    repoCfg.remove(onlineRepoUrl);
                    changed = true;
                    this.logger.debug("Removed repo '{}' from feature repo list.", (Object)onlineRepoUrl);
                }
                if (changed) {
                    properties.put(PROPERTY_MVN_REPOS, String.join((CharSequence)",", repoCfg));
                    this.paxCfgUpdated = true;
                    paxCfg.update(properties);
                }
            }
            catch (IOException e) {
                this.logger.error("Failed setting the add-on management online/offline mode: {}", (Object)e.getMessage(), (Object)this.debugException(e));
            }
        }
        return changed;
    }

    private boolean installAddons(Map<String, Object> config) {
        HashSet currentAddons = new HashSet();
        HashSet<String> targetAddons = new HashSet<String>();
        HashSet<String> installAddons = new HashSet<String>();
        for (String type : ADDON_TYPES) {
            Object configValue = config.get(type);
            if (!(configValue instanceof String)) continue;
            String addonString = (String)configValue;
            try {
                Feature[] features = this.featuresService.listInstalledFeatures();
                String typePrefix = PREFIX + type + "-";
                Set configFeatureNames = Arrays.stream(addonString.split(",")).map(String::strip).filter(Predicate.not(String::isEmpty)).map(addon -> typePrefix + addon).collect(Collectors.toSet());
                for (String name2 : configFeatureNames) {
                    if (this.featuresService.getFeature(name2) != null) {
                        targetAddons.add(name2);
                        if (FeatureInstaller.anyMatchingFeature(features, FeatureInstaller.withName(name2))) continue;
                        installAddons.add(name2);
                        continue;
                    }
                    this.logger.warn("The {} add-on '{}' does not exist - ignoring it.", (Object)type, (Object)name2.substring(typePrefix.length()));
                }
                this.getAllFeatureNamesWithPrefix(typePrefix).stream().filter(name -> FeatureInstaller.anyMatchingFeature(features, FeatureInstaller.withName(name))).forEach(currentAddons::add);
            }
            catch (Exception e) {
                this.logger.error("Failed retrieving features: {}", (Object)e.getMessage(), (Object)this.debugException(e));
            }
        }
        Set<String> uninstallAddons = currentAddons.stream().filter(addon -> !targetAddons.contains(addon)).collect(Collectors.toSet());
        if (!installAddons.isEmpty()) {
            this.installFeatures(installAddons);
        }
        uninstallAddons.forEach(this::uninstallFeature);
        return !installAddons.isEmpty() || !uninstallAddons.isEmpty();
    }

    private Set<String> getAllFeatureNamesWithPrefix(String prefix) {
        try {
            return Arrays.stream(this.featuresService.listFeatures()).map(Feature::getName).filter(name -> name.startsWith(prefix)).collect(Collectors.toSet());
        }
        catch (Exception e) {
            this.logger.error("Failed retrieving features: {}", (Object)e.getMessage(), (Object)this.debugException(e));
            return Set.of();
        }
    }

    private void installFeatures(Set<String> addons) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Installing '{}'", (Object)String.join((CharSequence)", ", addons));
            }
            this.featuresService.installFeatures(addons, EnumSet.of(FeaturesService.Option.NoAutoRefreshBundles, FeaturesService.Option.Upgrade, FeaturesService.Option.NoFailOnFeatureNotFound));
            try {
                Feature[] features = this.featuresService.listInstalledFeatures();
                HashSet<String> installed = new HashSet<String>();
                HashSet<String> failed = new HashSet<String>();
                for (String addon : addons) {
                    if (FeatureInstaller.anyMatchingFeature(features, FeatureInstaller.withName(addon))) {
                        installed.add(addon);
                        continue;
                    }
                    failed.add(addon);
                }
                if (!installed.isEmpty() && this.logger.isDebugEnabled()) {
                    this.logger.debug("Installed '{}'", (Object)String.join((CharSequence)", ", installed));
                }
                if (!failed.isEmpty()) {
                    this.logger.error("Failed installing '{}'", (Object)String.join((CharSequence)", ", failed));
                    this.configMapCache = null;
                }
                installed.forEach(this::postInstalledEvent);
            }
            catch (Exception e) {
                this.logger.error("Failed retrieving features: {}", (Object)e.getMessage(), (Object)this.debugException(e));
                this.configMapCache = null;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed installing '{}': {}", new Object[]{String.join((CharSequence)", ", addons), e.getMessage(), this.debugException(e)});
            this.configMapCache = null;
        }
    }

    private void uninstallFeature(String name) {
        try {
            Feature[] features = this.featuresService.listInstalledFeatures();
            if (FeatureInstaller.anyMatchingFeature(features, FeatureInstaller.withName(name))) {
                this.featuresService.uninstallFeature(name);
                this.logger.debug("Uninstalled '{}'", (Object)name);
                this.postUninstalledEvent(name);
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed uninstalling '{}': {}", (Object)name, (Object)e.getMessage());
        }
    }

    private void postInstalledEvent(String featureName) {
        String extensionId = featureName.substring(PREFIX.length());
        AddonEvent event = AddonEventFactory.createAddonInstalledEvent((String)extensionId);
        this.eventPublisher.post((Event)event);
    }

    private void postUninstalledEvent(String featureName) {
        String extensionId = featureName.substring(PREFIX.length());
        AddonEvent event = AddonEventFactory.createAddonUninstalledEvent((String)extensionId);
        this.eventPublisher.post((Event)event);
    }

    private static boolean anyMatchingFeature(Feature[] features, Predicate<Feature> predicate) {
        return Arrays.stream(features).anyMatch(predicate);
    }

    private static Predicate<Feature> withName(String name) {
        return feature -> feature.getName().equals(name);
    }
}

