/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.util;

import de.focus_shift.jollyday.core.util.ClassLoadingUtil;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public final class ResourceUtil {
    private static final String COUNTRY_PROPERTY_PREFIX = "country.description";
    private static final String COUNTRY_DESCRIPTIONS_FILE_PREFIX = "descriptions.country_descriptions";
    private static final Map<Locale, ResourceBundle> COUNTRY_DESCRIPTIONS_CACHE = new ConcurrentHashMap<Locale, ResourceBundle>();
    private static final String HOLIDAY_PROPERTY_PREFIX = "holiday.description";
    private static final String HOLIDAY_DESCRIPTIONS_FILE_PREFIX = "descriptions.holiday_descriptions";
    private static final Map<Locale, ResourceBundle> HOLIDAY_DESCRIPTION_CACHE = new ConcurrentHashMap<Locale, ResourceBundle>();
    public static final String UNDEFINED = "undefined";

    private ResourceUtil() {
    }

    public static String getHolidayDescription(String key) {
        return ResourceUtil.getHolidayDescription(Locale.getDefault(), key);
    }

    public static String getHolidayDescription(Locale locale, String key) {
        return ResourceUtil.getDescription("holiday.description." + key, ResourceUtil.getHolidayDescriptions(locale));
    }

    public static String getCountryDescription(String key) {
        return ResourceUtil.getCountryDescription(Locale.getDefault(), key);
    }

    public static String getCountryDescription(Locale locale, String key) {
        if (key != null) {
            return ResourceUtil.getDescription("country.description." + key.toLowerCase(), ResourceUtil.getCountryDescriptions(locale));
        }
        return UNDEFINED;
    }

    private static String getDescription(String key, ResourceBundle bundle) {
        if (!bundle.containsKey(key)) {
            return UNDEFINED;
        }
        return bundle.getString(key);
    }

    private static ResourceBundle getHolidayDescriptions(Locale locale) {
        return ResourceUtil.getResourceBundle(locale, HOLIDAY_DESCRIPTION_CACHE, HOLIDAY_DESCRIPTIONS_FILE_PREFIX);
    }

    private static ResourceBundle getCountryDescriptions(Locale locale) {
        return ResourceUtil.getResourceBundle(locale, COUNTRY_DESCRIPTIONS_CACHE, COUNTRY_DESCRIPTIONS_FILE_PREFIX);
    }

    private static ResourceBundle getResourceBundle(Locale locale, Map<Locale, ResourceBundle> resourceCache, String filePrefix) {
        return resourceCache.computeIfAbsent(locale, givenLocale -> ResourceBundle.getBundle(filePrefix, givenLocale, ClassLoadingUtil.getClassloader()));
    }

    public static Optional<URL> getResource(String resourceName) {
        return ResourceUtil.getResource(resourceName, false);
    }

    public static Optional<URL> getResource(String resourceName, boolean searchOnlyInJar) {
        Stream stream = ResourceUtil.getResources(resourceName).stream();
        return searchOnlyInJar ? stream.filter(resource -> resource.getProtocol().equals("jar")).findFirst() : stream.findFirst();
    }

    private static List<URL> getResources(String resourceName) {
        Enumeration<URL> resourcesEnum;
        try {
            resourcesEnum = ClassLoadingUtil.getClassloader().getResources(resourceName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load resource: " + resourceName, e);
        }
        return Collections.list(resourcesEnum);
    }
}

