/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SWTBrowserRegistry {
    private static final String INTERNAL_BROWSER_PROPERTY = "org.eclipse.swt.browser.DefaultType";
    private static final String[] LEGACY_WINDOWS_VERSIONS = new String[]{"Windows 98", "Windows XP", "Windows Vista", "Windows 7", "Windows 8", "Windows 8.1", "Windows Server 2008", "Windows Server 2008 R2", "Windows Server 2012", "Windows Server 2012 R2", "Windows Server 2016", "Windows Server 2019"};

    private SWTBrowserRegistry() {
    }

    @NotNull
    public static BrowserSelection getActiveBrowser() {
        DBPPreferenceStore preferences = ModelPreferences.getPreferences();
        String type = preferences.getString("swt.client.browser");
        if (CommonUtils.isEmpty((String)type)) {
            return SWTBrowserRegistry.getDefaultBrowser();
        }
        return Objects.requireNonNull((BrowserSelection)CommonUtils.valueOf(BrowserSelection.class, (String)type));
    }

    @NotNull
    public static BrowserSelection getDefaultBrowser() {
        if (RuntimeUtils.isWindows() && ArrayUtils.containsIgnoreCase((String[])LEGACY_WINDOWS_VERSIONS, (String)System.getProperty("os.name"))) {
            return BrowserSelection.IE;
        }
        return BrowserSelection.EDGE;
    }

    public static void overrideBrowser() {
        System.setProperty(INTERNAL_BROWSER_PROPERTY, SWTBrowserRegistry.getActiveBrowser().name());
    }

    public static void setActiveBrowser(@NotNull BrowserSelection browser) {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        preferences.setValue("swt.client.browser", browser.name());
        System.setProperty(INTERNAL_BROWSER_PROPERTY, preferences.getString("swt.client.browser"));
    }

    public static enum BrowserSelection {
        EDGE("Microsoft Edge"),
        IE("Internet Explorer");

        private final String name;

        private BrowserSelection(String name) {
            this.name = name;
        }

        @NotNull
        public String getFullName() {
            return this.name;
        }
    }
}

