// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// GetCurrentMilestoneReader is a Reader for the GetCurrentMilestone structure.
type GetCurrentMilestoneReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCurrentMilestoneReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCurrentMilestoneOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetCurrentMilestoneDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetCurrentMilestoneOK creates a GetCurrentMilestoneOK with default headers values
func NewGetCurrentMilestoneOK() *GetCurrentMilestoneOK {
	return &GetCurrentMilestoneOK{}
}

/*
GetCurrentMilestoneOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetCurrentMilestoneOK struct {
	Payload *models.HashicorpCloudVault20201125GetCurrentMilestoneResponse
}

// IsSuccess returns true when this get current milestone o k response has a 2xx status code
func (o *GetCurrentMilestoneOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get current milestone o k response has a 3xx status code
func (o *GetCurrentMilestoneOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get current milestone o k response has a 4xx status code
func (o *GetCurrentMilestoneOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get current milestone o k response has a 5xx status code
func (o *GetCurrentMilestoneOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get current milestone o k response a status code equal to that given
func (o *GetCurrentMilestoneOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get current milestone o k response
func (o *GetCurrentMilestoneOK) Code() int {
	return 200
}

func (o *GetCurrentMilestoneOK) Error() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/current-milestone][%d] getCurrentMilestoneOK  %+v", 200, o.Payload)
}

func (o *GetCurrentMilestoneOK) String() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/current-milestone][%d] getCurrentMilestoneOK  %+v", 200, o.Payload)
}

func (o *GetCurrentMilestoneOK) GetPayload() *models.HashicorpCloudVault20201125GetCurrentMilestoneResponse {
	return o.Payload
}

func (o *GetCurrentMilestoneOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125GetCurrentMilestoneResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCurrentMilestoneDefault creates a GetCurrentMilestoneDefault with default headers values
func NewGetCurrentMilestoneDefault(code int) *GetCurrentMilestoneDefault {
	return &GetCurrentMilestoneDefault{
		_statusCode: code,
	}
}

/*
GetCurrentMilestoneDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetCurrentMilestoneDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this get current milestone default response has a 2xx status code
func (o *GetCurrentMilestoneDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get current milestone default response has a 3xx status code
func (o *GetCurrentMilestoneDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get current milestone default response has a 4xx status code
func (o *GetCurrentMilestoneDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get current milestone default response has a 5xx status code
func (o *GetCurrentMilestoneDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get current milestone default response a status code equal to that given
func (o *GetCurrentMilestoneDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get current milestone default response
func (o *GetCurrentMilestoneDefault) Code() int {
	return o._statusCode
}

func (o *GetCurrentMilestoneDefault) Error() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/current-milestone][%d] GetCurrentMilestone default  %+v", o._statusCode, o.Payload)
}

func (o *GetCurrentMilestoneDefault) String() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/current-milestone][%d] GetCurrentMilestone default  %+v", o._statusCode, o.Payload)
}

func (o *GetCurrentMilestoneDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *GetCurrentMilestoneDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
