// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package chat

// schema: chat.bsky.moderation.getMessageContext

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/bluesky-social/indigo/lex/util"
	"github.com/bluesky-social/indigo/xrpc"
)

// ModerationGetMessageContext_Output is the output of a chat.bsky.moderation.getMessageContext call.
type ModerationGetMessageContext_Output struct {
	Messages []*ModerationGetMessageContext_Output_Messages_Elem `json:"messages" cborgen:"messages"`
}

type ModerationGetMessageContext_Output_Messages_Elem struct {
	ConvoDefs_MessageView        *ConvoDefs_MessageView
	ConvoDefs_DeletedMessageView *ConvoDefs_DeletedMessageView
}

func (t *ModerationGetMessageContext_Output_Messages_Elem) MarshalJSON() ([]byte, error) {
	if t.ConvoDefs_MessageView != nil {
		t.ConvoDefs_MessageView.LexiconTypeID = "chat.bsky.convo.defs#messageView"
		return json.Marshal(t.ConvoDefs_MessageView)
	}
	if t.ConvoDefs_DeletedMessageView != nil {
		t.ConvoDefs_DeletedMessageView.LexiconTypeID = "chat.bsky.convo.defs#deletedMessageView"
		return json.Marshal(t.ConvoDefs_DeletedMessageView)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *ModerationGetMessageContext_Output_Messages_Elem) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "chat.bsky.convo.defs#messageView":
		t.ConvoDefs_MessageView = new(ConvoDefs_MessageView)
		return json.Unmarshal(b, t.ConvoDefs_MessageView)
	case "chat.bsky.convo.defs#deletedMessageView":
		t.ConvoDefs_DeletedMessageView = new(ConvoDefs_DeletedMessageView)
		return json.Unmarshal(b, t.ConvoDefs_DeletedMessageView)

	default:
		return nil
	}
}

// ModerationGetMessageContext calls the XRPC method "chat.bsky.moderation.getMessageContext".
//
// convoId: Conversation that the message is from. NOTE: this field will eventually be required.
func ModerationGetMessageContext(ctx context.Context, c *xrpc.Client, after int64, before int64, convoId string, messageId string) (*ModerationGetMessageContext_Output, error) {
	var out ModerationGetMessageContext_Output

	params := map[string]interface{}{
		"after":     after,
		"before":    before,
		"convoId":   convoId,
		"messageId": messageId,
	}
	if err := c.Do(ctx, xrpc.Query, "", "chat.bsky.moderation.getMessageContext", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
