/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.Triple;
import driftwood.util.ProcessTank;
import driftwood.util.ReflectiveRunnable;
import driftwood.util.SoftLog;
import driftwood.util.StreamTank;
import driftwood.util.Strings;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import king.KingMain;
import king.core.AGE;
import king.core.AHE;
import king.core.KGroup;
import king.core.Kinemage;
import king.io.KinfileParser;

public class BgKinRunner
implements Runnable {
    DecimalFormat df = new DecimalFormat("0.0##");
    KingMain kMain;
    Kinemage kin;
    volatile Kinemage newKin = null;
    KGroup oldGroup = null;
    volatile Collection dropboxResidues = null;
    volatile ModelState dropboxState = null;
    volatile File dropboxPdbFile = null;
    volatile String cmdTemplate = null;
    volatile boolean dropboxFull = false;
    volatile boolean backgroundTerminate = false;
    final boolean dumpCmdLine;
    final boolean dumpStdErr;
    final boolean dumpStdOut;
    final int helperTimeout;

    public BgKinRunner(KingMain kingMain, Kinemage kinemage, String string) {
        if (kingMain == null || kinemage == null || string == null) {
            throw new NullPointerException("Null parameters are not allowed.");
        }
        this.kMain = kingMain;
        this.kin = kinemage;
        this.cmdTemplate = string;
        this.dumpCmdLine = this.kMain.getPrefs().getBoolean("showHelperCommand");
        this.dumpStdErr = this.kMain.getPrefs().getBoolean("showHelperErrors");
        this.dumpStdOut = this.kMain.getPrefs().getBoolean("showHelperOutput");
        this.helperTimeout = this.kMain.getPrefs().getInt("helperTimeout") * 1000;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.backgroundTerminate) {
            Object object;
            while (this.dropboxFull) {
                String string;
                File file;
                ModelState modelState;
                BgKinRunner bgKinRunner = this;
                synchronized (bgKinRunner) {
                    object = this.dropboxResidues;
                    modelState = this.dropboxState;
                    file = this.dropboxPdbFile;
                    string = this.cmdTemplate;
                    this.dropboxFull = false;
                }
                try {
                    this.runCommand((Collection)object, modelState, file, string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(SoftLog.err);
                }
            }
            SwingUtilities.invokeLater(new ReflectiveRunnable(this, "updateKinemage"));
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void runCommand(Collection collection, ModelState modelState, File file, String string) throws IOException {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object2 : collection) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(((Residue)object2).getSequenceNumber());
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("not all");
        }
        Object object3 = this.kMain.getView().getCenter();
        object2 = (float)object3[0] + ", " + (float)object3[1] + ", " + (float)object3[2];
        Triple[] tripleArray = this.getBoundingBox(collection, modelState);
        if (tripleArray[0].isNaN()) {
            tripleArray[0].setXYZ(0.0, 0.0, 0.0);
        }
        if (tripleArray[1].isNaN()) {
            tripleArray[1].setXYZ(0.0, 0.0, 0.0);
        }
        double d = tripleArray[1].mag() + 5.0;
        String[] stringArray = new String[]{"pdbfile", "molten", "viewcenter", "bbcenter", "bbradius"};
        String[] stringArray2 = new String[]{file.getCanonicalPath(), stringBuffer.toString(), object2, tripleArray[0].format(this.df, ", "), this.df.format(d)};
        String string2 = Strings.expandVariables(string, stringArray, stringArray2);
        if (this.dumpCmdLine) {
            SoftLog.err.println(string2);
        }
        String[] stringArray3 = Strings.tokenizeCommandLine(string2);
        StreamTank streamTank = new StreamTank();
        PdbWriter pdbWriter = new PdbWriter(streamTank);
        pdbWriter.writeResidues(collection, modelState);
        if (this.dropboxFull) {
            return;
        }
        Process process = Runtime.getRuntime().exec(stringArray3);
        streamTank.writeTo(process.getOutputStream());
        process.getOutputStream().close();
        ProcessTank processTank = new ProcessTank();
        if (!processTank.fillTank(process, this.helperTimeout)) {
            SoftLog.err.println("*** Forced termination of background process '" + stringArray3[0] + "'!");
        }
        if (this.dropboxFull) {
            return;
        }
        KinfileParser kinfileParser = new KinfileParser();
        kinfileParser.parse(new LineNumberReader(new InputStreamReader(processTank.getStdout())));
        Collection collection2 = kinfileParser.getKinemages();
        if (collection2.size() > 0) {
            this.newKin = (Kinemage)collection2.iterator().next();
            if (this.dumpStdErr) {
                BgKinRunner.streamcopy(processTank.getStderr(), SoftLog.err);
            }
        } else {
            this.newKin = null;
            SoftLog.err.println("*** No kinemage produced by background process '" + stringArray3[0] + "'");
            SoftLog.err.println(string2);
            SoftLog.err.println();
            BgKinRunner.streamcopy(processTank.getStderr(), SoftLog.err);
            if (this.dumpStdOut) {
                SoftLog.err.println();
                BgKinRunner.streamcopy(processTank.getStdout(), SoftLog.err);
            }
        }
    }

    private static final void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    Triple[] getBoundingBox(Collection collection, ModelState modelState) {
        Triple[] tripleArray2;
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>(20 * collection.size());
        int n = 0;
        for (Triple[] tripleArray2 : collection) {
            for (Atom atom : tripleArray2.getAtoms()) {
                try {
                    arrayList.add(modelState.get(atom));
                    ++n;
                }
                catch (AtomException atomException) {}
            }
        }
        Builder builder = new Builder();
        tripleArray2 = Builder.makeBoundingBox(arrayList);
        tripleArray2[0].add(tripleArray2[1]).div(2.0);
        tripleArray2[1].sub(tripleArray2[0]);
        return tripleArray2;
    }

    public void updateKinemage() {
        if (this.newKin != null) {
            Iterator iterator = this.newKin.iterator();
            if (iterator.hasNext()) {
                KGroup kGroup = (KGroup)iterator.next();
                kGroup.setParent((AGE)this.kin);
                if (this.oldGroup == null) {
                    this.kin.appendKinemage(this.newKin);
                } else {
                    this.kin.replace((AHE)this.oldGroup, (AHE)kGroup);
                }
                this.oldGroup = kGroup;
                this.newKin = null;
            } else if (this.oldGroup != null) {
                this.oldGroup.clear();
            }
        }
    }

    public synchronized void requestRun(Collection collection, ModelState modelState, File file) {
        if (this.backgroundTerminate) {
            throw new IllegalThreadStateException("terminate() was called; worker thread is dead");
        }
        this.dropboxResidues = collection;
        this.dropboxState = modelState;
        this.dropboxPdbFile = file;
        this.dropboxFull = true;
        this.notifyAll();
    }

    public synchronized void terminate() {
        this.backgroundTerminate = true;
        this.notifyAll();
    }

    public Kinemage getKinemage() {
        return this.kin;
    }

    public String findProgram(String string) {
        File file;
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("windows") != -1) {
            string = string + ".exe";
        }
        if ((file = new File(this.kMain.getPrefs().jarFileDirectory, string)).exists()) {
            try {
                string = "'" + file.getCanonicalPath() + "'";
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(SoftLog.err);
            }
        }
        return string;
    }

    public String getCommand() {
        return this.cmdTemplate;
    }

    public synchronized void setCommand(String string) {
        this.cmdTemplate = string;
    }

    public boolean editCommand(Component component) {
        Object[] objectArray = new Object[]{"{pdbfile} is the full path to the PDB file", "{molten} is a list of molten residues: 1,2,3", "{viewcenter} is the current center of view: x, y, z", "{bbcenter} is the center of the bounding box for molten atoms: x, y, z", "{bbradius} is the 'radius' of the bounding box for molten atoms: x, y, z"};
        String string = this.getCommand();
        Object object = JOptionPane.showInputDialog(component, objectArray, "Edit command line", -1, null, null, string);
        if (object != null && !string.equals(object.toString())) {
            this.setCommand(object.toString());
            return true;
        }
        return false;
    }

    public void setLastGroupOn(boolean bl) {
        if (this.oldGroup != null) {
            this.oldGroup.setOn(bl);
        }
    }
}

